{# start twig vars #}{##}
{% set openLinksInNewTabAttr %}{% if open_links_in_new_tab == "true" %}target="_blank"{% endif %}{% endset %}
{# openLinksInNewTabAttr end #}{##}

{% set itemButtonElem %}
  {% if item.btn_text|raw is empty %}
  	<div class="uc_more_btn-item">{{button_text|raw}}</div>
  {% else %}
  	<div class="uc_more_btn-item">{{item.btn_text|raw}}</div>
  {% endif %}
{% endset %}
{# itemButtonElem end #}{##}

{% set itemButtonLinkElem %}
  <div class="ue-content-bottom">
    <a class="uc_more_btn {{button_hover}} {{item.dynamic_popup_link_class|raw}}" href="{{item.link|raw}}" {{openLinksInNewTabAttr}} {{item.link_html_attributes|raw}} {{item.dynamic_popup_link_class|raw}}>
      <div class="ue-btn-inner-wrapper">{{itemButtonElem}}<div>{{button_icon_html|raw}}</div></div>
    </a>
  </div>
{% endset %}
{# itemButtonLinkElem end #}{##}

{% set itemTitleElem %}<{{title_html_tag}} class="ue-title">{{item.title|raw}}</{{title_html_tag}}>{% endset %}
{# itemTitleElem end #}{##}

{% set itemTitleLinkElem %}
  {% if title_linkable == "true" %}
  	<a {% if item.link is not empty %} href="{{item.link|raw}}" {{openLinksInNewTabAttr}} {{item.link_html_attributes|raw}}{% endif %}>{{itemTitleElem}}</a>
  {% else %}
  	{{itemTitleElem}}
  {% endif %}
{% endset %}
{# itemTitleLinkElem end #}{##}

{% set imageSrc %}{% if item.image is not empty %}{{item.image}}{% else %}{{fallback_image}}{% endif %}{% endset %}

{% set imageElem %}<img src="{{imageSrc}}" alt="{{item.image_alt}}">{% endset %}
{# imageElem end #}{##}

{% set imageLinkElem %}
  {% if image_link_type == "link" %}
  	<a {% if item.link is not empty %}href="{{item.link|raw}}" {{openLinksInNewTabAttr}} {{item.link_html_attributes|raw}}{% endif %}>{{imageElem}}</a>
  {% elseif image_link_type == "lightbox" %}
  	<a class="ue-link" href="{{item.image}}" data-e-disable-page-transition="true">{{imageElem}}</a>
  {% endif %}
{% endset %}
{# imageLinkElem end #}{##}

{# end twig vars #}{##}

<div class="ue-item-holder {{item.item_repeater_class}}">
  <div class="uc_dark_carousel_container_holder ue-item" >

    <div class="uc_dark_carousel_placeholder">
      {{imageLinkElem}}
      {% if show_second_image == "true" %}<a {% if item.link is not empty %}href="{{item.link|raw}}" {{openLinksInNewTabAttr}} {{item.link_html_attributes|raw}}{% endif %}><img src="{{item.second_image}}" alt="{{item.second_image_alt}}"></a>{% endif %}	
      {% if item.badge is empty %}  
      {% else %} 
          <div class="ue-item-badge">{{item.badge|raw}}</div>  
      {% endif %}	

    </div>

    {% if show_content == "true" %}
      <div class="uc_dark_carousel_content">
        {% if show_title == "true" %}{{itemTitleLinkElem}}{% endif %}
        {% if show_text == "true" %}<p>{{item.content|raw}}</p>{% endif %}    
        {% if show_button == "true" %}{{itemButtonLinkElem}}{% endif %}
      </div>
    {% endif %}
  </div>
</div>