jQuery(document).ready(function(){	
function {{uc_id}}_start(){

	const slider = document.querySelector('#{{uc_id}} .uc-items-wrapper');
  
    let isDown = false;
    let startX;
    let scrollLeft;

    slider.addEventListener('mousedown', (e) => {
      isDown = true;
      slider.classList.add('active');
      startX = e.pageX - slider.offsetLeft;
      scrollLeft = slider.scrollLeft;
    });
  
    slider.addEventListener('mouseleave', () => {
      isDown = false;
      slider.classList.remove('active');
    });
  
    slider.addEventListener('mouseup', () => {
      isDown = false;
      slider.classList.remove('active');
    });
  
    slider.addEventListener('mousemove', (e) => {
      if(!isDown) return;
      e.preventDefault();
      const x = e.pageX - slider.offsetLeft;
      const walk = (x - startX) * 3; //scroll-fast
      slider.scrollLeft = scrollLeft - walk;
    });
  
  	//position title and text
  	var objCarousel = jQuery("#{{uc_id}}");
  	var dataShowTitle = objCarousel.data("show-title");
    var dataShowText = objCarousel.data("show-text");
  	var dataJustifiedWidths = objCarousel.data("justified-widths");
  
  	function positionContent(){
    
    	var objItems = objCarousel.find(".galleryItem");
      
      	if(!objItems.length)
        return(false);
      
      	if(dataShowTitle == false && dataShowText == false)
        return(false); 
      
      	var maxHeight = 0;
      
      	objItems.each(function(){
        
        	var objItem = jQuery(this);
          	var objContent = objItem.find(".swipe_css_carousel-content");
          	var contentHeight = objContent.height();
        
          	if(dataJustifiedWidths == true)
          	objItem.css("margin-bottom", contentHeight+"px");
          
          	var itemHeight = objItem.height();
          
          	if(contentHeight > maxHeight)
            maxHeight = contentHeight;
              
          	var carouselHeight = maxHeight + itemHeight;
          	var objItemsHolder = objCarousel.find(".uc-items-wrapper");
          
          	if(dataJustifiedWidths == false)
        	objItemsHolder.css("height", carouselHeight+"px");
          
          	//set min-width of an item to fit title and text if no image found
          	var objImg = objItem.find(".galleryItemImg");
          	var imageSrc = objImg.attr("src");
          
          	if(imageSrc != "")
            return(true);  
          
          	var contentWidth = objContent.width();
          
          	objItem.css("min-width", contentWidth+"px");
          
        });
    
    }
  
  	//position after page load
  	positionContent();
  
  	//position after resize and filters
  	jQuery(window).on("resize", positionContent);
  
  	objCarousel.on("uc_ajax_refreshed", function(){
    	setTimeout(positionContent,200)
    });
  

}if(jQuery("#{{uc_id}}").length) {{uc_id}}_start(); else
	jQuery( document ).on( 'elementor/popup/show', () => { if(jQuery("#{{uc_id}}").length) {{uc_id}}_start();});
});