<?php
// If accessed directly, deny access.
defined('ABSPATH') || exit;

class Khtt_Arfnts_Admin {
    
    public  $elements = [ 'body', 'h1', 'h2', 'h3', 'h4', 'h5', 'h6' ];
    
    public function khtt_arfnts_init() {
        add_action('customize_register', [$this, 'register_customizer_settings']);
        add_action('customize_controls_enqueue_scripts', [$this, 'enqueue_customizer_assets']);
       
    }

    public function register_customizer_settings($wp_customize) {
        
        // Add a new section
        $wp_customize->add_section('khattat_arabic_section', [
            'title'             => __('Khattat Arabic Fonts', 'khattat-arabic-fonts'),
            'priority'          => 10,
            'active_callback'   => '__return_true',
        ]);

        $arabic_fonts_choices = [
                'inherit'               => __( 'Inherit', 'khattat-arabic-fonts' ),
                'Amiri'                 => __( 'Amiri', 'khattat-arabic-fonts' ),
                'Amiri Quran'           => __( 'Amiri Quran', 'khattat-arabic-fonts' ),
                'Alexandria'            => __( 'Alexandria', 'khattat-arabic-fonts' ),
                'Alkalami'              => __( 'Al Kalami', 'khattat-arabic-fonts' ),
                'algeria'               => __( 'Algeria', 'khattat-arabic-fonts' ),
                'alhurra'               => __( 'Al Hurra', 'khattat-arabic-fonts' ),
                'Almarai'               => __( 'Al Marai', 'khattat-arabic-fonts' ),
                'almushaf'              => __( 'Al Mushaf', 'khattat-arabic-fonts' ),
                'Aref Ruqaa'            => __( 'Aref Ruqaa', 'khattat-arabic-fonts' ),
                'Aref Ruqaa Ink'        => __( 'Aref Ruqaa Ink', 'khattat-arabic-fonts' ),
                'assaf'                 => __( 'Assaf', 'khattat-arabic-fonts' ),
                'asmaa'                 => __( 'Asmaa', 'khattat-arabic-fonts' ),
                'baghdad'               => __( 'baghdad', 'khattat-arabic-fonts' ),
                'bahij'                 => __( 'Bahij', 'khattat-arabic-fonts' ),
                'Baloo Bhaijaan 2'      => __( 'Baloo Bhaijaan 2', 'khattat-arabic-fonts' ),
                'baran'                 => __( 'baran', 'khattat-arabic-fonts' ),
                'bedayah'               => __( 'Bedayah', 'khattat-arabic-fonts' ),
                'bein'                  => __( 'Bein', 'khattat-arabic-fonts' ),
                'Beiruti'               => __( 'Beiruti', 'khattat-arabic-fonts' ),
                'boutros-ads'           => __( 'Boutros', 'khattat-arabic-fonts' ),
                'Cairo'                 => __( 'Cairo', 'khattat-arabic-fonts' ),
                'Cairo Play'            => __( 'Cairo Play', 'khattat-arabic-fonts' ),
                'Changa'                => __( 'Changa', 'khattat-arabic-fonts' ),
                'cocon-next-arabic'     => __( 'Cocon', 'khattat-arabic-fonts' ),
                'b-compset'             => __( 'Compset', 'khattat-arabic-fonts' ),
                'bdavat'                => __( 'Davat', 'khattat-arabic-fonts' ),
                'decotype-thuluth'      => __( 'Thuluth', 'khattat-arabic-fonts' ),
                'diana-light'           => __( 'Diana', 'khattat-arabic-fonts' ),
                'diwanltr'              => __( 'Diwani', 'khattat-arabic-fonts' ),
                'diwani-bent'           => __( 'Diwani Bent', 'khattat-arabic-fonts' ),
                'Droid Arabic Kufi'     => __( 'Droid Arabic Kufi', 'khattat-arabic-fonts' ),
                'dubai'                 => __( 'Dubai', 'khattat-arabic-fonts' ),
                'El Messiri'            => __( 'El Messiri', 'khattat-arabic-fonts' ),
                'fanni'                 => __( 'Fanni', 'khattat-arabic-fonts' ),
                'Fustat'                => __( 'Fustat', 'khattat-arabic-fonts' ),
                'ghala'                 => __( 'Ghala', 'khattat-arabic-fonts' ),
                'Handjet'               => __( 'Handjet', 'khattat-arabic-fonts' ),
                'hanimation'            => __( 'Hanimation', 'khattat-arabic-fonts' ),
                'Harmattan'             => __( 'Harmattan', 'khattat-arabic-fonts' ),
                'hayah'                 => __( 'Hayah', 'khattat-arabic-fonts' ),
                'helal'                 => __( 'Helal', 'khattat-arabic-fonts' ),
                'IBM Plex Sans Arabic'  => __( 'IBM Plex Sans Arabic', 'khattat-arabic-fonts' ),
                'insan'                 => __( 'Insan', 'khattat-arabic-fonts' ),
                'ishraq'                => __( 'Ishraq', 'khattat-arabic-fonts' ),
                'jazeera'               => __( 'Al Jazeera', 'khattat-arabic-fonts' ),
                'jomhuria'              => __( 'Jomhuria', 'khattat-arabic-fonts' ),
                'jooza'                 => __( 'Jozoor', 'khattat-arabic-fonts' ),
                'jordan'                => __( 'Jordan', 'khattat-arabic-fonts' ),
                'kacst-farsi'           => __( 'Kacst Farsi', 'khattat-arabic-fonts' ),
                'kamran'                => __( 'Kamran', 'khattat-arabic-fonts' ),
                'Katibeh'               => __( 'Katibeh', 'khattat-arabic-fonts' ),
                'Kufam'                 => __( 'Kufam', 'khattat-arabic-fonts' ),
                'kufi'                  => __( 'Kufi', 'khattat-arabic-fonts' ),
                'flat-jooza'            => __( 'JF Flat Font', 'khattat-arabic-fonts' ),
                'Lalezar'               => __( 'Lalezar', 'khattat-arabic-fonts' ),
                'Lateef'                => __( 'Lateef', 'khattat-arabic-fonts' ),
                'Lemonada'              => __( 'Lemonada', 'khattat-arabic-fonts' ),
                'Mada'                  => __( 'Mada', 'khattat-arabic-fonts' ),
                'maidan'                => __( 'Maidan', 'khattat-arabic-fonts' ),
                'Marhey'                => __( 'Marhey', 'khattat-arabic-fonts' ),
                'Markazi Text'          => __( 'Markazi Text', 'khattat-arabic-fonts' ),
                'mbc'                   => __( 'MBC', 'khattat-arabic-fonts' ),
                'Mirza'                 => __( 'Mirza', 'khattat-arabic-fonts' ),
                'motken'                => __( 'Motken', 'khattat-arabic-fonts' ),
                'neckar'                => __( 'Neckar', 'khattat-arabic-fonts' ),
                'Noto Kufi Arabic'      => __( 'Noto Kufi Arabic', 'khattat-arabic-fonts' ),
                'Noto Naskh Arabic'     => __( 'Noto Naskh Arabic', 'khattat-arabic-fonts' ),
                'Noto Nastaliq Urdu'    => __( 'Noto Nastaliq Urdu', 'khattat-arabic-fonts' ),
                'Noto Sans Arabic'      => __( 'Noto Sans Arabic', 'khattat-arabic-fonts' ),
                'omar'                  => __( 'Omar', 'khattat-arabic-fonts' ),
                'taha-naskh'            => __( 'Osman', 'khattat-arabic-fonts' ),
                'rabar'                 => __( 'Rabar', 'khattat-arabic-fonts' ),
                'Rakkas'                => __( 'Rakkas', 'khattat-arabic-fonts' ),
                'rawy-thin'             => __( 'Rawy Thin', 'khattat-arabic-fonts' ),
                'rawi'                  => __( 'Rawi', 'khattat-arabic-fonts' ),
                'Readex Pro'            => __( 'Readex Pro', 'khattat-arabic-fonts' ),
                'Reem Kufi'             => __( 'Reem Kufi', 'khattat-arabic-fonts' ),
                'Reem Kufi Fun'         => __( 'Reem Kufi Fun', 'khattat-arabic-fonts' ),
                'Reem Kufi Ink'         => __( 'Reem Kufi Ink', 'khattat-arabic-fonts' ),
                'Rubik'                 => __( 'Rubik', 'khattat-arabic-fonts' ),
                'Ruwudu'                => __( 'Ruwudu', 'khattat-arabic-fonts' ),    
                'saudi'                 => __( 'Saudi', 'khattat-arabic-fonts' ),
                'saudi-font'            => __( 'Saudi Official', 'khattat-arabic-fonts' ),
                'Scheherazade New'      => __( 'Scheherazade New', 'khattat-arabic-fonts' ),
                'shahd'                 => __( 'Shahd', 'khattat-arabic-fonts' ),
                'shiraz'                => __( 'Shiraz', 'khattat-arabic-fonts' ),
                'shorooq'               => __( 'Shorooq', 'khattat-arabic-fonts' ),
                'sky'                   => __( 'Sky', 'khattat-arabic-fonts' ),
                'stc'                   => __( 'STC', 'khattat-arabic-fonts' ),
                'stoor'                 => __( 'Stoor', 'khattat-arabic-fonts' ),
                'sukar'                 => __( 'Sukar', 'khattat-arabic-fonts' ),
                'Tajawal'               => __( 'Tajawal', 'khattat-arabic-fonts' ),
                'tanseek'               => __( 'Tanseek', 'khattat-arabic-fonts' ),
                'themixarab'            => __( 'The Mix Arab', 'khattat-arabic-fonts' ),
                'thameen'               => __( 'Thameen', 'khattat-arabic-fonts' ),
                'btehran'               => __( 'Tehran', 'khattat-arabic-fonts' ),
                'thuluth-decorated'     => __( 'Thuluth Decorated', 'khattat-arabic-fonts' ),
                'Vazirmatn'             => __( 'Vazirmatn', 'khattat-arabic-fonts' ),
                'Vibes'                 => __( 'Vibes', 'khattat-arabic-fonts' ),
                'yassin'                => __( 'Yassin', 'khattat-arabic-fonts' ),
                'Zain'                  => __( 'Zain', 'khattat-arabic-fonts' ),
                'zahra'                 => __( 'Zahra', 'khattat-arabic-fonts' ),
        ];

        foreach ($this->elements as $element) {
            // Add a setting for Global font
            $wp_customize->add_setting('khattat_arabic_' . $element . '_font', [
                'type'              => 'theme_mod',
                'capability'        => 'edit_theme_options',
                'transport'         => 'refresh',
                'sanitize_callback' => [$this, 'sanitize_font_choice'],
                'default'           => 'Inherit',

            ]);

            // Add a control (dropdown) for Global font
            $wp_customize->add_control('khattat_arabic_' . $element . '_font_control', [
                'label'    => ucfirst($element) .' '. __('Font', 'khattat-arabic-fonts'),
                'section'  => 'khattat_arabic_section',
                'settings' => 'khattat_arabic_' . $element . '_font',
                'type'     => 'select',
                'choices'  =>$arabic_fonts_choices,
            ]);
        }

    }

    public function sanitize_font_choice($input) {
        
        $valid_fonts = ['inherit', 'Amiri', 'Amiri Quran', 'Alexandria', 'algeria', 'alhurra', 'Alkalami', 'Almarai', 'almushaf', 'Aref Ruqaa', 'Aref Ruqaa Ink', 'asmaa', 'assaf', 'baghdad', 'bahij', 'Baloo Bhaijaan 2', 'baran', 'bedayah', 'bein', 'Beiruti', 'boutros-ads', 'Cairo', 'Cairo Play', 'Changa', 'cocon-next-arabic', 'b-compset', 'bdavat', 'decotype-thuluth', 'diana-light', 'diwanltr', 'diwani-bent', 'Droid Arabic Kufi', 'dubai', 'El Messiri', 'fanni', 'Fustat', 'ghala', 'IBM Plex Sans Arabic', 'Handjet', 'hanimation', 'Harmattan', 'hayah', 'helal', 'ishraq', 'insan', 'jazeera', 'flat-jooza', 'jomhuria', 'jooza', 'jordan', 'kacst-farsi', 'kamran', 'Lalezar', 'Lateef', 'Lemonada', 'Mada', 'maidan', 'Marhey', 'Markazi Text', 'mbc', 'Mirza', 'motken', 'neckar', 'Noto Kufi Arabic', 'Noto Naskh Arabic', 'Noto Nastaliq Urdu', 'Noto Sans Arabic', 'omar', 'taha-naskh', 'rabar', 'Rakkas', 'rawy-thin', 'rawi', 'Readex Pro', 'Reem Kufi', 'Reem Kufi Fun', 'Reem Kufi Ink', 'Rubik', 'Ruwudu', 'Kufam', 'kufi', 'saudi', 'saudi-font', 'sky', 'shahd', 'shiraz', 'shorooq', 'Scheherazade New', 'stc', 'stoor','sukar', 'Tajawal', 'tanseek', 'thameen', 'themixarab', 'btehran', 'thuluth-decorated', 'Vazirmatn', 'Vibes', 'yassin', 'Zain', 'zahra'];
        return in_array($input, $valid_fonts, true) ? $input : 'Cairo';
    }

    public function enqueue_customizer_assets() {
            
        // Load admin CSS files.
            wp_enqueue_style(
                'khtt-arfnts-select2-style',
                KHTT_ARFNTS_URL . 'admin/assets/css/select2.min.css',
                [],
                KHTT_ARFNTS_VERSION
            );

            // Load admin JS files.
            wp_enqueue_script(
                'khtt-arfnts-select2-script',
                KHTT_ARFNTS_URL . 'admin/assets/js/select2.min.js',
                ['jquery'],
                KHTT_ARFNTS_VERSION,
                true 
            );

            wp_enqueue_script(
                'khtt-arfnts-select2-init',
                KHTT_ARFNTS_URL . 'admin/assets/js/select2-init.js',
                ['jquery'],
                KHTT_ARFNTS_VERSION,
                true 
            );
            
            
    }

}
