<?php
// If accessed directly, deny access.
defined('ABSPATH') || exit;

function khtt_arfnts_review_notice() {
    $activation_time = get_option('khattat_arabic_activation_time', 0);
    $last_notice_time = get_option('khattat_last_notice_time', 0);


    if (!$activation_time || (time() - $activation_time) < (7 * 24 * 60 * 60)) {
        return;
    }

    if ($last_notice_time && (time() - $last_notice_time) < (30 * 24 * 60 * 60)) {
        return;
    }

    ?>
    <div class="notice notice-info is-dismissible khattat-review-notice">
        <p>🥰 <?php echo esc_html__('You have used:', 'khattat-arabic-fonts'); ?> 
        <strong><?php echo esc_html__('Khattat - Arabic Fonts', 'khattat-arabic-fonts'); ?></strong>
        <?php echo esc_html__('for over 7 days! If you love the plugin, please leave a ', 'khattat-arabic-fonts'); ?>
        <a href="<?php echo esc_url( 'https://wordpress.org/support/plugin/khattat-arabic-fonts/reviews/#new-post' ); ?>" target="_blank">
            <?php echo esc_html__('positive review', 'khattat-arabic-fonts'); ?>
        </a> <?php echo esc_html__('to help us improve. Thank you!', 'khattat-arabic-fonts'); ?>❤️</p>
    </div>
    <?php
    update_option('khattat_last_notice_time', time());
}
add_action('admin_notices', 'khtt_arfnts_review_notice');
