<?php
/**
 * Plugin Name: Khattat - Arabic Fonts
 * Description: Choose a beautiful Arabic font for your site from over 100 stunning fonts to enhance user experience.
 * Plugin URI: https://wordpress.org/plugins/khattat-arabic-fonts
 * Version:     2.5.0
 * Tested up to: 6.7
 * Requires PHP: 7.4
 * Author:      Mokhtar Bensaid
 * Author URI:  https://mokhtarbensaid.com
 * License:     GPL-2.0+
 * Text Domain: khattat-arabic-fonts
 * Domain Path: /languages
 */

// If accessed directly, deny access.
defined('ABSPATH') || exit;

// Definition of plugin constants.
define('KHTT_ARFNTS_VERSION', '2.5.0');
define('KHTT_ARFNTS_PATH', plugin_dir_path(__FILE__));
define('KHTT_ARFNTS_URL', plugin_dir_url(__FILE__));

// Include essential files.
require_once KHTT_ARFNTS_PATH . 'includes/class-main.php';
require_once KHTT_ARFNTS_PATH . 'includes/class-activator.php';
require_once KHTT_ARFNTS_PATH . 'includes/class-deactivator.php';
require_once KHTT_ARFNTS_PATH . 'includes/functions.php';

// Code that works when activation.
register_activation_hook(__FILE__, ['Khtt_Arfnts_Activator', 'activate']);
register_deactivation_hook(__FILE__, ['Khtt_Arfnts_Deactivator', 'deactivate']);

// Load text domain
function khtt_arfnts_load_textdomain() {
    load_plugin_textdomain('khattat-arabic-fonts', false, plugin_basename(dirname(__FILE__)) . '/languages');
}
add_action('plugins_loaded', 'khtt_arfnts_load_textdomain');

// Run the plugin
function khtt_arfnts_run_plugin() {
    $plugin = new Khtt_Arfnts_Main();
    $plugin->khtt_arfnts_run_main();
}
khtt_arfnts_run_plugin();
