<?php
/**
 * Theme functions and definitions.
 */
	 
add_action('template_redirect','check_if_logged_in');
    function check_if_logged_in()
    {
        $pageid = get_option( 'woocommerce_checkout_page_id' );
        if(!is_user_logged_in() && is_page($pageid))
        {
            $url = add_query_arg(
                'redirect_to',
                get_permalink($pageid),
                site_url('/my-account/') // your my account url
            );
            wp_redirect($url);
            exit;
        }
        if(is_user_logged_in())
        {
        if(is_page(get_option( 'woocommerce_myaccount_page_id' )))
        {
            
            $redirect = $_GET['redirect_to'];
            if (isset($redirect)) {
            echo '<script>window.location.href = "'.$redirect.'";</script>';
            }
    
        }
        }
    }


/*** redirect_to my account berfore add to cart or buy 
function custom_add_to_cart_redirect() { 
    return 'https://remark3demos3.com/books/my-account/'; 
}
add_filter( 'woocommerce_add_to_cart_redirect', 'custom_add_to_cart_redirect' );***/
/******** redirect_to my account berfore add to cart or buy ***********/







/************* Free for first year plguin code  ************/
// Ensure WooCommerce is active before proceeding.
if ( in_array( 'woocommerce/woocommerce.php', apply_filters( 'active_plugins', get_option( 'active_plugins' ) ) ) ) {

    /**
     * Filters the product price to make it free if published within the last year.
     *
     * @param string $price The product price HTML.
     * @param WC_Product $product The product object.
     * @return string The modified product price HTML.
     */
    function custom_woocommerce_first_year_free_price( $price, $product ) {
        // Get the product's publication date (post_date).
        $post_date = get_post_field( 'post_date', $product->get_id() );

        // Convert the publication date to a Unix timestamp.
        $post_timestamp = strtotime( $post_date );

        // Calculate the timestamp for one year ago from now.
        $one_year_ago_timestamp = strtotime( '-1 year' );

        // Check if the product was published within the last year.
        if ( $post_timestamp >= $one_year_ago_timestamp ) {
            // If it's within the first year, set the price to 0 and display "Free!".
            return '<span class="woocommerce-Price-amount amount"><span class="woocommerce-Price-currencySymbol"></span>مجانا!</span>';
        }

        // Otherwise, return the original price.
        return $price;
    }
    add_filter( 'woocommerce_get_price_html', 'custom_woocommerce_first_year_free_price', 10, 2 );

    /**
     * Filters the product's raw price to ensure it's treated as 0 for calculations.
     * This is crucial for cart, checkout, and order totals.
     *
     * @param float $price The product's raw price.
     * @param WC_Product $product The product object.
     * @return float The modified raw price.
     */
    function custom_woocommerce_first_year_free_raw_price( $price, $product ) {
        // Get the product's publication date (post_date).
        $post_date = get_post_field( 'post_date', $product->get_id() );

        // Convert the publication date to a Unix timestamp.
        $post_timestamp = strtotime( $post_date );

        // Calculate the timestamp for one year ago from now.
        $one_year_ago_timestamp = strtotime( '-1 year' );

        // Check if the product was published within the last year.
        if ( $post_timestamp >= $one_year_ago_timestamp ) {
            // If it's within the first year, set the raw price to 0.
            return 0;
        }

        // Otherwise, return the original raw price.
        return $price;
    }
    // Apply this filter to various price hooks to ensure consistency.
    add_filter( 'woocommerce_product_get_price', 'custom_woocommerce_first_year_free_raw_price', 10, 2 );
    add_filter( 'woocommerce_product_get_regular_price', 'custom_woocommerce_first_year_free_raw_price', 10, 2 );
    add_filter( 'woocommerce_product_get_sale_price', 'custom_woocommerce_first_year_free_raw_price', 10, 2 );
    add_filter( 'woocommerce_product_get_display_price', 'custom_woocommerce_first_year_free_raw_price', 10, 2 );
    add_filter( 'woocommerce_product_variation_get_price', 'custom_woocommerce_first_year_free_raw_price', 10, 2 );
    add_filter( 'woocommerce_product_variation_get_regular_price', 'custom_woocommerce_first_year_free_raw_price', 10, 2 );
    add_filter( 'woocommerce_product_variation_get_sale_price', 'custom_woocommerce_first_year_free_raw_price', 10, 2 );
    add_filter( 'woocommerce_product_variation_get_display_price', 'custom_woocommerce_first_year_free_raw_price', 10, 2 );


    /**
     * Ensures that products marked as free are not treated as taxable.
     *
     * @param bool $is_taxable Whether the product is taxable.
     * @param WC_Product $product The product object.
     * @return bool True if taxable, false otherwise.
     */
    function custom_woocommerce_first_year_free_is_taxable( $is_taxable, $product ) {
        // Get the product's publication date (post_date).
        $post_date = get_post_field( 'post_date', $product->get_id() );

        // Convert the publication date to a Unix timestamp.
        $post_timestamp = strtotime( $post_date );

        // Calculate the timestamp for one year ago from now.
        $one_year_ago_timestamp = strtotime( '-1 year' );

        // If the product was published within the last year, it's not taxable.
        if ( $post_timestamp >= $one_year_ago_timestamp ) {
            return false;
        }

        // Otherwise, return the original taxable status.
        return $is_taxable;
    }
    add_filter( 'woocommerce_product_is_taxable', 'custom_woocommerce_first_year_free_is_taxable', 10, 2 );

    /**
     * Ensures that products marked as free are treated as purchasable.
     * This might be needed if WooCommerce's default behavior prevents purchasing 0-priced items.
     *
     * @param bool $purchasable Whether the product is purchasable.
     * @param WC_Product $product The product object.
     * @return bool True if purchasable, false otherwise.
     */
    function custom_woocommerce_first_year_free_is_purchasable( $purchasable, $product ) {
        // Get the product's publication date (post_date).
        $post_date = get_post_field( 'post_date', $product->get_id() );

        // Convert the publication date to a Unix timestamp.
        $post_timestamp = strtotime( $post_date );

        // Calculate the timestamp for one year ago from now.
        $one_year_ago_timestamp = strtotime( '-1 year' );

        // If the product was published within the last year, it should be purchasable.
        if ( $post_timestamp >= $one_year_ago_timestamp ) {
            return true;
        }

        // Otherwise, return the original purchasable status.
        return $purchasable;
    }
    add_filter( 'woocommerce_is_purchasable', 'custom_woocommerce_first_year_free_is_purchasable', 10, 2 );

}