{{ ucfunc("put_docready_start") }}

  	var objContentGrid = jQuery('#{{uc_id}}');
	var objSearch = objContentGrid.find("input");
	var objItems = objContentGrid.find(".uc_post_grid_style_one_item");
	var objPaginationNumbers = objContentGrid.find(".uc_post_grid_style_one_pagination_numbers");
	var pobjPaginatedList = objContentGrid.find(".uc_post_grid_style_one_wrap");
	var objNextButton = objContentGrid.find(".uc_post_grid_style_one_next_button");
    var objPrevButton = objContentGrid.find(".uc_post_grid_style_one_prev_button");
	var objResetButton = objContentGrid.find(".uc_post_grid_style_one_reset_icon");
  	var objSearchButton = objContentGrid.find(".uc_post_grid_style_one_search_icon");

	var itemsPerPage = Number("{{items_number_per_page}}");
	var totalItems = objItems.length;
	var pageCount = Math.ceil(totalItems / itemsPerPage);
	var currentPage = 1;
	var isPagesEnabled = "{{show_pagination}}";

	var classActive = "ue-active";
    var classVisible = "ue-visible";
    var classDisabled = "ue-disabled";
    var classHidden = "ue-hidden";
	var classSelected = "ue-selected";
	var classPageNumber = "uc_post_grid_style_one_pagination_number";

	/*
    * click on fancy title link
    */
    function onTitleLighboxLinkClick(){
      var objTitle = jQuery(this);
      var objItem = objTitle.closest(".ue-item");
      var objFancyLink = objItem.find("[data-fancybox='gallery']");
          
      if(objFancyLink && objFancyLink.length > 0)
        objFancyLink.trigger("click");
    }
  
  	/**
    * use fancybox
    */
  	function initFancybox(){    
      var useFancybox = objContentGrid.data("lightbox");

      if(useFancybox == false)
      return(false);      
       
      var itemsNum = objItems.length;

      //set data index for each origin item
      for(let i=0; i<itemsNum; i++){

        var objItem = objItems.eq(i);
        
        {% if show_item_title_in_lightbox == "true" %}
          var objTitle = objItem.find(".ue-item-title");
		
          if(objTitle && objTitle.length > 0){
              var titleText = objTitle.text();
              var objLink = objItem.find('.uc_post_grid_style_one-link');
            
              objLink.attr('data-caption', titleText);
          }
        {% endif %}
             
      }

      var fancyLinks = objContentGrid.find(".uc_post_grid_style_one-link");

      fancyLinks.fancybox({
         loop: true,
         arrows : true,
         backfocus: false,
         btnTpl: {
           arrowLeft: `<button data-fancybox-prev class="fancybox-button fancybox-button--arrow_left" title="prev">` +
           `<div>{{previous_arrow_icon_html|raw}}</div>` +
           `</button>`,
           arrowRight: `<button data-fancybox-next class="fancybox-button fancybox-button--arrow_right" title="next">` +
           `<div>{{next_arrow_icon_html|raw}}</div>` +
           `</button>`,
         },
         {% if disable_zoom_in_after_lightbox_image_click == "true" %}
           clickContent: "next",
         {% endif %}
      }); 
         
      {% if image_link_type == "true" and title_link_type == "lightbox" %}   
        var objTitleLinks = objContentGrid.find(".uc_post_grid_style_one-link-lightbox");
       
        objTitleLinks.on("click", onTitleLighboxLinkClick);
      {% endif %}
    }

    /**
    * enable reset buton
    */
	function enableResetButton(){
      objResetButton.removeClass(classHidden);
      objSearchButton.addClass(classHidden);
    }

	/**
    * disable reset buton
    */
	function disableResetButton(){
      objResetButton.addClass(classHidden);
      objSearchButton.removeClass(classHidden);
    }

 	/**
    * hide reset button
    */
	function onSearchInputBlur(){
      setTimeout(disableResetButton, 300);
    }

	/**
    * on focus
    */
	function onSearchInputFocus(){
      var searchValue = objSearch.val();
      
      if(searchValue != "")
      enableResetButton();
    }

	/**
    * function for reaset button
    */
	function onResetButtonClick(){
      objSearch.val("");
      
      objSearch.trigger("input")
    }

 	/**
    * scroll to top
    */
    function scrollToTop(obj, num){
      var offsetTop = obj.offset().top;

      jQuery("html").animate({ scrollTop: (offsetTop + num) }, 500);
    }

    /**
    * on input search
    */
	function onSearchInput(){
      var value = objSearch.val().toLowerCase();
      
      //show reset icon instead of search icon
      enableResetButton();
      
      objItems.each(function(index) {
        var objItem = jQuery(this);
        var titleText = objItem.find(".ue-item-title").text().toLowerCase(); // Get the title text
        var textText = objItem.find(".ue-item-text").text().toLowerCase();   // Get the main text
        var descrText = objItem.find(".ue-item-descr").text().toLowerCase(); // Get the description text
        var titleTextIndex = titleText.indexOf(value);
        var textTextIndex = textText.indexOf(value);
        var descrTextIndex = descrText.indexOf(value);
        
        // Check if the search value is found in any of the texts
        if (titleTextIndex > -1 || textTextIndex > -1 || descrTextIndex > -1) {
          objItem.removeClass(classHidden); // Show the item if a match is found
          objItem.addClass(classSelected);          
        } else {
          objItem.addClass(classHidden); // Hide the item if no match
          objItem.removeClass(classSelected);
        }
       
      });
           
      //make sure that items are separated by pages after search input
      if(isPagesEnabled == "true"){
        var objSelectedByFilterItems = objContentGrid.find("."+classSelected);
        var objPages = objContentGrid.find("."+classPageNumber);
        
        if(!objSelectedByFilterItems || objSelectedByFilterItems.length == 0){
          //remove existing pages        
          objPages.remove();
          
          return(true);
        }          
        
        var selectedItemsNum = objSelectedByFilterItems.length;
        
        //update totalItems var
        totalItems = selectedItemsNum;
        pageCount = Math.ceil(totalItems / itemsPerPage);
	
        //remove existing pages        
        objPages.remove();
        
        //append new amount of pages
        setPaginationNumbers();
        setCurrentPage(1, true);
      }
    }

	/**
    * disable button
    */
    function disableButton(objButton){
      objButton.addClass(classDisabled);
    }

	/**
    * enable button
    */
    function enableButton(objButton){
        objButton.removeClass(classDisabled);
    }

	/**
    * handle status
    */
    function handlePageButtonsStatus(){
      if (currentPage === 1) {
        disableButton(objPrevButton);
      } else {
        enableButton(objPrevButton);
      }
      
      if (pageCount === currentPage) {
        disableButton(objNextButton);
      } else {
        enableButton(objNextButton);
      }
      
      setTimeout(function(){
      	var objPages = objContentGrid.find("."+classPageNumber);
     
        if(!objPages || objPages.length == 0){
          disableButton(objPrevButton);
          disableButton(objNextButton);
        } 
      },300);      
    }

	/**
    * handle active state
    */
    function handleActivePageNumber(){
      const pagesNum = document.querySelectorAll("."+classPageNumber).length;
      
      document.querySelectorAll("."+classPageNumber).forEach((button) => {
        button.classList.remove(classActive);
        button.classList.remove(classVisible); 
        
        const pageIndex = Number(button.getAttribute("page-index"));
        
        if (pageIndex == currentPage) {
          button.classList.add(classActive);        
        }        
      });
    }

 	/*
    ** append nums
    */
    function appendPageNumber(index){
      const pageNumber = document.createElement("button");
      pageNumber.className = classPageNumber;
      pageNumber.innerHTML = index;
      pageNumber.setAttribute("page-index", index);
      pageNumber.setAttribute("aria-label", "Page " + index);
      
      objPaginationNumbers[0].appendChild(pageNumber);
    }

	/**
    * returns pages num
    */
    function setPaginationNumbers(){
      for (let i = 1; i <= pageCount; i++) {
        appendPageNumber(i);
      }
    }

	/**
    * sets current page
    */
    function setCurrentPage(pageNum, isFiltered, isScrollToTop){
      currentPage = Number(pageNum);
    
      handleActivePageNumber();
      handlePageButtonsStatus();

      const prevRange = (pageNum - 1) * itemsPerPage;
      const currRange = pageNum * itemsPerPage;

      // Get the filtered items if isFiltered is true
      let itemsToDisplay;

      if (isFiltered) {
          itemsToDisplay = objItems.filter('.'+classSelected);
      } else {
          itemsToDisplay = objItems;
      }

      // Calculate total number of filtered items
      const totalFilteredItems = itemsToDisplay.length;

      // Hide all items first
      objItems.each(function(index, item) {
          item.classList.add(classHidden);
      });

      // Show filtered items if available
      if (isFiltered && totalFilteredItems > 0) {
          itemsToDisplay.each(function(index, item) {
              // Check if the index falls within the current page range
              if (index >= prevRange && index < currRange) {
                  item.classList.remove(classHidden); // Show the item if it's in range
              }
          });
      } else {
          // If no filtering or no filtered items, show all items in range
          objItems.each(function(index, item) {
              if (index >= prevRange && index < currRange) {
                  item.classList.remove(classHidden); // Show the item if it's in range
              }
          });
      }
      
      if(isScrollToTop)
      scrollToTop(objContentGrid, -80, false);
    }; 
  
	//init fancy box
  	initFancybox();

 	if(isPagesEnabled == "true" && `{{multisource}}` == "uc_items"){
      setPaginationNumbers();
      setCurrentPage(1, true, false);
      
      //init events
      objPrevButton.on("click", function(){
        setCurrentPage(currentPage - 1, true, true);
      });
      
      objNextButton.on("click", function(){
        setCurrentPage(currentPage + 1, true, true);
      });
      
      objContentGrid.on("click", "."+classPageNumber, function(){
        var objButton = jQuery(this);
        var pageIndex = objButton.attr("page-index");
        
        if(pageIndex){
          setCurrentPage(pageIndex, true, true);
        }
  	  });     
    }
  
	//init events
  	objContentGrid.on("uc_ajax_refreshed",function(){      
      initFancybox();     
    });

	if("{{show_live_search}}" && `{{multisource}}` == "uc_items"){
      objSearch.on("input", onSearchInput);	  
      objSearch.on("focus", onSearchInputFocus);
      objResetButton.on("click", onResetButtonClick);
      objSearch.on("blur", onSearchInputBlur);
    }	
      
	if(objContentGrid.hasClass("uc-remote-parent") == false)
      	return(false);
    
	var objRemoteOptions = {
    	class_items:"ue-item",
    	class_active:"uc-active-item",
    	selector_item_trigger:null,
      	add_set_active_code:true
    };
    
  	{{ucfunc("put_remote_parent_js","objContentGrid","objRemoteOptions")}}
    	
{{ ucfunc("put_docready_end") }}