# Remark CMS (Laravel + Filament) + Static Next.js Site (Installer, no terminal)

You chose **Mode 1: Static Export**.
This package is designed for cPanel where:
- PHP 8.3 is available
- `exec()` is enabled (confirmed)
- Node is supported in cPanel (optional for building static)
- You do NOT want to use Terminal

## What this installer does
Open: `https://cms.yourdomain.com/install`

Wizard will:
1. Download Composer (composer.phar) into `cms/`
2. Create Laravel project in `cms/` (if not already installed)
3. Install packages: Filament + Sanctum
4. Write `.env` using your DB settings
5. Run migrations + create admin user
6. Create API token for the site and show it
7. (Optional) Build static site from `/web` using npm and copy `/web/out` to your site Document Root

## Folder structure (after upload)
- `cms/`  (subdomain document root points to `cms/public`)
- `web/`  (Next.js source used for static export)

## cPanel steps (no terminal)
1) Upload the ZIP and extract it in your home directory (e.g. `~/remark/`)
2) Create subdomain: `cms.yourdomain.com`
   - Document Root: `/home/USER/remark/cms/public`
3) Create MySQL database + user (cPanel UI)
4) Visit: `https://cms.yourdomain.com/install`
5) Follow steps and finish
6) Site static files will be copied to your chosen Document Root (e.g. `/home/USER/public_html`)

Default admin (created by installer)
- Email: admin@local.test
- Password: Admin@12345

Security
- Installer auto-locks by creating `cms/storage/app/install.lock`
- You can delete `/install` folder after successful install.

