\
<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Hash;
use App\Models\User;

class RemarkBootstrap extends Command
{
    protected $signature = 'remark:bootstrap {--force : overwrite existing token file}';
    protected $description = 'Create admin user and API token for Next.js';

    public function handle(): int
    {
        $email = 'admin@local.test';
        $password = 'Admin@12345';

        $user = User::query()->firstOrCreate(
            ['email' => $email],
            [
                'name' => 'Admin',
                'password' => Hash::make($password),
                'email_verified_at' => now(),
            ]
        );

        $token = $user->createToken('next-site')->plainTextToken;

        $path = storage_path('app/remark-token.txt');
        if (file_exists($path) && !$this->option('force')) {
            $this->warn("Token file exists: {$path} (use --force to overwrite)");
        } else {
            file_put_contents($path, $token);
            $this->info("Saved token to: {$path}");
        }

        $this->info("Admin: {$email} / {$password}");
        $this->info("CMS_API_TOKEN={$token}");
        return self::SUCCESS;
    }
}
