\
<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Page;

class PageController extends Controller
{
    public function showBySlug(string $slug)
    {
        $page = Page::query()->where('slug', $slug)->first();
        if (!$page) return response()->json(['message' => 'Not found'], 404);

        return response()->json([
            'id' => $page->id,
            'title' => $page->title,
            'slug' => $page->slug,
            'seo' => $page->seo,
            'blocks' => $page->blocks,
            'updated_at' => $page->updated_at,
        ]);
    }
}
