<?php
/**
 * 
 * Demo Imports
 */

function tp_ocdi_import_files()
{

  return array(
    array(
      'import_file_name' => 'University Classic (Tutor)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-1.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/',
    ),
    array(
      'import_file_name' => 'Online Course (Tutor)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-2.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/online-course/',
    ),
    array(
      'import_file_name' => 'Kids Education (Tutor)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-3.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/kids-education/',
    ),
    array(
      'import_file_name' => 'Gym Coaching (Tutor)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-4.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/gym-coaching/',
    ),
    array(
      'import_file_name' => 'High School (Tutor)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-5.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/high-school/',
    ),
    array(
      'import_file_name' => 'Books Shop (Tutor)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-6.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia/books-shop/',
    ),
    
    // learnpress

    array(
      'import_file_name' => 'University Classic (LearnPress)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-1.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/',
    ),
    array(
      'import_file_name' => 'Online Course (LearnPress)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-2.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/online-course/',
    ),
    array(
      'import_file_name' => 'Kids Education (LearnPress)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-3.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/kids-education/',
    ),
    array(
      'import_file_name' => 'Gym Coaching (LearnPress)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-4.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/gym-coaching/',
    ),
    array(
      'import_file_name' => 'High School (LearnPress)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-5.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/high-school/',
    ),
    array(
      'import_file_name' => 'Books Shop (LearnPress)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/contents-demo.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/widget-settings.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/lp/customizer-data.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-6.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-learnpress/books-shop/',
    ),

    // rtl
    array(
      'import_file_name' => 'Acadia RTL Demo (Tutor)',
      'local_import_file' => trailingslashit(get_template_directory()) . 'sample-data/rtl/contents-demo-rtl.xml',
      'local_import_widget_file' => trailingslashit(get_template_directory()) . 'sample-data/rtl/widget-settings-rtl.json',
      'local_import_customizer_file' => trailingslashit(get_template_directory()) . 'sample-data/rtl/customizer-data-rtl.dat',
      'import_preview_image_url' => plugin_dir_url(__FILE__) . '../../assets/img/demo/home-2-rtl.jpg',
      'preview_url' => 'https://wp.themepure.net/acadia-rtl/online-course/',
    ),
  );
}
add_filter('ocdi/import_files', 'tp_ocdi_import_files');


function tp_ocdi_page($tp_page_name = 'Home')
{
  $posts = get_posts(
    array(
      'post_type' => 'page',
      'title' => $tp_page_name,
      'post_status' => 'all',
      'posts_per_page' => 1,
      'no_found_rows' => true,
      'ignore_sticky_posts' => true,
      'update_post_term_cache' => false,
      'update_post_meta_cache' => false,
      'orderby' => 'post_date ID',
      'order' => 'ASC',
    )
  );

  if (!empty($posts)) {
    $page_got_by_title = $posts[0];
  } else {
    $page_got_by_title = null;
  }

  return $page_got_by_title;

}

// after demo imports
function tp_ocdi_after_import_setup($demo)
{
  $front_page_id = "";
  $blog_page_id = "";
  if ("University Classic (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('University Classic');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Online Course (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Course');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Kids Education (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Kids Education');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Gym Coaching (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Gym Coaching');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("High School (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('High School');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Books Shop (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Books Shop');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Acadia RTL Demo (Tutor)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Course');
    $blog_page_id = tp_ocdi_page('Blog');
  }  elseif ("University Classic (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('University Classic');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Online Course (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Course');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Kids Education (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Kids Education');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Gym Coaching (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Gym Coaching');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("High School (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('High School');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Books Shop (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Books Shop');
    $blog_page_id = tp_ocdi_page('Blog');
  } else if ("Acadia RTL Demo (LearnPress)" == $demo['import_file_name']) {
    // Assign front page and posts page (blog page).
    $front_page_id = tp_ocdi_page('Online Course');
    $blog_page_id = tp_ocdi_page('Blog');
  }

  update_option('show_on_front', 'page');
  update_option('page_on_front', $front_page_id->ID);
  update_option('page_for_posts', $blog_page_id->ID);

  // Assign menus to their locations.
  $main_menu = get_term_by('name', 'Main Menu', 'nav_menu');

  set_theme_mod(
    'nav_menu_locations',
    [
      'main-menu' => $main_menu->term_id, // replace 'main-menu' here with the menu location identifier from register_nav_menu() function in your theme.
    ]
  );

  // woocommerce default settings reset
  if (class_exists('woocommerce')) {
    update_option('woocommerce_shop_page_id', '970');
    update_option('woocommerce_cart_page_id', '971');
    update_option('woocommerce_checkout_page_id', '972');
    update_option('woocommerce_myaccount_page_id', '973');
  }
}
add_action('ocdi/after_import', 'tp_ocdi_after_import_setup');

function tp_ocdi_plugin_page_setup($default_settings)
{
  $default_settings['parent_slug'] = 'themes.php';
  $default_settings['page_title'] = esc_html__('One Click Demo Import', 'one-click-demo-import');
  $default_settings['menu_title'] = esc_html__('Import Theme Demos', 'one-click-demo-import');
  $default_settings['capability'] = 'import';
  $default_settings['menu_slug'] = 'one-click-demo-import';

  return $default_settings;
}
add_filter('ocdi/plugin_page_setup', 'tp_ocdi_plugin_page_setup');