<?php

namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Background;
use TPCore\Elementor\Controls\Group_Control_TPGradient;
use \Elementor\Repeater;


if (!defined('ABSPATH'))
	exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Theme_Button extends Widget_Base
{

	use TP_Style_Trait, TP_Icon_Trait, TP_Offcanvas_Trait, TP_Menu_Trait, TP_Animation_Trait;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'tp-theme-button';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __(TPCORE_THEME_NAME . ' :: Theme Button', 'tpcore');
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['tpcore'];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends()
	{
		return ['tpcore'];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

	protected function register_controls()
	{
		$this->register_controls_section();
		$this->style_tab_content();
	}

	protected function register_controls_section()
	{

		$this->tp_design_layout('Select Layout', 5);

		$this->start_controls_section(
			'tp_theme_btn_button_group',
			[
				'label' => esc_html__('Theme Button', 'tpcore'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'tp_button_type',
			[
				'label' => esc_html__('Button Style Type', 'tpcore'),
				'type' => Controls_Manager::SELECT,
				'default' => 'inline',
				'options' => [
					'inline' => esc_html__('Inline', 'tpcore'),
					'w-100 d-block' => esc_html__('Full Width', 'tpcore'),
				],

			]
		);

		$this->add_control(
			'tp_theme_btn_button_show',
			[
				'label' => esc_html__('Show Button', 'tpcore'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'tpcore'),
				'label_off' => esc_html__('Hide', 'tpcore'),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'tp_theme_btn_text',
			[
				'label' => esc_html__('Button Text', 'tpcore'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Read More', 'tpcore'),
				'title' => esc_html__('Enter button text', 'tpcore'),
				'label_block' => true,
				'condition' => [
					'tp_theme_btn_button_show' => 'yes'
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_line_effect',
			[
				'label' => esc_html__('Line Effect', 'tpcore'),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'tpcore'),
				'label_off' => esc_html__('Hide', 'tpcore'),
				'return_value' => 'yes',
				'default' => 'no',
				'condition' => [
					'tp_theme_btn_button_show' => 'yes',
					'tp_design_style!' => ['layout-1', 'layout-2', 'layout-3']
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_icon_show',
			[
				'label' => esc_html__('Add Icon ?', 'tpcore'),
				'type' => \Elementor\Controls_Manager::SWITCHER,
				'label_on' => esc_html__('Show', 'tpcore'),
				'label_off' => esc_html__('Hide', 'tpcore'),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);


		$this->tp_single_icon_control('theme_btn', 'tp_theme_btn_icon_show', 'yes');

		$this->add_control(
			'tp_theme_btn_icon_position',
			[
				'label' => esc_html__('Choose Icon Position', 'tpcore'),
				'type' => \Elementor\Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'tpcore'),
						'icon' => 'eicon-h-align-left',
					],
					'right' => [
						'title' => esc_html__('Right', 'tpcore'),
						'icon' => 'eicon-h-align-right',
					],
				],
				'default' => 'right',
				'toggle' => true,
				'condition' => [
					'tp_theme_btn_icon_show' => 'yes',
					'tp_design_style' => ['layout-1', 'layout-4']
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_link_type',
			[
				'label' => esc_html__('Button Link Type', 'tpcore'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'1' => 'Custom Link',
					'2' => 'Internal Page',
				],
				'default' => '1',
				'label_block' => true,
				'condition' => [
					'tp_theme_btn_button_show' => 'yes'
				],
			]
		);
		$this->add_control(
			'tp_theme_btn_link',
			[
				'label' => esc_html__('Button link', 'tpcore'),
				'type' => Controls_Manager::URL,
				'dynamic' => [
					'active' => true,
				],
				'placeholder' => esc_html__('https://your-link.com', 'tpcore'),
				'show_external' => false,
				'default' => [
					'url' => '#',
					'is_external' => false,
					'nofollow' => false,
				],
				'condition' => [
					'tp_theme_btn_link_type' => '1',
					'tp_theme_btn_button_show' => 'yes'
				],
				'label_block' => true,
			]
		);
		$this->add_control(
			'tp_theme_btn_page_link',
			[
				'label' => esc_html__('Select Button Link Page', 'tpcore'),
				'type' => Controls_Manager::SELECT2,
				'label_block' => true,
				'options' => tp_get_all_types_post('page'),
				'condition' => [
					'tp_theme_btn_link_type' => '2',
					'tp_theme_btn_button_show' => 'yes'
				]
			]
		);

		$this->add_responsive_control(
			'tp_button_align',
			[
				'label' => esc_html__('Alignment', 'tpcore'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'start' => [
						'title' => esc_html__('Left', 'tpcore'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'tpcore'),
						'icon' => 'eicon-text-align-center',
					],
					'end' => [
						'title' => esc_html__('Right', 'tpcore'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn' => 'justify-content: {{VALUE}};',
				],
				'frontend_available' => true,
				'toggle' => true,
			]
		);
		$this->end_controls_section();
	}

	// style_tab_content
	protected function style_tab_content()
	{

		$this->start_controls_section(
			'tp_theme_btn_style_sec',
			[
				'label' => esc_html__('Button Style', 'tpcore'),
				'tab' => \Elementor\Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' => 'tp_theme_btn_typography',
				'label' => esc_html__('Typhography', 'tpcore'),
				'selector' => '{{WRAPPER}} .tp-el-theme-btn',
			]
		);

		$this->add_control(
			'tp_theme_btn_icon_image_size',
			[
				'label' => esc_html__('Icon Image Size', 'tpcore'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100000,
						'step' => 10,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn .theme-btn-icon img' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'tp_theme_btn_icon_show' => 'yes',
					'tp_theme_btn_icon_type' => 'image'
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_icon_size',
			[
				'label' => esc_html__('Icon Size', 'tpcore'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn .theme-btn-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'tp_theme_btn_icon_show' => 'yes',
					'tp_theme_btn_icon_type' => 'icon'
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_icon_svg_size',
			[
				'label' => esc_html__('Icon SVG Size', 'tpcore'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px', 'em'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 1,
					],
					'em' => [
						'min' => 0,
						'max' => 100,
						'step' => 0.1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => '',
				],
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn .theme-btn-icon svg' => 'width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};',
				],
				'condition' => [
					'tp_theme_btn_icon_show' => 'yes',
					'tp_theme_btn_icon_type' => 'svg'
				],
			]
		);

		$this->start_controls_tabs(
			'tp_theme_btn_state_tabs',
		);

		// button normal state
		$this->start_controls_tab(
			'tp_theme_btn_normal_tab',
			[
				'label' => esc_html__('Normal', 'tpcore'),
			]
		);

		$this->add_control(
			'tp_theme_btn_color',
			[
				'label' => esc_html__('Text Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn' => 'color: {{VALUE}};',
				],
			]
		);
		$this->add_control(
			'tp_theme_btn_icon_color',
			[
				'label' => esc_html__('Icon Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn .theme-btn-icon' => 'color: {{VALUE}};',
				],
				'condition' => [
					'tp_theme_btn_icon_show' => 'yes',
					'tp_theme_btn_icon_type' => 'icon'
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_bg_color',
			[
				'label' => esc_html__('Background Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_line_color',
			[
				'label' => esc_html__('Button Line Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-line-btn:before' => 'background: {{VALUE}};',
				],
				'condition' => [
					'tp_theme_btn_line_effect' => 'yes'
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'tp_theme_btn_border',
				'selector' => '{{WRAPPER}} .tp-el-theme-btn',
			]
		);

		$this->add_control(
			'tp_theme_btn_border_radius',
			[
				'label' => esc_html__('Border Radius', 'tpcore'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tp_theme_btn_box_shadow',
				'selector' => '{{WRAPPER}} .tp-el-theme-btn',
			]
		);

		$this->end_controls_tab();
		// end normal state

		// button hover state
		$this->start_controls_tab(
			'tp_theme_btn_hover_tab',
			[
				'label' => esc_html__('Hover', 'tpcore'),
			]
		);

		$this->add_control(
			'tp_theme_btn_hover_color',
			[
				'label' => esc_html__('Text Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn:hover' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_hover_icon_color',
			[
				'label' => esc_html__('Icon Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn:hover .theme-btn-icon' => 'color: {{VALUE}};',
				],
				'condition' => [
					'tp_theme_btn_icon_show' => 'yes',
					'tp_theme_btn_icon_type' => 'icon'
				],

			]
		);

		$this->add_control(
			'tp_theme_btn_hover_bg_color',
			[
				'label' => esc_html__('Background Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn:hover' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_line_hvr_color',
			[
				'label' => esc_html__('Line Hover Color', 'tpcore'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-line-btn:after' => 'background: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' => 'tp_theme_btn_hover_border',
				'selector' => '{{WRAPPER}} .tp-el-theme-btn:hover',
			]
		);

		$this->add_control(
			'tp_theme_btn_hover_border_radius',
			[
				'label' => esc_html__('Border Radius', 'tpcore'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn:hover' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' => 'tp_theme_btn_hover_box_shadow',
				'selector' => '{{WRAPPER}} .tp-el-theme-btn:hover',
			]
		);

		$this->end_controls_tab();
		// end hover state


		$this->end_controls_tabs();
		// end button state tabs

		$this->add_control(
			'tp_theme_btn_margin',
			[
				'label' => esc_html__('Button Margin', 'tpcore'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'tp_theme_btn_padding',
			[
				'label' => esc_html__('Button Padding', 'tpcore'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->add_control(
			'tp_theme_btn_icon_margin',
			[
				'label' => esc_html__('Icon Margin', 'tpcore'),
				'type' => \Elementor\Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%', 'em'],
				'selectors' => [
					'{{WRAPPER}} .tp-el-theme-btn .theme-btn-icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();


		// animation
		$this->tp_creative_animation(['layout-1', 'layout-2', 'layout-3', 'layout-5']);
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display();
		$btn_id = 'theme_btn';

		?>

		<?php if ($settings['tp_design_style'] == 'layout-2'):
			$animation = $this->tp_animation_show($settings);

			$line_effect = $settings['tp_theme_btn_line_effect'] == 'yes' ? ' themepure-theme-btn-line-effect' : '';
			$this->tp_link_attributes_render('theme_btn', 'tp-el-btn' . '', $this->get_settings());
			?>

			<div class="tp-hero-3-apply-btn <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<a <?php echo $this->get_render_attribute_string('tp-button-arg' . $btn_id . ''); ?>>
					<span>
						<?php tp_render_signle_icon_html($settings, 'theme_btn', ''); ?>
					</span>
					<br>
					<?php if (!empty($settings['tp_' . $btn_id . '_text'])): ?>
						<?php echo $settings['tp_' . $btn_id . '_text']; ?>
					<?php endif; ?>
				</a>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-3'):
			$animation = $this->tp_animation_show($settings);

			$line_effect = $settings['tp_theme_btn_line_effect'] == 'yes' ? ' themepure-theme-btn-line-effect' : '';
			$this->tp_link_attributes_render('theme_btn', 'tp-el-btn tp-el-theme-btn tp-btn-circle' . '', $this->get_settings());
			?>

			<div class="tp-hero-4-btn <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<a <?php echo $this->get_render_attribute_string('tp-button-arg' . $btn_id . ''); ?>>
					<?php tp_render_signle_icon_html($settings, 'theme_btn', ''); ?>
					<?php if (!empty($settings['tp_' . $btn_id . '_text'])): ?>
						<?php echo $settings['tp_' . $btn_id . '_text']; ?>
					<?php endif; ?>
				</a>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-4'):
			$line_effect = $settings['tp_theme_btn_line_effect'] == 'yes' ? 'tp-acadia-btn-line' : '';
			$this->tp_link_attributes_render('theme_btn', 'tp-el-theme-btn d-inline-flex align-items-center' . $line_effect, $this->get_settings());
			?>

			<?php if (!empty($settings['tp_' . $btn_id . '_text']) || ($settings['tp_theme_btn_icon_show'] == 'yes') && $settings['tp_' . $btn_id . '_button_show'] == 'yes'): ?>
				<div class="tp-btn-wrapper tp-program-all">
					<a <?php echo $this->get_render_attribute_string('tp-button-arg' . $btn_id . ''); ?>>
						<?php if (!empty($line_effect)): ?>
							<span class="tp-acadia-btn-line tp-el-theme-line-btn"></span>
						<?php endif; ?>

						<?php if (($settings['tp_theme_btn_icon_position'] == 'left') && ($settings['tp_theme_btn_icon_show'] == 'yes')): ?>
							<?php tp_render_signle_icon_html($settings, 'theme_btn', 'theme-btn-icon on-left'); ?>
						<?php endif; ?>

						<?php if (!empty($settings['tp_' . $btn_id . '_text'])): ?>
							<span class="theme-btn-text"><?php echo $settings['tp_' . $btn_id . '_text']; ?></span>
						<?php endif; ?>

						<?php if (($settings['tp_theme_btn_icon_position'] == 'right') && ($settings['tp_theme_btn_icon_show'] == 'yes')): ?>
							<?php tp_render_signle_icon_html($settings, 'theme_btn', 'theme-btn-icon on-right'); ?>
						<?php endif; ?>
					</a>
				</div>
			<?php endif; ?>

			<?php elseif ($settings['tp_design_style'] == 'layout-5'):
			$tp_button_type = $settings['tp_button_type'];
			$this->tp_link_attributes_render('theme_btn', 'tp-el-theme-btn' . $tp_button_type, $this->get_settings());
			$animation = $this->tp_animation_show($settings);
			?>

			<div class="tp-megamenu-academics-banner <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
					<a <?php echo $this->get_render_attribute_string('tp-button-arg' . $btn_id . ''); ?>>

						<?php if (($settings['tp_theme_btn_icon_position'] == 'left') && ($settings['tp_theme_btn_icon_show'] == 'yes')): ?>
							<?php tp_render_signle_icon_html($settings, 'theme_btn', 'theme-btn-icon on-left'); ?>
						<?php endif; ?>


						<?php if (!empty($settings['tp_' . $btn_id . '_text'])): ?>
							<span class="theme-btn-text"><?php echo $settings['tp_' . $btn_id . '_text']; ?></span>
						<?php endif; ?>


						<?php if (($settings['tp_theme_btn_icon_position'] == 'right') && ($settings['tp_theme_btn_icon_show'] == 'yes')): ?>
							<?php tp_render_signle_icon_html($settings, 'theme_btn', 'theme-btn-icon on-right'); ?>
						<?php endif; ?>
					</a>
				</div>

		<?php else:
			$tp_button_type = $settings['tp_button_type'];
			$this->tp_link_attributes_render('theme_btn', 'tp-el-theme-btn d-inline-flex align-items-center tp-btn-round ' . $tp_button_type, $this->get_settings());
			$animation = $this->tp_animation_show($settings);
			?>


			<?php if (!empty($settings['tp_' . $btn_id . '_text']) || ($settings['tp_theme_btn_icon_show'] == 'yes') && $settings['tp_' . $btn_id . '_button_show'] == 'yes'): ?>
				<div class="tp-btn-wrapper <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
					<a <?php echo $this->get_render_attribute_string('tp-button-arg' . $btn_id . ''); ?>>

						<?php if (($settings['tp_theme_btn_icon_position'] == 'left') && ($settings['tp_theme_btn_icon_show'] == 'yes')): ?>
							<?php tp_render_signle_icon_html($settings, 'theme_btn', 'theme-btn-icon on-left'); ?>
						<?php endif; ?>


						<?php if (!empty($settings['tp_' . $btn_id . '_text'])): ?>
							<span class="theme-btn-text"><?php echo $settings['tp_' . $btn_id . '_text']; ?></span>
						<?php endif; ?>


						<?php if (($settings['tp_theme_btn_icon_position'] == 'right') && ($settings['tp_theme_btn_icon_show'] == 'yes')): ?>
							<?php tp_render_signle_icon_html($settings, 'theme_btn', 'theme-btn-icon on-right'); ?>
						<?php endif; ?>
					</a>
				</div>
			<?php endif; ?>

		<?php endif; ?>

		<?php
	}
}

$widgets_manager->register(new TP_Theme_Button());
