<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Utils;
use \Elementor\Control_Media;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Group_Control_Border;
use \Elementor\Group_Control_Box_Shadow;
use \Elementor\Group_Control_Text_Shadow;
use \Elementor\Group_Control_Typography;
use \Elementor\Core\Schemes\Typography;
use \Elementor\Group_Control_Background;
use TPCore\Elementor\Controls\Group_Control_TPGradient;
use \Elementor\Repeater;


if (!defined('ABSPATH'))
	exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_Icon_Box extends Widget_Base
{

	use TP_Style_Trait, TP_Icon_Trait, TP_Offcanvas_Trait, TP_Menu_Trait, TP_Animation_Trait;

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name()
	{
		return 'tp-icon-box';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title()
	{
		return __(TPCORE_THEME_NAME . ' :: Icon Box', 'tpcore');
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon()
	{
		return 'tp-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories()
	{
		return ['tpcore'];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends()
	{
		return ['tpcore'];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

	protected function register_controls()
	{
		$this->register_controls_section();
		$this->style_tab_content();
	}

	protected function register_controls_section()
	{
		$this->tp_design_layout('Layout', 4);

		$this->start_controls_section(
			'tp_icon_box_section',
			[
				'label' => esc_html__('Icon Box Contents', 'tpcore'),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		tp_render_icon_controls($this, 'icon_box');

		$this->add_control(
			'tp_icon_box_title',
			[
				'label' => esc_html__('Title', 'tpcore'),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Branding', 'tpcore'),
				'placeholder' => esc_html__('Your Text', 'tpcore'),
				'label_block' => true,
			]
		);

		tp_render_links_controls($this, 'icon_box');

		$this->add_control(
			'tp_icon_box_desc',
			[
				'label' => esc_html__('Description', 'tpcore'),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Branding is one of the most important ingredients for the success of any business.', 'tpcore'),
				'placeholder' => esc_html__('Your Text', 'tpcore'),
				'label_block' => true,
				'condition' => [
					'tp_design_style!' => ['layout-3'],
				]
			]
		);

		$this->end_controls_section();

		// animation
		$this->tp_creative_animation();

	}

	// style_tab_content
	protected function style_tab_content()
	{
		$this->tp_section_style_controls('section', 'Section - Style', '.tp-el-section:before');

		// icon 
		$this->start_controls_section(
		 'tp_icon_box_section_style',
			 [
			   'label' => esc_html__( 'Icon/Image/SVG', 'textdomain' ),
			   'tab'   => \Elementor\Controls_Manager::TAB_STYLE,
			 ]
		);

		$this->start_controls_tabs(
		   'tp_icon_box_tabs',
		 );
		
		$this->start_controls_tab(
		   'tp_icon_box_tab_icon',
		   [
			 'label'   => esc_html__( 'Icon', 'textdomain' ),
		   ]
		 );

		 $this->add_control(
		  'tp_icon_box_tab_icon_color',
		  [
			'label'       => esc_html__( 'Color', 'textdomain' ),
			'type'     => \Elementor\Controls_Manager::COLOR,
			'selectors' => [
			'{{WRAPPER}} .tp-icon-box-icon i' => 'color: {{VALUE}}',
			],
		  ]
		 );

		$this->add_responsive_control(
			'tp_icon_box_tab_icon_size',
			[
				'label' => esc_html__('Size', 'textdomain'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .tp-icon-box-icon i' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_tab();

		// Image 
		$this->start_controls_tab(
		   'tp_icon_box_tab_image',
		   [
			 'label'   => esc_html__( 'Image', 'textdomain' ),
		   ]
		 );


		$this->add_responsive_control(
			'tp_icon_box_tab_image_w',
			[
				'label' => esc_html__('Width', 'textdomain'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .tp-icon-box-icon img' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		
		$this->add_responsive_control(
			'tp_icon_box_tab_image_h',
			[
				'label' => esc_html__('Height', 'textdomain'),
				'type' => \Elementor\Controls_Manager::SLIDER,
				'size_units' => ['px', '%'],
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 1000,
						'step' => 5,
					],
					'%' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 20,
				],
				'selectors' => [
					'{{WRAPPER}} .tp-icon-box-icon img' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_tab();

		// SVG 
		$this->start_controls_tab(
			'tp_icon_box_tab_svg',
			[
			  'label'   => esc_html__( 'svg', 'textdomain' ),
			]
		  );
 
 
		 $this->add_responsive_control(
			 'tp_icon_box_tab_svg_w',
			 [
				 'label' => esc_html__('Width', 'textdomain'),
				 'type' => \Elementor\Controls_Manager::SLIDER,
				 'size_units' => ['px', '%'],
				 'range' => [
					 'px' => [
						 'min' => 0,
						 'max' => 1000,
						 'step' => 5,
					 ],
					 '%' => [
						 'min' => 0,
						 'max' => 100,
					 ],
				 ],
				 'default' => [
					 'unit' => 'px',
					 'size' => 20,
				 ],
				 'selectors' => [
					 '{{WRAPPER}} .tp-icon-box-icon svg' => 'width: {{SIZE}}{{UNIT}};',
				 ],
			 ]
		 );
 
		 
		 $this->add_responsive_control(
			 'tp_icon_box_tab_svg_h',
			 [
				 'label' => esc_html__('Height', 'textdomain'),
				 'type' => \Elementor\Controls_Manager::SLIDER,
				 'size_units' => ['px', '%'],
				 'range' => [
					 'px' => [
						 'min' => 0,
						 'max' => 1000,
						 'step' => 5,
					 ],
					 '%' => [
						 'min' => 0,
						 'max' => 100,
					 ],
				 ],
				 'default' => [
					 'unit' => 'px',
					 'size' => 20,
				 ],
				 'selectors' => [
					 '{{WRAPPER}} .tp-icon-box-icon svg' => 'height: {{SIZE}}{{UNIT}};',
				 ],
			 ]
		 );
		 $this->end_controls_tab();
		
		$this->end_controls_tabs();

		$this->add_control(
			'tp_icon_box_background',
			[
				'label' => esc_html__('Background Color', 'textdomain'),
				'type' => \Elementor\Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .tp-icon-box-icon span::before' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_group_control(
		 \Elementor\Group_Control_Border::get_type(),
		 [
		   'name'     => 'tp_icon_box_background_border',
		   'label'    => esc_html__( 'Border', 'textdomain' ),
		   'selector' => '{{WRAPPER}} .tp-icon-box-icon span::before',
		 ]
		);
		$this->end_controls_section();

		$this->tp_basic_style_controls('icon_box_title', 'Title', '.tp-el-title');
		$this->tp_basic_style_controls('icon_box_content', 'Description', '.tp-el-content');
	}

	/**
	 * Render the widget output on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render()
	{
		$settings = $this->get_settings_for_display(); ?>

		<?php if ($settings['tp_design_style'] == 'layout-4'):
			$animation = $this->tp_animation_show($settings);

			$attrs = tp_get_repeater_links_attr($settings, 'icon_box');

			extract($attrs);

			$links_attrs = [
				'href' => !empty($link) ? $link : '#',
				'target' => !empty($link_target) ? $link_target : '_self',
				'rel' => !empty($link_nofollow) ? 'nofollow' : '',
			];
			?>

			<div class="tp-tutor-item about text-center tp-el-section mb-30 <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<div class="tp-tutor-icon tp-icon-box-icon">
					<?php tp_render_signle_icon_html($settings, 'icon_box'); ?>
				</div>
				<div class="tp-tutor-content">

					<?php if (!empty($settings['tp_icon_box_title'])): ?>
						<h4 class="tp-category-title tp-el-title">
							<?php echo tp_kses($settings['tp_icon_box_title']); ?>
						</h4>
					<?php endif; ?>
					<?php if (!empty($settings['tp_icon_box_desc'])): ?>
						<p class="tp-el-content">
							<?php echo tp_kses($settings['tp_icon_box_desc']); ?>
						</p>
					<?php endif; ?>
				</div>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-3'):
			$animation = $this->tp_animation_show($settings);

			$attrs = tp_get_repeater_links_attr($settings, 'icon_box');

			extract($attrs);

			$links_attrs = [
				'href' => !empty($link) ? $link : '#',
				'target' => !empty($link_target) ? $link_target : '_self',
				'rel' => !empty($link_nofollow) ? 'nofollow' : '',
			];
			?>

			<div class="tp-category-5-item mb-60  <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<div class="tp-category-5-hover"></div>
				<div class="tp-category-5-thumb">
					<?php tp_render_signle_icon_html($settings, 'icon_box'); ?>
				</div>
				<div class="tp-category-5-content">
					<?php if (!empty($settings['tp_icon_box_title'])): ?>
						<h4 class="tp-category-5-title tp-el-title">
							<a <?php echo tp_implode_html_attributes($links_attrs); ?>>
								<?php echo tp_kses($settings['tp_icon_box_title']); ?>
								<span>
									<svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
										<path d="M1 7H13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round"></path>
										<path d="M7 1L13 7L7 13" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
											stroke-linejoin="round"></path>
									</svg>
								</span>
							</a>
						</h4>
					<?php endif; ?>
				</div>
			</div>

		<?php elseif ($settings['tp_design_style'] == 'layout-2'):
			$animation = $this->tp_animation_show($settings);

			$attrs = tp_get_repeater_links_attr($settings, 'icon_box');

			extract($attrs);

			$links_attrs = [
				'href' => !empty($link) ? $link : '#',
				'target' => !empty($link_target) ? $link_target : '_self',
				'rel' => !empty($link_nofollow) ? 'nofollow' : '',
			];
			?>

			<div class="tp-tutor-item text-center tp-el-section mb-30 <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
				<div class="tp-tutor-icon tp-icon-box-icon">
					<?php tp_render_signle_icon_html($settings, 'icon_box'); ?>
				</div>
				<div class="tp-tutor-content">
					<?php if (!empty($settings['tp_icon_box_title'])): ?>
						<h4 class="tp-tutor-title tp-el-title">
							<a <?php echo tp_implode_html_attributes($links_attrs); ?>>
								<?php echo tp_kses($settings['tp_icon_box_title']); ?>
							</a>
						</h4>
					<?php endif; ?>
					<?php if (!empty($settings['tp_icon_box_desc'])): ?>
						<p class="tp-el-content">
							<?php echo tp_kses($settings['tp_icon_box_desc']); ?>
						</p>
					<?php endif; ?>
				</div>
			</div>

		<?php else:
			$animation = $this->tp_animation_show($settings);

			$attrs = tp_get_repeater_links_attr($settings, 'icon_box');

			extract($attrs);

			$links_attrs = [
				'href' => !empty($link) ? $link : '#',
				'target' => !empty($link_target) ? $link_target : '_self',
				'rel' => !empty($link_nofollow) ? 'nofollow' : '',
			];
			?>
			<div class="tp-acadia-cat-iteam">
				<a <?php echo tp_implode_html_attributes($links_attrs); ?>
					class="tp-category-item tp-el-section mb-25 <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
					<div class="tp-category-icon">
						<span class="cat-purple tp-icon-box-icon">
							<?php tp_render_signle_icon_html($settings, 'icon_box'); ?>
						</span>
					</div>
					<div class="tp-category-content">
						<?php if (!empty($settings['tp_icon_box_title'])): ?>
							<h4 class="tp-category-title tp-el-title">
								<?php echo tp_kses($settings['tp_icon_box_title']); ?>
							</h4>
						<?php endif; ?>
						<?php if (!empty($settings['tp_icon_box_desc'])): ?>
							<span class="tp-el-content">
								<?php echo tp_kses($settings['tp_icon_box_desc']); ?>
							</span>
						<?php endif; ?>
					</div>
				</a>
			</div>
		<?php endif; ?>

		<?php
	}
}

$widgets_manager->register(new TP_Icon_Box());