<?php

namespace TPCore\Widgets;


if (!empty($settings['tp_offcanvas_logo']['url'])) {
   $tp_offcanvas_logo = !empty($settings['tp_offcanvas_logo']['id']) ? wp_get_attachment_image_url($settings['tp_offcanvas_logo']['id'], $offcanvas_image_size, true) : $settings['tp_offcanvas_logo']['url'];
   $tp_offcanvas_logo_alt = get_post_meta($settings["tp_offcanvas_logo"]["id"], "_wp_attachment_image_alt", true);
}
if (!empty($settings['tp_offcanvas_logo_white']['url'])) {
   $tp_offcanvas_logo_white = !empty($settings['tp_offcanvas_logo_white']['id']) ? wp_get_attachment_image_url($settings['tp_offcanvas_logo_white']['id'], $offcanvas_image_size, true) : $settings['tp_offcanvas_logo_white']['url'];
   $tp_offcanvas_logo_white_alt = get_post_meta($settings["tp_offcanvas_logo_white"]["id"], "_wp_attachment_image_alt", true);
}

?>
<?php if ($settings['tp_offcanvas_type'] == 'full_width'): ?>

   <!-- offcanvas area end -->
   <div class="tp-offcanvas-2-area p-relative">
      <div class="tp-offcanvas-2-bg is-left left-box"></div>
      <div class="tp-offcanvas-2-bg is-right right-box d-none d-md-block"></div>
      <div class="tp-offcanvas-2-wrapper">
         <div class="tp-offcanvas-2-left left-box">
            <div class="tp-offcanvas-2-left-wrap d-flex justify-content-between align-items-center">
               <div class="tpoffcanvas__logo">
                  <a class="logo-1 acadia-offcanvas-logo-black" href="<?php print esc_url(home_url('/')); ?>">
                     <img src="<?php echo esc_url($tp_offcanvas_logo); ?>"
                        alt="<?php echo esc_attr($tp_offcanvas_logo_alt); ?>">
                  </a>
                  <a class="logo-2 acadia-offcanvas-logo-white" href="<?php print esc_url(home_url('/')); ?>">
                     <img src="<?php echo esc_url($tp_offcanvas_logo_white); ?>"
                        alt="<?php echo esc_attr($tp_offcanvas_logo_white_alt); ?>">
                  </a>
               </div>
               <div class="tp-offcanvas-2-close d-md-none text-end">
                  <button class="tp-offcanvas-2-close-btn">
                     <span class="text">
                        <span><?php echo esc_html__('close', 'acadia'); ?></span>
                     </span>
                     <span class="d-inline-block">
                        <span>
                           <svg width="24" height="24" viewBox="0 0 24 24" fill="none" xmlns="http://www.w3.org/2000/svg">
                              <rect width="32.621" height="1.00918"
                                 transform="matrix(0.704882 0.709325 -0.704882 0.709325 1.0061 0)" fill="currentcolor" />
                              <rect width="32.621" height="1.00918"
                                 transform="matrix(0.704882 -0.709325 0.704882 0.709325 0 23.2842)" fill="currentcolor" />
                           </svg>
                        </span>
                     </span>

                  </button>
               </div>
            </div>
            <div class="tp-main-menu-mobile menu-hover-active counter-row">
               <nav></nav>
            </div>
         </div>
         <div class="tp-offcanvas-2-right right-box p-relative">

            <div class="tp-offcanvas-2-close  d-none d-lg-block text-end">
               <button class="tp-offcanvas-2-close-btn">
                  <span class="text">
                     <span><?php echo esc_html__('close', 'acadia'); ?></span>
                  </span>

                  <span class="d-inline-block">
                     <span>
                        <svg width="38" height="38" viewBox="0 0 38 38" fill="none" xmlns="http://www.w3.org/2000/svg">
                           <path d="M9.80859 9.80762L28.1934 28.1924" stroke="currentColor" stroke-width="1.5"
                              stroke-linecap="round" stroke-linejoin="round" />
                           <path d="M9.80859 28.1924L28.1934 9.80761" stroke="currentColor" stroke-width="1.5"
                              stroke-linecap="round" stroke-linejoin="round" />
                        </svg>
                     </span>
                  </span>

               </button>
            </div>


            <div class="tp-offcanvas-2-right-inner h-100">
               <?php echo \Elementor\Plugin::$instance->frontend->get_builder_content($settings['tp_offcanvas_template']); ?>
            </div>
         </div>
      </div>
   </div>
   <!-- offcanvas area start -->

<?php else: ?>
   <!-- offcanvas area start -->
   <div class="offcanvas__area offcanvas__2">
      <div class="offcanvas__wrapper">
         <div class="offcanvas__close">
            <button class="offcanvas__close-btn offcanvas-close-btn">
               <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M11 1L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                     stroke-linejoin="round" />
                  <path d="M1 1L11 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round"
                     stroke-linejoin="round" />
               </svg>
            </button>
         </div>
         <div class="offcanvas__content">
            <div class="offcanvas__top mb-70 d-flex justify-content-between align-items-center">
               <div class="offcanvas__logo logo">
                  <a href="<?php print esc_url(home_url('/')); ?>">
                     <img src="<?php echo esc_url($tp_offcanvas_logo); ?>"
                        alt="<?php echo esc_url($tp_offcanvas_logo_alt); ?>">
                  </a>
               </div>
            </div>
            <div class="offcanvas-main">
               <?php echo \Elementor\Plugin::$instance->frontend->get_builder_content($settings['tp_offcanvas_template']); ?>
            </div>
         </div>
      </div>
   </div>
   <div class="body-overlay"></div>
   <!-- offcanvas area end -->
<?php endif; ?>