<?php
namespace TPCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use TUTOR\Instructors_List;

use \Etn\Utils\Helper as Helper;

if (!defined('ABSPATH'))
    exit; // Exit if accessed directly

/**
 * Tp Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class TP_lp_Course_Card extends Widget_Base
{

    use TP_Style_Trait, TP_Column_Trait, TP_Query_Trait, TP_Animation_Trait;
    /**
     * Retrieve the widget name.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget name.
     */
    public function get_name()
    {
        return 'lp-course-card';
    }

    /**
     * Retrieve the widget title.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget title.
     */
    public function get_title()
    {
        return __(TPCORE_THEME_NAME . ' :: Learnpress Course Card', 'tpcore');
    }

    /**
     * Retrieve the widget icon.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return string Widget icon.
     */
    public function get_icon()
    {
        return 'tp-icon';
    }

    /**
     * Retrieve the list of categories the widget belongs to.
     *
     * Used to determine where to display the widget in the editor.
     *
     * Note that currently Elementor supports only one category.
     * When multiple categories passed, Elementor uses the first one.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget categories.
     */
    public function get_categories()
    {
        return ['tpcore'];
    }

    /**
     * Retrieve the list of scripts the widget depended on.
     *
     * Used to set scripts dependencies required to run the widget.
     *
     * @since 1.0.0
     *
     * @access public
     *
     * @return array Widget scripts dependencies.
     */
    public function get_script_depends()
    {
        return ['tpcore'];
    }

    /**
     * Register the widget controls.
     *
     * Adds different input fields to allow the user to change and customize the widget settings.
     *
     * @since 1.0.0
     *
     * @access protected
     */



    protected function register_controls()
    {
        $this->register_controls_section();
        $this->style_tab_content();
    }

    protected function register_controls_section()
    {

        $this->tp_design_layout('Select Layout', 4);

        $this->tp_query_controls('course_card', 'Course Controls', 'lp_course', 'course_category');

        $this->start_controls_section(
            'course_sec',
            [
                'label' => esc_html__('Content Controls', 'tpcore'),
                'tab' => Controls_Manager::TAB_CONTENT,
                'condition' => [
                    'tp_design_style' => [ 'layout-2', 'layout-4' ]
                ]
            ]
        );
        
        $this->add_control(
            'tp_post_content',
            [
                'label' => esc_html__('Description', 'tpcore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'tpcore'),
                'label_off' => esc_html__('Hide', 'tpcore'),
                'return_value' => 'yes',
                'default' => 'yes',
                'condition' => [
                    'tp_design_style' => ['layout-2']
                ]
            ]
        );
        $this->add_control(
            'tp_post_content_limit',
            [
                'label' => esc_html__('Description Limit', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => '10',
                'dynamic' => [
                    'active' => true,
                ],
                'condition' => [
                    'tp_post_content' => 'yes',
                    'tp_design_style' => ['layout-2']
                ]
            ]
        );

        $this->add_control(
            'tp_course_main_image',
            [
                'label' => esc_html__('Main Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => 'layout-2'
                ]
            ]
        );
        
        $this->add_control(
            'tp_course_time',
            [
                'label' => esc_html__('Course Time', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('20 min', 'tpcore'),
                'placeholder' => esc_html__('Your Course Time here', 'tpcore'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => 'layout-2'
                ]
            ]
        );

        $this->add_control(
            'tp_course_student_text',
            [
                'label' => esc_html__('Students Text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Offline Students', 'tpcore'),
                'placeholder' => esc_html__('Your Offline Students here', 'tpcore'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => 'layout-2'
                ]
            ]
        );

        $this->add_control(
            'tp_course_live_image',
            [
                'label' => esc_html__('Live video Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => 'layout-2'
                ]
            ]
        );

        $this->add_control(
            'tp_course_student_image',
            [
                'label' => esc_html__('Student Image', 'tpcore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'tp_design_style' => 'layout-2'
                ]
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'tp_image',
                'default' => 'full',
                'exclude' => [
                    'custom'
                ],
                'condition' => [
                    'tp_design_style' => 'layout-2'
                ]
            ]
        );

        // course button
        $this->add_control(
            'tp_course_btn_text',
            [
                'label' => esc_html__('Button Text', 'tpcore'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Preview This Course', 'tpcore'),
                'placeholder' => esc_html__('Your Text', 'tpcore'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => 'layout-2'
                ]
            ]
        );

        $this->add_control(
            'tp_course_btn_url',
            [
                'label' => esc_html__('Video Class Url', 'tpcore'),
                'type' => Controls_Manager::URL,
                'default' => [
                    'url' => '#',
                    'is_external' => true,
                    'nofollow' => true,
                    'custom_attributes' => '',
                ],
                'placeholder' => esc_html__('Placeholder Text', 'tpcore'),
                'label_block' => true,
                'condition' => [
                    'tp_design_style' => 'layout-2'
                ]
            ]
        );

        $this->end_controls_section();

        // animation
        $this->tp_creative_animation();
    }

    protected function style_tab_content()
    {
        $this->tp_section_style_controls('a_p_content_style', 'Content', '.tp-el-content');

    }
    /**
     * Render the widget output on the frontend.
     *
     * Written in PHP and used to generate the final HTML.
     *
     * @since 1.0.0
     *
     * @access protected
     */
    protected function render()
    {
        $settings = $this->get_settings_for_display();
        ?>

        <?php if ($settings['tp_design_style'] == 'layout-2') : 
        $animation = $this->tp_animation_show($settings);
        if (!empty($settings['tp_course_btn_url']['url'])) {
            $this->add_link_attributes('tp_course_btn_url', $settings['tp_course_btn_url']);
        }
        $main_image = tp_get_img($settings, 'tp_course_main_image', 'tp_image');

        $live_image = tp_get_img($settings, 'tp_course_live_image', 'tp_image');
        $student_image = tp_get_img($settings, 'tp_course_student_image', 'tp_image');
        $args = tp_query_args('lp_course', 'course_category', $this->get_settings());
        $main_query = new \WP_Query($args);
        ?>

        <?php 
        if ($main_query->have_posts()):
        $main_query->the_post();
        global $post;
        $course          = \LP_Global::course();
        $instructor      = $course->get_instructor();
        $instructor_link = $course->get_instructor_html();
        $course_categories = get_the_terms($course->get_id(), 'course_category');

        $dir = learn_press_user_profile_picture_upload_dir();
        $user = get_user_by( 'id', $instructor->get_id());
        $pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
        $base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
        $profile_link =  $base_url.'/'.$pro_link;

        $attrs = [
            'class' => "tp-live-bg " . $animation['animation'] . ' ' . $animation['duration'] . ' ' . $animation['delay'],
        ];
        $cat_color = '#17A2B8';
        if (!empty($course_categories[0])) {
            $cat_color = get_term_meta($course_categories[0]->term_id, '_acadia_course_cat_color', true);
            $cat_color = !empty($cat_color) ? $cat_color : '#17A2B8';
        }
        ?>
        <div <?php echo tp_implode_html_attributes($attrs); ?>>
            <div class="row align-items-center">
                <div class="col-lg-6 col-md-6 col-12">
                    <div class="tp-live-thumb p-relative">
                        <img src="<?php echo esc_url($main_image['tp_course_main_image']); ?>"
                            alt="<?php echo esc_attr($main_image['tp_course_main_image_alt']); ?>">

                        <?php if (!empty($live_image['tp_course_live_image'])): ?>
                            <div class="tp-live-thumb-video">
                                <img src="<?php echo esc_url($live_image['tp_course_live_image']); ?>"
                                    alt="<?php echo esc_attr($live_image['tp_course_live_image_alt']); ?>">
                            </div>
                        <?php endif; ?>

                        <?php if (!empty($settings['tp_course_time'])): ?>
                            <div class="tp-live-thumb-text">
                                <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 16 16" fill="none">
                                        <path
                                            d="M8 15C11.866 15 15 11.866 15 8C15 4.13401 11.866 1 8 1C4.13401 1 1 4.13401 1 8C1 11.866 4.13401 15 8 15Z"
                                            stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        </path>
                                        <path d="M8 3.7998V7.9998L10.8 9.3998" stroke="white" stroke-width="2"
                                            stroke-linecap="round" stroke-linejoin="round">
                                        </path>
                                    </svg>
                                    <?php echo tp_kses($settings['tp_course_time']); ?>
                                </span>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-6 col-md-6 col-12">
                    <div class="tp-live-content">

                        <?php if (!empty($course_categories[0])): ?>
                            <span class="tp-live-tag" data-cat-color="<?php echo esc_attr($cat_color); ?>">
                                <a href="<?php echo get_term_link($course_categories[0]); ?>">
                                    <?php echo esc_html($course_categories[0]->name); ?>
                                </a>
                            </span>
                        <?php endif; ?>

                        <div class="tp-live-teacher">
                            <div class="tp-live-teacher-info d-flex align-items-center">
                                <div class="tp-live-teacher-thumb">
                                    <img src="<?php echo esc_url( get_avatar_url( $instructor->get_id() ) ); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
                                </div>
                                <div class="tp-live-teacher-text">
                                    <span><?php echo esc_html__( 'Instructor', 'tpcore' ); ?></span>

                                    <h4 class="tp-live-teacher-title"><?php echo esc_html( $user->display_name );  ?></h4>
                                </div>
                            </div>

                            <?php 
                            if( function_exists( 'learn_press_get_course_rate' ) ) {

                                $rated = $course_rate_res['rated'] ?? 0;
                                $course_rate_res = learn_press_get_course_rate( get_the_ID(), false );
                            ?>
                            <div class="tp-live-rating">
                                <p><?php echo esc_html( $rated ); ?><span><?php echo esc_html__( '/5', 'acadia' ); ?></span></p>
                                <div class="tp-live-rating-star">
                                    <?php
                                    \LP_Addon_Course_Review_Preload::$addon->get_template(
                                        'rating-stars.php',
                                        array( 'rated' => $course_rate_res['rated'] )
                                    );
                                    ?>
                                </div>
                            </div>
                            <?php 	
                            }
                            ?>
                        </div>

                        <h4 class="tp-live-title">
                            <a href="<?php the_permalink(); ?>">
                                <?php echo wp_trim_words(get_the_title(), $settings['tp_post_title_word'], ''); ?>
                            </a>
                        </h4>

                        <div class="tp-live-total">
                            <div class="tp-live-total-student">
                                <?php if (!empty($settings['tp_course_student_text'])): ?>
                                    <span>
                                        <?php echo tp_kses($settings['tp_course_student_text']); ?>
                                    </span>
                                <?php endif; ?>

                                <?php if (!empty($student_image['tp_course_student_image'])): ?>
                                    <img src="<?php echo esc_url($student_image['tp_course_student_image']); ?>"
                                        alt="<?php the_title(); ?>">
                                <?php endif; ?>
                            </div>

                            <?php if (!empty($settings['tp_course_btn_text'])): ?>
                                <div class="tp-live-join">
                                    <a class="tp-btn-border" <?php $this->print_render_attribute_string('tp_course_btn_url'); ?>>
                                        <span>
                                            <svg width="16" height="14" viewBox="0 0 16 14" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M3.70732 0.75H8.39024C9.65603 0.75 10.333 1.00147 10.7145 1.38301C11.0961 1.76456 11.3476 2.44153 11.3476 3.70732V9.95122C11.3476 11.217 11.0961 11.894 10.7145 12.2755C10.333 12.6571 9.65603 12.9085 8.39024 12.9085H3.70732C2.53342 12.9085 1.82979 12.5071 1.40543 11.9979C0.961765 11.4655 0.75 10.7255 0.75 9.95122V3.70732C0.75 2.44153 1.00147 1.76456 1.38301 1.38301C1.76456 1.00147 2.44153 0.75 3.70732 0.75Z"
                                                    stroke="currentColor" stroke-width="1.5">
                                                </path>
                                                <path
                                                    d="M7.21976 6.34479C8.03014 6.34479 8.68708 5.68785 8.68708 4.87747C8.68708 4.0671 8.03014 3.41016 7.21976 3.41016C6.40938 3.41016 5.75244 4.0671 5.75244 4.87747C5.75244 5.68785 6.40938 6.34479 7.21976 6.34479Z"
                                                    fill="currentColor">
                                                </path>
                                                <path
                                                    d="M13.6712 10.4795L13.6684 10.4775L12.8476 9.90073V3.75854L13.6676 3.18235C13.6677 3.18227 13.6678 3.18219 13.668 3.18211C14.021 2.93474 14.2801 2.87809 14.4413 2.87174C14.6067 2.86523 14.7268 2.9096 14.7996 2.94693C14.8665 2.98117 14.9706 3.05164 15.0602 3.19079C15.1476 3.3265 15.2501 3.57203 15.2501 4.00427V9.66281C15.2501 10.095 15.1476 10.3406 15.0602 10.4763C14.9706 10.6154 14.8665 10.6859 14.7996 10.7202L14.7996 10.7201L14.7922 10.724C14.7375 10.7528 14.6301 10.7938 14.4781 10.7938C14.3158 10.7938 14.0436 10.7437 13.6712 10.4795Z"
                                                    stroke="currentColor" stroke-width="1.5">
                                                </path>
                                            </svg>
                                        </span>
                                        <?php echo tp_kses($settings['tp_course_btn_text']); ?>
                                        <i>
                                            <svg width="14" height="11" viewBox="0 0 14 11" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M8.71533 1L13 5.28471L8.71533 9.56941" stroke="currentColor"
                                                    stroke-width="2" stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round">
                                                </path>
                                                <path d="M1 5.28473H12.88" stroke="currentColor" stroke-width="2"
                                                    stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round">
                                                </path>
                                            </svg>
                                        </i>
                                    </a>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php endif;  wp_reset_query();?>

        <?php 
        elseif ($settings['tp_design_style'] == 'layout-3') : 
            $animation = $this->tp_animation_show($settings);
        ?>

        <div class="tp-course-5-position">
            <div class="row tp-gx-60 <?php echo esc_attr($animation['animation']); ?>"
                <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
                <?php
                $args       = tp_query_args('lp_course', 'course_category', $this->get_settings());
                $main_query = new \WP_Query($args);
                ?>
                <?php if ($main_query->have_posts()): ?>
                    <?php while ($main_query->have_posts()):
                        $main_query->the_post();
                        global $post;
                        $course     = \LP_Global::course();
                        $price      = !empty($course->get_origin_price()) ? $course->get_origin_price_html() : "<span class='price'><span class='lms-free'>Free</span></span>";
                        $instructor = $course->get_instructor();
                        $instructor_link = $course->get_instructor_html();
                        $user = get_user_by( 'id', $instructor->get_id());
                        $pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
                        $base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
                        $profile_link =  $base_url.'/'.$pro_link;

                        ?>
                        <div class="col-lg-4 col-md-6">
                            <div class="tp-course-5-item mb-60">
                                <div class="tp-course-5-hover"></div>
                                <?php if( has_post_thumbnail() ) : ?>
                                <div class="tp-course-5-thumb">
                                    <?php the_post_thumbnail(); ?>
                                    <div class="tp-course-5-price">
                                        <span><?php echo tp_kses($price); ?></span>
                                    </div>
                                </div>
                                <?php endif; ?>
                                <div class="tp-course-5-content">

                                    <?php if($pro_link !='') : ?>
                                    <div class="tp-course-5-avatar d-flex align-items-center">
                                        <span><img src="<?php echo esc_url($profile_link); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>"></span>
                                        <h5 class="tp-course-5-avatar-title"><?php echo wp_kses_post($instructor_link) ?></h5>
                                    </div>
                                    <?php else : ?>
                                    <div class="tp-course-5-avatar d-flex align-items-center">
                                        <span><img src="<?php echo esc_url( get_avatar_url( $instructor->get_id() ) ); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>"></span>
                                        <h5 class="tp-course-5-avatar-title"><?php echo wp_kses_post($instructor_link) ?></h5>
                                    </div>
                                    <?php endif; ?>

                                    <h4 class="tp-course-5-title"><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), $settings['tp_post_title_word'], ''); ?></a></h4>
                                    <div class="tp-course-meta">
                                        <span>
                                            <span>
                                                <svg width="15" height="14" viewBox="0 0 15 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z" stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                                                    <path d="M7.46118 2.81787V12.4506" stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                                                </svg>
                                            </span>
                                            <?php   
                                                $lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0; 
                                                echo esc_html($lessons). esc_html__(' lessons','acadia'); 
                                            ?>
                                        </span>
                                        <span>
                                            <span>
                                                <svg width="13" height="15" viewBox="0 0 13 15" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z" stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                                                    <path d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14" stroke="#94928E" stroke-width="1.2" stroke-linecap="round" stroke-linejoin="round"/>
                                                </svg>
                                            </span>
                                            <?php 
                                            $student = _n('%s  Student', '%s Students', $course->get_users_enrolled(), 'acadia');
                                            echo sprintf($student, $course->get_users_enrolled());
                                            ?> 
                                        </span>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endwhile;
                    wp_reset_query();
                endif; ?>
            </div>
        </div>

        <?php 
        elseif ($settings['tp_design_style'] == 'layout-4') : 
            $animation = $this->tp_animation_show($settings);
        ?>

        <div class="row <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>

            <?php
            $args = tp_query_args('lp_course', 'course_category', $this->get_settings());
            $main_query = new \WP_Query($args);
            ?>

            <?php if ($main_query->have_posts()):
            while ($main_query->have_posts()):
                $main_query->the_post();
                
                global $post;
                $course     = \LP_Global::course();
                $instructor = $course->get_instructor();
                $instructor_link = $course->get_instructor_html();
                $user = get_user_by( 'id', $instructor->get_id());
                $pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
                $base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
                $profile_link =  $base_url.'/'.$pro_link;
            ?>
            <div class="col-lg-6">
                <div class="tp-course-4-item d-flex wow fadeInUp" data-wow-delay=".3s">
                    <?php if( has_post_thumbnail() ) : ?>
                    <div class="tp-course-4-thumb">
                        <?php the_post_thumbnail(); ?>
                    </div>
                    <?php endif; ?>
                    <div class="tp-course-4-content">

                        <?php 
                        if( function_exists( 'learn_press_get_course_rate' ) ) {

                            $rated = $course_rate_res['rated'] ?? 0;
                            $course_rate_res = learn_press_get_course_rate( get_the_ID(), false );
                        ?>
                        <div class="tp-course-4-rating d-flex">
                            <?php
                            \LP_Addon_Course_Review_Preload::$addon->get_template(
                                'rating-stars.php',
                                array( 'rated' => $course_rate_res['rated'] )
                            );
                            ?>
                            <span>(<?php echo $course_rate_res['total'] . ' reviews'; ?>)</span>
                        </div>
                        <?php
                        }
                        ?>
                        
                        <h4 class="tp-course-4-title"><a class="tp-el-title" href="<?php the_permalink(); ?>"><?php echo wp_trim_words(get_the_title(), $settings['tp_post_title_word'], ''); ?></a></h4>
                        <div class="tp-course-4-info d-flex align-items-center">
                            <div class="tp-course-4-info-item">
                                <span>
                                    <span>
                                    <svg width="15" height="14" viewBox="0 0 15 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M13.9231 10.0426V2.29411C13.9231 1.51825 13.2951 0.953997 12.5254 1.01445H12.4849C11.1278 1.12529 9.07187 1.82055 7.9173 2.53596L7.80591 2.6065C7.62361 2.71733 7.30959 2.71733 7.11717 2.6065L6.95515 2.50573C5.81071 1.79033 3.75477 1.1152 2.39764 1.00437C1.62793 0.943911 1 1.51827 1 2.28405V10.0426C1 10.6573 1.50637 11.2417 2.12417 11.3122L2.30646 11.3425C3.7041 11.5238 5.8715 12.2392 7.10709 12.9143L7.13744 12.9244C7.30961 13.0252 7.59318 13.0252 7.75522 12.9244C8.99081 12.2393 11.1683 11.5339 12.5761 11.3425L12.7888 11.3122C13.4167 11.2417 13.9231 10.6674 13.9231 10.0426Z"
                                            stroke="#6D6C68" stroke-width="1.2" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                        <path d="M7.46143 2.81787V12.4506" stroke="#6D6C68" stroke-width="1.2"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                    </span>
                                    <?php   
                                        $lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0; 
                                        echo esc_html($lessons). esc_html__(' lessons','acadia'); 
                                    ?>
                                </span>
                            </div>
                            <div class="tp-course-4-info-item">
                                <span>
                                    <span>
                                    <svg xmlns="http://www.w3.org/2000/svg" width="13" height="15" viewBox="0 0 13 15"
                                        fill="none">
                                        <path
                                            d="M6.57159 7.5C8.36263 7.5 9.81456 6.04493 9.81456 4.25C9.81456 2.45507 8.36263 1 6.57159 1C4.78054 1 3.32861 2.45507 3.32861 4.25C3.32861 6.04493 4.78054 7.5 6.57159 7.5Z"
                                            stroke="#6D6C68" stroke-width="1.2" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                        <path
                                            d="M12.1429 14C12.1429 11.4845 9.64577 9.44995 6.57143 9.44995C3.49709 9.44995 1 11.4845 1 14"
                                            stroke="#6D6C68" stroke-width="1.2" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                    </span>
                                    <?php 
                                    $student = _n('%s  Student', '%s Students', $course->get_users_enrolled(), 'acadia');
                                    echo sprintf($student, $course->get_users_enrolled());
                                    ?> 
                                </span>
                            </div>
                        </div>
                        <?php if (!empty($settings['tp_post_content'])):
                            $tp_post_content_limit = (!empty($settings['tp_post_content_limit'])) ? $settings['tp_post_content_limit'] : '';
                            ?>
                            <p class="tp-el-rep-des tp-el-c-desc">
                                <?php print wp_trim_words(get_the_excerpt(get_the_ID()), $tp_post_content_limit, ''); ?>
                            </p>
                        <?php endif; ?>
                        <div class="tp-course-4-avatar d-flex align-items-center justify-content-between">
                            <div class="tp-course-4-avatar-info d-flex align-items-center">
                                <?php if($pro_link !='') : ?>
                                <div class="tp-course-4-avatar-thumb">
                                    <img src="<?php echo esc_url($profile_link); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
                                </div>
                                <?php else : ?>
                                <div class="tp-course-4-avatar-thumb">
                                    <img src="<?php echo esc_url( get_avatar_url( $instructor->get_id() ) ); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
                                </div>
                                <?php endif; ?>

                                <div class="tp-course-4-avatar-text">
                                    <span><?php echo esc_html__( 'By', 'tpcore' ); ?></span>
                                    <?php echo wp_kses_post($instructor_link) ?>
                                </div>
                            </div>
                            <div class="tp-course-4-ammount">
                                <?php if($course->is_free()): ?>
                                <span><?php echo esc_html__('Free','acadia'); ?></span>
                                <?php else: ?>
                                <?php if ( $course->get_origin_price() != $course->get_price() ) : ?>
                                <span class='d-block'><del><?php echo esc_html($course->get_origin_price_html()); ?></del></span>
                                <?php endif; ?>
                                <span><?php echo esc_html($course->get_price_html()); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endwhile; wp_reset_query(); endif; ?>

        </div>

        <?php else: 
        $animation = $this->tp_animation_show($settings);    
        ?>

            <div class="tp-hero-2-course p-relative <?php echo esc_attr($animation['animation']); ?>" <?php echo $animation['duration'] . ' ' . $animation['delay']; ?>>
                
                <?php 
                $args = tp_query_args('lp_course', 'course-category', $this->get_settings());
                $main_query = new \WP_Query($args);
                if ($main_query->have_posts()):
                    while ($main_query->have_posts()):
                        $main_query->the_post();
                        $course          = \LP_Global::course();
                        $instructor      = $course->get_instructor();
                        $instructor_link = $course->get_instructor_html();
                        $instructor_id   = $course->get_id();
                        $categories = get_the_terms($course->get_id(), 'course_category');

                        $dir = learn_press_user_profile_picture_upload_dir();
                        $user = get_user_by( 'id', $instructor->get_id());
                        $pro_link = get_user_meta($user->ID,'_lp_profile_picture',true); 
                        $base_url = isset($dir['baseurl'])?$dir['baseurl']:'';
                        $profile_link =  $base_url.'/'.$pro_link;

                        if(!empty($course->get_origin_price())) {
                            $old_price = $course->get_origin_price();
                        }
                        if(!empty($course->get_price())) {
                            $new_price = $course->get_price();
                        }
                        
                        if( !empty( $course->get_origin_price() && $course->get_price() ) && true != $course->is_free() ) {
                            $discount_percentage = (($old_price - $new_price) / $old_price) * 100;
                            $discount_percentage = round($discount_percentage, 2);
                        }
                ?>
                <div class="tp-course-item p-relative fix mb-30">
                    <?php if($pro_link !='') : ?>
                    <div class="tp-course-teacher mb-15">
                        <span><img src="<?php echo esc_url($profile_link); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
                        <?php echo wp_kses_post($instructor_link) ?></span>
                        <?php if( !empty( $discount_percentage ) ) : ?>
                        <span class="discount">-<?php echo esc_html( $discount_percentage . '%' ); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php else : ?>
                    <div class="tp-course-teacher mb-15">
                        <span><img src="<?php echo esc_url( get_avatar_url( $instructor->get_id() ) ); ?>" alt="<?php  echo  esc_attr($user->display_name); ?>">
                        <?php echo wp_kses_post($instructor_link) ?></span>
                        <?php if( !empty( $discount_percentage ) ) : ?>
                        <span class="discount">-<?php echo esc_html( $discount_percentage . '%' ); ?></span>
                        <?php endif; ?>
                    </div>
                    <?php endif; ?>
                    <?php if( has_post_thumbnail() ) : ?>
                    <div class="tp-course-thumb sidebar">
                        <a href="<?php the_permalink()?>"><img class="course-pink" src="<?php echo get_the_post_thumbnail_url()?>" alt="<?php echo esc_attr__( 'course-thumb', 'acadia' );  ?>"></a>
                    </div>
                    <?php endif; ?>
                    <div class="tp-course-content">
                        <?php if( !empty( $categories[0]->name ) ) : ?>
                        <div class="tp-course-tag mb-10">
                            <span><?php echo esc_html( $categories[0]->name ); ?></span>
                        </div>
                        <?php endif; ?>
                        <div class="tp-course-meta">
                            <span>
                                <span>
                                    <svg width="15" height="14" viewBox="0 0 15 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M13.9228 10.0426V2.29411C13.9228 1.51825 13.2949 0.953997 12.5252 1.01445H12.4847C11.1276 1.12529 9.07163 1.82055 7.91706 2.53596L7.80567 2.6065C7.62337 2.71733 7.30935 2.71733 7.11692 2.6065L6.9549 2.50573C5.81046 1.79033 3.75452 1.1152 2.3974 1.00437C1.62768 0.943911 0.999756 1.51827 0.999756 2.28405V10.0426C0.999756 10.6573 1.50613 11.2417 2.12393 11.3122L2.30622 11.3425C3.70386 11.5238 5.87126 12.2392 7.10685 12.9143L7.1372 12.9244C7.30937 13.0252 7.59293 13.0252 7.75498 12.9244C8.99057 12.2393 11.1681 11.5339 12.5758 11.3425L12.7885 11.3122C13.4164 11.2417 13.9228 10.6674 13.9228 10.0426Z"
                                            stroke="#94928E" stroke-width="1.2"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                        <path d="M7.46118 2.81787V12.4506" stroke="#94928E"
                                            stroke-width="1.2" stroke-linecap="round"
                                            stroke-linejoin="round" />
                                    </svg>
                                </span>
                                <?php   
                                    $lessons = $course->get_curriculum_items( 'lp_lesson' )? count( $course->get_curriculum_items( 'lp_lesson' ) ) : 0; 
                                    echo esc_html($lessons). esc_html__(' lessons','acadia'); 
                                ?>
                            </span>
                            <span>
                                <span>
                                    <svg width="13" height="15" viewBox="0 0 13 15" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path
                                            d="M6.57134 7.5C8.36239 7.5 9.81432 6.04493 9.81432 4.25C9.81432 2.45507 8.36239 1 6.57134 1C4.7803 1 3.32837 2.45507 3.32837 4.25C3.32837 6.04493 4.7803 7.5 6.57134 7.5Z"
                                            stroke="#94928E" stroke-width="1.2"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                        <path
                                            d="M12.1426 14C12.1426 11.4845 9.64553 9.44995 6.57119 9.44995C3.49684 9.44995 0.999756 11.4845 0.999756 14"
                                            stroke="#94928E" stroke-width="1.2"
                                            stroke-linecap="round" stroke-linejoin="round" />
                                    </svg>
                                </span>
                                <?php 
                                $student = _n('%s  Student', '%s Students', $course->get_users_enrolled(), 'acadia');
                                echo sprintf($student, $course->get_users_enrolled());
                                ?> 
                            </span>
                        </div>
                        <h4 class="tp-course-title">
                            <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                        </h4>
                        <div class="tp-course-rating d-flex align-items-end justify-content-between">

                            <?php 
                            if( function_exists( 'learn_press_get_course_rate' ) ) {

                                $rated = $course_rate_res['rated'] ?? 0;
                                $course_rate_res = learn_press_get_course_rate( get_the_ID(), false );
                            ?>
                            <div class="tp-course-rating-star">
                                <p><?php echo esc_html( $rated ); ?><span><?php echo esc_html__( '/5', 'acadia' ); ?></span></p>
                                <?php
                                \LP_Addon_Course_Review_Preload::$addon->get_template(
                                    'rating-stars.php',
                                    array( 'rated' => $course_rate_res['rated'] )
                                );
                                ?>
                            </div>
                            <?php 	
                            }
                            ?>
                            
                            <div class="tp-course-pricing">
                                <?php if($course->is_free()): ?>
                                <span><?php echo esc_html__('Free','acadia'); ?></span>
                                <?php else: ?>
                                <?php if ( $course->get_origin_price() != $course->get_price() ) : ?>
                                <span class='d-block'><del><?php echo esc_html($course->get_origin_price_html()); ?></del></span>
                                <?php endif; ?>
                                <span><?php echo esc_html($course->get_price_html()); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>
                    <div class="tp-course-btn">
                        <a href="<?php the_permalink()?>"><?php echo esc_html__( 'Preview this course', 'acadia' ); ?></a>
                    </div>
                </div>
                <?php endwhile;
                    wp_reset_query();
                endif; ?>

            </div>


        <?php endif; ?>

        <?php
    }
}

$widgets_manager->register(new TP_lp_Course_Card());