<?php if ( ! defined( 'ABSPATH' ) ) { die; } // Cannot access directly.
/**
 *
 * Field: icon
 *
 * @since 1.0.0
 * @version 1.0.0
 *
 */
if ( ! class_exists( 'ECTCSF_Field_icon' ) ) {
  class ECTCSF_Field_icon extends ECTCSF_Fields {

    public function __construct( $field, $value = '', $unique = '', $where = '', $parent = '' ) {
      parent::__construct( $field, $value, $unique, $where, $parent );
    }

    public function render() {

      $args = wp_parse_args( $this->field, array(
        'button_title' => esc_html__( 'Add Icon', 'ectcsf' ),
        'remove_title' => esc_html__( 'Remove Icon', 'ectcsf' ),
      ) );

      echo $this->field_before();

      $nonce  = wp_create_nonce( 'ectcsf_icon_nonce' );
      $hidden = ( empty( $this->value ) ) ? ' hidden' : '';

      echo '<div class="ectcsf-icon-select">';
      echo '<span class="ectcsf-icon-preview'. esc_attr( $hidden ) .'"><i class="'. esc_attr( $this->value ) .'"></i></span>';
      echo '<a href="#" class="button button-primary ectcsf-icon-add" data-nonce="'. esc_attr( $nonce ) .'">'. $args['button_title'] .'</a>';
      echo '<a href="#" class="button ectcsf-warning-primary ectcsf-icon-remove'. esc_attr( $hidden ) .'">'. $args['remove_title'] .'</a>';
      echo '<input type="hidden" name="'. esc_attr( $this->field_name() ) .'" value="'. esc_attr( $this->value ) .'" class="ectcsf-icon-value"'. $this->field_attributes() .' />';
      echo '</div>';

      echo $this->field_after();

    }

    public function enqueue() {
      add_action( 'admin_footer', array( 'ECTCSF_Field_icon', 'add_footer_modal_icon' ) );
      add_action( 'customize_controls_print_footer_scripts', array( 'ECTCSF_Field_icon', 'add_footer_modal_icon' ) );
    }

    public static function add_footer_modal_icon() {
    ?>
      <div id="ectcsf-modal-icon" class="ectcsf-modal ectcsf-modal-icon hidden">
        <div class="ectcsf-modal-table">
          <div class="ectcsf-modal-table-cell">
            <div class="ectcsf-modal-overlay"></div>
            <div class="ectcsf-modal-inner">
              <div class="ectcsf-modal-title">
                <?php esc_html_e( 'Add Icon', 'ectcsf' ); ?>
                <div class="ectcsf-modal-close ectcsf-icon-close"></div>
              </div>
              <div class="ectcsf-modal-header">
                <input type="text" placeholder="<?php esc_html_e( 'Search...', 'ectcsf' ); ?>" class="ectcsf-icon-search" />
              </div>
              <div class="ectcsf-modal-content">
                <div class="ectcsf-modal-loading"><div class="ectcsf-loading"></div></div>
                <div class="ectcsf-modal-load"></div>
              </div>
            </div>
          </div>
        </div>
      </div>
    <?php
    }

  }
}
