<?php

/**
 * The template for displaying 404 pages (not found)
 *
 * @link https://codex.wordpress.org/Creating_an_Error_404_Page
 *
 * @package acadia
 */

get_header();

$acadia_404_thumb = get_theme_mod('acadia_error_thumb', get_template_directory_uri() . '/assets/img/error/error.png');
$acadia_error_title = get_theme_mod('acadia_error_title', __('Oops!', 'acadia'));
$acadia_error_title_sm = get_theme_mod('acadia_error_title_sm', __('Something went Wrong...', 'acadia'));
$acadia_error_link_text = get_theme_mod('acadia_error_link_text', __('Back To Home', 'acadia'));
$acadia_error_desc = get_theme_mod('acadia_error_desc', __('Sorry, we couldn\'t find your page.', 'acadia'));

?>



<!-- error area start -->
<div class="tp-error-area pt-120 pb-120">
   <div class="container">
      <div class="row">
         <div class="col-xl-12">
            <div class="tp-error-wrapper text-center">

               <?php if (!empty($acadia_error_title)) : ?>
                  <h3 class="tp-error-title"><?php print esc_html($acadia_error_title); ?></h3>
               <?php endif; ?>

               <?php if (!empty($acadia_404_thumb)) : ?>
                  <img src="<?php echo esc_url($acadia_404_thumb); ?>" alt="<?php print esc_attr__('Error 404', 'acadia'); ?>">
               <?php endif; ?>

               <div class="tp-error-content mt-50">

                  <?php if (!empty($acadia_error_title_sm)) : ?>
                     <h4 class="tp-error-title-sm"><?php print esc_html($acadia_error_title_sm); ?></h4>
                  <?php endif; ?>

                  <?php if (!empty($acadia_error_desc)) : ?>
                     <p><?php print esc_html($acadia_error_desc); ?></p>
                  <?php endif; ?>

                  <?php if (!empty($acadia_error_link_text)) : ?>
                     <a href="<?php print esc_url(home_url('/')); ?>" class="tp-btn-inner"><?php print esc_html($acadia_error_link_text); ?></a>
                  <?php endif; ?>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>
<!-- error area end -->


<?php
get_footer();
