<?php
defined('ABSPATH') || exit;

global $post;
use \Etn\Utils\Helper;
$single_event_id = get_the_id();
$categories = get_the_terms($single_event_id, 'etn_category');
$etn_terms = get_the_terms($single_event_id, 'etn_tags');
$event_options = get_option("etn_event_options");
$data = Helper::single_template_options($single_event_id);

$etn_schedule = get_post_meta(get_the_ID(), 'etn_event_schedule', true);

$location = '';
$loc_arr = $data['etn_event_location'];
if (!empty(is_array($loc_arr) || is_object($loc_arr))):
    foreach ($loc_arr as $key => $loc) {
        if ($key == 'address') {
            $location .= $loc;
        } elseif ($key == 'custom_url') {
            $location .= $loc;
        }
    }
endif;

if ((ETN_DEMO_SITE === false) || (ETN_DEMO_SITE == true && ETN_EVENT_TEMPLATE_TWO_ID != get_the_ID() && ETN_EVENT_TEMPLATE_THREE_ID != get_the_ID())) {
    ?>
    <?php do_action("etn_before_single_event_details", $single_event_id); ?>

    <?php do_action('acadia_etn_breadcrumb'); ?>

    <?php // dump($data); ?>

    <section class="tp-event-details-area pt-80 pb-70">
        <div class="container">
            <div class="row">
                <div class="col-lg-8">
                    <div class="tp-event-details-wrapper">
                        <?php the_content(); ?>
                        <?php if( !empty( $etn_schedule ) ) : ?>
                        <div class="tp-event-schedule-wrap mt-50">
                            <?php do_action( 'acadia_event_single_schedule' ); ?>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="tp-event-details-box">
                        <div class="tp-event-details-details">
                            <?php if (!empty($data['event_start_date'])): ?>
                                <h4 class="tp-event-details-box-title"><?php echo esc_html__('Event Details', 'acadia'); ?></h4>
                                <div class="tp-event-details-list d-flex align-items-center justify-content-between">
                                    <h5><span><svg width="15" height="16" viewBox="0 0 15 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.4" d="M1.06836 6.18262H13.5451" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M10.4102 8.91699H10.4194" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M7.30273 8.91699H7.312" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M4.1875 8.91699H4.19676" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M10.4102 11.6377H10.4194" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M7.30273 11.6377H7.312" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M4.1875 11.6377H4.19676" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M10.1289 1V3.30355" stroke="#4F5158" stroke-width="1.5"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M4.47656 1V3.30355" stroke="#4F5158" stroke-width="1.5"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M10.2668 2.10547H4.33967C2.28399 2.10547 1 3.25062 1 5.35559V11.6903C1 13.8284 2.28399 15 4.33967 15H10.2603C12.3225 15 13.6 13.8483 13.6 11.7433V5.35559C13.6065 3.25062 12.329 2.10547 10.2668 2.10547Z"
                                                    stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg></span> <?php echo esc_html__('Start Date', 'acadia'); ?></h5>
                                    <span><?php echo esc_html($data['event_start_date']); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($data['event_start_time'])): ?>
                                <div class="tp-event-details-list d-flex align-items-center justify-content-between">
                                    <h5><span><svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M8 15C11.866 15 15 11.866 15 8C15 4.13401 11.866 1 8 1C4.13401 1 1 4.13401 1 8C1 11.866 4.13401 15 8 15Z"
                                                    stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path d="M8 3.7998V7.9998L10.8 9.3998" stroke="#4F5158" stroke-width="1.5"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                            </svg></span> <?php echo esc_html__('Start Time', 'acadia'); ?></h5>
                                    <span><?php echo esc_html(strtoupper($data['event_start_time'])); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($data['event_end_date'])): ?>
                                <div class="tp-event-details-list d-flex align-items-center justify-content-between">
                                    <h5><span><svg width="15" height="16" viewBox="0 0 15 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path opacity="0.4" d="M1.06836 6.18262H13.5451" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M10.4102 8.91699H10.4194" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M7.30273 8.91699H7.312" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M4.1875 8.91699H4.19676" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M10.4102 11.6377H10.4194" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M7.30273 11.6377H7.312" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path opacity="0.4" d="M4.1875 11.6377H4.19676" stroke="#4F5158"
                                                    stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M10.1289 1V3.30355" stroke="#4F5158" stroke-width="1.5"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M4.47656 1V3.30355" stroke="#4F5158" stroke-width="1.5"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path fill-rule="evenodd" clip-rule="evenodd"
                                                    d="M10.2668 2.10547H4.33967C2.28399 2.10547 1 3.25062 1 5.35559V11.6903C1 13.8284 2.28399 15 4.33967 15H10.2603C12.3225 15 13.6 13.8483 13.6 11.7433V5.35559C13.6065 3.25062 12.329 2.10547 10.2668 2.10547Z"
                                                    stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg></span> <?php echo esc_html__('End Date', 'acadia'); ?></h5>
                                    <span><?php echo esc_html($data['event_end_date']); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($data['event_end_time'])): ?>
                                <div class="tp-event-details-list d-flex align-items-center justify-content-between">
                                    <h5><span><svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M8 15C11.866 15 15 11.866 15 8C15 4.13401 11.866 1 8 1C4.13401 1 1 4.13401 1 8C1 11.866 4.13401 15 8 15Z"
                                                    stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path d="M8 3.7998V7.9998L10.8 9.3998" stroke="#4F5158" stroke-width="1.5"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                            </svg></span> <?php echo esc_html__('End Time', 'acadia'); ?></h5>
                                    <span><?php echo esc_html(strtoupper($data['event_end_time'])); ?></span>
                                </div>
                            <?php endif; ?>
                            <?php if (!empty($location)): ?>
                                <div class="tp-event-details-list d-flex align-items-center justify-content-between">
                                    <h5><span><svg width="15" height="17" viewBox="0 0 15 17" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                    d="M14 7.13636C14 11.9091 7.5 16 7.5 16C7.5 16 1 11.9091 1 7.13636C1 5.5089 1.68482 3.94809 2.90381 2.7973C4.12279 1.64651 5.77609 1 7.5 1C9.22391 1 10.8772 1.64651 12.0962 2.7973C13.3152 3.94809 14 5.5089 14 7.13636Z"
                                                    stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path
                                                    d="M7.49992 9.18173C8.69654 9.18173 9.66659 8.26595 9.66659 7.13627C9.66659 6.0066 8.69654 5.09082 7.49992 5.09082C6.3033 5.09082 5.33325 6.0066 5.33325 7.13627C5.33325 8.26595 6.3033 9.18173 7.49992 9.18173Z"
                                                    stroke="#4F5158" stroke-width="1.5" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                            </svg></span> <?php echo esc_html__('Location', 'acadia'); ?></h5>
                                    <span><?php echo esc_html($location); ?></span>
                                </div>
                            <?php endif; ?>
                        </div>

                        <div class="tp-event-details-ticket">
                            <?php do_action("etn_after_single_event_meta", $single_event_id); ?>
                        </div>

                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php do_action("etn_after_single_event_details", $single_event_id); ?>

<?php } ?>