<?php

/**
 * acadia_scripts description
 * @return [type] [description]
 */
function acadia_scripts()
{

    /**
     * all css files
     */

    wp_enqueue_style('acadia-fonts', acadia_fonts_url(), array(), time());
    if (is_rtl()) {
        wp_enqueue_style('bootstrap-rtl', ACADIA_THEME_CSS_DIR . 'bootstrap-rtl.css', array());
    } else {
        wp_enqueue_style('bootstrap', ACADIA_THEME_CSS_DIR . 'bootstrap.css', array());
    }
    wp_enqueue_style('animate', ACADIA_THEME_CSS_DIR . 'animate.css', []);
    wp_enqueue_style('slick', ACADIA_THEME_CSS_DIR . 'slick.css', []);
    wp_enqueue_style('swiper-bundle', ACADIA_THEME_CSS_DIR . 'swiper-bundle.css', []);
    wp_enqueue_style('magnific-popup', ACADIA_THEME_CSS_DIR . 'magnific-popup.css', []);
    wp_enqueue_style('hover-reveal', ACADIA_THEME_CSS_DIR . 'hover-reveal.css', []);
    wp_enqueue_style('font-awesome-pro', ACADIA_THEME_CSS_DIR . 'font-awesome-pro.css', []);
    wp_enqueue_style('spacing', ACADIA_THEME_CSS_DIR . 'spacing.css', []);
    wp_enqueue_style('apexcharts', ACADIA_THEME_CSS_DIR . 'apexcharts.css', []);
    wp_enqueue_style('flatpickr', ACADIA_THEME_CSS_DIR . 'flatpickr.min.css', []);
    wp_enqueue_style('acadia-unit', ACADIA_THEME_CSS_DIR . 'acadia-unit.css', []);
    wp_enqueue_style('acadia-custom', ACADIA_THEME_CSS_DIR . 'acadia-custom.css', []);
    wp_enqueue_style('acadia-core', ACADIA_THEME_CSS_DIR . 'acadia-core.css', []);
    wp_enqueue_style('acadia-style', get_stylesheet_uri());

    // all js
    wp_enqueue_script('bootstrap-bundle', ACADIA_THEME_JS_DIR . 'bootstrap-bundle.js', ['jquery'], '', true);
    wp_enqueue_script('acadia-onepage-nav', ACADIA_THEME_JS_DIR . 'one-page-nav.js', ['jquery'], '', true);
    wp_enqueue_script('apexcharts', ACADIA_THEME_JS_DIR . 'apexcharts.min.js', ['jquery'], false, true);
    wp_enqueue_script('countdown', ACADIA_THEME_JS_DIR . 'countdown.js', ['jquery'], '', true);
    wp_enqueue_script('flatpickr', ACADIA_THEME_JS_DIR . 'flatpickr.js', ['jquery'], '', true);
    wp_enqueue_script('hover-reveal', ACADIA_THEME_JS_DIR . 'hover-reveal.js', ['jquery'], '', true);
    wp_enqueue_script('index-global', ACADIA_THEME_JS_DIR . 'index.global.js', ['jquery'], '', true);
    wp_enqueue_script('isotope-pkgd', ACADIA_THEME_JS_DIR . 'isotope-pkgd.js', ['imagesloaded'], false, true);
    wp_enqueue_script('magnific-popup', ACADIA_THEME_JS_DIR . 'magnific-popup.js', ['jquery'], '', true);
    wp_enqueue_script('nice-select', ACADIA_THEME_JS_DIR . 'nice-select.js', ['jquery'], '', true);
    wp_enqueue_script('purecounter', ACADIA_THEME_JS_DIR . 'purecounter.js', ['jquery'], false, true);
    wp_enqueue_script('range-slider', ACADIA_THEME_JS_DIR . 'range-slider.js', ['jquery'], false, true);
    wp_enqueue_script('select2', ACADIA_THEME_JS_DIR . 'select2.min.js', ['jquery'], false, true);
    wp_enqueue_script('slick', ACADIA_THEME_JS_DIR . 'slick.js', ['jquery'], false, true);
    wp_enqueue_script('swiper-bundle', ACADIA_THEME_JS_DIR . 'swiper-bundle.js', ['jquery'], false, true);
    wp_enqueue_script('tween-max-js', ACADIA_THEME_JS_DIR . 'tween-max.js', ['jquery'], '', true);
    wp_enqueue_script('waypoints', ACADIA_THEME_JS_DIR . 'waypoints.js', ['jquery'], false, true);
    wp_enqueue_script('wow', ACADIA_THEME_JS_DIR . 'wow.js', ['jquery'], false, true);
    wp_enqueue_script('acadia-main', ACADIA_THEME_JS_DIR . 'main.js', ['jquery'], false, true);

    if (is_singular() && comments_open() && get_option('thread_comments')) {
        wp_enqueue_script('comment-reply');
    }
}
add_action('wp_enqueue_scripts', 'acadia_scripts');

/*
Register Fonts
 */
function acadia_fonts_url()
{
    $font_url = '';

    /*
    Translators: If there are characters in your language that are not supported
    by chosen font(s), translate this to 'off'. Do not translate into your own language.
     */
    if ('off' !== _x('on', 'Google font: on or off', 'acadia')) {
        $font_url = 'https://fonts.googleapis.com/css2?' . urlencode('family=Crimson+Pro:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Jost:ital,wght@0,300;0,400;0,500;0,600;0,700;1,300;1,400;1,500;1,600;1,700&family=Outfit:wght@300;400;500;600;700;800&display=swap');
    }
    return $font_url;
}
