<?php
namespace LearnPress\TemplateHooks\Course;
use LearnPress\Models\Courses;
use LP_Course_Filter;

$course_cat = get_terms( array(
    'taxonomy'   => 'course_category',
    'hide_empty' => false,
) );

$instructors     = get_users(
    array(
        'role__in' => [ LP_TEACHER_ROLE, ADMIN_ROLE ],
        'fields'   => array( 'ID', 'display_name' ),
    )
);

// free
$filter_courses_free          = new LP_Course_Filter();
$filter_courses_free->sort_by = [];
$count_courses_free           = Courses::count_course_free( $filter_courses_free );


// paid
$filter_courses_price              = new LP_Course_Filter();
$filter_courses_price->query_count = true;
$filter_courses_price->sort_by     = [ 'on_paid' ];
$count_courses_paid                = 0;
Courses::get_courses( $filter_courses_price, $count_courses_paid );

$count_course_all = $count_courses_free + $count_courses_paid;

// lavels
$levels = lp_course_level();
$get_search_for    = isset($_GET['search_for']) ? sanitize_text_field( $_GET['search_for'] ) : '';
$ac_lp_search_sw = get_theme_mod( 'ac_lp_search_sw', true );
$ac_lp_sort_sw = get_theme_mod( 'ac_lp_sort_sw', true );
$ac_lp_cat_sw = get_theme_mod( 'ac_lp_cat_sw', true );
$ac_lp_instructor_sw = get_theme_mod( 'ac_lp_instructor_sw', true );
$ac_lp_price_sw = get_theme_mod( 'ac_lp_price_sw', true );
$ac_lp_skill_sw = get_theme_mod( 'ac_lp_skill_sw', true );

?>

<?php get_template_part('learnpress/archive-filter-double/filter-features','res'); ?>

<!-- course filter start -->
<section class="tp-course-filter-area tp-course-filter-bg p-relative tp-course-filter-space">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <div class="tp-breadcrumb__content-filter mb-50">
                    <div class="tp-breadcrumb__list">
                        <span><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                        d="M8.07207 0C8.19331 0 8.31107 0.0404348 8.40664 0.114882L16.1539 6.14233L15.4847 6.98713L14.5385 6.25079V12.8994C14.538 13.1843 14.4243 13.4574 14.2225 13.6589C14.0206 13.8604 13.747 13.9738 13.4616 13.9743H2.69231C2.40688 13.9737 2.13329 13.8603 1.93146 13.6588C1.72962 13.4573 1.61597 13.1843 1.61539 12.8994V6.2459L0.669148 6.98235L0 6.1376L7.7375 0.114882C7.83308 0.0404348 7.95083 0 8.07207 0ZM8.07694 1.22084L2.69231 5.40777V12.8994H13.4616V5.41341L8.07694 1.22084Z"
                                        fill="currentColor" />
                                </svg></a></span>
                        <span class="color"><?php echo esc_html__( 'All Courses', 'acadia' ); ?></span>
                    </div>
                    <h3 class="tp-breadcrumb__title"><?php echo esc_html__( 'All Courses', 'acadia' ); ?></h3>
                </div>
                <div class="tp-course-grid-wrap p-relative">
                    <div class="row">
                        <div class="col-lg-6">
                            <div class="tp-course-filter-top-left d-flex align-items-center">
                                <div class="tp-course-filter-top-tab tp-tab mb-20">
                                    <ul class="nav nav-tabs" id="filterTab" role="tablist">
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                                                data-bs-target="#home" type="button" role="tab" aria-controls="home"
                                                aria-selected="true">
                                                <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M5.66667 1H1V5.66667H5.66667V1Z" stroke="#031F42"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M12.9997 1H8.33301V5.66667H12.9997V1Z" stroke="#031F42"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                    <path d="M12.9997 8.33337H8.33301V13H12.9997V8.33337Z"
                                                        stroke="#031F42" stroke-linecap="round"
                                                        stroke-linejoin="round" />
                                                    <path d="M5.66667 8.33337H1V13H5.66667V8.33337Z" stroke="#031F42"
                                                        stroke-linecap="round" stroke-linejoin="round" />
                                                </svg>
                                                <?php echo esc_html__( 'Grid', 'acadia' ); ?>
                                            </button>
                                        </li>
                                        <li class="nav-item" role="presentation">
                                            <button class="nav-link" id="profile-tab" data-bs-toggle="tab"
                                                data-bs-target="#profile" type="button" role="tab"
                                                aria-controls="profile" aria-selected="false">
                                                <svg width="14" height="14" viewBox="0 0 16 15" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M15 7.11108H1" stroke="#031F42" stroke-width="1"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                    <path d="M15 1H1" stroke="#031F42" stroke-width="1"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                    <path d="M15 13.2222H1" stroke="#031F42" stroke-width="1"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                </svg>
                                                <?php echo esc_html__( 'List', 'acadia' ); ?>
                                            </button>
                                        </li>
                                    </ul>
                                </div>
                                <div class="tp-course-filter-top-result mb-20" data-total-courses>
                                    <p><?php echo $args['index']; ?></p>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-6">
                            <div class="tp-course-filter-top-right d-flex align-items-center justify-content-start justify-content-lg-end">
                                <div class="tp-course-filter-top-right-search d-none d-lg-block mb-20">
                                    <?php if( !empty( $ac_lp_search_sw ) ) : ?>
                                    <form action="" class="ac-archive-filter-open-search-form">
                                        <?php 
                                        $nonce = wp_create_nonce('_nonce2');
                                        
                                        ?>
                                        <input type="hidden" id="nonce" name="nonce" value="<?php echo esc_html( $nonce ); ?>">
                                        <input type="text" class="course_search" placeholder="<?php echo esc_attr__( 'Search for Courses...', 'acadia' ); ?>" value="<?php echo esc_attr( $get_search_for ); ?>" name="search_for">
                                        <button class="tp-course-filter-top-right-search-btn" type="submit">
                                            <span>
                                                <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                                    xmlns="http://www.w3.org/2000/svg">
                                                    <path d="M12.625 12.625L16 16" stroke="#8B8B8B" stroke-width="1.5"
                                                        stroke-linecap="round" stroke-linejoin="round"></path>
                                                    <path
                                                        d="M14.5 7.75C14.5 4.02208 11.4779 1 7.75 1C4.02208 1 1 4.02208 1 7.75C1 11.4779 4.02208 14.5 7.75 14.5C11.4779 14.5 14.5 11.4779 14.5 7.75Z"
                                                        stroke="#8B8B8B" stroke-width="1.5" stroke-linejoin="round">
                                                    </path>
                                                </svg>
                                            </span>
                                        </button>
                                    </form>
                                    <?php endif; ?>
                                </div>
                                <div class="tp-course-filter-btn mb-20">
                                    <button type="button"
                                        class="tp-filter-btn archive-filter-btn filter-open-dropdown-btn">
                                        <span>
                                            <svg width="16" height="15" viewBox="0 0 16 15" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path d="M14.9998 3.44995H10.7998" stroke="currentColor"
                                                    stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path d="M3.8 3.44995H1" stroke="currentColor" stroke-width="1.5"
                                                    stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path
                                                    d="M6.60039 5.9C7.95349 5.9 9.05039 4.8031 9.05039 3.45C9.05039 2.0969 7.95349 1 6.60039 1C5.24729 1 4.15039 2.0969 4.15039 3.45C4.15039 4.8031 5.24729 5.9 6.60039 5.9Z"
                                                    stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                                <path d="M15.0002 11.15H12.2002" stroke="currentColor"
                                                    stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path d="M5.2 11.15H1" stroke="currentColor" stroke-width="1.5"
                                                    stroke-miterlimit="10" stroke-linecap="round"
                                                    stroke-linejoin="round" />
                                                <path
                                                    d="M9.4002 13.6C10.7533 13.6 11.8502 12.503 11.8502 11.15C11.8502 9.79685 10.7533 8.69995 9.4002 8.69995C8.0471 8.69995 6.9502 9.79685 6.9502 11.15C6.9502 12.503 8.0471 13.6 9.4002 13.6Z"
                                                    stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"
                                                    stroke-linecap="round" stroke-linejoin="round" />
                                            </svg>
                                        </span>
                                        <?php echo esc_html__( 'Filter', 'acadia' ); ?>
                                    </button>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tp-filter-dropdown-area tp-filter-dropdown-wrapper d-none d-md-block">
                        <div class="row row-cols-lg-5 row-cols-md-3 row-cols-sm-2 row-cols-1">
                            <?php if( !empty( $ac_lp_sort_sw ) ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Sort by', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-radio">
                                        <ul>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="latest" id="sort_latest" <?php checked(($args['sort_by'] == 'latest'), 1); ?>>
                                                    <span><?php echo esc_html__( 'Latest', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="trending" id="sort_trending" <?php checked(($args['sort_by'] == 'trending'), 1); ?>>
                                                    <span><?php echo esc_html__( 'Trending', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="popularity" id="sort_popular" <?php checked(($args['sort_by'] == 'popularity'), 1); ?>>
                                                    <span><?php echo esc_html__( 'Popularity', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="low_high" id="sort_low_high" <?php checked(($args['sort_by'] == 'low_high'), 1); ?>>
                                                    <span><?php echo esc_html__( 'Price: low to high', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" name="sort_by" value="high_low" id="sort_high_low" <?php checked(($args['sort_by'] == 'high_low'), 1); ?>>
                                                    <span><?php echo esc_html__( 'Price: high to low', 'acadia' ); ?></span>
                                                </label>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( !empty( $ac_lp_cat_sw ) ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'All categories', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-checkbox">
                                        <ul>
                                            <?php foreach( $course_cat as $key => $cat ) : 
                                                $name  = $cat->name;
                                                $slug  = $cat->slug;
                                                $count = $cat->count;
                                            ?>
                                                <li>
                                                    <label class="form-checkbox">
                                                        <input id="<?php echo esc_attr($slug); ?>" 
                                                            name="categories" 
                                                            value="<?php echo esc_attr($slug); ?>" 
                                                            type="checkbox" 
                                                            <?php 
                                                            if (is_array($args['categories'])) {
                                                                checked(in_array($slug, $args['categories']), 1);
                                                            } else {
                                                                checked($args['categories'] == $slug, 1);
                                                            }
                                                            ?> 
                                                        >
                                                        <span><?php echo esc_html($name) . ' (' . esc_html($count) . ')'; ?></span>
                                                    </label>
                                                </li>
                                            <?php endforeach; ?>

                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( !empty( $ac_lp_instructor_sw ) ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Instructors', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-checkbox">
                                        <ul>
                                            <?php 
                                            foreach ( $instructors as $instructor ) :
                                            $total_course_of_instructor = 0;
                                            $filter                     = new LP_Course_Filter();
                                            $filter->query_count        = true;
                                            $filter->post_authors       = [ $instructor->ID ];
                                            Courses::get_courses( $filter, $total_course_of_instructor );
                                            $value    = $instructor->ID;
                                            $name  = $instructor->display_name;
                                            $count = $total_course_of_instructor;
                                            ?>
                                            <li>
                                                <label class="from-checkbox">
                                                    <input id="<?php echo esc_attr( $value ); ?>" type="checkbox" name="instructors" value="<?php echo esc_html( $value ); ?>" 
                                                    <?php 
                                                        if (is_array($args['instructors'])) {
                                                            checked(in_array($value, $args['instructors']), 1);
                                                        } else {
                                                            checked($args['instructors'] == $value, 1);
                                                        }
                                                    ?> >
                                                    <span><?php echo esc_html( ucwords( $name ) );  ?> (<?php echo esc_attr( $count ); ?>)</span>
                                                </label>
                                            </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( !empty( $ac_lp_price_sw ) ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Price', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-radio">
                                        <ul>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" value='on_all' name="sort_by_price" id="sort_on_all" 
                                                    <?php 
                                                        if (is_array($args['sort_by_price'])) {
                                                            checked(in_array('on_all', $args['sort_by_price']), 1);
                                                        } else {
                                                            checked($args['sort_by_price'] == 'on_all', 1);
                                                        }
                                                    ?>
                                                    >
                                                    <span><?php echo esc_html__( 'All', 'acadia' ); ?> (<?php echo esc_attr( $count_course_all ); ?>)</span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" value='on_free' name="sort_by_price" id="sort_on_free"
                                                    <?php 
                                                        if (is_array($args['sort_by_price'])) {
                                                            checked(in_array('on_free', $args['sort_by_price']), 1);
                                                        } else {
                                                            checked($args['sort_by_price'] == 'on_free', 1);
                                                        }
                                                    ?>
                                                    >
                                                    <span><?php echo esc_html__( 'Free', 'acadia' ); ?> (<?php echo esc_attr( $count_courses_free ); ?>)</span>
                                                </label>
                                            </li>
                                            <li>
                                                <label class="form-check">
                                                    <input class="form-check-input" type="radio" value='on_paid' name="sort_by_price" id="sort_on_paid" 
                                                    <?php 
                                                        if (is_array($args['sort_by_price'])) {
                                                            checked(in_array('on_paid', $args['sort_by_price']), 1);
                                                        } else {
                                                            checked($args['sort_by_price'] == 'on_paid', 1);
                                                        }
                                                    ?>
                                                    >
                                                    <span><?php echo esc_html__( 'Paid', 'acadia' ); ?> (<?php echo esc_attr( $count_courses_paid ); ?>)</span>
                                                </label>
                                            </li>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                            <?php if( !empty( $ac_lp_skill_sw ) ) : ?>
                            <div class="col">
                                <h4 class="tp-filter-widget-title"><?php echo esc_html__( 'Skills Level', 'acadia' ); ?></h4>
                                <div class="tp-filter-widget-content">
                                    <div class="tp-filter-widget-radio">
                                        <ul>
                                            <?php 
                                            foreach( $levels as $key => $lavel ) : 

                                            $filter = new LP_Course_Filter();
                                            $filter->only_fields = [ 'DISTINCT(ID)' ];
                                            $filter->query_count = true;
                                            $filter->levels      = [ $key ];
                                            $total_courses       = 0;
                                            Courses::get_courses( $filter, $total_courses );
                                            $name = $lavel;
                                            $count = $total_courses;
                                            
                                            ?>
                                            <li>
                                                <label class="from-checkbox">
                                                    <input id="<?php echo esc_attr( $lavel ); ?>" type="checkbox" value="<?php echo esc_attr( $key ); ?>" name="skills"
                                                    <?php 
                                                        if (is_array($args['skills'])) {
                                                            checked(in_array($key, $args['skills']), 1);
                                                        } else {
                                                            checked($args['skills'] == $key, 1);
                                                        }
                                                    ?>
                                                    
                                                    >
                                                    <span><?php echo esc_html( $name ); ?> (<?php echo esc_html( $count ); ?>)</span>
                                                </label>
                                            </li>
                                            <?php endforeach; ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- course filter end -->