<?php
namespace LearnPress\TemplateHooks\Course;
use LearnPress\Models\Courses;
use LP_Course_Filter;

global $ac_sale_course_count;

$course_cat = get_terms( array(
    'taxonomy'   => 'course_category',
    'hide_empty' => false,
) );

$instructors     = get_users(
    array(
        'role__in' => [ LP_TEACHER_ROLE, ADMIN_ROLE ],
        'fields'   => array( 'ID', 'display_name' ),
    )
);

// free
$filter_courses_free          = new LP_Course_Filter();
$filter_courses_free->sort_by = [];
$count_courses_free           = Courses::count_course_free( $filter_courses_free );


// paid
$filter_courses_price              = new LP_Course_Filter();
$filter_courses_price->query_count = true;
$filter_courses_price->sort_by     = [ 'on_paid' ];
$count_courses_paid                = 0;
Courses::get_courses( $filter_courses_price, $count_courses_paid );

$count_course_all = $count_courses_free + $count_courses_paid;

$ac_lp_sort_sw = get_theme_mod( 'ac_lp_sort_sw', true );
$ac_lp_cat_sw = get_theme_mod( 'ac_lp_cat_sw', true );
$ac_lp_instructor_sw = get_theme_mod( 'ac_lp_instructor_sw', true );
$ac_lp_price_sw = get_theme_mod( 'ac_lp_price_sw', true );
?>
<div class="row">
    <div class="col-lg-12">
        <div class="tp-course-grid-categories archive_filter_3 d-flex">
            <?php if( !empty( $ac_lp_sort_sw ) ) : ?>
            <div class="tp-course-grid-select">
                <p><?php echo esc_html__( 'SHORT BY', 'acadia' ); ?></p>
                <select class="wide" name='sort_by'>
                    <option value='' <?php selected(($args['sort_by'] == ''), 1); ?>><?php echo esc_html__( 'Default', 'acadia' ); ?></option>
                    <option value="latest" <?php selected(($args['sort_by'] == 'latest'), 1); ?>><?php echo esc_html__( 'Latest', 'acadia' ); ?></option>
                    <option value="trending" <?php selected(($args['sort_by'] == 'trending'), 1); ?>><?php echo esc_html__( 'Trending', 'acadia' ); ?></option>
                    <option value="popularity" <?php selected(($args['sort_by'] == 'popularity'), 1); ?>><?php echo esc_html__( 'Popularity', 'acadia' ); ?></option>
                    <option value="low_high" <?php selected(($args['sort_by'] == 'low_high'), 1); ?>><?php echo esc_html__( 'Price: low to high', 'acadia' ); ?></option>
                    <option value="high_low" <?php selected(($args['sort_by'] == 'high_low'), 1); ?>><?php echo esc_html__( 'Price: high to low', 'acadia' ); ?></option>
                </select>
            </div>
            <?php endif; ?>
            <?php if( !empty( $ac_lp_cat_sw ) ) : ?>
            <div class="tp-course-grid-select">
                <p><?php echo esc_html__( 'SHORT BY CATEGORY', 'acadia' ); ?></p>
                <select class="wide" name='categories'>
                    <option value='' <?php selected(($args['categories'] == ''), 1); ?>><?php echo esc_html__( 'Select Category', 'acadia' ); ?></option>
                    <?php foreach( $course_cat as $key => $cat ) : 
                        $name  = $cat->name;
                        $slug  = $cat->slug;
                        $count = $cat->count;
                    ?>
                    <option value="<?php echo esc_attr( $slug ); ?>" <?php selected(($args['categories'] == $slug), 1); ?>><?php echo $name . ' (' . $count . ')';?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php endif; ?>
            <?php if( !empty( $ac_lp_instructor_sw ) ) : ?>
            <div class="tp-course-grid-select">
                <p><?php echo esc_html__( 'SHORT BY AUTHOR', 'acadia' ); ?></p>
                <select class="wide" name="instructors">
                    <option value='' <?php selected(($args['instructors'] == ''), 1); ?>><?php echo esc_html__( 'Select Author', 'acadia' ); ?></option>
                    <?php 
                        foreach ( $instructors as $instructor ) :
                        $total_course_of_instructor = 0;
                        $filter               = new LP_Course_Filter();
                        $filter->query_count  = true;
                        $filter->post_authors = [ $instructor->ID ];
                        Courses::get_courses( $filter, $total_course_of_instructor );
                        $value    = $instructor->ID;
                        $name  = $instructor->display_name;
                        $count = $total_course_of_instructor;
                    ?>
                    <option value="<?php echo esc_html( $value ); ?>" <?php selected(($args['instructors'] == $value), 1); ?>><?php echo esc_html( ucwords( $name ) );  ?> (<?php echo esc_attr( $count ); ?>)</option>
                    <?php endforeach; ?>
                </select>
            </div>
            <?php endif; ?>
            <?php if( !empty( $ac_lp_price_sw ) ) : ?>
            <div class="tp-course-grid-select" >
                <p><?php echo esc_html__( 'SHORT BY PRICE', 'acadia' ); ?></p>
                <select class="wide" name="sort_by_price">
                    <option value='on_all' <?php selected(($args['sort_by_price'] == 'on_all'), 1); ?>><?php echo esc_html__( 'All', 'acadia' ); ?> (<?php echo esc_attr( $count_course_all ); ?>)</option>
                    <option value="on_free" <?php selected(($args['sort_by_price'] == 'on_free'), 1); ?>><?php echo esc_html__( 'Free', 'acadia' ); ?> (<?php echo esc_attr( $count_courses_free ); ?>)</option>
                    <option value="on_paid" <?php selected(($args['sort_by_price'] == 'on_paid'), 1); ?>><?php echo esc_html__( 'Paid', 'acadia' ); ?> (<?php echo esc_attr( $count_courses_paid ); ?>)</option>
                    <option value="on_sale" <?php selected(($args['sort_by_price'] == 'on_sale'), 1); ?>><?php echo esc_html__( 'On Sale', 'acadia' ); ?> (<?php echo esc_attr( $ac_sale_course_count ); ?>)</option>
                </select>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>