<?php

/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();
$course_order_by = 'DESC';

$get_ac_lp_course_per = get_theme_mod( 'ac_lp_course_per', 12 );
$get_ac_lp_load_more_sw = get_theme_mod( 'ac_lp_load_more_sw', true );

if (is_tax('course_category')) {
    $current_term = get_queried_object();
    $paged        = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
    $args         = array( 
        'post_type'      => LP_COURSE_CPT,
        'orderby'        => 'modified',
        'order'          => $course_order_by,
        'posts_per_page' => $get_ac_lp_course_per,
        'tax_query'      => array(
            array(
                'taxonomy' => 'course_category',
                'field'    => 'term_id',
                'terms'    => $current_term->term_id,
            ),
        ),
    );
    
} elseif (is_tax('course_tag')) {
    $current_term = get_queried_object();
    $paged        = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
    $args         = array( 
        'post_type'      => LP_COURSE_CPT,
        'orderby'        => 'modified',
        'order'          => $course_order_by,
        'posts_per_page' => $get_ac_lp_course_per,
        'tax_query'      => array(
            array(
                'taxonomy' => 'course_tag',
                'field'    => 'term_id',
                'terms'    => $current_term->term_id,
            ),
        ),
    );
} else {
    $args = array( 
        'post_type' => LP_COURSE_CPT,
        'orderby' => 'modified',
        'order' => $course_order_by,
        'posts_per_page' => $get_ac_lp_course_per,
    );
}

$get_instructors = isset($_GET['instructors'])? array_map('intval', explode(',', sanitize_text_field($_GET['instructors']))) : array();
sort($get_instructors);
$get_categories = isset($_GET['categories'])? explode(',', sanitize_text_field($_GET['categories'])) : array();
$get_skills = isset($_GET['skills'])? explode(',', sanitize_text_field($_GET['skills'])) : array();
$get_sort_by = isset($_GET['sort_by'])? sanitize_text_field($_GET['sort_by']) : '';
$get_rating = isset($_GET['rating'])? sanitize_text_field($_GET['rating']) : '';
$get_search_for = isset($_GET['search_for'])? sanitize_text_field($_GET['search_for']) : '';

$sidebar_args = array(
    'categories'    => $get_categories,
    'ac_instructors'   => $get_instructors,
    'skills'        => $get_skills,
    'sort_by'       => $get_sort_by,
    'rating'        => $get_rating
);

if(!empty($get_instructors)){
    $args['author__in'] =   $get_instructors;
}

// var_dump($get_categories);
if(!empty($get_categories)){
    $args['tax_query'] = array(
        'relation'  => 'OR',
        array(
            'taxonomy'  => 'course_category',
            'field'    => 'slug',
            'terms'     => $get_categories
        )
    );    
}

if(!empty($get_skills)){
    // $args['meta_key'] = '_lp_level';
    $args['meta_query'] = array(
        array(
            'key'       => '_lp_level',
            'value'     => $get_skills,
            'compare'   => 'IN'
        )
    );
}
// var_dump($args);
if(!empty($get_sort_by)){
    $compare = ($get_sort_by == 'on_free')? '=' : '!='; 
    $args['meta_query'] = array(
        array(
            'key'       => '_lp_regular_price',
            'value'     => '',
            'compare'   => $compare
        )
    );
}

if(!empty($get_rating)){
    $comment_args = array(
        'meta_query' => array(
            array(
                'key'     => '_lpr_rating',
                'value'   => $get_rating,
                'compare' => '=', // Checks if the meta key exists
            ),
        ),
    );
    $comment_query = new WP_Comment_Query($comment_args);

    // Step 2: Extract unique post IDs from comments
    $post_ids = array(0);
    if (!empty($comment_query->comments)) {
        foreach ($comment_query->comments as $comment) {
            if (!in_array($comment->comment_post_ID, $post_ids)) {
                $post_ids[] = $comment->comment_post_ID;
            }
        }
    }

    $args['post__in'] = $post_ids;
}

if(!empty($get_search_for)){
    $args['s'] = $get_search_for;
}

$query = new WP_Query($args);

$total = $query->found_posts;
if ( $total == 0 ) {
    $message = '<p class="message message-error">' . esc_html__( 'No courses found!', 'acadia' ) . '</p>';
    $index   = esc_html__( 'There are no available courses!', 'acadia' );
} elseif ( $total == 1 ) {
    $index = esc_html__( 'Showing only one result', 'acadia' );
} else {
    $courses_per_page = absint( LP()->settings->get( 'archive_course_limit' ) );
    
    $from = 1 + ( $paged - 1 ) * $courses_per_page;
    $to   = ( $paged * $courses_per_page > $total ) ? $total : $paged * $courses_per_page;

    if ( $from == $to ) {
        $index = sprintf(
            esc_html__( 'Showing last course of %s results', 'acadia' ),
            $total
        );
    } else {
        $index = sprintf(
            esc_html__( 'Showing %s-%s of %s results', 'acadia' ),
            $from,
            $total,
            $total
        );
    }
}

$ac_lp_search_sw = get_theme_mod( 'ac_lp_search_sw', true );

do_action('acadia_before_main_content');
?>

<!-- course filter area start -->
<div class="tp-grid-area pt-80 pb-40">
    <div class="container">
        <div class="tp-course-grid-sidebar p-relative">
            <div class="row">
                <div class="col-lg-8">
                    <div class="tp-course-grid-sidebar-left d-flex align-items-center">
                        <?php if( !empty( $ac_lp_search_sw ) ) : ?>
                        <div class="tp-course-grid-sidebar-search p-relative mr-30 d-none d-lg-block">
                            <form action="" class="ac-sidebar-search-form">
                                <?php 
                                $nonce = wp_create_nonce('_nonce');
                                
                                ?>
                                <input type="hidden" id="nonce" name="nonce" value="<?php echo esc_html( $nonce ); ?>">
                                <input type="text" class="course_search"  name='search_for' value='<?php echo esc_attr( $get_search_for ); ?>' placeholder="Search Courses...">
                                <button class="tp-sidebar-search-btn" type="submit">
                                    <span>
                                        <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M11.8496 11.85L14.9996 15" stroke="currentColor" stroke-width="1.5"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                            <path
                                                d="M13.6 7.29998C13.6 3.8206 10.7794 1 7.29998 1C3.8206 1 1 3.8206 1 7.29998C1 10.7794 3.8206 13.6 7.29998 13.6C10.7794 13.6 13.6 10.7794 13.6 7.29998Z"
                                                stroke="currentColor" stroke-width="1.5" stroke-linejoin="round" />
                                        </svg>
                                    </span>
                                </button>
                            </form>
                        </div>
                        <?php endif; ?>
                        <div class="tp-course-grid-sidebar-tab tp-tab">
                            <ul class="nav nav-tabs" id="filterTab" role="tablist">
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                                        data-bs-target="#home" type="button" role="tab" aria-controls="home"
                                        aria-selected="true">
                                        <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M5.66667 1H1V5.66667H5.66667V1Z" stroke="currentColor"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M12.9997 1H8.33301V5.66667H12.9997V1Z" stroke="currentColor"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M12.9997 8.33337H8.33301V13H12.9997V8.33337Z" stroke="currentColor"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                            <path d="M5.66667 8.33337H1V13H5.66667V8.33337Z" stroke="currentColor"
                                                stroke-linecap="round" stroke-linejoin="round" />
                                        </svg>
                                    </button>
                                </li>
                                <li class="nav-item" role="presentation">
                                    <button class="nav-link" id="profile-tab" data-bs-toggle="tab"
                                        data-bs-target="#profile" type="button" role="tab" aria-controls="profile"
                                        aria-selected="false">
                                        <svg width="14" height="14" viewBox="0 0 16 15" fill="none"
                                            xmlns="http://www.w3.org/2000/svg">
                                            <path d="M15 7.11108H1" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M15 1H1" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                            <path d="M15 13.2222H1" stroke="currentColor" stroke-width="1"
                                                stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>
                                    </button>
                                </li>
                            </ul>
                        </div>
                        <div class="tp-course-filter-top-result" data-total-courses>
                            <p><?php echo esc_html($index); ?></p>
                        </div>
                    </div>
                </div>
                <div class="col-lg-4">
                    <div class="tp-course-grid-sidebar-right d-flex justify-content-start justify-content-lg-end">
                        <div class="tp-course-grid-select tp-course-grid-sidebar-select">
                            <?php get_template_part('learnpress/filter','order'); ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<!-- course filter area end -->


<!-- grid-sidebar-area-start -->
<section class="tp-grid-sidebar-area pb-100">
    <div class="container">
        <div class="row">
            <div class="col-lg-3">
                <?php get_template_part( 'learnpress/archive-sidebar/sidebar/course', 'sidebar', $sidebar_args ); ?>
            </div>
            <div class="col-lg-9">
                <div class="tab-content" id="myTabContent">
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="tp-grid-sidebar-right">
                            <div class="row" data-ac-course-content>
                                <?php 
                                if($query->have_posts()):
                                    while ($query->have_posts()) : $query->the_post();
                                        get_template_part( 'learnpress/archive-sidebar/content-course', 'grid' ); 
                                    endwhile;
                                    wp_reset_postdata();
                                else:
                                    echo '<div class="alert alert-danger" role="alert">'.__('No course found!', 'acadia').'</div>';
                                endif;
                                ?> 
                            </div>
                        </div>
                    </div>

                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="tp-list-sidebar-right">
                            <div class="row" data-ac-course-content-list>

                                <?php 
                                if($query->have_posts()):
                                    while ($query->have_posts()) : $query->the_post();
                                        get_template_part( 'learnpress/archive-sidebar/content-course', 'list', $sidebar_args ); 
                                    endwhile;
                                    wp_reset_postdata();
                                else:
                                    echo '<div class="alert alert-danger" role="alert">'.__('No course found!', 'acadia').'</div>';
                                endif;
                                ?> 

                            </div>
                        </div>
                    </div>
                    <?php if( !empty( $get_ac_lp_load_more_sw ) ) : ?>
                    <div class="load-pagi-wrap text-center">
                        <input class="ac-lp-archive-load-more tp-btn-round mt-20" type="button" value="Load More">
                    </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

    </div>
</section>
<!-- grid-sidebar-area-end -->