<?php 
/**
 * Prevent loading this file directly
 */
defined( 'ABSPATH' ) || exit();

$course_total = wp_count_posts('lp_course');
$course_total = $course_total->publish;
$course_order_by = 'DESC';

$get_ac_lp_course_per = get_theme_mod( 'ac_lp_course_per', 12 );
$get_ac_lp_load_more_sw = get_theme_mod( 'ac_lp_load_more_sw', true );
$ac_lp_search_sw = get_theme_mod( 'ac_lp_search_sw', true );
$ac_lp_sort_sw = get_theme_mod( 'ac_lp_sort_sw', true );
$ac_lp_cat_sw = get_theme_mod( 'ac_lp_cat_sw', true );

if (is_tax('course_category')) {
    $current_term = get_queried_object();
    $paged        = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
    $args         = array( 
        'post_type'      => LP_COURSE_CPT,
        'orderby'        => 'modified',
        'order'          => $course_order_by,
        'posts_per_page' => $get_ac_lp_course_per,
        'tax_query'      => array(
            array(
                'taxonomy' => 'course_category',
                'field'    => 'term_id',
                'terms'    => $current_term->term_id,
            ),
        ),
    );
    
} elseif (is_tax('course_tag')) {
    $current_term = get_queried_object();
    $paged        = ( get_query_var('paged') ) ? get_query_var('paged') : 1;
    $args         = array( 
        'post_type'      => LP_COURSE_CPT,
        'orderby'        => 'modified',
        'order'          => $course_order_by,
        'posts_per_page' => $get_ac_lp_course_per,
        'tax_query'      => array(
            array(
                'taxonomy' => 'course_tag',
                'field'    => 'term_id',
                'terms'    => $current_term->term_id,
            ),
        ),
    );
} else {
    $args = array( 
        'post_type'      => LP_COURSE_CPT,
        'orderby'        => 'modified',
        'order'          => $course_order_by,
        'posts_per_page' => $get_ac_lp_course_per,
    );
}

$get_sort_by       = isset($_GET['sort_by']) ? sanitize_text_field( $_GET['sort_by'] ) : '';
$get_categories    = isset($_GET['categories']) ? sanitize_text_field( $_GET['categories'] ) : '';
$get_search_for = isset($_GET['search_for'])? sanitize_text_field($_GET['search_for']) : '';

// latest
if( !empty( $get_sort_by ) && 'latest' == $get_sort_by ) {
    $args['orderby'] = 'date';
}
// trending
if( !empty( $get_sort_by ) && 'trending' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = '_lp_course_is_sale';
}
// popular
if( !empty( $get_sort_by ) && 'popularity' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = 'lp_course_rating_average';
}
// low to high
if( !empty( $get_sort_by ) && 'low_high' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = '_lp_price';
    $args['order'] = 'ASC';
}
// hight to low
if( !empty( $get_sort_by ) && 'high_low' == $get_sort_by ) {
    $args['orderby'] = 'meta_value_num';
    $args['meta_key'] = '_lp_price';
    $args['order'] = 'DESC';
}

// filter by course category
if( !empty( $get_categories ) && 'all_courses' != $get_categories ) {
    $args['tax_query'] = array(
        'relation' => 'AND',
        array(
            'taxonomy' => 'course_category',
            'field'    => 'slug',
            'terms'    => $get_categories
        )
    );
}

if(!empty($get_search_for)){
    $args['s'] = $get_search_for;
}

$query = new WP_Query($args);

$total = $query->found_posts;
if ( $total == 0 ) {
    $message = '<p class="message message-error">' . esc_html__( 'No courses found!', 'acadia' ) . '</p>';
    $index   = esc_html__( 'There are no available courses!', 'acadia' );
} elseif ( $total == 1 ) {
    $index = esc_html__( 'Showing only one result', 'acadia' );
} else {
    $courses_per_page = absint( LP()->settings->get( 'archive_course_limit' ) );
    
    $from = 1 + ( $paged - 1 ) * $courses_per_page;
    $to   = ( $paged * $courses_per_page > $total ) ? $total : $paged * $courses_per_page;

    if ( $from == $to ) {
        $index = sprintf(
            esc_html__( 'Showing last course of %s results', 'acadia' ),
            $total
        );
    } else {
        $index = sprintf(
            esc_html__( 'Showing %s-%s of %s results', 'acadia' ),
            $from,
            $total,
            $total
        );
    }
}
$course_cat = get_terms( array(
    'taxonomy'   => 'course_category',
    'hide_empty' => false,
) );
?>
<main class="lp-archive-tab">
    <!-- course filter start -->
    <section class="tp-course-filter-area tp-course-filter-bg tp-course-filter-space p-relative">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="tp-breadcrumb__content-filter mb-50">
                        <div class="tp-breadcrumb__list">
                            <span><a href="<?php echo esc_url( home_url( '/' ) ); ?>"><svg width="17" height="14" viewBox="0 0 17 14" fill="none"
                                        xmlns="http://www.w3.org/2000/svg">
                                        <path fill-rule="evenodd" clip-rule="evenodd"
                                            d="M8.07207 0C8.19331 0 8.31107 0.0404348 8.40664 0.114882L16.1539 6.14233L15.4847 6.98713L14.5385 6.25079V12.8994C14.538 13.1843 14.4243 13.4574 14.2225 13.6589C14.0206 13.8604 13.747 13.9738 13.4616 13.9743H2.69231C2.40688 13.9737 2.13329 13.8603 1.93146 13.6588C1.72962 13.4573 1.61597 13.1843 1.61539 12.8994V6.2459L0.669148 6.98235L0 6.1376L7.7375 0.114882C7.83308 0.0404348 7.95083 0 8.07207 0ZM8.07694 1.22084L2.69231 5.40777V12.8994H13.4616V5.41341L8.07694 1.22084Z"
                                            fill="currentColor" />
                                    </svg></a></span>
                            <span class="color"><?php echo esc_html__( 'All Courses', 'acadia' ); ?></span>
                        </div>
                        <h3 class="tp-breadcrumb__title"><?php echo esc_html__( 'All Courses', 'acadia' ); ?></h3>
                    </div>
                    <div class="tp-course-grid-wrap p-relative">
                        <div class="row">
                            <div class="col-lg-6">
                                <div class="tp-course-filter-top-left d-flex align-items-center">
                                    <div class="tp-course-filter-top-tab tp-tab mb-20">
                                        <ul class="nav nav-tabs" id="filtertab" role="tablist">
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link active" id="home-tab" data-bs-toggle="tab"
                                                    data-bs-target="#home" type="button" role="tab"
                                                    aria-controls="home" aria-selected="true">
                                                    <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M5.66667 1H1V5.66667H5.66667V1Z" stroke="#031F42"
                                                            stroke-linecap="round" stroke-linejoin="round" />
                                                        <path d="M12.9997 1H8.33301V5.66667H12.9997V1Z"
                                                            stroke="#031F42" stroke-linecap="round"
                                                            stroke-linejoin="round" />
                                                        <path d="M12.9997 8.33337H8.33301V13H12.9997V8.33337Z"
                                                            stroke="#031F42" stroke-linecap="round"
                                                            stroke-linejoin="round" />
                                                        <path d="M5.66667 8.33337H1V13H5.66667V8.33337Z"
                                                            stroke="#031F42" stroke-linecap="round"
                                                            stroke-linejoin="round" />
                                                    </svg>
                                                    <?php echo esc_html__( 'Grid', 'acadia' ); ?>
                                                </button>
                                            </li>
                                            <li class="nav-item" role="presentation">
                                                <button class="nav-link" id="profile-tab" data-bs-toggle="tab"
                                                    data-bs-target="#profile" type="button" role="tab"
                                                    aria-controls="profile" aria-selected="false">
                                                    <svg width="14" height="14" viewBox="0 0 16 15" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M15 7.11108H1" stroke="#031F42" stroke-width="1"
                                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                                        <path d="M15 1H1" stroke="#031F42" stroke-width="1"
                                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                                        <path d="M15 13.2222H1" stroke="#031F42" stroke-width="1"
                                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                                    </svg>
                                                    <?php echo esc_html__( 'List', 'acadia' ); ?>
                                                </button>
                                            </li>
                                        </ul>
                                    </div>
                                    <div class="tp-course-filter-top-result mb-20" data-total-courses>
                                        <p><?php echo esc_html($index); ?></p>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6">
                                <div class="tp-course-filter-top-right categories d-flex align-items-center justify-content-start justify-content-lg-end">
                                    <div class="tp-course-filter-top-right-search d-none d-lg-block mb-20">
                                        <?php if( !empty( $ac_lp_search_sw ) ) : ?>
                                        <form action="" class="ac-archive-filter-tab-search-form">
                                            <?php 
                                                $nonce = wp_create_nonce('_nonce4');
                                            ?>
                                            <input type="hidden" id="nonce" name="nonce" value="<?php echo esc_html( $nonce ); ?>">
                                            <input type="text" class="course_search" placeholder="<?php echo esc_attr__( 'Search for Courses...', 'acadia' ); ?>" value="<?php echo esc_attr( $get_search_for ); ?>" name="search_for">
                                            <button class="tp-course-filter-top-right-search-btn" type="submit">
                                                <span>
                                                    <svg width="17" height="17" viewBox="0 0 17 17" fill="none"
                                                        xmlns="http://www.w3.org/2000/svg">
                                                        <path d="M12.625 12.625L16 16" stroke="#8B8B8B" stroke-width="1.5"
                                                            stroke-linecap="round" stroke-linejoin="round"></path>
                                                        <path
                                                            d="M14.5 7.75C14.5 4.02208 11.4779 1 7.75 1C4.02208 1 1 4.02208 1 7.75C1 11.4779 4.02208 14.5 7.75 14.5C11.4779 14.5 14.5 11.4779 14.5 7.75Z"
                                                            stroke="#8B8B8B" stroke-width="1.5" stroke-linejoin="round">
                                                        </path>
                                                    </svg>
                                                </span>
                                            </button>
                                        </form>
                                        <?php endif; ?>
                                    </div>
                                    <div class="tp-course-filter-select mb-20">
                                        <?php if( !empty( $ac_lp_sort_sw ) ) : ?>
                                        <select class="wide" name='sort_by'>
                                            <option value="" <?php selected(($get_sort_by == ''), 1); ?>><?php echo esc_html__( 'Sort by (Default)', 'acadia' ); ?></option>
                                            <option value="latest" <?php selected(($get_sort_by == 'latest'), 1); ?>><?php echo esc_html__( 'Latest', 'acadia' ); ?></option>
                                            <option value="trending" <?php selected(($get_sort_by == 'trending'), 1); ?>><?php echo esc_html__( 'Trending', 'acadia' ); ?></option>
                                            <option value="popularity" <?php selected(($get_sort_by == 'popularity'), 1); ?>><?php echo esc_html__( 'Popularity', 'acadia' ); ?></option>
                                            <option value="low_high" <?php selected(($get_sort_by == 'low_high'), 1); ?>><?php echo esc_html__( 'Price: low to high', 'acadia' ); ?></option>
                                            <option value="high_low" <?php selected(($get_sort_by == 'high_low'), 1); ?>><?php echo esc_html__( 'Price: high to low', 'acadia' ); ?></option>
                                        </select>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!-- course filter end -->

    <!-- course filter area start -->
    <section class="tp-filter-mt pb-100">
        <div class="container">
            <div class="row">

                <div class="tab-content" id="myTabContent">
                    <?php if( !empty( $ac_lp_cat_sw ) ) : ?>
                    <div class="tp-course-grid-box tp-tab">
                        <ul class="nav nav-tabs" id="filtertab-2" role="tablist">
                            <li class="nav-item" role="presentation">
                                <input class="nav-link <?php echo ( $get_categories == 'all_courses' ) || empty($get_categories) ? 'active' : ''; ?>" id="all_courses" data-slug='all_courses' data-bs-toggle="tab" type="button" value="<?php echo esc_attr__( 'All Courses', 'acadia' ) . ' (' . $course_total . ')'; ?>">
                            </li>

                            <?php foreach( $course_cat as $key => $cat ) : 
                            $name  = $cat->name;
                            $slug  = $cat->slug;
                            $count = $cat->count;
                            ?>
                            <li class="nav-item" role="presentation">
                                <input class="nav-link <?php echo $get_categories == $slug ? 'active' : ''; ?>" id="<?php echo esc_attr( $slug ); ?>" data-bs-toggle="tab" name='categories' data-slug='<?php echo esc_attr( $slug ); ?>' type="button" value="<?php echo $name . ' (' . $count . ')';?>">
                            </li>
                            <?php endforeach; ?>
                        </ul>
                    </div>
                    <?php endif; ?>
                    <div class="tab-pane fade show active" id="home" role="tabpanel" aria-labelledby="home-tab">
                        <div class="row" data-ac-course-tab>
                            <?php 
                                if($query->have_posts()):
                                    while ($query->have_posts()) : $query->the_post();
                                        get_template_part( 'learnpress/archive-tab/content-course', 'grid' );
                                    endwhile;
                                    wp_reset_postdata();
                                else:
                                    echo '<div class="alert alert-danger" role="alert">'.__('No course found!', 'acadia').'</div>';
                                endif;
                            ?>
                        </div>
                    </div>
                    <div class="tab-pane fade" id="profile" role="tabpanel" aria-labelledby="profile-tab">
                        <div class="course-tab-list" data-ac-course-tab-list>
                            <?php 
                                if($query->have_posts()):
                                    while ($query->have_posts()) : $query->the_post();
                                        get_template_part( 'learnpress/archive-tab/content-course', 'list' );
                                    endwhile;
                                    wp_reset_postdata();
                                else:
                                    echo '<div class="alert alert-danger" role="alert">'.__('No course found!', 'acadia').'</div>';
                                endif;
                            ?>
                        </div>
                    </div>
                </div>

                <?php if( !empty( $get_ac_lp_load_more_sw ) ) : ?>
                <div class="col-lg-12">
                    <div class="tp-event-inner-pagination pb-100">
                        <div class="tp-dashboard-pagination pt-20">
                            <div class="load-pagi-wrap text-center">
                                <input class="ac-lp-archive-load-more-4 tp-btn-round mt-20" type="button" value="Load More">
                            </div>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </section>
    <!-- course filter area end -->
</main>