<?php

/**
 * Template part for displaying header side information
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package acadia
 */

$acadia_offcanvas_logo = get_theme_mod('acadia_offcanvas_logo', get_template_directory_uri() . '/assets/img/logo/logo-black.png');
$acadia_offcanvas_content_switch = get_theme_mod('acadia_offcanvas_content_switch', false);


$acadia_offcanvas_title = get_theme_mod('acadia_offcanvas_title', esc_html__('Hello There!', 'acadia'));
$acadia_offcanvas_content = get_theme_mod('acadia_offcanvas_content', esc_html__('Lorem ipsum dolor sit amet, consectetur adipiscing elit, ', 'acadia'));

?>

<!-- offcanvas area start -->
<div class="offcanvas__area offcanvas__2">
   <div class="offcanvas__wrapper">
      <div class="offcanvas__close">
         <button class="offcanvas__close-btn offcanvas-close-btn">
            <svg width="12" height="12" viewBox="0 0 12 12" fill="none" xmlns="http://www.w3.org/2000/svg">
               <path d="M11 1L1 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
               <path d="M1 1L11 11" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
         </button>
      </div>
      <div class="offcanvas__content">
         <div class="offcanvas__top mb-90 d-flex justify-content-between align-items-center">
            <div class="offcanvas__logo logo">
               <?php if (!empty($acadia_offcanvas_logo)) : ?>
                  <a href="<?php print esc_url(home_url('/')); ?>" class="acadia-offcanvas-logo">
                     <img src="<?php echo esc_url($acadia_offcanvas_logo); ?>" alt="<?php echo esc_attr__('acadia Logo', 'acadia'); ?>">
                  </a>
               <?php endif; ?>
            </div>
         </div>
         <div class="offcanvas-main">
            <?php if ($acadia_offcanvas_content_switch) : ?>
               <div class="offcanvas-content">
                  <?php if (!empty($acadia_offcanvas_title)) : ?>
                     <h3 class="offcanvas-title">
                        <?php echo acadia_kses($acadia_offcanvas_title); ?>
                     </h3>
                  <?php endif; ?>

                  <?php if (!empty($acadia_offcanvas_content)) : ?>
                     <p><?php echo acadia_kses($acadia_offcanvas_content); ?></p>
                  <?php endif; ?>
               </div>
            <?php endif; ?>

            <div class="tp-main-menu-mobile d-xl-none"></div>

         </div>
      </div>
   </div>
</div>
<div class="body-overlay"></div>
<!-- offcanvas area end -->