{% if ucfunc("run_code_once", "search_filter_js") == true %}

function ucInitSearchFilter(objFilter){
  
  	var objInput = objFilter.find("input");
  	var objSearchBtn = objFilter.find(".uc-search-filter-btn");
    var objGrid;
  	var lastPhrase, isPhraseChanged, isSearchRequestSent; 
  	 	
  	objFilter.on("unselect_by_key", clearPhraseByKey);
    objFilter.on("clear_filter", clearFilter);
	
  	
    //clear filter if the key match
  	function clearPhraseByKey(event, key){
      	     
      	var newPhrase = objInput.val();
      	
      	key = decodeURIComponent(key);
      	
      	if(key.indexOf(newPhrase) > -1){
        	
          objInput.val("");
          
        } 		
          	
    }
  	
  
    //clear the filter
    function clearFilter(){
      
   	  objInput.val("");
      
    }
  	  
  
  	/**
    * check if phase is changed
    */
  	function checkPhrase(newPhrase, lastPhrase){
    
    	if(jQuery.trim(lastPhrase) == jQuery.trim(newPhrase))        
    	isPhraseChanged = false;
    
      	if(jQuery.trim(lastPhrase) != jQuery.trim(newPhrase))        
        isPhraseChanged = true;
    
    }
  
  	/**
    * update lastphrase value
    */
  	function onInputChange(){
    
      	lastPhrase = objInput.data('lastphrase');

      	var isAjaxUrlAddAttrExist = objFilter.attr('ajaxurladd');
      
      	if(typeof isAjaxUrlAddAttrExist != "undefined") 
        objFilter.attr('ajaxurladd', "postlinkadd=search%3D"+objInput.val()+"%0A");  
    }
  
  	/**
    * conect to grid
    */
  	function findGrid(){
    
      if(!objGrid)
        objGrid = objFilter.data("grid");
        
      if(!objGrid)
        return(false);
    
    }
  
  	/**
    * refresh grid
    */
  	function doSearch(){
    
    	objGrid.trigger("uc_refresh");
    
    }
  
  	/**
    * difines when to do search
    */
  	function onKeyup(e){
    
    	findGrid();
      
      	if(e.keyCode == 13){
          
        	doSearch();
          
          	isSearchRequestSent = true;
          
          	return(false);
            
        }
      
      	if(e.keyCode != 13)
        isSearchRequestSent = false;
      
      	if(objSearchBtn.length)
        return(false);  
      
      	g_ucDynamicFilters.runWithTrashold(function(){    
         
          objInput.data('lastphrase', objInput.val());
          
          if(isSearchRequestSent == true)
          return(false);
          
          var newPhrase = objInput.val();
         
          checkPhrase(newPhrase, lastPhrase);
          
          if(isPhraseChanged == false)
       	  return(false);
          
          doSearch();
        
        }, 1000); 
    
    }
  
  	/**
    * on search button click
    */
  	function onSearchBtnClick(){
    	
      	findGrid();
      
      	doSearch();
    
    }
    
  	/**
    * init events
    */
    objInput.on("keyup", onKeyup);    
  	objInput.on("input", onInputChange);  
  	objSearchBtn.on("click", onSearchBtnClick);
  
}
 

{% endif %}


{{ ucfunc("put_docready_start") }}
  	
   var objFilter = jQuery("#{{uc_id}}");

   if(typeof ucInitSearchFilter != "undefined") 
   		ucInitSearchFilter(objFilter);
 
{{ ucfunc("put_docready_end") }}