#{{uc_id}}
{
  display:grid;
}
#{{uc_id}} .ue-event-list-item
{
  display:flex;
  position:relative;
  overflow:hidden;
  transition:0.3s;
}

#{{uc_id}} .ue-event-list-item .ue-event-list-item-image
{
  flex-grow:0;
  flex-shrink:0;
  display:flex;
  flex-direction:column;
  align-items:center;
}

#{{uc_id}} .ue-event-list-item .ue-event-list-item-image img
{
  object-fit: cover;
}

#{{uc_id}} .ue-event-list-item .ue-event-list-item-image-spacing
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-event-list-item .ue-event-list-item-calendar
{
  flex-grow:0;
  flex-shrink:0;
  display:flex;
  flex-direction:column;
  
  text-align:center;
}

#{{uc_id}} .ue-event-list-item-calendar-container
{
  overflow:hidden;
}

#{{uc_id}} .ue-event-list-item .ue-event-list-item-calendar-spacing
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue-event-list-item-details-cta
{
  flex-grow:0;
  flex-shrink:0;
  display:flex;
  align-items:center;
}

#{{uc_id}} .ue-event-list-item .ue-event-list-item-details
{
  flex-grow:1;
}

.ue-event-list-item-details-title
{
  font-size:21px;
}

#{{uc_id}} .ue-event-list-item-details-attributes
{
  display:inline-flex;
  flex-wrap: wrap;
}

#{{uc_id}} .ue-event-list-item-details-attributes > div
{
  display:flex;
  align-items:center;
  gap:7px;
}

#{{uc_id}} .ue-event-list-item-details-attributes-icon
{
  line-height:1em;
}
#{{uc_id}} .ue-event-list-item-details-attributes-icon svg
{
  width:1em;
  height:1em;
}

#{{uc_id}} .ue-btn
{
  transition:0.5s;
  text-decoration:none;
  text-align:center;
}

.ue-event-list-item-calendar-day
{
  font-size:42px;
}

#{{uc_id}} .ue_badge
{
  position: absolute;
    top: 20px;
    {% if badge_placement == "right" %}right: -70px;transform: rotate(45deg);{% endif %}	
    {% if badge_placement == "left" %}left: -70px;transform: rotate(-45deg);{% endif %}
    padding: 5px 0px;
    width: 200px;
    text-align: center;
    box-sizing: border-box;
    z-index:2;
}

.ue_badge
{
  font-size:10px;
  line-height:1em;
}

#{{uc_id}} .ue-event-list-item div.ue-event-list-item-separator
{
  display:none;
}

{% if layout_type == "carousel" %}

#{{uc_id}} .owl-dots {
overflow:hidden;
text-align:{{dot_alignment}};
}

#{{uc_id}} .owl-dot {
border-radius:50%;
display:inline-block;
}

#{{uc_id}} .owl-nav .owl-prev,
#{{uc_id}} .owl-nav .owl-next{
    position:absolute;
    display:flex;
  	justify-content: center;
  	align-items: center;
    text-align:center;
}


#{{uc_id}} .owl-nav .disabled
{
    display: none;  
}
{% endif %}

@media only screen and (max-width: {{collapse_content}}px) {
  #{{uc_id}} .ue-event-list-item
  {
    flex-wrap: wrap;
  }
  
  
  	#{{uc_id}} .ue-event-list-item .ue-event-list-item-calendar{
      width: 100%;
      {% if  hide_calendar_on_collapse == "true" %}  
        display:none;
      {% endif %} 
  	}
 
 
}


#{{uc_id}}.uc-remote-parent .ue-event-list-item
{
  cursor:pointer;
}