{%if filter_isajax != "yes" %}

<div class="ue_taxonomy_toggle" id="{{uc_id}}-toggle">
  <div class="ue_taxonomy_toggle_icon">
    <div class="ue_taxonomy_toggle_icon_open">{{open_toggle_icon_html|raw}}</div>
    <div class="ue_taxonomy_toggle_icon_close">{{close_toggle_icon_html|raw}}</div>
  </div>
</div>

{% if layout_type == "accordion" %}
	<div id="{{uc_id}}-accordion-button-wrapper" class="uc-checkbox-filter-accordion-button-wrapper">
		<div id="{{uc_id}}-accordion-button" class="uc-checkbox-filter-accordion-button">
          <span class="uc-checkbox-filter-accordion-button-text">{{accordion_button_open_text|raw}}</span>
          <span class="uc-checkbox-filter-accordion-icon">{{open_accordion_icon_html|raw}}</span></div>
	</div>
{% endif %}

<div id="{{uc_id}}-container" {% if layout_type == "accordion" %}class="uc-checkbox-filter-accordion-container uc-hidden"{% endif %}>
{%endif%}
  
<div id="{{uc_id}}" class="ue_taxonomy {{filter_addclass}} uc-checkbox-filter" data-isfilter="{{is_filter}}" data-filtertype="general" data-generaltype="checkbox" {{filter_attributes|raw}} data-show-see-more="{{show_see_more_button}}" data-show-clear-button="{{show_clear_button}}" data-operator="{{filter_logic}}" style='{{filter_style|raw}}{% if rtl == "true" %}direction: rtl;{% endif %}'>
  
  {% if( taxonomy is empty and uc_inside_editor == "yes" ) %}
  		No Terms Found
  {% endif %}

  {% if show_title == "true" %}<div class="ue_checkfilter_title">{{title|raw}}</div>{% endif %}
  
  {% if (show_clear_button == "true") and (clear_button_position == "above") %}
  	<a class="ue-clear-button uc-hidden" href="javascript:void(0)" aria-label="clear">{{clear_button_icon_html|raw}}{{clear_button_text|raw}}</a>
  {% endif %}
  
  <div class="ue_checkbox_container" >
    
  {% for term in taxonomy %}
  	<label href="javascript:void(0)" class="ue_taxonomy_item {{term.addclass}} {{filter_addclass_item}} " {{term.html_data|raw}} {{term.html_attributes|raw}} aria-label="term">
      
      <input type="checkbox" class="uc-checkbox-filter__checkbox" {{term.html_attributes_input|raw}}>
          
      <span  class="ue_taxonomy_item_title uc-checkbox-filter_label">{{term.name|raw}}</span>
      
      {% if show_number_on_term == "true" %}
         <span class="ue_taxonomy_item_num_posts_spacer"></span>
         <span class="ue_taxonomy_item_num_posts">{{count_wrapper_open|raw}}{{term.num_posts}}{{count_wrapper_close|raw}}</span>
      {% endif %}

    </label>
  {% endfor %}
    
  {% if show_see_more_button == "true" %}
    <a class="ue-see-more-button" data-term-num="{{terms_to_show_initially}}" href="javascript:void(0)" aria-label="see more">{{see_more_expand_icon_html|raw}}{{see_more_expand_title|raw}}</a>
    <a class="ue-see-less-button uc-hidden" href="javascript:void(0)" aria-label="see less">{{see_more_collapse_icon_html|raw}}{{see_more_collapse_title|raw}}</a>
  {% endif %}
    
  {% if (show_clear_button == "true") and (clear_button_position == "below") %}
    <a class="ue-clear-button uc-hidden" href="javascript:void(0)" aria-label="clear">{{clear_button_icon_html|raw}}{{clear_button_text|raw}}</a>
  {% endif %}

  </div>

</div>

{%if filter_isajax != "yes" %}

</div>
{% endif %}