{% if ucfunc("run_code_once", "uc_checkbox_filters") == true %}


function ucCheckboxFilterTriggerRefresh(objFilter, isSelected){
  
  	if(!isSelected)
      var isSelected = false;
  
    var isRefresh = false;
    var objHidden = objFilter.find(".uc-item-hidden");

    var isSingleFilter = objFilter.data("singlefilter");
	var role = objFilter.data("role");
        
    if(isSelected == false && objHidden.length > 0 && isSingleFilter !== true && role != "child")
      isRefresh = true;

    objFilter.trigger("uc_filter_change",{refresh:isRefresh});
}

 
function initUCCheckboxFilters(event, objParent){
  
    //init checkboxes
    var objCheckboxes = objParent.find(".uc-checkbox-filter__checkbox:not(.uc-selected .uc-checkbox-filter__checkbox)");
    objCheckboxes.prop("checked",false).attr("checked",false);
  	
    objParent.on("change",".uc-checkbox-filter__checkbox", function(event){
        
      	var objCheckbox = jQuery(this);
      
        var objFilter = objCheckbox.parents(".uc-checkbox-filter");
      
        var objParent = objCheckbox.parents(".ue_taxonomy_item");

        var isSelected = objCheckbox.is(":checked");
        if(isSelected == true)
          objParent.addClass("uc-selected");
        else
          objParent.removeClass("uc-selected");
      
      	objFilter.trigger("filter_state_update");
      
      	ucCheckboxFilterTriggerRefresh(objFilter, isSelected);
      
    });
    
}

function getUCCheckboxFilterData(event, responseData){
  
  	var objFilter = jQuery(this);
  	var operator = objFilter.data("operator");
    
  	var objCheckboxes = objFilter.find(".uc-checkbox-filter__checkbox:checked");
  	
    if(objCheckboxes.length == 0)
      return(null);
  
   var arrTerms = [];
   
   jQuery.each(objCheckboxes,function(index, checkbox){
     
     	var objItem = jQuery(checkbox).parents(".ue_taxonomy_item");
     	var itemData = g_ucDynamicFilters.getFilterElementData(objItem);
     
        arrTerms.push(itemData);
   });
  
   var objOutput = {};
   objOutput["terms"] = arrTerms;
  
   if(operator == "and")
   		objOutput["operator"] = "and";
  
   responseData.output = objOutput;
}
 
function onUCClearCheckboxFilter(){
  
	var objFilter = jQuery(this);
  	
  	var objCheckboxes = objFilter.find(".uc-checkbox-filter__checkbox");
    objCheckboxes.prop("checked",false).attr("checked",false);
  	
  	var objSelectedItems = objFilter.find(".uc-selected");
    objSelectedItems.removeClass("uc-selected");
  
    objFilter.trigger("filter_state_update");
}
 
 
/*
* if layout is accordion
*/
function onUCCheckboxFiltersAccordionButtonClick(layoutType, objAccordionText, objAccordionIcon, objAccordionContainer, hiddenClass, closeAccText, closeAccIconHtml, openAccText, OpenAccIconHtml){
    
  	if(layoutType != "accordion")
   		 return(false);  
  
    var objButton = jQuery(this);
    var calssActive = "ue-active";
  
    if(objAccordionContainer.hasClass(hiddenClass) == true){
      
      objAccordionContainer.removeClass(hiddenClass); 
      objAccordionText.text(closeAccText);
      objButton.addClass(calssActive);
      objAccordionIcon.html(closeAccIconHtml);
      
    }else{
      
      objAccordionContainer.addClass(hiddenClass);
      objAccordionText.text(openAccText);
      objButton.removeClass(calssActive);
      objAccordionIcon.html(OpenAccIconHtml);
      
    }
    
    if(objAccordionContainer.hasClass(hiddenClass) == false)
    objAccordionContainer.slideDown("fast");  
    else
    objAccordionContainer.slideUp("fast");
  
} 	 

function onUCCheckboxFilterUnselectByKey(event, key){
  	
  	var objFilter = jQuery(this);
    var objSelectedItems = objFilter.find(".ue_taxonomy_item.uc-selected");
	
  	if(objSelectedItems.length == 0)
      return(false);
  	
  	jQuery.each(objSelectedItems,function(index, item){
      	var objItem = jQuery(item);
      	var itemKey = g_ucDynamicFilters.getFilterItemKey(objItem);
      	
      	//unselect
      	if(itemKey == key){
            objItem.find(".uc-checkbox-filter__checkbox").prop("checked",false).attr("checked",false);
            objItem.removeClass("uc-selected");
          	objFilter.data("uc_norefresh", true);
          	return(false);
        }
      	      	
    });
  	
}
 
{% endif %}


{{ ucfunc("put_docready_start") }}

		var objFilter = jQuery("#{{uc_id}}");   
		
		objFilter.on("init_filter_type", initUCCheckboxFilters);
        objFilter.on("get_filter_data", getUCCheckboxFilterData);
        objFilter.on("clear_filter", onUCClearCheckboxFilter);
        objFilter.on("unselect_by_key", onUCCheckboxFilterUnselectByKey);
 		objFilter.on("init_filter", function(){
          	objFilter.trigger("filter_state_update");
          	objFilter.trigger("filter_html_init");
        });
 
 		objFilter.on("uc_ajax_reloaded",function(){
          	objFilter.trigger("filter_state_update");
          	objFilter.trigger("filter_html_init");
        });
  
        var objAccordionContainer, objAccordionButton, objAccordionText, objAccordionIcon;
 		
  {% if (show_clear_button == "true") %}
  
  			//clear button
  
   			objFilter.on("click",".ue-clear-button",function(){
              
               objFilter.trigger("clear_filter");
               ucCheckboxFilterTriggerRefresh(objFilter);
            });
   
          	objFilter.on("filter_state_update",function(){
                            
              	var objSelected = objFilter.find(".uc-selected");
          		
              	var objClearButton = objFilter.find(".ue-clear-button");
              	
              	if(objSelected.length)
                  	objClearButton.removeClass("uc-hidden");
              	else
                  	objClearButton.addClass("uc-hidden");                            
             });
   		
  {% endif %}

  {% if (show_see_more_button == "true") %}
    
  		//see more/less button
  		
        objFilter.on("click",".ue-see-more-button",function(){
			          
            var objItems = objFilter.find(".ue_taxonomy_item:not(.uc-item-hidden)")
            objItems.removeClass("uc-hidden");  	
                    	
          	objFilter.find(".ue-see-more-button").addClass("uc-hidden");
          	objFilter.find(".ue-see-less-button").removeClass("uc-hidden");
        });
   
        objFilter.on("click",".ue-see-less-button",function(){
          
          	hideFilterItems();
          	
          	objFilter.find(".ue-see-more-button").removeClass("uc-hidden");
          	objFilter.find(".ue-see-less-button").addClass("uc-hidden");
        });
  		
   		function hideFilterItems(){
          
			var objSeeMoreButton = objFilter.find(".ue-see-more-button");
          	
            var showNumItems = objSeeMoreButton.data("term-num");
            var objVisibleFilterItems = objFilter.find(".ue_taxonomy_item:not(.uc-item-hidden)")
			
            var numItems = objVisibleFilterItems.length;
          	
          	if(numItems < showNumItems){
              	objSeeMoreButton.addClass("uc-hidden");
            	objVisibleFilterItems.removeClass("uc-hidden");  	
              	return(false);
            }
            	
            //show first showNumItems
            objVisibleFilterItems.each(function(index, item){

              var objItem = jQuery(this);
				
              if(index < showNumItems)
                  objItem.removeClass("uc-hidden");
               else
                  objItem.addClass("uc-hidden");
            });
        }
   
        objFilter.on("filter_html_init",function(){
          		hideFilterItems();
        });
          	
  {% endif %}
  
{% if layout_type == "accordion" %}
          
  // init accordion

  var objAccordionContainer = jQuery("#{{uc_id}}-container");
 
  //hide container after delay to let filters.js file finish all processes
  setTimeout(function(){
  	objAccordionContainer.hide();
  },200);
  
  var objAccordionButton = jQuery("#{{uc_id}}-accordion-button");
  var objAccordionText = objAccordionButton.find(".uc-checkbox-filter-accordion-button-text");
  var objAccordionIcon = objAccordionButton.find(".uc-checkbox-filter-accordion-icon");
	
   objAccordionButton.on("click", function(){
     	onUCCheckboxFiltersAccordionButtonClick("{{layout_type}}", objAccordionText, objAccordionIcon, objAccordionContainer, "uc-hidden", "{{accordion_button_close_text|raw}}", "{{close_accordion_icon_html|raw}}", "{{accordion_button_open_text|raw}}", "{{open_accordion_icon_html|raw}}")
   });

  {% endif %}
        
  
{{ ucfunc("put_docready_end") }}