{% if disable_page_scroll_when_popup_is_opened == "true" %}
  body.uc-active{
    overflow-y: hidden;
  }
{% endif %}	

{% if uc_inside_editor == "yes" %}

  #{{uc_id}} .ue-simple-popup-wrapper > *{
      pointer-events: none;
  }

{% endif %}	

{% if responsive_mode == "true" %}
#{{uc_id}} .ue-simple-popup-trigger-wrapper{
	display: none;
  	{% if uc_inside_editor == "yes" %}
  	display: block;
	pointer-events: none;
  	opacity: .2;
	{% endif %}	
}

{% endif %}	

#{{uc_id}} .ue-simple-popup-inner{
  position: relative;
}

#{{uc_id}} .ue-simple-popup-wrapper{
 	overflow-y:auto;
  	max-height: 100vh;
}

#{{uc_id}} .uc-editor-message.uc-error{
  padding:10px;
  font-size:14px;
  color: red;
}

#{{uc_id}} .ue-simple-popup-btn
{
  display:flex;
  align-items:center;
}

#{{uc_id}} .ue-simple-popup-btn-icon
{
  line-height:1em;
}

#{{uc_id}} .ue-simple-popup-btn-icon svg
{
  height:1em;
  width:1em;
}


{% if popup_source == "text" %}

  #{{uc_id}} .ue-simple-popup-wrapper{
      display: flex;
      justify-content: center;
      align-items: center;
      text-align: center;
  }

{% endif %}	

{% if uc_inside_editor == "no" and responsive_mode == "false" %}
#{{element_id|raw}}:not(#{{uc_id}} #{{element_id|raw}}){
	display: none;
}
{% endif %}	

#{{uc_id}} .ue-simple-popup-overlay{
  position: fixed;
  top:0;
  bottom:0;
  right:0;
  left:0;
  width:100%;
  z-index:{{z_index}};
  display:flex;
  opacity: 0;
  pointer-events: none;
}

#{{uc_id}} .ue-simple-popup-overlay.uc-active{
  opacity: 1;
  pointer-events: all;
}

#{{uc_id}} .ue-simple-popup-close{
  position:absolute;
  line-height:1em;
  cursor:pointer;
  display:flex;
  align-items:center;
  justify-content:center;
  z-index:1000;
  {{horizontal_snap}}: {{horizontal_offset}}px;
  {{vertical_snap}}: {{vertical_offset}}px;
}

#{{uc_id}} .ue-simple-popup-trigger{
  display: inline-block;
}

@media screen and (max-width: 1024px) {
  #{{uc_id}} .ue-simple-popup-close{
    {{horizontal_snap}}: {{horizontal_offset_tablet}}px;
    {{vertical_snap}}: {{vertical_offset_tablet}}px;
  }
}

@media screen and (max-width: 767px) {
  #{{uc_id}} .ue-simple-popup-close{
    {{horizontal_snap}}: {{horizontal_offset_mobile}}px;
    {{vertical_snap}}: {{vertical_offset_mobile}}px;
  }
}

{% if responsive_mode == "true" %}
@media screen and (max-width: {{breakpoint}}px) {
  	#{{uc_id}} .ue-simple-popup-trigger-wrapper{
        display: block;
    }
  	{% if uc_inside_editor == "no" %}
	#{{element_id|raw}}:not(#{{uc_id}} #{{element_id|raw}}){
        display: none;
    }
  	{% endif %}	
}
{% endif %}