{{ ucfunc("put_docready_start") }}

  var objFilter = jQuery("#{{uc_id}}");
  var objButton = objFilter.find(".uc-button-clear");
  var objGrid;
  var hiddenClass = "uc-hidden";

  /*
  * click on clear button
  */
  function onClearClick(){

     if(!objGrid)
       return(false);

    objGrid.trigger("clear_filters");
    
    hideClearButton();
    
  }

  /*
  * hide the button
  */
  function hideClearButton(){
  
  	objButton.addClass(hiddenClass);
    
    objButton.attr("disabled", "disabled");
  
  }

  /*
  * show the button
  */
  function showClearButton(){
  
    objButton.removeClass(hiddenClass);
    
    objButton.removeAttr("disabled");
  
  }
 
  /*
  * show button if any filter is selected
  */
  function showHideClearButton(){
      
	var activeFiltes = objGrid.data("active_filters_items");
    
    if(!activeFiltes || activeFiltes.length == 0)
 	hideClearButton();
    else
    showClearButton();    
  
  }

  /*
  * wait while filters inited
  */
  objFilter.on("init_filter",function(){

      objGrid = objFilter.data("grid");

      if(!objGrid)
        return(false);

      objButton.on("click", onClearClick);
    
      //show clear button after grid ajax refresh if needed
      objGrid.on("uc_ajax_refreshed", showHideClearButton);
    
      objGrid.on("update_active_filter_items", showHideClearButton);


  });

{{ ucfunc("put_docready_end") }}