<?php

use Hostinger\WpHelper\Utils;

$submenus = self::getMenuSubpages();

?>
    <div class="hsr-overlay"></div>
    <div class="hsr-onboarding-navbar">
        <div class="hsr-mobile-sidebar">
            <div class="hsr-close">
                <svg width="14" height="14" viewBox="0 0 14 14" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path d="M6.99961 8.04961L1.74961 13.2996C1.59961 13.4496 1.42461 13.5246 1.22461 13.5246C1.02461 13.5246 0.849609 13.4496 0.699609 13.2996C0.549609 13.1496 0.474609 12.9746 0.474609 12.7746C0.474609 12.5746 0.549609 12.3996 0.699609 12.2496L5.94961 6.99961L0.699609 1.74961C0.549609 1.59961 0.474609 1.42461 0.474609 1.22461C0.474609 1.02461 0.549609 0.849609 0.699609 0.699609C0.849609 0.549609 1.02461 0.474609 1.22461 0.474609C1.42461 0.474609 1.59961 0.549609 1.74961 0.699609L6.99961 5.94961L12.2496 0.699609C12.3996 0.549609 12.5746 0.474609 12.7746 0.474609C12.9746 0.474609 13.1496 0.549609 13.2996 0.699609C13.4496 0.849609 13.5246 1.02461 13.5246 1.22461C13.5246 1.42461 13.4496 1.59961 13.2996 1.74961L8.04961 6.99961L13.2996 12.2496C13.4496 12.3996 13.5246 12.5746 13.5246 12.7746C13.5246 12.9746 13.4496 13.1496 13.2996 13.2996C13.1496 13.4496 12.9746 13.5246 12.7746 13.5246C12.5746 13.5246 12.3996 13.4496 12.2496 13.2996L6.99961 8.04961Z"
                          fill="#673DE6"></path>
                </svg>
            </div>
            <div class="hsr-wrapper"></div>
        </div>
        <div class="hsr-onboarding-navbar__wrapper">
            <div class="hsr-logo">
                <svg class="hsr-mobile-logo" width="24" height="24" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M2.00025 14.046V0.000497794L9.08916 3.78046V10.1086L18.4735 10.1132L25.6774 14.046H2.00025ZM20.3925 8.95058V0L27.6725 3.6859V13.1797L20.3925 8.95058ZM20.3924 26.1177V19.8441L10.9358 19.8375C10.9446 19.8793 3.6123 15.8418 3.6123 15.8418L27.6725 15.9547V30L20.3924 26.1177ZM2 26.1177L2.00025 16.9393L9.08916 21.0683V29.8033L2 26.1177Z" fill="#1D1E20"/>
                </svg>
                <svg width="30" height="30" viewBox="0 0 30 30" fill="none" xmlns="http://www.w3.org/2000/svg">
                    <path fill-rule="evenodd" clip-rule="evenodd" d="M2.00025 14.046V0.000497794L9.08916 3.78046V10.1086L18.4735 10.1132L25.6774 14.046H2.00025ZM20.3925 8.95058V0L27.6725 3.6859V13.1797L20.3925 8.95058ZM20.3924 26.1177V19.8441L10.9358 19.8375C10.9446 19.8793 3.6123 15.8418 3.6123 15.8418L27.6725 15.9547V30L20.3924 26.1177ZM2 26.1177L2.00025 16.9393L9.08916 21.0683V29.8033L2 26.1177Z" fill="#1D1E20"/>
                </svg>
            </div>


            <svg class="hsr-mobile-menu-icon" width="24" height="24" viewBox="0 0 24 24" fill="none"
                 xmlns="http://www.w3.org/2000/svg">
                <path d="M3.75 18C3.5375 18 3.35938 17.9277 3.21563 17.7831C3.07187 17.6385 3 17.4594 3 17.2456C3 17.0319 3.07187 16.8542 3.21563 16.7125C3.35938 16.5708 3.5375 16.5 3.75 16.5H20.25C20.4625 16.5 20.6406 16.5723 20.7844 16.7169C20.9281 16.8615 21 17.0406 21 17.2544C21 17.4681 20.9281 17.6458 20.7844 17.7875C20.6406 17.9292 20.4625 18 20.25 18H3.75ZM3.75 12.75C3.5375 12.75 3.35938 12.6777 3.21563 12.5331C3.07187 12.3885 3 12.2094 3 11.9956C3 11.7819 3.07187 11.6042 3.21563 11.4625C3.35938 11.3208 3.5375 11.25 3.75 11.25H20.25C20.4625 11.25 20.6406 11.3223 20.7844 11.4669C20.9281 11.6115 21 11.7906 21 12.0044C21 12.2181 20.9281 12.3958 20.7844 12.5375C20.6406 12.6792 20.4625 12.75 20.25 12.75H3.75ZM3.75 7.5C3.5375 7.5 3.35938 7.42771 3.21563 7.28313C3.07187 7.13853 3 6.95936 3 6.74563C3 6.53188 3.07187 6.35417 3.21563 6.2125C3.35938 6.07083 3.5375 6 3.75 6H20.25C20.4625 6 20.6406 6.07229 20.7844 6.21687C20.9281 6.36147 21 6.54064 21 6.75437C21 6.96812 20.9281 7.14583 20.7844 7.2875C20.6406 7.42917 20.4625 7.5 20.25 7.5H3.75Z"
                      fill="#36344D"></path>
            </svg>
            <?php



            if (!empty($submenus)) {
                ?>
                <ul class="hsr-wrapper__list">
                    <?php

                    foreach ($submenus as $index => $submenu) {
                        $page = (isset($_GET['page'])) ? $_GET['page'] : '';

                        $is_active = ($page === $submenu['menu_slug'] || ($page === self::MENU_SLUG && $index === 0));

                        ?>
                        <li
                                class="hsr-list__item <?php echo ($is_active) ? "hsr-active" : ""; ?>"
                        >
                            <a
                                    href="<?php echo menu_page_url($submenu['menu_slug'], false); ?>"
                                    class="<?php echo $submenu['menu_slug']; ?>"
                            >
                                <?php

                                echo $submenu['menu_title'];

                                ?>
                            </a>
                        </li>
                        <?php
                    }

                    ?>
                </ul>
                <?php
            }

            $utils = new Utils();

            $api_token = Utils::getApiToken();

            if (!empty($api_token)) {
                ?>
                <div class="hsr-go-to-hpanel">
                    <svg width="20" height="20" viewBox="0 0 20 20" fill="none" xmlns="http://www.w3.org/2000/svg">
                        <path d="M11.6667 7.5C11.2064 7.5 10.8333 7.1269 10.8333 6.66667V3.33333C10.8333 2.8731 11.2064 2.5 11.6667 2.5H16.6667C17.1269 2.5 17.5 2.8731 17.5 3.33333V6.66667C17.5 7.1269 17.1269 7.5 16.6667 7.5H11.6667ZM3.33333 10.8333C2.8731 10.8333 2.5 10.4602 2.5 10V3.33333C2.5 2.8731 2.8731 2.5 3.33333 2.5H8.33333C8.79357 2.5 9.16667 2.8731 9.16667 3.33333V10C9.16667 10.4602 8.79357 10.8333 8.33333 10.8333H3.33333ZM11.6667 17.5C11.2064 17.5 10.8333 17.1269 10.8333 16.6667V10C10.8333 9.53976 11.2064 9.16667 11.6667 9.16667H16.6667C17.1269 9.16667 17.5 9.53976 17.5 10V16.6667C17.5 17.1269 17.1269 17.5 16.6667 17.5H11.6667ZM3.33333 17.5C2.8731 17.5 2.5 17.1269 2.5 16.6667V13.3333C2.5 12.8731 2.8731 12.5 3.33333 12.5H8.33333C8.79357 12.5 9.16667 12.8731 9.16667 13.3333V16.6667C9.16667 17.1269 8.79357 17.5 8.33333 17.5H3.33333ZM4.16667 9.16667H7.5V4.16667H4.16667V9.16667ZM12.5 15.8333H15.8333V10.8333H12.5V15.8333ZM12.5 5.83333H15.8333V4.16667H12.5V5.83333ZM4.16667 15.8333H7.5V14.1667H4.16667V15.8333Z" fill="#673DE6"></path>
                    </svg>
                    <a href="<?php echo esc_url($utils->getHpanelDomainUrl()); ?>" target="_blank" rel="noopener">
                        <?php echo esc_html__('Go to hPanel', 'hostinger-wp-menu-package'); ?>
                    </a>
                </div>
                <?php
            }

            ?>
        </div>
    </div>
<?php