#{{uc_id}}.uc-filter-initing{
    opacity:0.8;
    cursor:default;
}

#{{uc_id}} .ue-debug-meta
{
  font-size:10px;
  border:1px solid red;
  padding:10px;
}

#{{uc_id}} .ue_taxonomy_image img
{
  display:block;
}

#{{uc_id}}.ue_taxonomy
{
  flex-wrap: wrap;
}

#{{uc_id}} a.ue_taxonomy_item
{
  display:block;
}


{% if disabled_mode == "true" %}

#{{uc_id}} .ue_taxonomy_item.uc-item-hidden{
	display: block !important;
  	opacity: .5;
  	pointer-events: none;
}

{% else %}

#{{uc_id}} .uc-item-hidden{
	display:none !important;
}

{% endif %}

#{{uc_id}}.uc-filter-initing a{
   cursor:default;
   background-color:lightgray !important;
}

#{{uc_id}}.uc-filter-initing .ue_taxonomy_item_content{
	visibility:hidden;
}



{% if loader_type == "hidden" %}

  #{{uc_id}}.uc-filter-initing a{
      display:none !important;
  }

  #{{uc_id}}.uc-filter-initing a:first-child{
     display:block !important;  
     visibility:hidden;
  }
{% endif %}

#{{uc_id}}.uc-filter-hidden,
#{{uc_id}}.uc-filter-initing.uc-initing-filter-hidden{
  display:none !important;
}


#{{uc_id}} .ue_taxonomy_item_content
{
  display:flex;
  align-items:center;
}

#{{uc_id}} .ue_taxonomy_item_icon
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue_taxonomy_item_icon_spacer
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue_taxonomy_item_num_posts
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .ue_taxonomy_item_title
{
  flex-grow:1;
}


#{{uc_id}} .ue_taxonomy_item_num_posts_spacer
{
  flex-grow:0;
  flex-shrink:0;
}

#{{uc_id}} .uc-hide-loading-item{
	display:none !important;
}


#{{uc_id}}-toggle
{
  display:none;
}

#{{uc_id}}-toggle .#{{uc_id}}-toggle
{
  display:none;
}

#{{uc_id}}-toggle .ue_taxonomy_toggle_icon
{
  display:inline-flex;
  align-items:center;
  justify-content:center;
  line-height:1em;
  cursor:pointer;
}

#{{uc_id}}-toggle .ue_taxonomy_toggle_icon svg
{
  height:1em;
  width:1em;
}


#{{uc_id}}-toggle .ue_taxonomy_toggle_icon_close
{
  display:none;
}

{% if(show_numbers_on_all == "false") %}
  #{{uc_id}} .uc-item-all .ue_taxonomy_item_num_posts_spacer,
  #{{uc_id}} .uc-item-all .ue_taxonomy_item_num_posts{
	 	display:none !important;
  }
{% endif %}

{% if (responsive_behaviour == "toggle") %}
@media only screen and (max-width: {{responsive_breakpoint}}px) {
 
#{{uc_id}}-toggle
{
  display:block;
}

#{{uc_id}}-container
{
  display:none;
}
  
}
{% endif %}

{% if (responsive_behaviour == "swipe") %}

  {% if (snap_to_tabs_filter_item == "true") %}
    #{{uc_id}}:not(.active){
        scroll-snap-type: both mandatory;
    }

    #{{uc_id}} > a{
        scroll-snap-align: start;
    }
  {% endif %}

  @media only screen and (max-width: {{responsive_breakpoint}}px) {
    #{{uc_id}}.ue_taxonomy{
      display: flex;
      flex-wrap: nowrap;
      overflow-x: scroll;
      justify-content: unset;
    }
    #{{uc_id}}.ue_taxonomy::-webkit-scrollbar{
      display: none;
    }

    #{{uc_id}} a.ue_taxonomy_item{
      flex: 0 0 auto;
  	}
  } 

{% endif %}

{% if carousel_layout == "true" %}
#{{uc_id}}.slick-carousel{
  display:flex;
}
#{{uc_id}},.slick-track{
  display:flex;
}
#{{uc_id}} .ue-arrow-right, #{{uc_id}} .ue-arrow-left{
  transform: translateY(-50%);
  cursor:pointer;
}
#{{uc_id}} .ue-arrow-left{
    position:absolute;
    display:inline-block;
    text-align:center;
}
#{{uc_id}} .ue-arrow-right{
  position:absolute;
  display:inline-block;
  text-align:center;
}
{% endif %}