{{ ucfunc("put_docready_start") }}

  var objWidget = jQuery("#{{uc_id}}");

  jQuery("#{{uc_id}}-toggle").click(function(){
     jQuery("#{{uc_id}}-container").toggle();
     jQuery("#{{uc_id}}-toggle .ue_taxonomy_toggle_icon_open").toggle();
     jQuery("#{{uc_id}}-toggle .ue_taxonomy_toggle_icon_close").toggle();
  });
  
  
  {% if (layout is not empty) and (tabs_filter_drag == "true") %}
		
  	const tabs = document.querySelector('#{{uc_id}}');
  
    let isDown = false;
    let startX;
    let scrollLeft;

    tabs.addEventListener('mousedown', (e) => {
      isDown = true;
      tabs.classList.add('active');
      startX = e.pageX - tabs.offsetLeft;
      scrollLeft = tabs.scrollLeft;
      e.preventDefault();
    });
  
    tabs.addEventListener('mouseleave', () => {
      isDown = false;
      tabs.classList.remove('active');
    });
  
    tabs.addEventListener('mouseup', () => {
      isDown = false;
      tabs.classList.remove('active');
    });
  
    tabs.addEventListener('mousemove', (e) => {
      if(!isDown) return;
      e.preventDefault();
      const x = e.pageX - tabs.offsetLeft;
      const walk = (x - startX) * 3; //scroll-fast
      tabs.scrollLeft = scrollLeft - walk;
        e.preventDefault();
    });
  
  {% endif %}
  
  {% if carousel_layout == "true" %}
  
    function initTabCarousel(){
      
      objWidget.slick({
        infinite: {{loop}},
        slidesToShow: {{number_of_items}},
        slidesToScroll: {{items_to_scroll}},
        speed: {{transition_speed}},
        autoplay: {{autoplay}},
        {% if autoplay == "true" %}pauseOnHover:{{autoplayhoverpause}},{% endif %}
        {% if autoplay == "true" %}autoplaySpeed:{{autoplay_interval}},{% endif %}
        dots: {{show_bullets}},
        rtl:{{rtl}},
        variableWidth: {{auto_width}},
        arrows: {{show_arrows}},
        prevArrow:"<span class='ue-arrow-left'>{{left_arrow_html|raw}}</span>",
        nextArrow:"<span class='ue-arrow-right'>{{right_arrow_html|raw}}</span>",
        centerMode:{{center}},
        responsive: [
          {
            breakpoint: 1024,
            settings: {
                {% if number_of_items_tablet is not empty %}slidesToShow: {{number_of_items_tablet}},{% endif %}
                {% if items_to_scroll_tablet is not empty %}slidesToScroll: {{items_to_scroll_tablet}}{% endif %}
            }
          },
          {
            breakpoint: 768,
            settings: {
                {% if number_of_items_mobile is not empty %}slidesToShow: {{number_of_items_mobile}},{% endif %}
                {% if items_to_scroll_tablet is not empty %}slidesToScroll: {{items_to_scroll_mobile}}{% endif %}
            }
          }
        ]
      });
    }
     initTabCarousel();	
    
     objWidget.on("uc_ajax_refreshed",function(){      
        objWidget.slick('unslick');
        initTabCarousel();
     });
   
  {% endif %}

  
{{ ucfunc("put_docready_end") }}