function ueActiveFiters(){
  
  //classes
  var g_removeButtonClass, g_activeFiltersItemClass;
  
  //selectors
  var g_removeButtonSelector, g_activeFiltersItemSelector;
  
  //objects
  var g_objWidget, g_itemsHolder, g_objFilterableGrid;
  
  //custom attrs
  
  //helpers
  var g_arrayFilterItems;
  
  //events name
  var g_removeActiveFilterItemEvent, g_clearFiltersEvent;
  
  /**
  * get filter key
  */
  function getFilterKey(arrItem){
    
    var key = arrItem.key;
    var slug = arrItem.slug;
    var taxonomy = getTaxonomy(arrItem);
    
    if(key === undefined)      
    key = "term|"+taxonomy+"|"+slug;
    
    return(key);
    
  }
  
  /**
  * get filter key
  */
  function getTitle(arrItem){
    
    var title;
    var slug = arrItem.slug;
    
    title = arrItem.title;
    
    if(title === undefined)
    title = slug
    
    title = decodeURIComponent(title);
    
    return(title);
    
  }
  
  /**
  * get filter item type
  */
  function getType(arrItem){
    
    var type = arrItem.type;
    
    return(type);
    
  }
  
  /**
  * get filter key
  */
  function getTaxonomy(arrItem){
    
    var taxonomy;
    
    taxonomy = arrItem.taxonomy;
    
    if(taxonomy === undefined)
    taxonomy = null
    
    return(taxonomy);
    
  }
  
  /**
  * get object for arrItem
  */
  function getArrItemObject(title, key, type){
    
    var filterItemHtml = '<div class="'+g_activeFiltersItemClass+'" data-type="'+type+'" data-key="'+key+'">'+title+' <span class="'+g_removeButtonClass+'" style="color: red; font-weight: 700;"><svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 61 61"><rect x="25" y="-7" width="11" height="75.41" transform="translate(-13 31) rotate(-45)"/><rect x="25" y="-7" width="11" height="75.31" transform="translate(31 -13) rotate(45)"/></svg> </span></div>';
    
    return(filterItemHtml);
    
  }
  
  /**
  * check if g_arrayFilterItems contains search type item
  */
  function checkSearchTypeFilterAndReplace(){
    
    g_arrayFilterItems.forEach(function(element, index){
      
      var objElement = jQuery(element);
      
      if(objElement.data('type') === 'search')      
      g_arrayFilterItems.splice(index, 1);
      
    });
    
  }
  
  /**
  * put items in the list 
  */
  this.putfilterItemsInList = function(arrActiveItems){
    
    var arrNum = arrActiveItems.length;

    g_arrayFilterItems.length = 0;
    
    for(let i=0;i<arrNum;i++){
      
      var arrItem = arrActiveItems[i];
      
      var key = getFilterKey(arrItem);
      var title = getTitle(arrItem);
      var type = getType(arrItem);
      
      var filterItemElem = getArrItemObject(title, key, type);
      
      //if item type is search see if there is such item already and replaсe it
      checkSearchTypeFilterAndReplace();
      
      if(g_arrayFilterItems.indexOf(filterItemElem) == -1)
      g_arrayFilterItems.push(filterItemElem);
      
    }
    
    g_itemsHolder.html(g_arrayFilterItems);
    
  }
  
  /*
  * on remove button click
  */
  function onRemoveButtonClick(){
    
    var objButton = jQuery(this);
    var objFilterItem = objButton.parents(g_activeFiltersItemSelector);
   
    var key = objFilterItem.data("key");
    var itemToRemoveHTML = objFilterItem[0].outerHTML;
  
    //remove item from array, svg remove icon
    g_arrayFilterItems = g_arrayFilterItems.filter(function(item) {
      return jQuery(item).data("key") !== key;
    });
    
                       
    //remove item from array
    for (var i = 0; i < g_arrayFilterItems.length; i++) {
            
      if (jQuery(g_arrayFilterItems[i]).html() == jQuery(itemToRemoveHTML).html()) {
        g_arrayFilterItems.splice(i, 1);

        break; // Exit the loop after removing the item
        
      }
    }
    
    g_objFilterableGrid.trigger(g_removeActiveFilterItemEvent,[key]);

  }
  
  /**
  * on clear all filters
  */
  function onClearFilters(){
    
    g_arrayFilterItems.length = 0;
    
  }
  
  /**
  * init from external file
  */
  this.init = function(widgetId, objGrid){
    
    //init vars
    //classes
    var itemsHolderClass = "ue-active-filters-holder";
    g_removeButtonClass = "ue-active-filters-item-remove";
    g_activeFiltersItemClass = "ue-active-filters-item";
    
    //events names
    g_removeActiveFilterItemEvent = "uc_unselect_filter";
    g_clearFiltersEvent = "clear_filters";
    
    //selectors
    var itemsHolderSelector = "."+itemsHolderClass;
    g_removeButtonSelector = "."+g_removeButtonClass;
    g_activeFiltersItemSelector = "."+g_activeFiltersItemClass;
    
    //objects
    g_objWidget = jQuery("#"+widgetId);
    g_itemsHolder = g_objWidget.find(itemsHolderSelector);
    g_objFilterableGrid = objGrid;
    
    //custom attrs    
    
    //helpers
    g_arrayFilterItems = [];
    
    //init events
    g_objWidget.delegate(g_removeButtonSelector, 'click', onRemoveButtonClick);
    g_objFilterableGrid.on(g_clearFiltersEvent, onClearFilters);

  }
  
}