{{ ucfunc("put_docready_start") }}

//init remote scroll control script	
      var objRemoteScrollControl = new ueRemoteScrollControl();
      objRemoteScrollControl.init("{{uc_id}}");

      //init remote api
      var objRemoteApi = new UERemoteWidgets();

  function initRemoteScrollWidget(){
  	  

      objRemoteApi.onWidgetInit("{{uc_id}}", function(objWidget){
    
        var objScrollControlWidget = jQuery("#{{uc_id}}");
        var itemSelector = ".ue-remote-scroll-item";
        var objItems = objScrollControlWidget.find(itemSelector);
        var classActive = "ue-active";
        var isUeChanged = false;

        /**
        * get active item
        */
        function getActiveItem(){

          var objActiveItem = objScrollControlWidget.find(itemSelector+"."+classActive);

          return(objActiveItem);

        }

        //on custom change event change items in connected widget
        objScrollControlWidget.on( "ue_change", function() {
          
          isUeChanged = true;

          //set timeout to avoid multiple change event call
          setTimeout(function(){

             var objActiveItem = getActiveItem();
             var currentIndex = objActiveItem.data("number") - 1;
             var numCurrent = objRemoteApi.doAction("get_num_current"); 

             //change the item
             if(currentIndex == numCurrent)
             return(false)

             objRemoteApi.doAction("change_item", currentIndex);

             isUeChanged = false;

          },200);         

        });

        //after connected widget change reset active class
        objRemoteApi.onEvent("change", function() {

          var numCurrent = objRemoteApi.doAction("get_num_current");         

          //reset class
          objItems.removeClass(classActive).eq(numCurrent).addClass(classActive);    

          var objActiveItem = getActiveItem();

          //scroll after change in connected widget
          if(isUeChanged == false)
          objRemoteScrollControl.scrollToConnectedItemScrollPosition(objActiveItem);

        });

      });	
  }

  //set timeout to give some time to init some widgets (bg slider for example)
  setTimeout(function(){
    initRemoteScrollWidget()      
  }, 300);	

    	
{{ ucfunc("put_docready_end") }}