<?php

namespace WPAdminify\Inc\Classes;

// no direct access allowed
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
/**
 * WPAdminify
 * Add Dashicons to Icon Picker
 *
 * @author Jewel Theme <support@jeweltheme.com>
 */

class Icons_Library {

	public function __construct() {
		add_filter( 'adminify_field_icon_add_icons', [ $this, 'add_dashicons' ] );
		add_action( 'admin_enqueue_scripts', [ $this, 'enqueue_custom_fonts_scripts' ], 100 );
	}

	/**
	 * Enqueue Custom Fonts
	 *
	 * @return void
	 */
	public function enqueue_custom_fonts_scripts() {
		wp_enqueue_style( 'wp-adminify-simple-line-icons' );
	}


	/**
	 * Add Dashicons to Icon Picker
	 *
	 * @return void
	 */
	public function add_dashicons( $icons ) {
		// Add Dashicons to Icon Picker Library

		$icons[] = [
			'title' => __( 'Dashicons', 'adminify' ),
			'icons' => [
				'dashicons dashicons-menu',
				'dashicons dashicons-admin-site',
				'dashicons dashicons-dashboard',
				'dashicons dashicons-admin-post',
				'dashicons dashicons-admin-media',
				'dashicons dashicons-admin-links',
				'dashicons dashicons-admin-page',
				'dashicons dashicons-admin-comments',
				'dashicons dashicons-admin-appearance',
				'dashicons dashicons-admin-plugins',
				'dashicons dashicons-admin-users',
				'dashicons dashicons-admin-tools',
				'dashicons dashicons-admin-settings',
				'dashicons dashicons-admin-network',
				'dashicons dashicons-admin-home',
				'dashicons dashicons-admin-generic',
				'dashicons dashicons-admin-collapse',
				'dashicons dashicons-filter',
				'dashicons dashicons-admin-customizer',
				'dashicons dashicons-admin-multisite',
				'dashicons dashicons-welcome-write-blog',
				'dashicons dashicons-welcome-add-page',
				'dashicons dashicons-welcome-view-site',
				'dashicons dashicons-welcome-widgets-menus',
				'dashicons dashicons-welcome-comments',
				'dashicons dashicons-welcome-learn-more',
				'dashicons dashicons-format-aside',
				'dashicons dashicons-format-image',
				'dashicons dashicons-format-gallery',
				'dashicons dashicons-format-video',
				'dashicons dashicons-format-status',
				'dashicons dashicons-format-quote',
				'dashicons dashicons-format-chat',
				'dashicons dashicons-format-audio',
				'dashicons dashicons-camera',
				'dashicons dashicons-images-alt',
				'dashicons dashicons-images-alt2',
				'dashicons dashicons-video-alt',
				'dashicons dashicons-video-alt2',
				'dashicons dashicons-video-alt3',
				'dashicons dashicons-media-archive',
				'dashicons dashicons-media-audio',
				'dashicons dashicons-media-code',
				'dashicons dashicons-media-default',
				'dashicons dashicons-media-document',
				'dashicons dashicons-media-interactive',
				'dashicons dashicons-media-spreadsheet',
				'dashicons dashicons-media-text',
				'dashicons dashicons-media-video',
				'dashicons dashicons-playlist-audio',
				'dashicons dashicons-playlist-video',
				'dashicons dashicons-controls-play',
				'dashicons dashicons-controls-pause',
				'dashicons dashicons-controls-forward',
				'dashicons dashicons-controls-skipforward',
				'dashicons dashicons-controls-back',
				'dashicons dashicons-controls-skipback',
				'dashicons dashicons-controls-repeat',
				'dashicons dashicons-controls-volumeon',
				'dashicons dashicons-controls-volumeoff',
				'dashicons dashicons-image-crop',
				'dashicons dashicons-image-rotate',
				'dashicons dashicons-image-rotate-left',
				'dashicons dashicons-image-rotate-right',
				'dashicons dashicons-image-flip-vertical',
				'dashicons dashicons-image-flip-horizontal',
				'dashicons dashicons-image-filter',
				'dashicons dashicons-undo',
				'dashicons dashicons-redo',
				'dashicons dashicons-editor-bold',
				'dashicons dashicons-editor-italic',
				'dashicons dashicons-editor-ul',
				'dashicons dashicons-editor-ol',
				'dashicons dashicons-editor-quote',
				'dashicons dashicons-editor-alignleft',
				'dashicons dashicons-editor-aligncenter',
				'dashicons dashicons-editor-alignright',
				'dashicons dashicons-editor-insertmore',
				'dashicons dashicons-editor-spellcheck',
				'dashicons dashicons-editor-expand',
				'dashicons dashicons-editor-contract',
				'dashicons dashicons-editor-kitchensink',
				'dashicons dashicons-editor-underline',
				'dashicons dashicons-editor-justify',
				'dashicons dashicons-editor-textcolor',
				'dashicons dashicons-editor-paste-word',
				'dashicons dashicons-editor-paste-text',
				'dashicons dashicons-editor-removeformatting',
				'dashicons dashicons-editor-video',
				'dashicons dashicons-editor-customchar',
				'dashicons dashicons-editor-outdent',
				'dashicons dashicons-editor-indent',
				'dashicons dashicons-editor-help',
				'dashicons dashicons-editor-strikethrough',
				'dashicons dashicons-editor-unlink',
				'dashicons dashicons-editor-rtl',
				'dashicons dashicons-editor-break',
				'dashicons dashicons-editor-code',
				'dashicons dashicons-editor-paragraph',
				'dashicons dashicons-editor-table',
				'dashicons dashicons-align-left',
				'dashicons dashicons-align-right',
				'dashicons dashicons-align-center',
				'dashicons dashicons-align-none',
				'dashicons dashicons-lock',
				'dashicons dashicons-unlock',
				'dashicons dashicons-calendar',
				'dashicons dashicons-calendar-alt',
				'dashicons dashicons-visibility',
				'dashicons dashicons-hidden',
				'dashicons dashicons-post-status',
				'dashicons dashicons-edit',
				'dashicons dashicons-trash',
				'dashicons dashicons-sticky',
				'dashicons dashicons-external',
				'dashicons dashicons-arrow-up',
				'dashicons dashicons-arrow-down',
				'dashicons dashicons-arrow-right',
				'dashicons dashicons-arrow-left',
				'dashicons dashicons-arrow-up-alt',
				'dashicons dashicons-arrow-down-alt',
				'dashicons dashicons-arrow-right-alt',
				'dashicons dashicons-arrow-left-alt',
				'dashicons dashicons-arrow-up-alt2',
				'dashicons dashicons-arrow-down-alt2',
				'dashicons dashicons-arrow-right-alt2',
				'dashicons dashicons-arrow-left-alt2',
				'dashicons dashicons-sort',
				'dashicons dashicons-leftright',
				'dashicons dashicons-randomize',
				'dashicons dashicons-list-view',
				'dashicons dashicons-exerpt-view',
				'dashicons dashicons-grid-view',
				'dashicons dashicons-move',
				'dashicons dashicons-share',
				'dashicons dashicons-share-alt',
				'dashicons dashicons-share-alt2',
				'dashicons dashicons-twitter',
				'dashicons dashicons-rss',
				'dashicons dashicons-email',
				'dashicons dashicons-email-alt',
				'dashicons dashicons-facebook',
				'dashicons dashicons-facebook-alt',
				'dashicons dashicons-googleplus',
				'dashicons dashicons-networking',
				'dashicons dashicons-hammer',
				'dashicons dashicons-art',
				'dashicons dashicons-migrate',
				'dashicons dashicons-performance',
				'dashicons dashicons-universal-access',
				'dashicons dashicons-universal-access-alt',
				'dashicons dashicons-tickets',
				'dashicons dashicons-nametag',
				'dashicons dashicons-clipboard',
				'dashicons dashicons-heart',
				'dashicons dashicons-megaphone',
				'dashicons dashicons-schedule',
				'dashicons dashicons-wordpress',
				'dashicons dashicons-wordpress-alt',
				'dashicons dashicons-pressthis',
				'dashicons dashicons-update',
				'dashicons dashicons-screenoptions',
				'dashicons dashicons-info',
				'dashicons dashicons-cart',
				'dashicons dashicons-feedback',
				'dashicons dashicons-cloud',
				'dashicons dashicons-translation',
				'dashicons dashicons-tag',
				'dashicons dashicons-category',
				'dashicons dashicons-archive',
				'dashicons dashicons-tagcloud',
				'dashicons dashicons-text',
				'dashicons dashicons-yes',
				'dashicons dashicons-no',
				'dashicons dashicons-no-alt',
				'dashicons dashicons-plus',
				'dashicons dashicons-plus-alt',
				'dashicons dashicons-minus',
				'dashicons dashicons-dismiss',
				'dashicons dashicons-marker',
				'dashicons dashicons-star-filled',
				'dashicons dashicons-star-half',
				'dashicons dashicons-star-empty',
				'dashicons dashicons-flag',
				'dashicons dashicons-warning',
				'dashicons dashicons-location',
				'dashicons dashicons-location-alt',
				'dashicons dashicons-vault',
				'dashicons dashicons-shield',
				'dashicons dashicons-shield-alt',
				'dashicons dashicons-sos',
				'dashicons dashicons-search',
				'dashicons dashicons-slides',
				'dashicons dashicons-analytics',
				'dashicons dashicons-chart-pie',
				'dashicons dashicons-chart-bar',
				'dashicons dashicons-chart-line',
				'dashicons dashicons-chart-area',
				'dashicons dashicons-groups',
				'dashicons dashicons-businessman',
				'dashicons dashicons-id',
				'dashicons dashicons-id-alt',
				'dashicons dashicons-products',
				'dashicons dashicons-awards',
				'dashicons dashicons-forms',
				'dashicons dashicons-testimonial',
				'dashicons dashicons-portfolio',
				'dashicons dashicons-book',
				'dashicons dashicons-book-alt',
				'dashicons dashicons-download',
				'dashicons dashicons-upload',
				'dashicons dashicons-backup',
				'dashicons dashicons-clock',
				'dashicons dashicons-lightbulb',
				'dashicons dashicons-microphone',
				'dashicons dashicons-desktop',
				'dashicons dashicons-laptop',
				'dashicons dashicons-tablet',
				'dashicons dashicons-smartphone',
				'dashicons dashicons-phone',
				'dashicons dashicons-index-card',
				'dashicons dashicons-carrot',
				'dashicons dashicons-building',
				'dashicons dashicons-store',
				'dashicons dashicons-album',
				'dashicons dashicons-palmtree',
				'dashicons dashicons-tickets-alt',
				'dashicons dashicons-money',
				'dashicons dashicons-smiley',
				'dashicons dashicons-thumbs-up',
				'dashicons dashicons-thumbs-down',
				'dashicons dashicons-layout',
				'dashicons dashicons-paperclip',
			],
		];

		$icons[] = [
			'title' => __( 'Simple Line Icons', 'adminify' ),
			'icons' => [
				'icon-user',
				'icon-people',
				'icon-user-female',
				'icon-user-follow',
				'icon-user-following',
				'icon-user-unfollow',
				'icon-login',
				'icon-logout',
				'icon-emotsmile',
				'icon-phone',
				'icon-call-end',
				'icon-call-in',
				'icon-call-out',
				'icon-map',
				'icon-location-pin',
				'icon-direction',
				'icon-directions',
				'icon-compass',
				'icon-layers',
				'icon-menu',
				'icon-list',
				'icon-options-vertical',
				'icon-options',
				'icon-arrow-down',
				'icon-arrow-left',
				'icon-arrow-right',
				'icon-arrow-up',
				'icon-arrow-up-circle',
				'icon-arrow-left-circle',
				'icon-arrow-right-circle',
				'icon-arrow-down-circle',
				'icon-check',
				'icon-clock',
				'icon-plus',
				'icon-minus',
				'icon-close',
				'icon-event',
				'icon-exclamation',
				'icon-organization',
				'icon-trophy',
				'icon-screen-smartphone',
				'icon-screen-desktop',
				'icon-plane',
				'icon-notebook',
				'icon-mustache',
				'icon-mouse',
				'icon-magnet',
				'icon-energy',
				'icon-disc',
				'icon-cursor',
				'icon-cursor-move',
				'icon-crop',
				'icon-chemistry',
				'icon-speedometer',
				'icon-shield',
				'icon-screen-tablet',
				'icon-magic-wand',
				'icon-hourglass',
				'icon-graduation',
				'icon-ghost',
				'icon-game-controller',
				'icon-fire',
				'icon-eyeglass',
				'icon-envelope-open',
				'icon-envelope-letter',
				'icon-bell',
				'icon-badge',
				'icon-anchor',
				'icon-wallet',
				'icon-vector',
				'icon-speech',
				'icon-puzzle',
				'icon-printer',
				'icon-present',
				'icon-playlist',
				'icon-pin',
				'icon-picture',
				'icon-handbag',
				'icon-globe-alt',
				'icon-globe',
				'icon-folder-alt',
				'icon-folder',
				'icon-film',
				'icon-feed',
				'icon-drop',
				'icon-drawer',
				'icon-docs',
				'icon-doc',
				'icon-diamond',
				'icon-cup',
				'icon-calculator',
				'icon-bubbles',
				'icon-briefcase',
				'icon-book-open',
				'icon-basket-loaded',
				'icon-basket',
				'icon-bag',
				'icon-action-undo',
				'icon-action-redo',
				'icon-wrench',
				'icon-umbrella',
				'icon-trash',
				'icon-tag',
				'icon-support',
				'icon-frame',
				'icon-size-fullscreen',
				'icon-size-actual',
				'icon-shuffle',
				'icon-share-alt',
				'icon-share',
				'icon-rocket',
				'icon-question',
				'icon-pie-chart',
				'icon-pencil',
				'icon-note',
				'icon-loop',
				'icon-home',
				'icon-grid',
				'icon-graph',
				'icon-microphone',
				'icon-music-tone-alt',
				'icon-music-tone',
				'icon-earphones-alt',
				'icon-earphones',
				'icon-equalizer',
				'icon-like',
				'icon-dislike',
				'icon-control-start',
				'icon-control-rewind',
				'icon-control-play',
				'icon-control-pause',
				'icon-control-forward',
				'icon-control-end',
				'icon-volume-1',
				'icon-volume-2',
				'icon-volume-off',
				'icon-calendar',
				'icon-bulb',
				'icon-chart',
				'icon-ban',
				'icon-bubble',
				'icon-camrecorder',
				'icon-camera',
				'icon-cloud-download',
				'icon-cloud-upload',
				'icon-envelope',
				'icon-eye',
				'icon-flag',
				'icon-heart',
				'icon-info',
				'icon-key',
				'icon-link',
				'icon-lock',
				'icon-lock-open',
				'icon-magnifier',
				'icon-magnifier-add',
				'icon-magnifier-remove',
				'icon-paper-clip',
				'icon-paper-plane',
				'icon-power',
				'icon-refresh',
				'icon-reload',
				'icon-settings',
				'icon-star',
				'icon-symbol-female',
				'icon-symbol-male',
				'icon-target',
				'icon-credit-card',
				'icon-paypal',
				'icon-social-tumblr',
				'icon-social-twitter',
				'icon-social-facebook',
				'icon-social-instagram',
				'icon-social-linkedin',
				'icon-social-pinterest',
				'icon-social-github',
				'icon-social-google',
				'icon-social-reddit',
				'icon-social-skype',
				'icon-social-dribbble',
				'icon-social-behance',
				'icon-social-foursqare',
				'icon-social-soundcloud',
				'icon-social-spotify',
				'icon-social-stumbleupon',
				'icon-social-youtube',
				'icon-social-dropbox',
				'icon-social-vkontakte',
				'icon-social-steam',
			],
		];

		// Move custom icons to top of the list.
		$icons = array_reverse( $icons );

		return $icons;
	}
}
