/*!
 * Tokenize2 v1.3.6 (https://github.com/dragonofmercy/Tokenize2)
 * Copyright 2016-2017 DragonOfMercy.
 * Licensed under the new BSD license
 */
(function(a){if(typeof define==="function"&&define.amd){define(["jquery"],a)}else{if(typeof module==="object"&&module.exports){module.exports=function(b,c){if(c===undefined){if(typeof window!=="undefined"){c=require("jquery")}else{c=require("jquery")(b)}}a(c);return c}}else{a(jQuery)}}}(function(e){var c=function(g,f){this.control=false;this.element=e(g);this.options=e.extend({},c.DEFAULTS,f);this.options.tabIndex=this.options.tabIndex===-1?0:this.options.tabIndex;this.options.sortable=this.options.tokensMaxItems===1?false:this.options.sortable;this.bind();this.trigger("tokenize:load")};var a={BACKSPACE:8,TAB:9,ENTER:13,ESCAPE:27,ARROW_UP:38,ARROW_DOWN:40,CTRL:17,MAJ:16,A:65};c.VERSION="1.3.6";c.DEBOUNCE=null;c.DEFAULTS={tokensMaxItems:0,tokensAllowCustom:false,dropdownMaxItems:10,dropdownSelectFirstItem:true,searchMinLength:0,searchMaxLength:0,searchFromStart:true,searchHighlight:true,displayNoResultsMessage:false,noResultsMessageText:'No results mached "%s"',delimiter:",",dataSource:"select",debounce:0,placeholder:false,sortable:false,allowEmptyValues:false,zIndexMargin:500,tabIndex:0};c.prototype.trigger=function(h,i,g,f){this.element.trigger(h,i,g,f)};c.prototype.bind=function(){this.element.on("tokenize:load",{},e.proxy(function(){this.init()},this)).on("tokenize:clear",{},e.proxy(function(){this.clear()},this)).on("tokenize:remap",{},e.proxy(function(){this.remap()},this)).on("tokenize:select",{},e.proxy(function(f,g){this.focus(g)},this)).on("tokenize:deselect",{},e.proxy(function(){this.blur()},this)).on("tokenize:search",{},e.proxy(function(g,f){this.find(f)},this)).on("tokenize:paste",{},e.proxy(function(){this.paste()},this)).on("tokenize:dropdown:up",{},e.proxy(function(){this.dropdownSelectionMove(-1)},this)).on("tokenize:dropdown:down",{},e.proxy(function(){this.dropdownSelectionMove(1)},this)).on("tokenize:dropdown:clear",{},e.proxy(function(){this.dropdownClear()},this)).on("tokenize:dropdown:show",{},e.proxy(function(){this.dropdownShow()},this)).on("tokenize:dropdown:hide",{},e.proxy(function(){this.dropdownHide()},this)).on("tokenize:dropdown:fill",{},e.proxy(function(g,f){this.dropdownFill(f)},this)).on("tokenize:dropdown:itemAdd",{},e.proxy(function(g,f){this.dropdownAddItem(f)},this)).on("tokenize:keypress",{},e.proxy(function(g,f){this.keypress(f)},this)).on("tokenize:keydown",{},e.proxy(function(g,f){this.keydown(f)},this)).on("tokenize:keyup",{},e.proxy(function(g,f){this.keyup(f)},this)).on("tokenize:tokens:reorder",{},e.proxy(function(){this.reorder()},this)).on("tokenize:tokens:add",{},e.proxy(function(h,f,g,i){this.tokenAdd(f,g,i)},this)).on("tokenize:tokens:remove",{},e.proxy(function(g,f){this.tokenRemove(f)},this))};c.prototype.init=function(){this.id=this.guid();this.element.hide();if(!this.element.attr("multiple")){console.error("Attribute multiple is missing, tokenize2 can be buggy !")}this.dropdown=undefined;this.searchContainer=e('<li class="token-search" />');this.input=e('<input autocomplete="off" />').on("keydown",{},e.proxy(function(f){this.trigger("tokenize:keydown",[f])},this)).on("keypress",{},e.proxy(function(f){this.trigger("tokenize:keypress",[f])},this)).on("keyup",{},e.proxy(function(f){this.trigger("tokenize:keyup",[f])},this)).on("focus",{},e.proxy(function(){if(this.input.val().length>=this.options.searchMinLength&&this.input.val().length>0){this.trigger("tokenize:search",[this.input.val()])}},this)).on("paste",{},e.proxy(function(){if(this.options.tokensAllowCustom){setTimeout(e.proxy(function(){this.trigger("tokenize:paste")},this),10)}},this));if(this.options.searchMaxLength>0){this.input.attr("maxlength",this.options.searchMaxLength)}this.tokensContainer=e('<ul class="tokens-container form-control" />').addClass(this.element.attr("data-class")).attr("tabindex",this.options.tabIndex).append(this.searchContainer.append(this.input));if(this.options.placeholder!==false){this.placeholder=e('<li class="placeholder" />').html(this.options.placeholder);this.tokensContainer.prepend(this.placeholder);this.element.on("tokenize:tokens:add tokenize:remap tokenize:select tokenize:deselect tokenize:tokens:remove",e.proxy(function(){if(this.container.hasClass("focus")||e("li.token",this.tokensContainer).length>0||this.input.val().length>0){this.placeholder.hide()}else{this.placeholder.show()}},this))}this.container=e('<div class="tokenize" />').attr("id",this.id);this.container.append(this.tokensContainer).insertAfter(this.element);this.container.focusin(e.proxy(function(f){this.trigger("tokenize:select",[(e(f.target)[0]===this.tokensContainer[0])])},this)).focusout(e.proxy(function(){if(this.container.hasClass("focus")){this.trigger("tokenize:deselect")}},this));if(this.options.tokensMaxItems===1){this.container.addClass("single")}if(this.options.sortable){this.container.addClass("sortable");this.tokensContainer.tokenize2sortable({itemSelector:"li.token",cursor:"move",placeholder:'<li class="token shadow"><br /></li>',placeholderClass:"token shadow",onDragStart:e.proxy(function(g,f,h){this.searchContainer.hide();h(g,f)},this),onDrop:e.proxy(function(g,f,h){this.searchContainer.show();this.trigger("tokenize:tokens:reorder");h(g,f)},this)})}this.element.on("tokenize:tokens:add tokenize:tokens:remove",e.proxy(function(){if(this.options.tokensMaxItems>0&&e("li.token",this.tokensContainer).length>=this.options.tokensMaxItems){this.searchContainer.hide()}else{this.searchContainer.show()}},this)).on("tokenize:keydown tokenize:keyup tokenize:loaded",e.proxy(function(){this.scaleInput()},this));this.trigger("tokenize:remap");this.trigger("tokenize:tokens:reorder");this.trigger("tokenize:loaded");if(this.element.is(":disabled")){this.disable()}};c.prototype.reorder=function(){if(this.options.sortable){var f,h,g=this.tokensContainer.tokenize2sortable("serialize").get(0);e.each(g,e.proxy(function(j,i){h=e('option[value="'+i.value+'"]',this.element);if(f===undefined){h.prependTo(this.element)}else{f.after(h)}f=h},this))}};c.prototype.paste=function(){var f=new RegExp(this.escapeRegex(Array.isArray(this.options.delimiter)?this.options.delimiter.join("|"):this.options.delimiter),"ig");if(f.test(this.input.val())){e.each(this.input.val().split(f),e.proxy(function(g,h){this.trigger("tokenize:tokens:add",[h,null,true])},this))}};c.prototype.tokenAdd=function(g,h,f){g=this.escape(g);h=h===undefined?g:this.escape(h);f=f||false;this.resetInput();if(g===undefined||(!this.options.allowEmptyValues&&g==="")){this.trigger("tokenize:tokens:error:empty");return this}if(this.options.tokensMaxItems>0&&e("li.token",this.tokensContainer).length>=this.options.tokensMaxItems){this.trigger("tokenize:tokens:error:max");return this}if(e('li.token[data-value="'+g+'"]',this.tokensContainer).length>0){this.trigger("tokenize:tokens:error:duplicate",[g,h]);return this}if(e('option[value="'+g+'"]',this.element).length){e('option[value="'+g+'"]',this.element).attr("selected","selected").prop("selected",true)}else{if(f){this.element.append(e("<option selected />").val(g).html(h))}else{if(this.options.tokensAllowCustom){this.element.append(e('<option selected data-type="custom" />').val(g).html(h))}else{this.trigger("tokenize:tokens:error:notokensAllowCustom");return this}}}e('<li class="token" />').attr("data-value",g).append("<span>"+h+"</span>").prepend(e('<a class="dismiss" />').on("mousedown touchstart",{},e.proxy(function(i){i.preventDefault();if(i.which==1){this.trigger("tokenize:tokens:remove",[g])}},this))).insertBefore(this.searchContainer);this.trigger("tokenize:dropdown:hide");this.trigger("tokenize:tokens:added",[g,h]);return this};c.prototype.tokenRemove=function(g){var f=e('option[value="'+g+'"]',this.element);if(f.attr("data-type")==="custom"){f.remove()}else{f.removeAttr("selected").prop("selected",false)}e('li.token[data-value="'+g+'"]',this.tokensContainer).remove();this.trigger("tokenize:tokens:reorder");this.input.focus();return this};c.prototype.remap=function(){var f=e("option:selected",this.element);f.each(e.proxy(function(g,h){this.trigger("tokenize:tokens:add",[e(h).val(),e(h).html(),false])},this));return this};c.prototype.disable=function(){this.tokensContainer.addClass("disabled");this.searchContainer.hide();return this};c.prototype.enable=function(){this.tokensContainer.removeClass("disabled");this.searchContainer.show();return this};c.prototype.focus=function(f){if(this.element.is(":disabled")){this.tokensContainer.blur();return}if(f){this.input.focus()}if(!this.container.hasClass("focus")){this.container.addClass("focus");this.trigger("tokenize:focus")}};c.prototype.blur=function(){if(this.isDropdownOpen()){this.trigger("tokenize:dropdown:hide")}this.container.removeClass("focus");this.resetPending();if(!this.tokensContainer.attr("tabindex")){this.tokensContainer.attr("tabindex",this.options.tabIndex)}};c.prototype.keydown=function(g){if(g.type==="keydown"){switch(g.keyCode){case a.BACKSPACE:if(this.input.val().length<1){g.preventDefault();if(e("li.token.pending-delete",this.tokensContainer).length>0){e("li.token.pending-delete",this.tokensContainer).each(e.proxy(function(h,i){this.trigger("tokenize:tokens:remove",e(i).attr("data-value"))},this))}else{var f=e("li.token:last",this.tokensContainer);if(f.length>0){this.trigger("tokenize:tokens:markForDelete",[f.attr("data-value")]);f.addClass("pending-delete")}}this.trigger("tokenize:dropdown:hide")}break;case a.TAB:if(!g.shiftKey){this.pressedDelimiter(g)}else{this.tokensContainer.removeAttr("tabindex")}break;case a.ENTER:this.pressedDelimiter(g);break;case a.ESCAPE:this.resetPending();break;case a.ARROW_UP:g.preventDefault();this.trigger("tokenize:dropdown:up");break;case a.ARROW_DOWN:g.preventDefault();this.trigger("tokenize:dropdown:down");break;case a.CTRL:this.control=true;break;default:if(g.keyCode===a.A&&this.control&&this.input.val().length<1){g.preventDefault();e("li.token",this.tokensContainer).each(e.proxy(function(h,i){this.trigger("tokenize:tokens:markForDelete",[e(i).attr("data-value")]);e(i).addClass("pending-delete")},this))}else{this.resetPending()}break}}else{g.preventDefault()}};c.prototype.keyup=function(f){if(f.type==="keyup"){switch(f.keyCode){case a.TAB:case a.ENTER:case a.ESCAPE:case a.ARROW_UP:case a.ARROW_DOWN:case a.MAJ:break;case a.CTRL:this.control=false;break;case a.BACKSPACE:default:if(this.input.val().length>=this.options.searchMinLength&&this.input.val().length>0){this.trigger("tokenize:search",[this.input.val()])}else{this.trigger("tokenize:dropdown:hide")}break}}else{f.preventDefault()}};c.prototype.keypress=function(f){if(f.type==="keypress"&&!this.element.is(":disabled")){var g=false;if(Array.isArray(this.options.delimiter)){if(this.options.delimiter.indexOf(String.fromCharCode(f.which))>=0){g=true}}else{if(String.fromCharCode(f.which)===this.options.delimiter){g=true}}if(g){this.pressedDelimiter(f)}}else{f.preventDefault()}};c.prototype.pressedDelimiter=function(f){this.resetPending();if(this.isDropdownOpen()&&e("li.active",this.dropdown).length>0&&this.control===false){f.preventDefault();e("li.active a",this.dropdown).trigger("mousedown")}else{if(this.input.val().length>0){f.preventDefault();this.trigger("tokenize:tokens:add",[this.input.val()])}}};c.prototype.find=function(f){if(f.length<this.options.searchMinLength){this.trigger("tokenize:dropdown:hide");return false}this.lastSearchTerms=f;if(this.options.dataSource==="select"){this.dataSourceLocal(f)}else{if(typeof this.options.dataSource==="function"){this.options.dataSource(f,this)}else{this.dataSourceRemote(f)}}};c.prototype.dataSourceRemote=function(f){this.debounce(e.proxy(function(){if(this.xhr!==undefined){this.xhr.abort()}this.xhr=e.ajax(this.options.dataSource,{data:{search:f},dataType:"text",success:e.proxy(function(g){var h=[];if(g!=""){g=JSON.parse(g);e.each(g,function(j,i){h.push(i)})}this.trigger("tokenize:dropdown:fill",[h])},this)})},this),this.options.debounce)};c.prototype.dataSourceLocal=function(h){var f=this.transliteration(h);var k=[];var g=(this.options.searchFromStart?"^":"")+this.escapeRegex(f);var j=new RegExp(g,"i");var i=this;e("option",this.element).not(":selected, :disabled").each(function(){var m=i.trim(e(this).html());var l=i.trim(e(this).attr("value"));if(j.test(i.transliteration(m))){k.push({value:l,text:m})}});this.trigger("tokenize:dropdown:fill",[k])};c.prototype.debounce=function(h,g){var i=arguments;var f=e.proxy(function(){h.apply(this,i);this.debounceTimeout=undefined},this);if(this.debounceTimeout!==undefined){clearTimeout(this.debounceTimeout)}this.debounceTimeout=setTimeout(f,g||0)};c.prototype.dropdownShow=function(){if(!this.isDropdownOpen()){e(".tokenize-dropdown").remove();this.dropdown=e('<div class="tokenize-dropdown dropdown"><ul class="dropdown-menu" /></div>').attr("data-related",this.id);e("body").append(this.dropdown);this.dropdown.show();this.dropdown.css("z-index",this.calculatezindex()+this.options.zIndexMargin);e(window).on("resize scroll",{},e.proxy(function(){this.dropdownMove()},this)).trigger("resize");this.trigger("tokenize:dropdown:shown")}};c.prototype.calculatezindex=function(){var g=this.container;var f=0;if(!isNaN(parseInt(g.css("z-index")))&&parseInt(g.css("z-index"))>0){f=parseInt(g.css("z-index"))}if(f<1){while(g.length){g=g.parent();if(g.length>0){if(!isNaN(parseInt(g.css("z-index")))&&parseInt(g.css("z-index"))>0){return parseInt(g.css("z-index"))}if(g.is("html")){break}}}}return f};c.prototype.dropdownHide=function(){if(this.isDropdownOpen()){e(window).off("resize scroll");this.dropdown.remove();this.dropdown=undefined;this.trigger("tokenize:dropdown:hidden")}};c.prototype.dropdownClear=function(){if(this.dropdown){this.dropdown.find(".dropdown-menu li").remove()}};c.prototype.dropdownFill=function(f){if(f&&f.length>0){this.trigger("tokenize:dropdown:show");this.trigger("tokenize:dropdown:clear");e.each(f,e.proxy(function(h,g){if(e("li.dropdown-item",this.dropdown).length<=this.options.dropdownMaxItems){this.trigger("tokenize:dropdown:itemAdd",[g])}},this));if(e("li.active",this.dropdown).length<1&&this.options.dropdownSelectFirstItem){e("li:first",this.dropdown).addClass("active")}if(e("li.dropdown-item",this.dropdown).length<1){this.trigger("tokenize:dropdown:hide")}else{this.trigger("tokenize:dropdown:filled")}}else{if(this.options.displayNoResultsMessage){this.trigger("tokenize:dropdown:show");this.trigger("tokenize:dropdown:clear");this.dropdown.find(".dropdown-menu").append(e('<li class="dropdown-item locked" />').html(this.options.noResultsMessageText.replace("%s",this.input.val())))}else{this.trigger("tokenize:dropdown:hide")}}e(window).trigger("resize")};c.prototype.dropdownSelectionMove=function(g){if(e("li.active",this.dropdown).length>0){if(!e("li.active",this.dropdown).is("li:"+(g>0?"last-child":"first-child"))){var f=e("li.active",this.dropdown);f.removeClass("active");if(g>0){f.next().addClass("active")}else{f.prev().addClass("active")}}else{e("li.active",this.dropdown).removeClass("active");if(this.options.dropdownSelectFirstItem){e("li:"+(g>0?"first-child":"last-child"),this.dropdown).addClass("active")}}}else{e("li:first",this.dropdown).addClass("active")}};c.prototype.dropdownAddItem=function(f){if(this.isDropdownOpen()){if(f.hasOwnProperty("text")){f.text=this.escape(f.text)}f.value=this.escape(f.value);var g=e('<li class="dropdown-item" />').html(this.dropdownItemFormat(f)).on("mouseover",e.proxy(function(h){h.preventDefault();h.target=this.fixTarget(h.target);e("li",this.dropdown).removeClass("active");e(h.target).parent().addClass("active")},this)).on("mouseout",e.proxy(function(){e("li",this.dropdown).removeClass("active")},this)).on("mousedown touchstart",e.proxy(function(h){h.preventDefault();h.target=this.fixTarget(h.target);this.trigger("tokenize:tokens:add",[e(h.target).attr("data-value"),e(h.target).attr("data-text"),true])},this));if(e('li.token[data-value="'+g.find("a").attr("data-value")+'"]',this.tokensContainer).length<1){this.dropdown.find(".dropdown-menu").append(g);this.trigger("tokenize:dropdown:itemAdded",[f])}}};c.prototype.fixTarget=function(i){var f=e(i);if(!f.data("value")){var g=f.find("a");if(g.length){return g.get(0)}var h=f.parents("[data-value]");if(h.length){return h.get(0)}}return f.get(0)};c.prototype.dropdownItemFormat=function(h){if(h.hasOwnProperty("text")){var g="";if(this.options.searchHighlight){var f=new RegExp((this.options.searchFromStart?"^":"")+"("+this.escapeRegex(this.transliteration(this.lastSearchTerms))+")","gi");g=h.text.replace(f,'<span class="tokenize-highlight">$1</span>')}else{g=h.text}return e("<a />").html(g).attr({"data-value":h.value,"data-text":h.text})}};c.prototype.dropdownMove=function(){var h=this.tokensContainer.offset();var g=this.tokensContainer.outerHeight();var f=this.tokensContainer.outerWidth();h.top+=g;this.dropdown.css({width:f}).offset(h)};c.prototype.isDropdownOpen=function(){return(this.dropdown!==undefined)};c.prototype.clear=function(){e.each(e("li.token",this.tokensContainer),e.proxy(function(g,f){this.trigger("tokenize:tokens:remove",[e(f).attr("data-value")])},this));this.trigger("tokenize:dropdown:hide");return this};c.prototype.resetPending=function(){var f=e("li.pending-delete",this.tokensContainer);if(f.length>0){this.trigger("tokenize:tokens:cancelDelete",[f.attr("data-value")]);f.removeClass("pending-delete")}};c.prototype.scaleInput=function(){if(!this.ctx){this.ctx=document.createElement("canvas").getContext("2d")}var f,g;this.ctx.font=this.input.css("font-style")+" "+this.input.css("font-variant")+" "+this.input.css("font-weight")+" "+Math.ceil(parseFloat(this.input.css("font-size")))+"px "+this.input.css("font-family");f=Math.round(this.ctx.measureText(this.input.val()+"M").width)+Math.ceil(parseFloat(this.searchContainer.css("margin-left")))+Math.ceil(parseFloat(this.searchContainer.css("margin-right")));g=this.tokensContainer.width()-(Math.ceil(parseFloat(this.tokensContainer.css("border-left-width")))+Math.ceil(parseFloat(this.tokensContainer.css("border-right-width"))+Math.ceil(parseFloat(this.tokensContainer.css("padding-left")))+Math.ceil(parseFloat(this.tokensContainer.css("padding-right")))));if(f>=g){f=g}this.searchContainer.width(f);this.ctx.restore()};c.prototype.resetInput=function(){this.input.val("");this.scaleInput()};c.prototype.trim=function(f){return f.trim()};c.prototype.escape=function(f){f=String(f);if(f){f=this.replaceAll(f,/["]/,"&quot;");f=this.replaceAll(f,/[<]/,"&lt;");f=this.replaceAll(f,/[>]/,"&gt;")}return f};c.prototype.replaceAll=function(h,f,g){return h.replace(new RegExp(f,"g"),g)};c.prototype.escapeRegex=function(f){return f.replace(/[\-\[\]{}()*+?.,\\\^$|#\s]/g,"\\$&")};c.prototype.guid=function(){function f(){return Math.floor((1+Math.random())*65536).toString(16).substring(1)}return f()+f()+"-"+f()+"-"+f()+"-"+f()+"-"+f()+f()+f()};c.prototype.toArray=function(){var f=[];e("option:selected",this.element).each(function(){f.push(e(this).val())});return f};c.prototype.transliteration=function(h){var g={"\u24B6":"A","\uFF21":"A","\u00C0":"A","\u00C1":"A","\u00C2":"A","\u1EA6":"A","\u1EA4":"A","\u1EAA":"A","\u1EA8":"A","\u00C3":"A","\u0100":"A","\u0102":"A","\u1EB0":"A","\u1EAE":"A","\u1EB4":"A","\u1EB2":"A","\u0226":"A","\u01E0":"A","\u00C4":"A","\u01DE":"A","\u1EA2":"A","\u00C5":"A","\u01FA":"A","\u01CD":"A","\u0200":"A","\u0202":"A","\u1EA0":"A","\u1EAC":"A","\u1EB6":"A","\u1E00":"A","\u0104":"A","\u023A":"A","\u2C6F":"A","\uA732":"AA","\u00C6":"AE","\u01FC":"AE","\u01E2":"AE","\uA734":"AO","\uA736":"AU","\uA738":"AV","\uA73A":"AV","\uA73C":"AY","\u24B7":"B","\uFF22":"B","\u1E02":"B","\u1E04":"B","\u1E06":"B","\u0243":"B","\u0182":"B","\u0181":"B","\u24B8":"C","\uFF23":"C","\u0106":"C","\u0108":"C","\u010A":"C","\u010C":"C","\u00C7":"C","\u1E08":"C","\u0187":"C","\u023B":"C","\uA73E":"C","\u24B9":"D","\uFF24":"D","\u1E0A":"D","\u010E":"D","\u1E0C":"D","\u1E10":"D","\u1E12":"D","\u1E0E":"D","\u0110":"D","\u018B":"D","\u018A":"D","\u0189":"D","\uA779":"D","\u01F1":"DZ","\u01C4":"DZ","\u01F2":"Dz","\u01C5":"Dz","\u24BA":"E","\uFF25":"E","\u00C8":"E","\u00C9":"E","\u00CA":"E","\u1EC0":"E","\u1EBE":"E","\u1EC4":"E","\u1EC2":"E","\u1EBC":"E","\u0112":"E","\u1E14":"E","\u1E16":"E","\u0114":"E","\u0116":"E","\u00CB":"E","\u1EBA":"E","\u011A":"E","\u0204":"E","\u0206":"E","\u1EB8":"E","\u1EC6":"E","\u0228":"E","\u1E1C":"E","\u0118":"E","\u1E18":"E","\u1E1A":"E","\u0190":"E","\u018E":"E","\u24BB":"F","\uFF26":"F","\u1E1E":"F","\u0191":"F","\uA77B":"F","\u24BC":"G","\uFF27":"G","\u01F4":"G","\u011C":"G","\u1E20":"G","\u011E":"G","\u0120":"G","\u01E6":"G","\u0122":"G","\u01E4":"G","\u0193":"G","\uA7A0":"G","\uA77D":"G","\uA77E":"G","\u24BD":"H","\uFF28":"H","\u0124":"H","\u1E22":"H","\u1E26":"H","\u021E":"H","\u1E24":"H","\u1E28":"H","\u1E2A":"H","\u0126":"H","\u2C67":"H","\u2C75":"H","\uA78D":"H","\u24BE":"I","\uFF29":"I","\u00CC":"I","\u00CD":"I","\u00CE":"I","\u0128":"I","\u012A":"I","\u012C":"I","\u0130":"I","\u00CF":"I","\u1E2E":"I","\u1EC8":"I","\u01CF":"I","\u0208":"I","\u020A":"I","\u1ECA":"I","\u012E":"I","\u1E2C":"I","\u0197":"I","\u24BF":"J","\uFF2A":"J","\u0134":"J","\u0248":"J","\u24C0":"K","\uFF2B":"K","\u1E30":"K","\u01E8":"K","\u1E32":"K","\u0136":"K","\u1E34":"K","\u0198":"K","\u2C69":"K","\uA740":"K","\uA742":"K","\uA744":"K","\uA7A2":"K","\u24C1":"L","\uFF2C":"L","\u013F":"L","\u0139":"L","\u013D":"L","\u1E36":"L","\u1E38":"L","\u013B":"L","\u1E3C":"L","\u1E3A":"L","\u0141":"L","\u023D":"L","\u2C62":"L","\u2C60":"L","\uA748":"L","\uA746":"L","\uA780":"L","\u01C7":"LJ","\u01C8":"Lj","\u24C2":"M","\uFF2D":"M","\u1E3E":"M","\u1E40":"M","\u1E42":"M","\u2C6E":"M","\u019C":"M","\u24C3":"N","\uFF2E":"N","\u01F8":"N","\u0143":"N","\u00D1":"N","\u1E44":"N","\u0147":"N","\u1E46":"N","\u0145":"N","\u1E4A":"N","\u1E48":"N","\u0220":"N","\u019D":"N","\uA790":"N","\uA7A4":"N","\u01CA":"NJ","\u01CB":"Nj","\u24C4":"O","\uFF2F":"O","\u00D2":"O","\u00D3":"O","\u00D4":"O","\u1ED2":"O","\u1ED0":"O","\u1ED6":"O","\u1ED4":"O","\u00D5":"O","\u1E4C":"O","\u022C":"O","\u1E4E":"O","\u014C":"O","\u1E50":"O","\u1E52":"O","\u014E":"O","\u022E":"O","\u0230":"O","\u00D6":"O","\u022A":"O","\u1ECE":"O","\u0150":"O","\u01D1":"O","\u020C":"O","\u020E":"O","\u01A0":"O","\u1EDC":"O","\u1EDA":"O","\u1EE0":"O","\u1EDE":"O","\u1EE2":"O","\u1ECC":"O","\u1ED8":"O","\u01EA":"O","\u01EC":"O","\u00D8":"O","\u01FE":"O","\u0186":"O","\u019F":"O","\uA74A":"O","\uA74C":"O","\u01A2":"OI","\uA74E":"OO","\u0222":"OU","\u24C5":"P","\uFF30":"P","\u1E54":"P","\u1E56":"P","\u01A4":"P","\u2C63":"P","\uA750":"P","\uA752":"P","\uA754":"P","\u24C6":"Q","\uFF31":"Q","\uA756":"Q","\uA758":"Q","\u024A":"Q","\u24C7":"R","\uFF32":"R","\u0154":"R","\u1E58":"R","\u0158":"R","\u0210":"R","\u0212":"R","\u1E5A":"R","\u1E5C":"R","\u0156":"R","\u1E5E":"R","\u024C":"R","\u2C64":"R","\uA75A":"R","\uA7A6":"R","\uA782":"R","\u24C8":"S","\uFF33":"S","\u1E9E":"S","\u015A":"S","\u1E64":"S","\u015C":"S","\u1E60":"S","\u0160":"S","\u1E66":"S","\u1E62":"S","\u1E68":"S","\u0218":"S","\u015E":"S","\u2C7E":"S","\uA7A8":"S","\uA784":"S","\u24C9":"T","\uFF34":"T","\u1E6A":"T","\u0164":"T","\u1E6C":"T","\u021A":"T","\u0162":"T","\u1E70":"T","\u1E6E":"T","\u0166":"T","\u01AC":"T","\u01AE":"T","\u023E":"T","\uA786":"T","\uA728":"TZ","\u24CA":"U","\uFF35":"U","\u00D9":"U","\u00DA":"U","\u00DB":"U","\u0168":"U","\u1E78":"U","\u016A":"U","\u1E7A":"U","\u016C":"U","\u00DC":"U","\u01DB":"U","\u01D7":"U","\u01D5":"U","\u01D9":"U","\u1EE6":"U","\u016E":"U","\u0170":"U","\u01D3":"U","\u0214":"U","\u0216":"U","\u01AF":"U","\u1EEA":"U","\u1EE8":"U","\u1EEE":"U","\u1EEC":"U","\u1EF0":"U","\u1EE4":"U","\u1E72":"U","\u0172":"U","\u1E76":"U","\u1E74":"U","\u0244":"U","\u24CB":"V","\uFF36":"V","\u1E7C":"V","\u1E7E":"V","\u01B2":"V","\uA75E":"V","\u0245":"V","\uA760":"VY","\u24CC":"W","\uFF37":"W","\u1E80":"W","\u1E82":"W","\u0174":"W","\u1E86":"W","\u1E84":"W","\u1E88":"W","\u2C72":"W","\u24CD":"X","\uFF38":"X","\u1E8A":"X","\u1E8C":"X","\u24CE":"Y","\uFF39":"Y","\u1EF2":"Y","\u00DD":"Y","\u0176":"Y","\u1EF8":"Y","\u0232":"Y","\u1E8E":"Y","\u0178":"Y","\u1EF6":"Y","\u1EF4":"Y","\u01B3":"Y","\u024E":"Y","\u1EFE":"Y","\u24CF":"Z","\uFF3A":"Z","\u0179":"Z","\u1E90":"Z","\u017B":"Z","\u017D":"Z","\u1E92":"Z","\u1E94":"Z","\u01B5":"Z","\u0224":"Z","\u2C7F":"Z","\u2C6B":"Z","\uA762":"Z","\u24D0":"a","\uFF41":"a","\u1E9A":"a","\u00E0":"a","\u00E1":"a","\u00E2":"a","\u1EA7":"a","\u1EA5":"a","\u1EAB":"a","\u1EA9":"a","\u00E3":"a","\u0101":"a","\u0103":"a","\u1EB1":"a","\u1EAF":"a","\u1EB5":"a","\u1EB3":"a","\u0227":"a","\u01E1":"a","\u00E4":"a","\u01DF":"a","\u1EA3":"a","\u00E5":"a","\u01FB":"a","\u01CE":"a","\u0201":"a","\u0203":"a","\u1EA1":"a","\u1EAD":"a","\u1EB7":"a","\u1E01":"a","\u0105":"a","\u2C65":"a","\u0250":"a","\uA733":"aa","\u00E6":"ae","\u01FD":"ae","\u01E3":"ae","\uA735":"ao","\uA737":"au","\uA739":"av","\uA73B":"av","\uA73D":"ay","\u24D1":"b","\uFF42":"b","\u1E03":"b","\u1E05":"b","\u1E07":"b","\u0180":"b","\u0183":"b","\u0253":"b","\u24D2":"c","\uFF43":"c","\u0107":"c","\u0109":"c","\u010B":"c","\u010D":"c","\u00E7":"c","\u1E09":"c","\u0188":"c","\u023C":"c","\uA73F":"c","\u2184":"c","\u24D3":"d","\uFF44":"d","\u1E0B":"d","\u010F":"d","\u1E0D":"d","\u1E11":"d","\u1E13":"d","\u1E0F":"d","\u0111":"d","\u018C":"d","\u0256":"d","\u0257":"d","\uA77A":"d","\u01F3":"dz","\u01C6":"dz","\u24D4":"e","\uFF45":"e","\u00E8":"e","\u00E9":"e","\u00EA":"e","\u1EC1":"e","\u1EBF":"e","\u1EC5":"e","\u1EC3":"e","\u1EBD":"e","\u0113":"e","\u1E15":"e","\u1E17":"e","\u0115":"e","\u0117":"e","\u00EB":"e","\u1EBB":"e","\u011B":"e","\u0205":"e","\u0207":"e","\u1EB9":"e","\u1EC7":"e","\u0229":"e","\u1E1D":"e","\u0119":"e","\u1E19":"e","\u1E1B":"e","\u0247":"e","\u025B":"e","\u01DD":"e","\u24D5":"f","\uFF46":"f","\u1E1F":"f","\u0192":"f","\uA77C":"f","\u24D6":"g","\uFF47":"g","\u01F5":"g","\u011D":"g","\u1E21":"g","\u011F":"g","\u0121":"g","\u01E7":"g","\u0123":"g","\u01E5":"g","\u0260":"g","\uA7A1":"g","\u1D79":"g","\uA77F":"g","\u24D7":"h","\uFF48":"h","\u0125":"h","\u1E23":"h","\u1E27":"h","\u021F":"h","\u1E25":"h","\u1E29":"h","\u1E2B":"h","\u1E96":"h","\u0127":"h","\u2C68":"h","\u2C76":"h","\u0265":"h","\u0195":"hv","\u24D8":"i","\uFF49":"i","\u00EC":"i","\u00ED":"i","\u00EE":"i","\u0129":"i","\u012B":"i","\u012D":"i","\u00EF":"i","\u1E2F":"i","\u1EC9":"i","\u01D0":"i","\u0209":"i","\u020B":"i","\u1ECB":"i","\u012F":"i","\u1E2D":"i","\u0268":"i","\u0131":"i","\u24D9":"j","\uFF4A":"j","\u0135":"j","\u01F0":"j","\u0249":"j","\u24DA":"k","\uFF4B":"k","\u1E31":"k","\u01E9":"k","\u1E33":"k","\u0137":"k","\u1E35":"k","\u0199":"k","\u2C6A":"k","\uA741":"k","\uA743":"k","\uA745":"k","\uA7A3":"k","\u24DB":"l","\uFF4C":"l","\u0140":"l","\u013A":"l","\u013E":"l","\u1E37":"l","\u1E39":"l","\u013C":"l","\u1E3D":"l","\u1E3B":"l","\u017F":"l","\u0142":"l","\u019A":"l","\u026B":"l","\u2C61":"l","\uA749":"l","\uA781":"l","\uA747":"l","\u01C9":"lj","\u24DC":"m","\uFF4D":"m","\u1E3F":"m","\u1E41":"m","\u1E43":"m","\u0271":"m","\u026F":"m","\u24DD":"n","\uFF4E":"n","\u01F9":"n","\u0144":"n","\u00F1":"n","\u1E45":"n","\u0148":"n","\u1E47":"n","\u0146":"n","\u1E4B":"n","\u1E49":"n","\u019E":"n","\u0272":"n","\u0149":"n","\uA791":"n","\uA7A5":"n","\u01CC":"nj","\u24DE":"o","\uFF4F":"o","\u00F2":"o","\u00F3":"o","\u00F4":"o","\u1ED3":"o","\u1ED1":"o","\u1ED7":"o","\u1ED5":"o","\u00F5":"o","\u1E4D":"o","\u022D":"o","\u1E4F":"o","\u014D":"o","\u1E51":"o","\u1E53":"o","\u014F":"o","\u022F":"o","\u0231":"o","\u00F6":"o","\u022B":"o","\u1ECF":"o","\u0151":"o","\u01D2":"o","\u020D":"o","\u020F":"o","\u01A1":"o","\u1EDD":"o","\u1EDB":"o","\u1EE1":"o","\u1EDF":"o","\u1EE3":"o","\u1ECD":"o","\u1ED9":"o","\u01EB":"o","\u01ED":"o","\u00F8":"o","\u01FF":"o","\u0254":"o","\uA74B":"o","\uA74D":"o","\u0275":"o","\u01A3":"oi","\u0223":"ou","\uA74F":"oo","\u24DF":"p","\uFF50":"p","\u1E55":"p","\u1E57":"p","\u01A5":"p","\u1D7D":"p","\uA751":"p","\uA753":"p","\uA755":"p","\u24E0":"q","\uFF51":"q","\u024B":"q","\uA757":"q","\uA759":"q","\u24E1":"r","\uFF52":"r","\u0155":"r","\u1E59":"r","\u0159":"r","\u0211":"r","\u0213":"r","\u1E5B":"r","\u1E5D":"r","\u0157":"r","\u1E5F":"r","\u024D":"r","\u027D":"r","\uA75B":"r","\uA7A7":"r","\uA783":"r","\u24E2":"s","\uFF53":"s","\u00DF":"s","\u015B":"s","\u1E65":"s","\u015D":"s","\u1E61":"s","\u0161":"s","\u1E67":"s","\u1E63":"s","\u1E69":"s","\u0219":"s","\u015F":"s","\u023F":"s","\uA7A9":"s","\uA785":"s","\u1E9B":"s","\u24E3":"t","\uFF54":"t","\u1E6B":"t","\u1E97":"t","\u0165":"t","\u1E6D":"t","\u021B":"t","\u0163":"t","\u1E71":"t","\u1E6F":"t","\u0167":"t","\u01AD":"t","\u0288":"t","\u2C66":"t","\uA787":"t","\uA729":"tz","\u24E4":"u","\uFF55":"u","\u00F9":"u","\u00FA":"u","\u00FB":"u","\u0169":"u","\u1E79":"u","\u016B":"u","\u1E7B":"u","\u016D":"u","\u00FC":"u","\u01DC":"u","\u01D8":"u","\u01D6":"u","\u01DA":"u","\u1EE7":"u","\u016F":"u","\u0171":"u","\u01D4":"u","\u0215":"u","\u0217":"u","\u01B0":"u","\u1EEB":"u","\u1EE9":"u","\u1EEF":"u","\u1EED":"u","\u1EF1":"u","\u1EE5":"u","\u1E73":"u","\u0173":"u","\u1E77":"u","\u1E75":"u","\u0289":"u","\u24E5":"v","\uFF56":"v","\u1E7D":"v","\u1E7F":"v","\u028B":"v","\uA75F":"v","\u028C":"v","\uA761":"vy","\u24E6":"w","\uFF57":"w","\u1E81":"w","\u1E83":"w","\u0175":"w","\u1E87":"w","\u1E85":"w","\u1E98":"w","\u1E89":"w","\u2C73":"w","\u24E7":"x","\uFF58":"x","\u1E8B":"x","\u1E8D":"x","\u24E8":"y","\uFF59":"y","\u1EF3":"y","\u00FD":"y","\u0177":"y","\u1EF9":"y","\u0233":"y","\u1E8F":"y","\u00FF":"y","\u1EF7":"y","\u1E99":"y","\u1EF5":"y","\u01B4":"y","\u024F":"y","\u1EFF":"y","\u24E9":"z","\uFF5A":"z","\u017A":"z","\u1E91":"z","\u017C":"z","\u017E":"z","\u1E93":"z","\u1E95":"z","\u01B6":"z","\u0225":"z","\u0240":"z","\u2C6C":"z","\uA763":"z","\u0386":"\u0391","\u0388":"\u0395","\u0389":"\u0397","\u038A":"\u0399","\u03AA":"\u0399","\u038C":"\u039F","\u038E":"\u03A5","\u03AB":"\u03A5","\u038F":"\u03A9","\u03AC":"\u03B1","\u03AD":"\u03B5","\u03AE":"\u03B7","\u03AF":"\u03B9","\u03CA":"\u03B9","\u0390":"\u03B9","\u03CC":"\u03BF","\u03CD":"\u03C5","\u03CB":"\u03C5","\u03B0":"\u03C5","\u03C9":"\u03C9","\u03C2":"\u03C3"};var f=function(i){return g[i]||i};return h.replace(/[^\u0000-\u007E]/g,f)};function d(f){var g=[];this.filter("select").each(function(){var j=e(this);var i=j.data("tokenize2");var h=typeof f==="object"&&f;if(!i){j.data("tokenize2",new c(this,h))}g.push(j.data("tokenize2"))});if(g.length>1){return g}else{return g[0]}}var b=e.fn.tokenize2;e.fn.tokenize2=d;e.fn.tokenize2.Constructor=c;e.fn.tokenize2.noConflict=function(){e.fn.tokenize2=b;return this}}));!function(c,f,a,e){var i={drag:true,drop:true,exclude:"",nested:true,vertical:true},o={afterMove:function(t,d,u){},containerPath:"",containerSelector:"ol, ul",distance:0,delay:0,handle:"",itemPath:"",itemSelector:"li",bodyClass:"dragging",draggedClass:"dragged",isValidTarget:function(t,d){return true},onCancel:function(t,d,v,u){},onDrag:function(t,d,v,u){t.css(d)},onDragStart:function(t,d,v,u){t.css({height:t.outerHeight(),width:t.outerWidth()});t.addClass(d.group.options.draggedClass);c("body").addClass(d.group.options.bodyClass)},onDrop:function(t,d,v,u){t.removeClass(d.group.options.draggedClass).removeAttr("style");c("body").removeClass(d.group.options.bodyClass)},onMousedown:function(d,u,t){if(!t.target.nodeName.match(/^(input|select|textarea)$/i)){t.preventDefault();return true}},placeholderClass:"placeholder",placeholder:'<li class="placeholder"></li>',pullPlaceholder:true,serialize:function(v,u,t){var d=c.extend({},v.data());if(t){return[u]}else{if(u[0]){d.children=u}}delete d.subContainers;delete d.sortable;return d},tolerance:0},q={},l=0,h={left:0,top:0,bottom:0,right:0},g={start:"touchstart.sortable mousedown.sortable",drop:"touchend.sortable touchcancel.sortable mouseup.sortable",drag:"touchmove.sortable mousemove.sortable",scroll:"scroll.sortable"},s="subContainers";function r(u,t){var d=Math.max(0,u[0]-t[0],t[0]-u[1]),v=Math.max(0,u[2]-t[1],t[1]-u[3]);return d+v}function n(z,x,t,v){var u=z.length,d=v?"offset":"position";t=t||0;while(u--){var w=z[u].el?z[u].el:c(z[u]),y=w[d]();y.left+=parseInt(w.css("margin-left"),10);y.top+=parseInt(w.css("margin-top"),10);x[u]=[y.left-t,y.left+w.outerWidth()+t,y.top-t,y.top+w.outerHeight()+t]}}function b(u,d){var t=d.offset();return{left:u.left-t.left,top:u.top-t.top}}function p(v,x,u){x=[x.left,x.top];u=u&&[u.left,u.top];var w,t=v.length,d=[];while(t--){w=v[t];d[t]=[t,r(w,x),u&&r(w,u)]}d=d.sort(function(z,y){return y[1]-z[1]||y[2]-z[2]||y[0]-z[0]});return d}function m(d){this.options=c.extend({},o,d);this.containers=[];if(!this.options.rootGroup){this.scrollProxy=c.proxy(this.scroll,this);this.dragProxy=c.proxy(this.drag,this);this.dropProxy=c.proxy(this.drop,this);this.placeholder=c(this.options.placeholder);if(!d.isValidTarget){this.options.isValidTarget=e}}}m.get=function(d){if(!q[d.group]){if(d.group===e){d.group=l++}q[d.group]=new m(d)}return q[d.group]};m.prototype={dragInit:function(u,t){this.$document=c(t.el[0].ownerDocument);var d=c(u.target).closest(this.options.itemSelector);if(d.length){this.item=d;this.itemContainer=t;if(this.item.is(this.options.exclude)||!this.options.onMousedown(this.item,o.onMousedown,u)){return}this.setPointer(u);this.toggleListeners("on");this.setupDelayTimer();this.dragInitDone=true}},drag:function(w){if(!this.dragging){if(!this.distanceMet(w)||!this.delayMet){return}this.options.onDragStart(this.item,this.itemContainer,o.onDragStart,w);this.item.before(this.placeholder);this.dragging=true}this.setPointer(w);this.options.onDrag(this.item,b(this.pointer,this.item.offsetParent()),o.onDrag,w);var v=this.getPointer(w),u=this.sameResultBox,d=this.options.tolerance;if(!u||u.top-d>v.top||u.bottom+d<v.top||u.left-d>v.left||u.right+d<v.left){if(!this.searchValidTarget()){this.placeholder.detach();this.lastAppendedItem=e}}},drop:function(d){this.toggleListeners("off");this.dragInitDone=false;if(this.dragging){if(this.placeholder.closest("html")[0]){this.placeholder.before(this.item).detach()}else{this.options.onCancel(this.item,this.itemContainer,o.onCancel,d)}this.options.onDrop(this.item,this.getContainer(this.item),o.onDrop,d);this.clearDimensions();this.clearOffsetParent();this.lastAppendedItem=this.sameResultBox=e;this.dragging=false}},searchValidTarget:function(y,w){if(!y){y=this.relativePointer||this.pointer;w=this.lastRelativePointer||this.lastPointer}var t=p(this.getContainerDimensions(),y,w),v=t.length;while(v--){var u=t[v][0],z=t[v][1];if(!z||this.options.pullPlaceholder){var d=this.containers[u];if(!d.disabled){if(!this.$getOffsetParent()){var x=d.getItemOffsetParent();y=b(y,x);w=b(w,x)}if(d.searchValidTarget(y,w)){return true}}}}if(this.sameResultBox){this.sameResultBox=e}},movePlaceholder:function(t,u,w,d){var v=this.lastAppendedItem;if(!d&&v&&v[0]===u[0]){return}u[w](this.placeholder);this.lastAppendedItem=u;this.sameResultBox=d;this.options.afterMove(this.placeholder,t,u)},getContainerDimensions:function(){if(!this.containerDimensions){n(this.containers,this.containerDimensions=[],this.options.tolerance,!this.$getOffsetParent())}return this.containerDimensions},getContainer:function(d){return d.closest(this.options.containerSelector).data(a)},$getOffsetParent:function(){if(this.offsetParent===e){var d=this.containers.length-1,t=this.containers[d].getItemOffsetParent();if(!this.options.rootGroup){while(d--){if(t[0]!=this.containers[d].getItemOffsetParent()[0]){t=false;break}}}this.offsetParent=t}return this.offsetParent},setPointer:function(t){var u=this.getPointer(t);if(this.$getOffsetParent()){var d=b(u,this.$getOffsetParent());this.lastRelativePointer=this.relativePointer;this.relativePointer=d}this.lastPointer=this.pointer;this.pointer=u},distanceMet:function(d){var t=this.getPointer(d);return(Math.max(Math.abs(this.pointer.left-t.left),Math.abs(this.pointer.top-t.top))>=this.options.distance)},getPointer:function(d){var t=d.originalEvent||d.originalEvent.touches&&d.originalEvent.touches[0];return{left:d.pageX||t.pageX,top:d.pageY||t.pageY}},setupDelayTimer:function(){var d=this;this.delayMet=!this.options.delay;if(!this.delayMet){clearTimeout(this._mouseDelayTimer);this._mouseDelayTimer=setTimeout(function(){d.delayMet=true},this.options.delay)}},scroll:function(d){this.clearDimensions();this.clearOffsetParent()},toggleListeners:function(u){var t=this,d=["drag","drop","scroll"];c.each(d,function(v,w){t.$document[u](g[w],t[w+"Proxy"])})},clearOffsetParent:function(){this.offsetParent=e},clearDimensions:function(){this.traverse(function(d){d._clearDimensions()})},traverse:function(t){t(this);var d=this.containers.length;while(d--){this.containers[d].traverse(t)}},_clearDimensions:function(){this.containerDimensions=e},_destroy:function(){q[this.options.group]=e}};function j(u,t){this.el=u;this.options=c.extend({},i,t);this.group=m.get(this.options);this.rootGroup=this.options.rootGroup||this.group;this.handle=this.rootGroup.options.handle||this.rootGroup.options.itemSelector;var d=this.rootGroup.options.itemPath;this.target=d?this.el.find(d):this.el;this.target.on(g.start,this.handle,c.proxy(this.dragInit,this));if(this.options.drop){this.group.containers.push(this)}}j.prototype={dragInit:function(t){var d=this.rootGroup;if(!this.disabled&&!d.dragInitDone&&this.options.drag&&this.isValidDrag(t)){d.dragInit(t,this)}},isValidDrag:function(d){return d.which==1||d.type=="touchstart"&&d.originalEvent.touches.length==1},searchValidTarget:function(d,u){var x=p(this.getItemDimensions(),d,u),v=x.length,y=this.rootGroup,z=!y.options.isValidTarget||y.options.isValidTarget(y.item,this);if(!v&&z){y.movePlaceholder(this,this.target,"append");return true}else{while(v--){var w=x[v][0],t=x[v][1];if(!t&&this.hasChildGroup(w)){var A=this.getContainerGroup(w).searchValidTarget(d,u);if(A){return true}}else{if(z){this.movePlaceholder(w,d);return true}}}}},movePlaceholder:function(A,t){var E=c(this.items[A]),z=this.itemDimensions[A],d="after",u=E.outerWidth(),D=E.outerHeight(),y=E.offset(),v={left:y.left,right:y.left+u,top:y.top,bottom:y.top+D};if(this.options.vertical){var C=(z[2]+z[3])/2,B=t.top<=C;if(B){d="before";v.bottom-=D/2}else{v.top+=D/2}}else{var w=(z[0]+z[1])/2,x=t.left<=w;if(x){d="before";v.right-=u/2}else{v.left+=u/2}}if(this.hasChildGroup(A)){v=h}this.rootGroup.movePlaceholder(this,E,d,v)},getItemDimensions:function(){if(!this.itemDimensions){this.items=this.$getChildren(this.el,"item").filter(":not(."+this.group.options.placeholderClass+", ."+this.group.options.draggedClass+")").get();n(this.items,this.itemDimensions=[],this.options.tolerance)}return this.itemDimensions},getItemOffsetParent:function(){var t,d=this.el;if(d.css("position")==="relative"||d.css("position")==="absolute"||d.css("position")==="fixed"){t=d}else{t=d.offsetParent()}return t},hasChildGroup:function(d){return this.options.nested&&this.getContainerGroup(d)},getContainerGroup:function(u){var v=c.data(this.items[u],s);if(v===e){var t=this.$getChildren(this.items[u],"container");v=false;if(t[0]){var d=c.extend({},this.options,{rootGroup:this.rootGroup,group:l++});v=t[a](d).data(a).group}c.data(this.items[u],s,v)}return v},$getChildren:function(v,u){var t=this.rootGroup.options,w=t[u+"Path"],d=t[u+"Selector"];v=c(v);if(w){v=v.find(w)}return v.children(d)},_serialize:function(v,u){var w=this,d=u?"item":"container",t=this.$getChildren(v,d).not(this.options.exclude).map(function(){return w._serialize(c(this),!u)}).get();return this.rootGroup.options.serialize(v,t,u)},traverse:function(d){c.each(this.items||[],function(t){var u=c.data(this,s);if(u){u.traverse(d)}});d(this)},_clearDimensions:function(){this.itemDimensions=e},_destroy:function(){var d=this;this.target.off(g.start,this.handle);this.el.removeData(a);if(this.options.drop){this.group.containers=c.grep(this.group.containers,function(t){return t!=d})}c.each(this.items||[],function(){c.removeData(this,s)})}};var k={enable:function(){this.traverse(function(d){d.disabled=false})},disable:function(){this.traverse(function(d){d.disabled=true})},serialize:function(){return this._serialize(this.el,true)},refresh:function(){this.traverse(function(d){d._clearDimensions()})},destroy:function(){this.traverse(function(d){d._destroy()})}};c.extend(j.prototype,k);c.fn[a]=function(d){var t=Array.prototype.slice.call(arguments,1);return this.map(function(){var v=c(this),u=v.data(a);if(u&&k[d]){return k[d].apply(u,t)||this}else{if(!u&&(d===e||typeof d==="object")){v.data(a,new j(v,d))}}return this})}}(jQuery,window,"tokenize2sortable");
