<?php
global $wpdb;
$action = (isset($_GET['action'])) ? sanitize_text_field( $_GET['action'] ) : '';
$heading = '';
$id = ( isset( $_GET['quiz_attribute'] ) ) ? absint( intval( $_GET['quiz_attribute'] ) ) : null;

// Loader image
$loader_iamge = "<span class='display_none ays_quiz_loader_box'><img src=". AYS_QUIZ_ADMIN_URL ."/images/loaders/loading.gif></span>";

$user_id = get_current_user_id();
$user = get_userdata($user_id);
$author = array(
    'id' => $user->ID,
    'name' => $user->data->display_name
);

$maxId = $wpdb->get_var("SELECT MAX(id) FROM " . $wpdb->prefix . 'aysquiz_attributes');
$quiz_attribute = array(
    'id'        => '',
    'author_id' => $user_id,
    'name'      => '',
    'slug'      => "quiz_attr_" . ($maxId + 1) ,
    'type'      => '',
    'published' => '',
    'attr_options'   => ''
);

$file_attr_default_values = array(
    'allow_specific_types'  => 'off',
    'max_size'              => '5',
    'types'                 => array(
        'pdf'   => 'on',
        'docx'  => 'on',
        'png'   => 'on',
        'jpg'   => 'on',
        'gif'   => 'on',
    )
);

$attr_options = array(
    'show_custom_fields'              => 'off',
    'show_custom_fields_user_page'    => 'off',
    'show_custom_fields_user_results' => 'off',
    'show_custom_fields_quiz_results' => 'off',
    'quiz_attr_file'                  => $file_attr_default_values
);

switch( $action ) {
    case 'add':
        $heading = __('Add new field', $this->plugin_name);
        break;
    case 'edit':
        $heading = __('Edit field', $this->plugin_name);
        $quiz_attribute = $this->attributes_obj->get_attribute_by_id( $id );
        if (isset( $quiz_attribute['attr_options'] ) && $quiz_attribute['attr_options'] != "") {
            $attr_options = json_decode($quiz_attribute['attr_options'], true);
        }
        break;
}

$author_id = (isset( $quiz_attribute['author_id'] ) && $quiz_attribute['author_id'] != "") ? absint( $quiz_attribute['author_id'] ) : $user_id;
$owner = false;
if( $user_id == $author_id ){
    $owner = true;
}

if( $this->current_user_can_edit ){
    $owner = true;
}

$disabled_option = '';
$readonly_option = '';
if( !$owner ){
    $disabled_option = ' disabled ';
    $readonly_option = ' readonly ';
}

if( isset( $_POST['ays_submit'] ) ) {
    $_POST['id'] = $id;
    $result = $this->attributes_obj->add_edit_quiz_attribute( $_POST );
}
if(isset($_POST['ays_apply'])){
    $_POST["id"] = $id;
    $_POST['ays_change_type'] = 'apply';
    $this->attributes_obj->add_edit_quiz_attribute($_POST);
}

//Custom fields for shortcode
$shortcodes = array(
    'user_results'              => __('All Results', $this->plugin_name),
    'user_page'                 => __('User Page', $this->plugin_name),
    'quiz_results'              => __('Single quiz Results', $this->plugin_name),
    'individual_leaderboard'    => __('Individual Leaderboard', $this->plugin_name),
    'leaderboard_by_quiz_cat'   => __('Leaderboard By Quiz Category', $this->plugin_name),
);

$quiz_attribute_published = (isset( $quiz_attribute["published"] ) && $quiz_attribute["published"] != "") ? absint($quiz_attribute["published"]) : 1;

//Show Custom Fields
$attr_options['show_custom_fields'] = isset($attr_options['show_custom_fields']) ? sanitize_text_field($attr_options['show_custom_fields']) : 'off';
$show_custom_fields = (isset($attr_options['show_custom_fields']) && $attr_options['show_custom_fields'] == 'on') ? true : false;

//Show Custom Fields User Page
$attr_options['show_custom_fields_user_page'] = isset($attr_options['show_custom_fields_user_page']) ? sanitize_text_field($attr_options['show_custom_fields_user_page']) : 'off';
$user_page = (isset($attr_options['show_custom_fields_user_page']) && $attr_options['show_custom_fields_user_page'] == 'on') ? true : false;

//Show Custom Fields User Results
$attr_options['show_custom_fields_user_results'] = isset($attr_options['show_custom_fields_user_results']) ? sanitize_text_field($attr_options['show_custom_fields_user_results']) : 'off';
$user_results = (isset($attr_options['show_custom_fields_user_results']) && $attr_options['show_custom_fields_user_results'] == 'on') ? true : false;

//Show Custom Fields User Results
$attr_options['show_custom_fields_quiz_results'] = isset($attr_options['show_custom_fields_quiz_results']) ? sanitize_text_field($attr_options['show_custom_fields_quiz_results']) : 'off';
$quiz_results = (isset($attr_options['show_custom_fields_quiz_results']) && $attr_options['show_custom_fields_quiz_results'] == 'on') ? true : false;

//Show Custom Fields Individual Leaderboard
$attr_options['show_custom_fields_individual_leaderboard'] = isset($attr_options['show_custom_fields_individual_leaderboard']) ? sanitize_text_field($attr_options['show_custom_fields_individual_leaderboard']) : 'off';
$individual_leaderboard = (isset($attr_options['show_custom_fields_individual_leaderboard']) && $attr_options['show_custom_fields_individual_leaderboard'] == 'on') ? true : false;

// Show Custom Fields Leaderboard By Quiz Category
$attr_options['show_custom_fields_leaderboard_by_quiz_cat'] = isset($attr_options['show_custom_fields_leaderboard_by_quiz_cat']) ? sanitize_text_field($attr_options['show_custom_fields_leaderboard_by_quiz_cat']) : 'off';
$leaderboard_by_quiz_cat = (isset($attr_options['show_custom_fields_leaderboard_by_quiz_cat']) && $attr_options['show_custom_fields_leaderboard_by_quiz_cat'] == 'on') ? true : false;

$quiz_attr_file = isset( $attr_options['quiz_attr_file'] ) ? $attr_options['quiz_attr_file'] : $file_attr_default_values;
$file_max_size = !empty( $quiz_attr_file['max_size'] ) ? $quiz_attr_file['max_size'] : $file_attr_default_values['max_size'];
$allow_specific_types = isset( $quiz_attr_file['allow_specific_types'] ) && $quiz_attr_file['allow_specific_types'] === 'on' ? 'on' : 'off';
$file_types = is_array( $quiz_attr_file['types'] ) && !empty( $quiz_attr_file['types'] ) ? $quiz_attr_file['types'] : $file_attr_default_values['types'];
$file_type_pdf  = isset( $file_types['pdf'] ) && $file_types['pdf'] === 'on' ? 'on' : 'off';
$file_type_docx = isset( $file_types['docx'] ) && $file_types['docx'] === 'on' ? 'on' : 'off';
$file_type_png  = isset( $file_types['png'] ) && $file_types['png'] === 'on' ? 'on' : 'off';
$file_type_jpg  = isset( $file_types['jpg'] ) && $file_types['jpg'] === 'on' ? 'on' : 'off';
$file_type_gif  = isset( $file_types['gif'] ) && $file_types['gif'] === 'on' ? 'on' : 'off';

?>

<div class="wrap ays-quiz-dashboard-main-wrap">
    <div class="container-fluid">
        <div class="ays-quiz-heading-box">
            <div class="ays-quiz-wordpress-user-manual-box">
                <a href="https://quiz-plugin.com/docs/" target="_blank">
                    <i class="ays_fa ays_fa_file_text" ></i> 
                    <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", "quiz-maker"); ?></span>
                </a>
            </div>
        </div>
        <h1><?php echo $heading; ?></h1>
        <hr/>
        <form class="ays-quiz-attribute-form" id="ays-quiz-attribute-form" method="post">
            <div id="tab1" class="ays-quiz-tab-content ays-quiz-tab-content-active">
                <p class="ays-subtitle"><?php echo __('Settings',$this->plugin_name); ?></p>
                <hr class="ays-quiz-bolder-hr"/>
                <input type="hidden" name="ays_quiz_attributes_author" value="<?php echo $author_id; ?>">
                <div class="form-group row">
                    <div class="col-sm-2">
                        <label for='ays-attribute-name'>
                            <?php echo __('Name', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('The name of field. It will show up as a placeholder for text input.',$this->plugin_name)?>">
                                <i class="ays_fa ays_fa_info_circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-10">
                        <input class='ays-text-input' id='ays-attribute-name' name='ays_name' required type='text' value='<?php echo isset($quiz_attribute['name']) ? esc_attr( $quiz_attribute['name'] ) : ''; ?>' <?php echo $readonly_option; ?>>
                    </div>
                </div>

                <hr/>
                <div class="form-group row">
                    <div class="col-sm-2">
                        <label>
                            <?php echo __('Slug', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Unique identifier for the field. You can use it in the integrations to show the user’s answer for this field.',$this->plugin_name)?>">
                                <i class="ays_fa ays_fa_info_circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-10">
                        <input class='ays-text-input' id='ays-attribute-slug' name='ays_slug' required readonly type='text' value='<?php echo (isset($quiz_attribute['slug'])) ? stripslashes(htmlentities($quiz_attribute['slug'])) : ''; ?>'>
                    </div>
                </div>
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-2">
                        <label>
                            <?php echo __('Mailchimp Slug', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Copy the given tag and add it in the *|MERGE|* tags field (All contacts > Settings > Audience fields and *|MERGE|* tags). After that the users tags will be collected in your MailChimp lists.',$this->plugin_name); ?>">
                                <i class="ays_fa ays_fa_info_circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-10">
                        <input class='ays-text-input' id='ays-quiz-mailchimp-attribute-slug' readonly type='text' value='<?php echo (isset( $id )) ? "QATTR_" . stripslashes(esc_attr($id)) : ''; ?>'>
                    </div>
                </div>

                <hr/>
                <div class="form-group row">
                    <div class="col-sm-2">
                        <label>
                            <?php echo __('Type', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose what kind of field to add from the mentioned list.',$this->plugin_name)?>">
                                <i class="ays_fa ays_fa_info_circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-3">
                        <select class='ays-text-input ays-text-input-short' id='ays-attribute-type' name='ays_quiz_attr_type' <?php echo $disabled_option; ?>>
                            <option value="text" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'text' ) ? 'selected' : '' ; ?>><?php echo __('Text', $this->plugin_name); ?></option>
                            <option value="textarea" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'textarea' ) ? 'selected' : '' ; ?>><?php echo __('Textarea', $this->plugin_name); ?></option>
                            <option value="email" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'email' ) ? 'selected' : '' ; ?>><?php echo __('E-Mail', $this->plugin_name); ?></option>
                            <option value="number" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'number' ) ? 'selected' : '' ; ?>><?php echo __('Number', $this->plugin_name); ?></option>
                            <option value="tel" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'tel' ) ? 'selected' : '' ; ?>><?php echo __('Telephone', $this->plugin_name); ?></option>
                            <option value="url" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'url' ) ? 'selected' : '' ; ?>><?php echo __('URL', $this->plugin_name); ?></option>
                            <option value="select" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'select' ) ? 'selected' : '' ; ?>><?php echo __('Select', $this->plugin_name); ?></option>
                            <option value="checkbox" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'checkbox' ) ? 'selected' : '' ; ?>><?php echo __('Checkbox', $this->plugin_name); ?></option>
                            <option value="date" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'date' ) ? 'selected' : '' ; ?>><?php echo __('Date', $this->plugin_name); ?></option>
                            <option value="file" <?php echo (isset($quiz_attribute['type']) && $quiz_attribute['type'] == 'file' ) ? 'selected' : '' ; ?>><?php echo __('File Upload', $this->plugin_name); ?></option>
                        </select>
                    </div>
                    <div class="col-sm-7 ays_attr_options" <?php echo (!isset($quiz_attribute['type']) || $quiz_attribute['type'] != "select") ? 'style="display:none"' : ''; ?>>    <div class="form-group row">
                            <div class="col-sm-2">
                                <label for="ays_quiz_attr_option"><?php echo __('Options', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Please write your options separated by example: Red; Blue; Green',$this->plugin_name)?>">
                                    <i class="ays_fa ays_fa_info_circle"></i>
                                </a>
                                </label>
                            </div>
                            <div class="col-sm-10">
                                <input type="text" name="ays_quiz_attr_options" id="ays_quiz_attr_option" class="ays-text-input" value="<?php echo (isset($quiz_attribute['options']) && $quiz_attribute['type'] == "select") ? stripslashes(htmlentities($quiz_attribute['options'])) : ''; ?>" placeholder="Red; Blue; Green" <?php echo $readonly_option; ?>>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-7 ays_attr_description" <?php echo (!isset($quiz_attribute['type']) || $quiz_attribute['type'] != "checkbox") ? 'style="display:none"' : ''; ?>>
                        <div class="form-group row">
                            <div class="col-sm-2">
                                <label for="ays_quiz_attr_description"><?php echo __('Description', $this->plugin_name); ?>
                                    <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Please write any text, email or link',$this->plugin_name)?>">
                                        <i class="ays_fa ays_fa_info_circle"></i>
                                    </a>
                                </label>
                            </div>
                            <div class="col-sm-10">
                                <input type="text" name="ays_quiz_attr_description" id="ays_quiz_attr_description" class="ays-text-input" value="<?php echo (isset($quiz_attribute['options']) && $quiz_attribute['type'] == "checkbox") ? stripslashes($quiz_attribute['options']) : ''; ?>" placeholder="<?php echo __('Type your description here', $this->plugin_name); ?>" <?php echo $readonly_option; ?>>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-7 ays_attr_file_options" <?php echo (!isset($quiz_attribute['type']) || $quiz_attribute['type'] != "file") ? 'style="display:none"' : ''; ?>>
                        <div class="form-group row">
                            <div class="col-sm-2">
                                <label><?php echo __('Settings', $this->plugin_name); ?></label>
                            </div>
                            <div class="col-sm-10">
                                <div class="ays-quiz-question-type-upload-main-box ays_toggle_parent">
                                    <div class="ays-quiz-question-type-upload-allow-type-box">
                                        <label>
                                            <input
                                                type="checkbox"
                                                name="ays_quiz_attr_file[allow_specific_types]"
                                                class="display_none ays_toggle_checkbox"
                                                value="on"
                                                <?php echo checked( 'on', $allow_specific_types); ?>
                                            />
                                            <span><?php echo __("Allow only specific file types" , $this->plugin_name); ?></span>
                                        </label>
                                    </div>
                                    <div class="ays-quiz-question-type-upload-allowed-types ays_toggle_target"
                                        <?php echo $allow_specific_types === 'on' ? '' : 'style="display:none"'; ?>>
                                        <label class="form-check form-check-inline checkbox_ays">
                                            <input
                                                type="checkbox"
                                                name="ays_quiz_attr_file[types][pdf]"
                                                value="on"
                                                <?php echo checked('on', $file_type_pdf) ?>
                                            />
                                            <span class="">PDF</span>
                                        </label>
                                        <label class="form-check form-check-inline checkbox_ays">
                                            <input
                                                type="checkbox"
                                                name="ays_quiz_attr_file[types][docx]"
                                                value="on"
                                                <?php echo checked('on', $file_type_docx) ?>
                                            />
                                            <span class="">DOC,DOCX</span>
                                        </label>
                                        <label class="form-check form-check-inline checkbox_ays">
                                            <input
                                                type="checkbox"
                                                name="ays_quiz_attr_file[types][png]"
                                                value="on"
                                                <?php echo checked('on', $file_type_png) ?>
                                            />
                                            <span class="">PNG</span>
                                        </label>
                                        <label class="form-check form-check-inline checkbox_ays">
                                            <input
                                                type="checkbox"
                                                name="ays_quiz_attr_file[types][jpg]"
                                                value="on"
                                                <?php echo checked('on', $file_type_jpg) ?>
                                            />
                                            <span class="">JPG, JPEG</span>
                                        </label>
                                        <label class="form-check form-check-inline checkbox_ays">
                                            <input
                                                type="checkbox"
                                                name="ays_quiz_attr_file[types][gif]"
                                                value="on"
                                                <?php echo checked('on', $file_type_gif) ?>
                                            />
                                            <span class="">GIF</span>
                                        </label>
                                    </div>
                                    <hr>
                                    <div class="ays-quiz-question-type-upload-max-size-main-box">
                                        <label class="ays-quiz-question-type-upload-max-size-text-box">
                                            <span class="ays-quiz-question-type-upload-max-size-text">
                                                <?php echo __("Maximum file size" , $this->plugin_name); ?>
                                            </span>
                                            <select name="ays_quiz_attr_file[max_size]">
                                                <option <?php echo selected( '1', $file_max_size); ?> value="1">1 MB</option>
                                                <option <?php echo selected( '5', $file_max_size); ?> value="5">5 MB</option>
                                                <option <?php echo selected( '10', $file_max_size); ?> value="10">10 MB</option>
                                                <option <?php echo selected( '100', $file_max_size); ?> value="100">100 MB</option>
                                            </select>
                                        </label>
                                    </div>
                                    <hr>
                                    <div>
                                        <?php
                                        echo __( "Maximum upload file size of your website: ", $this->plugin_name ) . wp_max_upload_size() / 1024 / 1024 . " MB";
                                        ?>
                                        <a data-toggle="tooltip" class="ays_help" title="<?php echo __('The chosen value must be equal or higher than the value set on your Server. For example, if the Server value is 64MB, in case of choosing 100MB, the users will not be able to upload the file. Please, note that in the note text, the value set in the Server will be displayed.',$this->plugin_name); ?>">
                                            <i class="ays_fa ays_fa_info_circle"></i>
                                        </a>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <hr>
                <div class="form-group row ays_toggle_parent">
                    <div class="col-sm-2">
                        <label for="ays_quiz_show_custom_fields">
                            <?php echo __('Show custom field on your shortcodes', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose in which shortcode to enable the custom field.',$this->plugin_name)?>">
                                <i class="ays_fa ays_fa_info_circle"></i>
                            </a>
                        </label>
                    </div>
                    <div class="col-sm-3">
                        <input type="checkbox" id="ays_quiz_show_custom_fields" class="ays_toggle_checkbox" name="ays_quiz_show_custom_fields" <?php echo $show_custom_fields ? 'checked' : '';?>>
                    </div>
                    <div class="col-sm-7 ays_toggle_target <?php echo $show_custom_fields ? "" : "display_none" ?>">
                        <?php
                            foreach ($shortcodes as $shortcode_key => $shortcode):
                            ?>
                            <div class="form-group row">
                                <div class="col-sm-4">
                                    <label for="ays_quiz_<?php echo $shortcode_key; ?>"><?php echo $shortcode;?></label>
                                </div>
                                <div class="col-sm-8">
                                    <input type="checkbox" id="ays_quiz_<?php echo $shortcode_key; ?>" name="ays_quiz_show_custom_fields_<?php echo $shortcode_key; ?>" <?php echo $$shortcode_key ? 'checked' : '';?>>
                                </div>
                            </div>
                            <?php
                            endforeach;
                        ?>
                    </div>
                </div>
                <hr/>
                <div class="form-group row">
                    <div class="col-sm-2">
                        <label>
                            <?php echo __('Attribute status', $this->plugin_name); ?>
                            <a class="ays_help" data-toggle="tooltip" title="<?php echo __('Choose whether the attribute is active or not. If you choose Unpublished option, the attribute won’t be shown anywhere.',$this->plugin_name)?>">
                                <i class="ays_fa ays_fa_info_circle"></i>
                            </a>
                        </label>
                    </div>

                    <div class="col-sm-10">
                        <div class="form-check form-check-inline">
                            <input type="radio" id="ays-publish" name="ays_publish" <?php echo $readonly_option; ?> value="1" <?php echo ( $quiz_attribute_published == '' ) ? "checked" : ""; ?> <?php echo ( $quiz_attribute_published == '1') ? 'checked' : ''; ?> />
                            <label class="form-check-label" for="ays-publish"> <?php echo __('Published', $this->plugin_name); ?> </label>
                        </div>
                        <div class="form-check form-check-inline">
                            <input type="radio" id="ays-unpublish" name="ays_publish"<?php echo $readonly_option; ?>  value="0" <?php echo ( $quiz_attribute_published  == '0' ) ? 'checked' : ''; ?> />
                            <label class="form-check-label" for="ays-unpublish"> <?php echo __('Unpublished', $this->plugin_name); ?> </label>
                        </div>
                    </div>
                </div>
            </div>
            <hr/>
            <?php
            if( $owner ){
            ?>
            <div class="ays-question-button-box ays_save_buttons_content ays_save_buttons_bottom_content">
                <div class="ays-question-button-first-row ays_save_buttons_box" style="padding: 0;">
                    <?php
                        wp_nonce_field('quiz_attribute_action', 'quiz_attribute_action');
                        echo $loader_iamge;
                        $other_attributes = array( 'id' => 'ays-button' );
                        submit_button(__('Save', $this->plugin_name), 'primary', 'ays_apply', true, $other_attributes);
                        submit_button( __( 'Save and close', $this->plugin_name ), '', 'ays_submit', true, $other_attributes );
                    ?>
                </div>
            </div>
            <?php
            }
            ?>
        </form>
    </div>
</div>
