<?php
global $wpdb;
// if(isset($_GET['ays_result_tab'])){
//     $tab = $_GET['ays_result_tab'];
// }else{
// }
$tab = 'questions';

$quiz_id = isset($_GET['quiz']) ? intval($_GET['quiz']) : null;
if($quiz_id === null){
    wp_redirect( admin_url('admin.php') . '?page=' . $this->plugin_name . '-results' );
}
$quizes_table = $wpdb->prefix . 'aysquiz_quizes';
$quizes_questions_table = $wpdb->prefix . 'aysquiz_questions';
$sql = "SELECT question_ids FROM {$quizes_table} WHERE id = {$quiz_id};";
$results = $wpdb->get_var( $sql);

$sql = "SELECT * FROM {$quizes_table} WHERE id =". $quiz_id;
$quiz = $wpdb->get_row( $sql, 'ARRAY_A' );

$quiz_trash_status = (isset( $quiz['published'] ) && absint( $quiz['published'] ) == 2 ) ? true : false;

$user_id = get_current_user_id();
$author_id = intval( $quiz['author_id'] );
$owner = false;
if( $user_id == $author_id ){
    $owner = true;
}

if( $this->current_user_can_edit ){
    $owner = true;
}

if( !$owner ){
    $url = esc_url_raw( remove_query_arg( array( 'page', 'quiz', 'ays_result_tab' ) ) ) . "?page=quiz-maker-results";
    wp_redirect( $url );
}

if( $quiz_trash_status ){
    $url = esc_url_raw( remove_query_arg( array( 'page', 'quiz', 'ays_result_tab' ) ) ) . "?page=quiz-maker-results";
    wp_redirect( $url );
}

$quiz_each_results_tab                = "?page=".$this->plugin_name."-each-result&quiz=$quiz_id";
$quiz_each_not_finished_tab           = "?page=".$this->plugin_name."-not-finished-results&quiz=$quiz_id";
$quiz_each_results_statistics_tab     = "?page=".$this->plugin_name."-each-result-statistics&quiz=$quiz_id";
$quiz_each_results_questions_tab      = "?page=".$this->plugin_name."-each-result-questions&quiz=$quiz_id";
$quiz_each_results_quest_cat_stat_tab = "?page=".$this->plugin_name."-each-result-question-category-statistics&quiz=$quiz_id";
$quiz_each_results_leaderboard_tab    = "?page=".$this->plugin_name."-each-result-leaderboard&quiz=$quiz_id";
$quiz_each_results_reviews_tab        = "?page=".$this->plugin_name."-all-reviews&quiz=$quiz_id";

$questions_ids = array();
$questions_counts = array();
$questions_list = array();
if($results != ''){
    $sql = "SELECT id, question FROM {$quizes_questions_table} WHERE id IN ({$results});";
    $test = $wpdb->get_results($sql, "ARRAY_A");
    foreach($test as $k => $v){
        $questions_list[$v['id']] = $v['question'];
        $questions_ids[$v['id']] = 0;
        $questions_counts[$v['id']] = 0;
    }

    $results = explode("," , $results);
    $questions_ids = Quiz_Maker_Data::sort_array_keys_by_array_for_id_keys( $questions_ids, $results );
}

$quizes_reports_table = $wpdb->prefix . 'aysquiz_reports';
$sql = "SELECT options FROM {$quizes_reports_table} WHERE quiz_id ={$quiz_id} AND `status` = 'finished';";
$report = $wpdb->get_results( $sql, ARRAY_A );
if(! empty($report)){
    foreach ($report as $key){
        $report = json_decode($key["options"]);
        $questions = isset( $report->correctness ) ? $report->correctness : array();
        if ( is_object( $questions ) && !empty( $questions ) ) {
            foreach ($questions as $i => $v){
                $q = (int) substr($i,12);
                if(isset($questions_ids[$q])) {
                    if ($v) {
                        $questions_ids[$q]++;
                    }

                    $questions_counts[$q]++;
                }
            }
        }
    }
}

$quiz_export_questions_statistics_nonce = wp_create_nonce( 'quiz-maker-export-questions-statistics-nonce' );

?>

<div class="wrap ays-quiz-list-table ays_each_results_table">
    <div class="ays-quiz-heading-box">
        <div class="ays-quiz-wordpress-user-manual-box">
            <a href="https://quiz-plugin.com/docs/" target="_blank">
                <i class="ays_fa ays_fa_file_text" ></i> 
                <span style="margin-left: 3px;text-decoration: underline;"><?php echo __("View Documentation", "quiz-maker"); ?></span>
            </a>
        </div>
    </div>
    <h1 class="wp-heading-inline" style="padding-left:15px;">
        <?php
        echo sprintf( '<a href="?page=%s" class="go_back"><span><i class="fa fa-long-arrow-left" aria-hidden="true"></i> %s</span></a>', $this->plugin_name."-results", __("Back to results", $this->plugin_name) );
        ?>
    </h1>
    <div style="display: flex; justify-content: space-between;">
        <h1 class="wp-heading-inline" style="padding-left:15px;">
            <?php
            echo __("Results for", $this->plugin_name) . " \"" . __(esc_html( stripslashes( $quiz['title'] ) ), $this->plugin_name) . "\"";
            ?>
        </h1>
        <div class="question-action-butons" style="padding: 10px; display: inline-block;">
            <button type="button" class="button ays-export-answers-filters" data-type="xlsx" quiz-id="<?php echo $quiz_id ?>"><?php echo __('Export results', $this->plugin_name); ?></button>
        </div>
    </div>

    <div class="ays-top-menu-wrapper">
        <div class="ays_menu_left" data-scroll="0"><i class="ays_fa ays_fa_angle_left"></i></div>
        <div class="ays-top-menu">
            <div class="nav-tab-wrapper ays-top-tab-wrapper">
                <a href="<?php echo $quiz_each_results_tab; ?>" class="no-js nav-tab <?php echo ($tab == 'poststuff') ? 'nav-tab-active' : ''; ?>" ><?php echo __("Results", $this->plugin_name); ?></a>
                <a href="<?php echo $quiz_each_not_finished_tab; ?>" class="no-js nav-tab" ><?php echo __("Not Finished", $this->plugin_name); ?></a>
                <a href="<?php echo $quiz_each_results_statistics_tab; ?>" class="no-js nav-tab <?php echo ($tab == 'statistics') ? 'nav-tab-active' : ''; ?>"><?php echo __("Statistics", $this->plugin_name); ?></a>
                <a href="#questions" class="no-js nav-tab <?php echo ($tab == 'questions') ? 'nav-tab-active' : ''; ?>"><?php echo __("Questions", $this->plugin_name); ?></a>
                <a href="<?php echo $quiz_each_results_quest_cat_stat_tab; ?>" class="no-js nav-tab <?php echo ($tab == 'quest_cat_stat') ? 'nav-tab-active' : ''; ?>"><?php echo __("Question category statistics", $this->plugin_name); ?></a>
                <a href="<?php echo $quiz_each_results_leaderboard_tab; ?>" class="no-js nav-tab <?php echo ($tab == 'leaderboard') ? 'nav-tab-active' : ''; ?>"><?php echo __("Leaderboard", $this->plugin_name); ?></a>
                <a href="<?php echo $quiz_each_results_reviews_tab; ?>" class="no-js nav-tab <?php echo ($tab == '6') ? 'nav-tab-active' : ''; ?>"><?php echo __('Reviews',$this->plugin_name)?></a>
            </div>
        </div>
        <div class="ays_menu_right" data-scroll="-1"><i class="ays_fa ays_fa_angle_right"></i></div>
    </div>
    <div id="questions" class="ays-quiz-tab-content <?php echo ($tab == 'questions') ? 'ays-quiz-tab-content-active' : ''; ?>">
        <div class="row">
            <div class="question-action-butons" style="padding: 10px; width: 100%;">
                <button type="button" class="button button-primary ays-export-questions-statistics" data-type="xlsx" quiz-id="<?php echo $quiz_id ?>"><?php echo __('Export', $this->plugin_name); ?></button>
                <input type="hidden" id="ays_quiz_export_questions_statistics_nonce" name="ays_quiz_export_questions_statistics_nonce" value="<?php echo $quiz_export_questions_statistics_nonce; ?>">
            </div>
            <div class="col-sm-12" style="padding: 15px;">
                <table class="table table-hover table-striped ays_each_results_question_table" border="1">
                    <thead>
                    <tr>
                        <th style="width: 35%;"><span><?php echo __("Question", $this->plugin_name); ?></span></th>
                        <th style="width: 35%;"><span><?php echo __("Correctness", $this->plugin_name); ?></span></th>
                        <th style="width: 20%;"><span><?php echo __("Amount of correct", $this->plugin_name); ?></span></th>
                        <th style="width: 10%;"><span><?php echo __("ID", $this->plugin_name); ?></span></th>
                    </tr>
                    </thead>
                    <tbody>
                        <?php
                        foreach ($questions_ids as $n => $a){
                            if ($a != 0 ||  $questions_counts[$n] != 0){
                                $score = round($a/$questions_counts[$n]*100, 1);
                            }else {
                                $score = 0;
                            }

                            echo "<tr>
                                    <td><span>".stripslashes($questions_list[$n])."</span></td>
                                    <td>
                                        <div class=\"progress\">
                                          <div class=\"progress-bar progress-bar-striped progress-bar-animated bg-success\" role=\"progressbar\" style=\"width: ".$score."%\" aria-valuenow=\"25\" aria-valuemin=\"0\" aria-valuemax=\"100\">".$score."%</div>
                                        </div>
                                    </td>
                                    <td><span>".$a."/".$questions_counts[$n]."</span></td>
                                    <td><span>".$n."</span></td>
                                </tr>";
                        }
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div id="ays-results-modal" class="ays-modal">
        <div class="ays-modal-content">
            <div class="ays-quiz-preloader">
                <img class="loader" src="<?php echo AYS_QUIZ_ADMIN_URL; ?>/images/loaders/3-1.svg">
            </div>
            <div class="ays-modal-header">
                <span class="ays-close" id="ays-close-results">&times;</span>
                <h2><?php echo __("Detailed report", $this->plugin_name); ?></h2>
            </div>
            <div class="ays-modal-body" id="ays-results-body">
            </div>
        </div>
    </div>
    <div class="ays-modal" id="export-answers-filters">
        <div class="ays-modal-content">
            <div class="ays-quiz-preloader">
                <img class="loader" src="<?php echo AYS_QUIZ_ADMIN_URL; ?>/images/loaders/3-1.svg">
            </div>
          <!-- Modal Header -->
            <div class="ays-modal-header">
                <span class="ays-close">&times;</span>
                <h2><?=__('Export Filter', $this->plugin_name)?></h2>
            </div>

          <!-- Modal body -->
            <div class="ays-modal-body">
                <form method="post" id="ays_export_answers_filter">
                   <div class="filter-row">
                        <div class="filter-row-overlay display_none"></div>
                        <div class="filter-col">
                            <label for="user_id-answers-filter"><?=__("Users", $this->plugin_name)?></label>
                            <button type="button" class="ays_userid_clear button button-small wp-picker-default"><?=__("Clear", $this->plugin_name)?></button>
                            <select name="user_id-select[]" id="user_id-answers-filter" multiple="multiple"></select>
                            <input type="hidden" name="quiz_id-answers-filter" id="quiz_id-answers-filter" value="<?php echo $quiz_id; ?>">
                        </div>
                        <div class="filter-col">
                           <div style="padding: 10px;line-height:1;">
                                <input type="checkbox" name="export_answers_guests" id="export_answers_guests" value="on">
                                <label for="export_answers_guests">
                                    <span><?php echo __( "Include guests who do not have any personal data", $this->plugin_name ); ?></span>
                                </label>
                                <br>
                                <span style="font-style: italic; font-size:14px;"><?php echo __( "Include those not logged in users who have not inserted any personal data such as name and email.", $this->plugin_name ); ?></span>
                           </div>
                        </div>
                    </div>
                    <hr>
                    <div class="filter-block">
                        <div class="filter-block filter-col">
                            <label for="start-date-answers-filter"><?=__("Start Date from", $this->plugin_name)?></label>
                            <input type="date" name="start-date-filter" id="start-date-answers-filter">
                        </div>
                        <div class="filter-block filter-col">
                            <label for="end-date-answers-filter"><?=__("Start Date to", $this->plugin_name)?></label>
                            <input type="date" name="end-date-filter" id="end-date-answers-filter">
                        </div>
                    </div>
                    <hr>
                    <div class="filter-col">
                       <div style="padding: 10px;line-height:1;">
                            <input type="checkbox" name="export_answers_only_guests" id="export_answers_only_guests" value="on">
                            <label for="export_answers_only_guests">
                                <span><?php echo __( "Export only guests results", $this->plugin_name ); ?></span>
                            </label>
                            <br>
                            <span style="font-style: italic; font-size:14px;"><?php echo __( "Please note that if this checkbox is ticked, the above filters (except dates) will not be applied.", $this->plugin_name ); ?></span>
                       </div>
                    </div>
                </form>
            </div>

          <!-- Modal footer -->
            <div class="ays-modal-footer">
                <div class="export_results_count">
                    <p><?php echo __( "Matched", $this->plugin_name ); ?> <span></span> <?php echo __( "results", $this->plugin_name ); ?></p>
                </div>
                <span><?php echo __('Export to', $this->plugin_name); ?></span>
                <button type="button" class="button button-primary export-anwers-action" data-type="xlsx" quiz-id="<?php echo $quiz_id; ?>"><?=__('XLSX', $this->plugin_name)?></button>
                <a download="" id="downloadFile" hidden href=""></a>
            </div>

        </div>
    </div>

</div>