<?php
namespace WGL_Extensions\Includes;

defined('ABSPATH') || exit;

use Elementor\{
    Controls_Manager
};
use WGL_Framework;

if (!class_exists('WGL_Cursor')) {
    /**
     * WGL Elementor Media Settings
     *
     *
     * @package bili-core\includes\elementor
     * @author WebGeniusLab <webgeniuslab@gmail.com>
     * @since 1.0.0
     * @version 1.0.0
     */
    class WGL_Cursor
    {
        private static $instance;

        public function build($self, $atts)
        {
            return (new WGL_Cursor_Builder())->build($self, $atts);
        }

        /**
         * @since 1.0.0
         * @version 1.0.0
         */
        public static function init($self, $attrs = [])
        {

            // Variables validation
            $section = $attrs['section'] ?? true;

            if ($section) {
                $self->start_controls_section(
                    'add_cursor_tooltip_section',
                    [
                        'label' => esc_html__('Cursor Tooltip', 'bili-core'),
                        'condition' => $attrs['condition'] ?? [],
                    ]
                );
            }

            $self->add_control(
                'cursor_tooltip',
                [
                    'label' => esc_html__('Cursor Tooltip', 'bili-core'),
                    'type' => Controls_Manager::SWITCHER,
                    'condition' => ($attrs['condition'] ?? []),
                ]
            );

            $self->add_control(
                'cursor_tooltip_type',
                [
                    'label' => esc_html__('Tooltip Type', 'bili-core'),
                    'type' => Controls_Manager::SELECT,
                    'options' => [
                        'simple' => esc_html__('Simple', 'bili-core'),
                        'def' => esc_html__('Default Text', 'bili-core'),
                        'custom' => esc_html__('Custom Text', 'bili-core'),
                        'image' => esc_html__('Image', 'bili-core'),
                    ],
                    'default' => 'simple',
                    'condition' => ['cursor_tooltip' => 'yes'] + ($attrs['condition'] ?? []),
                ]
            );

            $self->add_control(
                'cursor_color_bg',
                [
                    'label' => esc_html__('Background Color', 'bili-core'),
                    'type' => Controls_Manager::COLOR,
                    'dynamic' => ['active' => true],
                    'condition' => [
                        'cursor_tooltip_type' => 'simple',
                        'cursor_tooltip' => 'yes'
                    ] + ($attrs['condition'] ?? []),
                ]
            );

            $self->add_control(
                'tooltip_text',
                [
                    'label' => esc_html__('Tooltip Text', 'bili-core'),
                    'type' => Controls_Manager::TEXT,
                    'condition' => [
                        'cursor_tooltip_type' => 'custom',
                        'cursor_tooltip' => 'yes'
                    ] + ($attrs['condition'] ?? []),
                    'default' => esc_html__('VIEW MORE​', 'bili-core'),
                    'label_block' => true,
                ]
            );

            $self->add_control(
                'cursor_thumbnail',
                [
                    'label' => esc_html__('Thumbnail', 'bili-core'),
                    'type' => Controls_Manager::MEDIA,
                    'label_block' => true,
                    'condition' => [
                        'cursor_tooltip_type' => 'image',
                        'cursor_tooltip' => 'yes'
                    ] + ($attrs['condition'] ?? []),
                ]
            );

            $self->add_control(
                'tooltip_color_bg',
                [
                    'label' => esc_html__('Tooltip Background Color', 'bili-core'),
                    'type' => Controls_Manager::COLOR,
                    'dynamic' => ['active' => true],
                    'condition' => [
                        'cursor_tooltip_type!' => 'simple',
                        'cursor_tooltip' => 'yes'
                    ] + ($attrs['condition'] ?? []),
                ]
            );

            $self->add_control(
                'tooltip_color',
                [
                    'label' => esc_html__('Tooltip Text Color', 'bili-core'),
                    'type' => Controls_Manager::COLOR,
                    'dynamic' => ['active' => true],
                    'condition' => [
                        'cursor_tooltip_type' => ['def', 'custom'],
                        'cursor_tooltip' => 'yes'
                    ] + ($attrs['condition'] ?? []),
                ]
            );

            $self->add_control(
                'tooltip_size',
                [
                    'label' => esc_html__('Font Size', 'bili-core'),
                    'type' => Controls_Manager::SLIDER,
                    'size_units' => ['px'],
                    'range' => [
                        'px' => ['min' => 6, 'max' => 50],
                    ],
                    'condition' => [
                        'cursor_tooltip_type' => ['def', 'custom'],
                        'cursor_tooltip' => 'yes'
                    ] + ($attrs['condition'] ?? []),
                ]
            );

            // NOTICE
            $self->add_control(
                'cursor_tooltip_notice',
                [
                    'type' => Controls_Manager::RAW_HTML,
                    'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
                    'raw' => esc_html__('Cursor Tooltip will only work if Cursor Pointer is turned ON in Theme Options.', 'bili-core'),
                    'condition' => ($attrs['condition'] ?? []),
                ]
            );

            if (!empty($attrs['output'])) {
                foreach ($attrs['output'] as $key => $value) {
                    $self->add_control(
                        $key,
                        $value
                    );
                }
            }

            if ($section) {
                $self->end_controls_section();
            }
        }

        public static function get_instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }
    }

    new WGL_Cursor();
}

if (!class_exists('WGL_Cursor_Builder')) {
    /**
     * WGL Cursor Build
     *
     *
     * @package bili-core\includes\elementor
     * @author WebGeniusLab <webgeniuslab@gmail.com>
     * @since 1.0.0
     * @version 1.0.0
     */
    class WGL_Cursor_Builder
    {
        private static $instance;

        /**
         * @since 1.0.0
         * @version 1.0.0
         */
        public function build($self, $atts)
        {

            $cursor_tooltip = isset($atts['cursor_tooltip']) ? $atts['cursor_tooltip'] : false;

            if (!$cursor_tooltip) {
                // Bailout.
                return '';
            }

            switch ($atts['cursor_tooltip_type']) {
                case 'image':
                    $cursor_image = isset($atts['cursor_thumbnail']['url']) && !empty($atts['cursor_thumbnail']['url']) ? '<img src=\'' . esc_url($atts['cursor_thumbnail']['url']) . '\' alt=\'' . ($atts['cursor_thumbnail']['alt'] ?? '1') . '\'>' : '';
                    break;

                case 'custom':
                    $cursor_text = $atts['tooltip_text'] ? $atts['tooltip_text'] : '';
                    break;

                case 'def':
                    $cursor_text = esc_attr__('VIEW MORE', 'bili-core');
                    break;

                case 'simple':
                    $cursor_color = $atts['cursor_color_bg'] ? $atts['cursor_color_bg'] : '';
                    break;

                default:
                    $cursor_text = $cursor_image = $cursor_color = '';
                    break;
            }
            $cursor_text_data = !empty($cursor_text) ? ' data-cursor-text="' . esc_attr($cursor_text) . '"' : '';
            $cursor_image_data = !empty($cursor_image) ? ' data-cursor-image="' . esc_attr($cursor_image) . '"' : '';
            $cursor_color_bg = !empty($cursor_color) ? ' data-cursor-color-bg="' . esc_attr($cursor_color) . '"' : '';
            $cursor_text_color = $atts['tooltip_color'] ? ' data-cursor-text-color="' . esc_attr($atts['tooltip_color']) . '"' : '';
            $cursor_text_color_bg = $atts['tooltip_color_bg'] ? ' data-cursor-text-color-bg="' . esc_attr($atts['tooltip_color_bg']) . '"' : '';
            $cursor_text_size = isset($atts['tooltip_size']['size']) && !empty($atts['tooltip_size']['size']) ? ' data-cursor-text-size="' . esc_attr($atts['tooltip_size']['size']) . '"' : '';

            $output = $cursor_color_bg . $cursor_text_data . $cursor_image_data . $cursor_text_color . $cursor_text_color_bg . $cursor_text_size;

            return $output;
        }

        public static function get_instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }
    }
}
