<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/templates/wgl-button.php`.
 */
namespace WGL_Extensions\Templates;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use WGL_Extensions\{
    Includes\WGL_Cursor,
    Includes\WGL_Icons
};

if ( ! class_exists( 'WGL_Button' ) ) {
    /**
     * WGL Elementor Button Template
     *
     *
     * @package bili-core\includes\elementor
     * @author WebGeniusLab <webgeniuslab@gmail.com>
     * @since 1.0.0
     */
    class WGL_Button
    {
        public function render( $self, $settings )
        {

            $cursor = new WGL_Cursor;
            $cursor_data = $cursor->build($self, $settings);

            if (isset($settings['cursor_tooltip']) && '' != $settings['cursor_tooltip']) {
                add_filter( 'wgl/bili_module_cursor', function () { return true; });
            }

            $self->add_render_attribute([
                'wrapper' => [
                    'class' => [
                        'wgl-button',
                        ! empty( $settings[ 'size' ] ) ? 'btn-size-' . $settings[ 'size' ] : '',
                        ( isset($settings['cursor_tooltip']) && !empty($settings['cursor_tooltip']) ? ' wgl-cursor-text' : '' )
                    ],
                    'role' => 'button'
                ],
                'content' => [
                    'class' => [
                        'button__content',
                        ! empty( $settings[ 'icon_align' ] ) ? 'align-icon-' . $settings[ 'icon_align' ] : '',
                    ],
                ],
                'text' => [
                    'class' => 'button__text',
                ],
            ] );
            if ( ! empty( $settings[ 'hover_animation' ] ) ) {
                $self->add_render_attribute( 'wrapper', 'class', 'elementor-animation-' . $settings[ 'hover_animation' ] );
                $settings[ 'hover_animation' ] = ''; // clear hover_animation for image
            }

            if ( ! empty( $settings[ 'link' ][ 'url' ] ) ) {
                $self->add_link_attributes( 'wrapper', $settings[ 'link' ] );
            }

            $media_prefix = $settings[ 'media_prefix' ] ?? '';

            // Render
            echo '<a  ', $self->get_render_attribute_string( 'wrapper' ), $cursor_data, '>';

            if (
                ! empty( $settings[ 'text' ] )
                || ! empty( $settings[ $media_prefix . 'icon_type' ] )
            ) {
                echo '<div ', $self->get_render_attribute_string( 'content' ), '>';

                if ( ! empty( $settings[ $media_prefix . 'icon_type' ] ) ) {
                    echo ( new WGL_Icons )->build( $self, $settings, $media_prefix );
                }

                echo '<span ', $self->get_render_attribute_string( 'text' ), '>',
                    $settings[ 'text' ],
                '</span>';

                echo '</div>';
            }

            if(isset($settings['highlight_animation']) && $settings['highlight_animation']){
                echo '<svg class="highlight_svg" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 582.6 372.1" preserveAspectRatio="none"><path d="M272.4,78.5c137.7-24.2,257.7,4.4,268.1,63.8s-92.7,127.1-230.4,151.3 C172.5,317.8,52.5,289.2,42,229.8S134.8,102.7,272.4,78.5z"/><path d="M251.9,84.2c130.3-50.5,253.7-45.8,275.4,10.4c21.8,56.2-66.2,142.7-196.6,193.2 S77.1,333.7,55.3,277.5S121.5,134.7,251.9,84.2z"/></svg>';
            }

            echo '</a>';
        }
    }
}
