<?php
/**
 * This template can be overridden by copying it to `yourtheme[-child]/bili-core/elementor/widgets/wgl-countdown.php`.
 */
namespace WGL_Extensions\Widgets;

defined('ABSPATH') || exit; // Abort, if called directly.

use Elementor\{
	Widget_Base,
	Controls_Manager,
	Group_Control_Typography
};
use WGL_Extensions\{
	WGL_Framework_Global_Variables as WGL_Globals,
	Templates\WGLCountDown
};

class WGL_CountDown extends Widget_Base
{
	public function get_name()
	{
		return 'wgl-countdown';
	}

	public function get_title()
	{
		return esc_html__('WGL Countdown Timer', 'bili-core');
	}

	public function get_icon()
	{
		return 'wgl-countdown';
	}

	public function get_categories()
	{
		return ['wgl-modules'];
	}

	public function get_script_depends()
	{
		return [
			'jquery-countdown',
			'wgl-widgets',
		];
	}

	protected function register_controls()
	{

		/*-----------------------------------------------------------------------------------*/
		/*  CONTENT -> GENERAL
		/*-----------------------------------------------------------------------------------*/

		$this->start_controls_section(
			'section_content_general',
			['label' => esc_html__('General', 'bili-core')]
		);

		$this->add_control(
			'h_tip',
			[
				'label' => esc_html__('Choose the specific date:', 'bili-core'),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'countdown_year',
			[
				'label' => esc_html__('Year', 'bili-core'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('Example: 2022', 'bili-core'),
				'default' => esc_html__('2022', 'bili-core'),
			]
		);

		$this->add_control(
			'countdown_month',
			[
				'label' => esc_html__('Month', 'bili-core'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('Example: 12', 'bili-core'),
				'default' => esc_html__('12', 'bili-core'),
			]
		);

		$this->add_control(
			'countdown_day',
			[
				'label' => esc_html__('Day', 'bili-core'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('Example: 31', 'bili-core'),
				'default' => esc_html__('31', 'bili-core'),
			]
		);

		$this->add_control(
			'countdown_hours',
			[
				'label' => esc_html__('Hours', 'bili-core'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('Example: 24', 'bili-core'),
				'default' => esc_html__('24', 'bili-core'),
			]
		);

		$this->add_control(
			'countdown_min',
			[
				'label' => esc_html__('Minutes', 'bili-core'),
				'type' => Controls_Manager::TEXT,
				'placeholder' => esc_html__('Example: 59', 'bili-core'),
				'default' => esc_html__('59', 'bili-core'),
			]
		);

		$this->add_responsive_control(
			'alignment',
			[
				'label' => esc_html__('Alignment', 'bili-core'),
				'type' => Controls_Manager::CHOOSE,
				'separator' => 'before',
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'bili-core'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'bili-core'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'bili-core'),
						'icon' => 'eicon-text-align-right',
					],
					'justify' => [
						'title' => esc_html__('Full Width', 'bili-core'),
						'icon' => 'eicon-text-align-justify',
					],
				],
                'description' => esc_html__('Too large a font size can affect alignment', 'bili-core'),
                'default' => 'center',
				'prefix_class' => 'a%s',
			]
		);

		$this->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*  CONTENT -> CONTENT
		/*-----------------------------------------------------------------------------------*/

		$this->start_controls_section(
			'section_content_content',
			[ 'label' => esc_html__('Content', 'bili-core') ]
		);

		$this->add_control(
			'show_value_names',
			[
				'label' => esc_html__('Show Title?', 'bili-core'),
				'type' => Controls_Manager::SWITCHER,
				'prefix_class' => 'show_title_',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'show_separating',
			[
				'label' => esc_html__('Show Separating Dots?', 'bili-core'),
				'type' => Controls_Manager::SWITCHER,
				'default' => 'yes',
				'selectors' => [
					'{{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:before,
                	 {{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:after' => 'visibility: visible;'
				]
			]
		);

		$this->add_control(
			'hide_day',
			[
				'label' => esc_html__('Hide Days?', 'bili-core'),
				'type' => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'hide_hours',
			[
				'label' => esc_html__('Hide Hours?', 'bili-core'),
				'type' => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'hide_minutes',
			[
				'label' => esc_html__('Hide Minutes?', 'bili-core'),
				'type' => Controls_Manager::SWITCHER,
			]
		);

		$this->add_control(
			'hide_seconds',
			[
				'label' => esc_html__('Hide Seconds?', 'bili-core'),
				'type' => Controls_Manager::SWITCHER,
			]
		);

		$this->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*  STYLE -> SECTION
		/*-----------------------------------------------------------------------------------*/

		$this->start_controls_section(
			'countdown_style_section',
			[
				'label' => esc_html__('Section', 'bili-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'countdown_section_padding',
			[
				'label' => esc_html__('Padding', 'bili-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', 'em'],
				'default' => [
					'top' => '0',
					'right' => '0.6',
					'bottom' => '0',
					'left' => '0.6',
					'unit' => 'em',
					'isLinked' => false
				],
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-section' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'general_font_size',
			[
				'label' => esc_html__('Font Size', 'bili-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 12,
						'max' => 200,
					],
					'vw' => [
						'min' => 1,
						'max' => 20,
					],
				],
				'size_units' => ['px', 'vw'],
				'default' => [
					'size' => 110,
					'unit' => 'px',
				],
				'tablet_extra_default' => [
					'size' => 80,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 70,
					'unit' => 'px',
				],
				'mobile_extra_default' => [
					'size' => 56,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 6,
					'unit' => 'vw',
				],
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*  STYLE -> NUMBERS
		/*-----------------------------------------------------------------------------------*/

		$this->start_controls_section(
			'countdown_style_numbers',
			[
				'label' => esc_html__('Numbers', 'bili-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'bili-core'),
				'name' => 'custom_fonts_number',
				'selector' => '{{WRAPPER}} .wgl-countdown .countdown-amount',
			]
		);

		$this->add_control(
			'number_color_idle',
			[
				'label' => esc_html__('Text Color', 'bili-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-amount' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'number_bg_idle',
			[
				'label' => esc_html__('Background Color', 'bili-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-amount' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'number_width',
			[
				'label' => esc_html__('Min Width', 'bili-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 20,
						'max' => 400,
					],
					'em' => [
						'min' => 1,
						'max' => 3,
						'step' => 0.1,
					],
				],
				'default' => [
					'size' => 1.3,
					'unit' => 'em',
				],
				'condition' => ['alignment!' => 'justify'],
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-amount' => 'min-width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'number_padding',
			[
				'label' => esc_html__('Padding', 'bili-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'separator' => 'before',
				'size_units' => ['px', 'em'],
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-amount' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*  STYLE -> TITLES
		/*-----------------------------------------------------------------------------------*/

		$this->start_controls_section(
			'section_style_titles',
			[
				'label' => esc_html__('Titles', 'bili-core'),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label' => esc_html__('Typography', 'bili-core'),
				'name' => 'custom_fonts_titles',
				'selector' => '{{WRAPPER}} .wgl-countdown .countdown-period',
			]
		);

		$this->add_responsive_control(
			'titles_alignment',
			[
				'label' => esc_html__('Alignment', 'bili-core'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'bili-core'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'bili-core'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'bili-core'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'center',
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-period' => 'text-align: {{VALUE}};',
				],
			]
		);

		$this->add_responsive_control(
			'titles_padding',
			[
				'label' => esc_html__('Padding', 'bili-core'),
				'type' => Controls_Manager::DIMENSIONS,
				'size_units' => ['px', '%'],
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-period' => 'padding-right: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'titles_color_idle',
			[
				'label' => esc_html__('Text Color', 'bili-core'),
				'type' => Controls_Manager::COLOR,
				'default' => '#C4C4C4',
				'selectors' => [
					'{{WRAPPER}} .wgl-countdown .countdown-period' => 'color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		/*-----------------------------------------------------------------------------------*/
		/*  STYLE -> DOTS
		/*-----------------------------------------------------------------------------------*/

		$this->start_controls_section(
			'section_style_dots',
			[
				'label' => esc_html__('Dots', 'bili-core'),
				'tab' => Controls_Manager::TAB_STYLE,
				'condition' => ['show_separating!' => ''],
			]
		);

		$this->add_control(
			'dots_color_idle',
			[
				'label' => esc_html__('Dots Color', 'bili-core'),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:before,
					 {{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:after' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'dots_shape',
			[
				'label' => esc_html__('Dots Shape', 'bili-core'),
				'type' => Controls_Manager::SELECT,
				'options' => [
					'font' => esc_html__('Current Font', 'bili-core'),
					'circle' => esc_html__('Circle', 'bili-core'),
					'square' => esc_html__('Rhombus', 'bili-core'),
					'rectangle' => esc_html__('Rectangle', 'bili-core'),
				],
				'default' => 'circle',
				'prefix_class' => 'dots_style-',
			]
		);


		$this->add_responsive_control(
			'dots_size',
			[
				'label' => esc_html__('Dots Size', 'bili-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 1,
						'max' => 30,
					],
				],
				'condition' => ['dots_shape!' => ['font', 'rectangle']],
				'default' => [
					'size' => 10,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 8,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 3,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:before,
					 {{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:after' => 'width: {{SIZE}}{{UNIT}};height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'dots_width',
			[
				'label' => esc_html__('Dots Width', 'bili-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => ['min' => 1, 'max' => 30 ]
				],
				'condition' => ['dots_shape' => 'rectangle'],
				'default' => [
					'size' => 10,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 4,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 2,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:before,
					 {{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:after' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'dots_height',
			[
				'label' => esc_html__('Dots Height', 'bili-core'),
				'type' => Controls_Manager::SLIDER,
				'size_units' => ['px'],
				'range' => [
					'px' => ['min' => 1, 'max' => 30 ]
				],
				'default' => [
					'size' => 8,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 10,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 5,
					'unit' => 'px',
				],
				'condition' => ['dots_shape' => 'rectangle'],
				'selectors' => [
					'{{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:before,
					 {{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:after' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'dots_interval',
			[
				'label' => esc_html__('Dots Interval', 'bili-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'px' => [
						'min' => 0,
						'max' => 100,
					],
				],
				'condition' => ['dots_shape!' => 'font'],
				'default' => [
					'size' => 30,
					'unit' => 'px',
				],
				'tablet_default' => [
					'size' => 15,
					'unit' => 'px',
				],
				'mobile_default' => [
					'size' => 7,
					'unit' => 'px',
				],
				'selectors' => [
					'{{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:after' => 'margin-top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'dots_v_position',
			[
				'label' => esc_html__('Dots Vertical Position', 'bili-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'%' => [ 'min' => 0, 'max' => 100 ],
					'px' => [ 'min' => 0, 'max' => 100 ],
				],
				'condition' => ['dots_shape!' => 'font'],
				'default' => [
					'size' => 25,
					'unit' => '%',
				],
				'tablet_default' => [
					'size' => 24,
					'unit' => '%',
				],
				'mobile_default' => [
					'size' => 15,
					'unit' => '%',
				],
				'selectors' => [
					'{{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:before,
					 {{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:after' => 'top: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'dots_h_position',
			[
				'label' => esc_html__('Dots Horizontal Position', 'bili-core'),
				'type' => Controls_Manager::SLIDER,
				'range' => [
					'%' => [ 'min' => -100, 'max' => 100 ],
					'px' => [ 'min' => -100, 'max' => 100 ],
				],
				'condition' => ['dots_shape!' => 'font'],
				'selectors' => [
					'{{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:before,
					 {{WRAPPER}} .countdown-section:not(:last-child) .countdown-amount:after' => 'right: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
	}

	protected function render()
	{
		$atts = $this->get_settings_for_display();

		$countdown = new WGLCountDown();
		$countdown->render($this, $atts);
	}

	public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
