<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/widgets/wgl-portfolio.php`.
 */
namespace WGL_Extensions\Widgets;

defined('ABSPATH') || exit; // Abort, if called directly.

use Elementor\{
    Widget_Base,
    Controls_Manager,
    Group_Control_Border,
    Group_Control_Typography,
    Group_Control_Background,
    Group_Control_Box_Shadow,
    Utils
};
use WGL_Extensions\{
    Includes\WGL_Loop_Settings,
    Includes\WGL_Carousel_Settings,
    Templates\WGL_Portfolio as Portfolio_Template
};

class WGL_Portfolio extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-portfolio';
    }

    public function get_title()
    {
        return esc_html__('WGL Portfolio', 'bili-core');
    }

    public function get_icon()
    {
        return 'wgl-portfolio';
    }

    public function get_categories()
    {
        return ['wgl-modules'];
    }

    public function get_script_depends()
    {
        return [
            'swiper',
            'imagesloaded',
            'isotope',
            'wgl-widgets',
        ];
    }

    protected function register_controls()
    {
        /**
         * CONTENT -> GENERAL
         */

        $this->start_controls_section(
            'content_general',
            ['label' => esc_html__('General', 'bili-core')]
        );

        $this->add_control(
            'portfolio_title',
            [
                'label' => esc_html__('Title', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'portfolio_subtitle',
            [
                'label' => esc_html__('Subitle', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
                'separator' => 'after',
                'label_block' => true,
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'bili-core'),
                'type' => 'wgl-radio-image',
                'options' => [
                    'grid' => [
                        'title' => esc_html__('Grid', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/layout_grid.png',
                    ],
                    'carousel' => [
                        'title' => esc_html__('Carousel', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/layout_carousel.png',
                    ],
                    'masonry-1' => [
                        'title' => esc_html__('Masonry 1', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/layout_masonry.png',
                    ],
                    'masonry-2' => [
                        'title' => esc_html__('Masonry 2', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/layout_masonry_2.png',
                    ],
                    'masonry-3' => [
                        'title' => esc_html__('Masonry 3', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/layout_masonry_3.png',
                    ],
                    'masonry-4' => [
                        'title' => esc_html__('Masonry 4', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/layout_masonry_4.png',
                    ],
                ],
                'default' => 'grid',
            ]
        );

        $this->add_control(
            'posts_per_row',
            [
                'label' => esc_html__('Columns Amount', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'layout' => ['grid', 'masonry-1', 'carousel']
                ],
                'options' => [
                    1 => esc_html__('1 (one)', 'bili-core'),
                    2 => esc_html__('2 (two)', 'bili-core'),
                    3 => esc_html__('3 (three)', 'bili-core'),
                    4 => esc_html__('4 (four)', 'bili-core'),
                    5 => esc_html__('5 (five)', 'bili-core'),
                ],
                'default' => 3,
            ]
        );

	    $this->add_responsive_control(
		    'grid_gap',
		    [
			    'label' => esc_html__('Grid Gap', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => ['min' => 0, 'max' => 70, 'step' => 2],
			    ],
			    'default' => ['size' => 30],
			    'selectors' => [
				    '{{WRAPPER}} .wgl-portfolio' => '--portfolio-columns-gap: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_control(
            'show_filter',
            [
                'label' => esc_html__('Show Filter', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => ['layout!' => 'carousel'],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'filter_counter_enabled',
            [
                'label' => esc_html__('Use Filter Counter?', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [
                    'show_filter' => 'yes',
                    'layout!' => 'carousel'
                ],
                'default' => 'yes',
            ]
        );

	    $this->add_control(
            'filter_max_width_enabled',
            [
                'label' => esc_html__('Limit the Filter Container Width', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => [
                    'show_filter' => 'yes',
                    'layout!' => 'carousel'
                ],
            ]
        );

        $this->add_control(
            'filter_max_width',
            [
                'label' => esc_html__('Filter Container Max Width (px)', 'bili-core'),
                'type' => Controls_Manager::NUMBER,
                'condition' => [
                    'show_filter' => 'yes',
                    'filter_max_width_enabled' => 'yes',
                    'layout!' => 'carousel'
                ],
                'default' => '1170',
                'selectors' => [
                    '{{WRAPPER}} .wgl-portfolio_header' => 'max-width: {{VALUE}}px; overflow: hidden; margin-left: auto; margin-right: auto;',
                ],
            ]
        );

	    $this->add_control(
		    'filter_alignment',
		    [
			    'label' => esc_html__('Filter Align', 'bili-core'),
			    'type' => Controls_Manager::SELECT,
			    'condition' => [
				    'show_filter' => 'yes',
                    'layout!' => 'carousel'
			    ],
			    'options' => [
				    'left' => esc_html__('Left', 'bili-core'),
				    'center' => esc_html__('Сenter', 'bili-core'),
				    'right' => esc_html__('Right', 'bili-core'),
			    ],
			    'default' => 'center',
		    ]
	    );

        $this->add_control(
            'img_size_string',
            [
                'label' => esc_html__('Image Size', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'layout' => ['grid', 'carousel', 'masonry-1']
                ],
                'separator' => 'before',
                'options' => [
                    '150' => esc_html__('150x150 - Thumbnail', 'bili-core'),
                    '300' => esc_html__('300x300 - Medium', 'bili-core'),
                    '1024' => esc_html__('1024x1024 - Large', 'bili-core'),
                    '1140x840' => esc_html__('1140x840 - 2 Columns', 'bili-core'),
                    '740x740' => esc_html__('740x740 - 3 Columns', 'bili-core'),
                    '886' => esc_html__('886x886 - 4 Columns Wide', 'bili-core'),
                    'full' => esc_html__('Full', 'bili-core'),
                    'custom' => esc_html__('Custom', 'bili-core'),
                ],
                'default' => '740x740',
            ]
        );

        $this->add_control(
            'img_size_array',
            [
                'label' => esc_html__('Image Dimension', 'bili-core'),
                'type' => Controls_Manager::IMAGE_DIMENSIONS,
                'condition' => [
                    'img_size_string' => 'custom',
                    'layout' => ['grid', 'carousel', 'masonry-1'],
                ],
                'description' => esc_html__('Crop the original image to any custom size. You can also set a single value for width to keep the initial ratio.', 'bili-core'),
                'default' => [
                    'width' => '740',
                    'height' => '740',
                ],
            ]
        );

        $this->add_control(
            'img_aspect_ratio',
            [
                'label' => esc_html__('Image Aspect Ratio', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'layout' => ['grid', 'carousel', 'masonry-1'],
                    'img_size_string!' => 'custom',
                ],
                'options' => [
                    '' => esc_html__('No Crop', 'bili-core'),
                    '1:1' => esc_html('1:1'),
                    '3:2' => esc_html('3:2'),
                    '4:3' => esc_html('4:3'),
                    '6:5' => esc_html('6:5'),
                    '9:16' => esc_html('9:16'),
                    '16:9' => esc_html('16:9'),
                    '21:9' => esc_html('21:9'),
                    '10:7,1:1' => esc_html__('Chess Type ( 10:7 / 1:1 )', 'bili-core'),
                    '1:1,10:7' => esc_html__('Chess Type ( 1:1 / 10:7 )', 'bili-core'),
                ],
                'default' => '',
            ]
        );

        $this->add_control(
            'remainings_loading_type',
            [
                'label' => esc_html__('Remaining Posts Loading Type', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => ['layout!' => 'carousel'],
                'separator' => 'before',
                'options' => [
                    'none' => esc_html__('None', 'bili-core'),
                    'pagination' => esc_html__('Pagination', 'bili-core'),
                    'infinite' => esc_html__('Infinite Scroll', 'bili-core'),
                    'load_more' => esc_html__('Load More', 'bili-core'),
                ],
                'default' => 'none',
            ]
        );

        $this->add_control(
            'remainings_loading_alignment',
            [
                'label' => esc_html__('Alignment', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'condition' => ['remainings_loading_type' => 'pagination'],
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'bili-core'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'bili-core'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'bili-core'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .wgl-pagination' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'remainings_loading_pagination_offset',
            [
                'label' => esc_html__('Margin Top', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'condition' => ['remainings_loading_type' => 'pagination'],
                'range' => [
                    'px' => ['min' => -150, 'max' => 500],
                ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-pagination' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'remainings_loading_btn_items_amount',
            [
                'label' => esc_html__('Items to be loaded', 'bili-core'),
                'type' => Controls_Manager::NUMBER,
                'condition' => [
                    'layout!' => 'carousel',
                    'remainings_loading_type' => ['load_more', 'infinite'],
                ],
                'min' => 1,
                'default' => 4,
            ]
        );

        $this->add_control(
            'load_more_text',
            [
                'label' => esc_html__('Button Text', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'condition' => [
                    'layout!' => 'carousel',
                    'remainings_loading_type' => 'load_more',
                ],
                'dynamic' => ['active' => true],
                'default' => esc_html__('LOAD MORE', 'bili-core'),
            ]
        );

        $this->add_control(
            'appear_animation_enabled',
            [
                'label' => esc_html__('Appear Animation', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'appear_animation_style',
            [
                'label' => esc_html__('Animation Style', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => ['appear_animation_enabled!' => ''],
                'options' => [
                    'fade-in' => esc_html__('Fade In', 'bili-core'),
                    'slide-top' => esc_html__('Slide Top', 'bili-core'),
                    'slide-bottom' => esc_html__('Slide Bottom', 'bili-core'),
                    'slide-left' => esc_html__('Slide Left', 'bili-core'),
                    'slide-right' => esc_html__('Slide Right', 'bili-core'),
                    'zoom' => esc_html__('Zoom', 'bili-core'),
                ],
                'default' => 'fade-in',
            ]
        );

        $this->end_controls_section();

        /**
         * CONTENT -> APPEARANCE
         */

        $this->start_controls_section(
            'content_appearance',
            ['label' => esc_html__('Appearance', 'bili-core')]
        );

        $this->add_control(
            'gallery_mode_enabled',
            [
                'label' => esc_html__('Gallery Mode', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'use_additional_post',
            [
                'label' => esc_html__('Add Additional Post', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'additional_post_notice',
            [
                'type' => Controls_Manager::RAW_HTML,
                'condition' => ['use_additional_post!' => ''],
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
                'raw' => esc_html__('Additional Post item is fully cusomizible via `Style` tab.', 'bili-core'),
            ]
        );

        $this->add_control(
            'show_portfolio_title',
            [
                'label' => esc_html__('Show Heading?', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => ['gallery_mode_enabled' => ''],
                'separator' => 'before',
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_meta_categories',
            [
                'label' => esc_html__('Show Categories?', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => ['gallery_mode_enabled' => ''],
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'show_content',
            [
                'label' => esc_html__('Show Excerpt/Content?', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => ['gallery_mode_enabled' => ''],
            ]
        );

        $this->add_control(
            'content_letter_count',
            [
                'label' => esc_html__('Content Characters Amount', 'bili-core'),
                'type' => Controls_Manager::NUMBER,
                'condition' => [
                    'show_content' => 'yes',
                    'gallery_mode_enabled' => '',
                ],
                'min' => 1,
                'default' => 85,
            ]
        );

        $this->add_control(
            'description_heading',
            [
                'label' => esc_html__('Description', 'bili-core'),
                'type' => Controls_Manager::HEADING,
                'condition' => ['gallery_mode_enabled' => ''],
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'description_position',
            [
                'label' => esc_html__('Position', 'bili-core'),
                'condition' => ['gallery_mode_enabled' => ''],
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'inside_image' => esc_html__('Within Image', 'bili-core'),
                    'under_image' => esc_html__('Beneath Image', 'bili-core'),
                    'cursor_tooltip' => esc_html__('Cursor Tooltip', 'bili-core'),
                ],
                'default' => 'under_image',
            ]
        );

        $this->add_control(
            'description_animation',
            [
                'label' => esc_html__('Animation', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => [
                    'description_position' => 'inside_image',
                    'gallery_mode_enabled' => ''
                ],
                'options' => [
                    'simple' => esc_html__('Simple', 'bili-core'),
                    'sub_layer' => esc_html__('Sub-Layer', 'bili-core'),
                    'offset' => esc_html__('Side Offset', 'bili-core'),
                    'zoom_in' => esc_html__('Zoom In', 'bili-core'),
                    'outline' => esc_html__('Outline', 'bili-core'),
                    'until_hover' => esc_html__('Visible Until Hover', 'bili-core'),
                ],
                'default' => 'sub_layer',
            ]
        );

        $this->add_control(
            'description_alignment',
            [
                'label' => esc_html__('Alignment', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'condition' => [
                    'gallery_mode_enabled' => '',
                    'description_position!' => 'cursor_tooltip',
                ],
                'toggle' => false,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'bili-core'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'bili-core'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'bili-core'),
                        'icon' => 'eicon-text-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__('Justified', 'bili-core'),
                        'icon' => 'eicon-text-align-justify',
                    ],
                ],
                'default' => 'left',
                'selectors' => [
                    '{{WRAPPER}} .description__wrapper' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'description_media_type',
            [
                'label' => esc_html__('Media', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'condition' => [
                    'gallery_mode_enabled' => '',
                    'description_position!' => 'cursor_tooltip',
                ],
                'label_block' => false,
                'options' => [
                    '' => [
                        'title' => esc_html__('None', 'bili-core'),
                        'icon' => 'fa fa-ban',
                    ],
                    'font' => [
                        'title' => esc_html__('Icon', 'bili-core'),
                        'icon' => 'far fa-smile',
                    ],
                ],
            ]
        );

        $this->add_control(
            'description_icon',
            [
                'label' => esc_html__('Icon', 'bili-core'),
                'type' => Controls_Manager::ICONS,
                'condition' => [
                    'description_media_type' => 'font',
                    'gallery_mode_enabled' => '',
                    'description_position!' => 'cursor_tooltip',
                ],
                'label_block' => true,
            ]
        );

        $this->end_controls_section();

        /**
         * CONTENT -> LINKS
         */

        $this->start_controls_section(
            'content_links',
            [
                'label' => esc_html__('Links', 'bili-core'),
                'condition' => ['gallery_mode_enabled' => ''],
            ]
        );

        $this->add_control(
            'image_has_link',
            [
                'label' => esc_html__('Add link on Image', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'title_has_link',
            [
                'label' => esc_html__('Add link on Heading', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'condition' => ['show_portfolio_title!' => ''],
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'linked_icon',
            [
                'label' => esc_html__('Add link on Icon', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [
                    'description_media_type' => 'font',
                    'description_icon!' => '',
                    'gallery_mode_enabled' => '',
                ],
            ]
        );

        $this->add_control(
            'link_destination',
            [
                'label' => esc_html__('Click Action', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'title_has_link',
                            'operator' => '!==',
                            'value' => '',
                        ], [
                            'name' => 'image_has_link',
                            'operator' => '!==',
                            'value' => '',
                        ],
                    ],
                ],
                'options' => [
                    'single' => esc_html__('Open Single Page', 'bili-core'),
                    'custom' => esc_html__('Open Custom Link', 'bili-core'),
                    'popup' => esc_html__('Popup the Image', 'bili-core'),
                ],
                'default' => 'single',
            ]
        );

        $this->add_control(
            'link_custom_notice',
            [
                'type' => Controls_Manager::RAW_HTML,
                'condition' => ['link_destination' => 'custom'],
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
                'raw' => esc_html__('Note: Specify the link in metabox section of each corresponding post.', 'bili-core'),
            ]
        );

        $this->add_control(
            'link_target',
            [
                'label' => esc_html__('Open link in a new tab', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'conditions' => [
                    'terms' => [
                        [
                            'relation' => 'or',
                            'terms' => [
                                [
                                    'name' => 'title_has_link',
                                    'operator' => '!==',
                                    'value' => '',
                                ], [
                                    'name' => 'image_has_link',
                                    'operator' => '!==',
                                    'value' => '',
                                ],
                            ],
                        ],
                        [
                            'name' => 'link_destination',
                            'operator' => '!==',
                            'value' => 'popup',
                        ],
                    ],
                ],
            ]
        );

        $this->end_controls_section();

        /**
         * CONTENT -> CAROUSEL OPTIONS
         */

        $this->start_controls_section(
            'content_carousel',
            [
                'label' => esc_html__('Carousel Options', 'bili-core'),
                'condition' => ['layout' => 'carousel'],
            ]
        );

        WGL_Carousel_Settings::add_general_controls($this, [
            'slider_infinite'  => [
                'default' => 'yes'
            ],
            'slide_per_single' => [
                'default' => 1
            ],
        ]);

        $this->add_control(
            'variable_width',
            [
                'label' => esc_html__('Variable Width', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
            ]
        );

        $this->add_control(
            'chess_divider_before',
            [
                'type' => Controls_Manager::DIVIDER,
                'condition' => ['chess_layout!' => ''],
            ]
        );

        $this->add_control(
            'chess_layout',
            [
                'label' => esc_html__('Chess Layout', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'chess',
                'prefix_class' => 'layout-',
            ]
        );

        $this->add_control(
            'chess_offset',
            [
                'label' => esc_html__('Chess Offset', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'condition' => ['chess_layout!' => ''],
                'size_units' => ['px', 'rem'],
                'range' => [
                    'px' => ['min' => 1, 'max' => 300],
                    'rem' => ['min' => 0.1, 'max' => 20, 'step' => 0.1],
                ],
                'default' => ['size' => '30'],
                'selectors' => [
                    '{{WRAPPER}} .swiper-wrapper' => 'padding-top: {{SIZE}}{{UNIT}} !important;',
                    '{{WRAPPER}} .portfolio__item:nth-child(even)' => 'margin-top: -{{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'chess_notice',
            [
                'type' => Controls_Manager::RAW_HTML,
                'condition' => [
                    'autoplay!' => '',
                    'chess_layout!' => '',
                ],
                'content_classes' => 'elementor-panel-alert elementor-panel-alert-warning',
                'raw' => esc_html__('Note: even number of portfolio items is preffered.', 'bili-core'),
            ]
        );

        $this->add_control(
		    'multi_sized_layout',
		    [
			    'label' => esc_html__( 'Multi-sized Layout', 'bili-core' ),
			    'type' => Controls_Manager::SWITCHER,
			    'return_value' => 'scale',
			    'prefix_class' => 'layout-',
		    ]
	    );

	    $this->add_responsive_control(
		    'scale_size',
		    [
			    'label' => esc_html__( 'Scale Size', 'bili-core' ),
			    'type' => Controls_Manager::SLIDER,
			    'condition' => [ 'multi_sized_layout!' => '' ],
			    'size_units' => [ 'px' ],
			    'range' => [
				    'px' => [ 'min' => 0.1, 'max' => 1, 'step' => 0.01 ],
			    ],
			    'default' => [ 'size' => 0.7357 ],
			    'selectors' => [
				    '{{WRAPPER}} .portfolio__item:nth-child(even)' => '--wgl-portfolio-scale-size: {{SIZE}};',
			    ],
		    ]
	    );

        $this->add_control(
            'pagination_divider',
            [
                'type' => Controls_Manager::DIVIDER,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [[
                        'terms' => [[
                            'name' => 'chess_layout',
                            'operator' => '!=',
                            'value' => '',
                        ]]
                    ], [
                        'terms' => [[
                            'name' => 'use_pagination',
                            'operator' => '!=',
                            'value' => '',
                        ]]
                    ],],
                ],
            ]
        );

        WGL_Carousel_Settings::add_pagination_controls($this, [
            'pagination_type'  => [
                'default' => 'circle_border',
            ],
            'pagination_margin' => [
                'range' => [
                    'px' => ['min' => -60, 'max' => 1000]
                ],
            ],
        ]);

        $this->add_control(
            'pagination_navigation_divider',
            [
                'type' => Controls_Manager::DIVIDER,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [[
                        'terms' => [[
                            'name' => 'use_pagination',
                            'operator' => '!=',
                            'value' => '',
                        ]]
                    ], [
                        'terms' => [[
                            'name' => 'use_navigation',
                            'operator' => '!=',
                            'value' => '',
                        ]]
                    ],],
                ],
            ]
        );

        WGL_Carousel_Settings::add_navigation_controls($this, [
            'pagination_margin' => [
                'range' => [
                    'px' => ['min' => -60, 'max' => 1000]
                ],
            ],
        ]);

        $this->add_control(
            'navigation_responsive_divider',
            [
                'type' => Controls_Manager::DIVIDER,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [[
                        'terms' => [[
                            'name' => 'use_navigation',
                            'operator' => '!=',
                            'value' => '',
                        ]]
                    ], [
                        'terms' => [[
                            'name' => 'customize_responsive',
                            'operator' => '!=',
                            'value' => '',
                        ]]
                    ],],
                ],
            ]
        );

        WGL_Carousel_Settings::add_responsive_controls($this, [
            'desktop_slides' => [
                'label' => esc_html__('Columns amount', 'bili-core'),
                'max' => 5,
            ],
            'tablet_slides' => [
                'label' => esc_html__('Columns amount', 'bili-core'),
                'max' => 5,
            ],
            'mobile_slides' => [
                'label' => esc_html__('Columns amount', 'bili-core'),
                'max' => 5,
            ],
        ]);

        $this->end_controls_section();

        /**
         * SETTINGS -> QUERY
         */

        WGL_Loop_Settings::add_controls($this, [
            'post_type' => 'portfolio',
            'hide_cats' => true,
            'hide_tags' => true
        ]);

        /**
         * STYLE -> FILTER
         */

        $this->start_controls_section(
            'style_filter',
            [
                'label' => esc_html__('Filter', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['show_filter' => 'yes'],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'filter',
                'selector' => '{{WRAPPER}} .isotope-filter a',
            ]
        );

	    $this->add_control(
		    'filter_cats_gap',
		    [
			    'label' => esc_html__('Categories Gap', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'range' => [
				    'px' => ['min' => 0, 'max' => 100, 'step' => 2],
			    ],
			    'selectors' => [
				    '{{WRAPPER}} .isotope-filter' => '--wgl-filtet-categories-gap: {{SIZE}}px;',
			    ],
		    ]
	    );

        $this->add_responsive_control(
            'filter_cats_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'filter_cats_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'filter_cats_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('filter');

        $this->start_controls_tab(
            'filter_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'filter_color_idle',
            [
                'label' => esc_html__('Category Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a:not(.active)' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_bg_idle',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a:not(.active)' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'filter_border_idle',
                'selector' => '{{WRAPPER}} .isotope-filter a',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'filter_color_hover',
            [
                'label' => esc_html__('Category Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_counter_color_hover',
            [
                'label' => esc_html__('Counter Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['filter_counter_enabled' => 'yes'],
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a:hover .filter_counter' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_bg_hover',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'filter_border_hover',
                'selector' => '{{WRAPPER}} .isotope-filter a:hover',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'filter_active',
            ['label' => esc_html__('Active', 'bili-core')]
        );

        $this->add_control(
            'filter_color_active',
            [
                'label' => esc_html__('Category Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a.active' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_counter_color_active',
            [
                'label' => esc_html__('Counter Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['filter_counter_enabled' => 'yes'],
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a.active .filter_counter' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_extra_element_color_active',
            [
                'label' => esc_html__('Animated Element Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a:after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'filter_bg_active',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .isotope-filter a.active' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'filter_border_active',
                'selector' => '{{WRAPPER}} .isotope-filter a.active',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'filter_shadow_divider',
            ['type' => Controls_Manager::DIVIDER]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'filter_shadow',
                'selector' => '{{WRAPPER}} .isotope-filter a',
            ]
        );

        $this->end_controls_section();

        /**
         * STYLE -> MODULE TITLE
         */

        $this->start_controls_section(
            'section_style_module_title',
            [
                'label' => esc_html__('Module Title', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['portfolio_title!' => ''],
            ]
        );

        $this->add_control(
            'heading_portfolio_title',
            [
                'label' => esc_html__('Title', 'bili-core'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'module_title',
                'selector' => '{{WRAPPER}} .portfolio_title',
            ]
        );

        $this->add_control(
            'heading_portfolio_title_color',
            [
                'label' => esc_html__('Title Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .portfolio_title' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'portfolio_title_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'heading_portfolio_subtitle',
            [
                'label' => esc_html__('Subtitle', 'bili-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'module_subtitle',
                'selector' => '{{WRAPPER}} .portfolio_subtitle',
            ]
        );

        $this->add_control(
            'heading_portfolio_subtitle_color',
            [
                'label' => esc_html__('Subtitle Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .portfolio_subtitle' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'portfolio_subtitle_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio_subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         * STYLE -> OVERLAYS
         */

        $this->start_controls_section(
            'style_overlays',
            [
                'label' => esc_html__('Overlays', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $item_overlay_conditions = [
            'relation' => 'or',
            'terms' => [
                [
                    'terms' => [
                        [
                            'name' => 'description_position',
                            'operator' => '===',
                            'value' => 'inside_image',
                        ],
                        [
                            'name' => 'description_animation',
                            'operator' => '!==',
                            'value' => 'sub_layer',
                        ],
                    ],
                ],
                [
                    'name' => 'gallery_mode_enabled',
                    'operator' => '!==',
                    'value' => '',
                ],
            ],
        ];

        $this->add_control(
            'overlay_heading',
            [
                'label' => esc_html__('Items Overlay', 'bili-core'),
                'type' => Controls_Manager::HEADING,
                'conditions' => $item_overlay_conditions,
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_overlay',
                'conditions' => $item_overlay_conditions,
                'selector' => '{{WRAPPER}} .overlay',
            ]
        );

        $this->add_control(
            'outline_color',
            [
                'label' => esc_html__('Outline Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'condition' => [
                    'description_position' => 'inside_image',
                    'description_animation' => 'outline',
                ],
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .animation_outline:hover .overlay:before' => 'box-shadow: inset 0px 0px 0px 10px {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'overlay_divider',
            [
                'type' => Controls_Manager::DIVIDER,
                'conditions' => $item_overlay_conditions,
            ]
        );

        $this->add_control(
            'images_overlay_heading',
            [
                'label' => esc_html__('Images Overlay', 'bili-core'),
                'type' => Controls_Manager::HEADING,
            ]
        );

        $this->start_controls_tabs('images_overlay');

        $this->start_controls_tab(
            'img_overlay_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'images_grayscale_idle',
            [
                'label' => esc_html__('Grayscale Filter', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 0, 'max' => 1, 'step' => 0.1],
                ],
                'selectors' => [
                    '{{WRAPPER}} .item__image img' => 'filter: grayscale({{SIZE}});',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'thubmnail_overlay_idle',
                'selector' => '{{WRAPPER}} .item__image:before',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'img_overlay_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'images_grayscale_hover',
            [
                'label' => esc_html__('Grayscale Filter', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 0, 'max' => 1, 'step' => 0.1],
                ],
                'selectors' => [
                    '{{WRAPPER}} .portfolio__item:hover .item__image img' => 'filter: grayscale({{SIZE}});',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'thubmnail_overlay_hover',
                'selector' => '{{WRAPPER}} .item__image:after',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLE -> DESCRIPTIONS
         */

        $this->start_controls_section(
            'style_descriptions',
            [
                'label' => esc_html__('Descriptions', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['gallery_mode_enabled' => ''],
            ]
        );

        $this->add_responsive_control(
            'description_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .item__description' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                ],
            ]
        );

        $this->add_responsive_control(
            'description_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .item__description' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .item__description' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'description_under_img',
                'condition' => ['description_position' => 'under_image'],
                'selector' => '{{WRAPPER}} .item__description',
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'description_inside_img',
                'condition' => [
                    'description_position' => 'inside_image',
                    'description_animation' => 'sub_layer',
                ],
                'selector' => '{{WRAPPER}} .item__description',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'description_shdw',
                'condition' => [
                    'description_position' => 'inside_image',
                    'description_animation' => 'sub_layer',
                ],
                'selector' => '{{WRAPPER}} .item__description',
            ]
        );

        $this->end_controls_section();

        /**
         * STYLE -> DESCRIPTION ICONS
         */

        $this->start_controls_section(
            'style_description_icons',
            [
                'label' => esc_html__('Description Icons', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'description_media_type' => 'font',
                    'description_icon!' => '',
                    'description_position' => 'inside_image',
                    'gallery_mode_enabled' => '',
                ],
            ]
        );

        $this->add_responsive_control(
            'description_icon_size',
            [
                'label' => esc_html__('Icon Size', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 10, 'max' => 100],
                ],
                'selectors' => [
                    '{{WRAPPER}} .description__icon' => 'font-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_icon_animation',
            [
                'label' => esc_html__('Rotate on Hover', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'return_value' => 'rotate-icon',
                'default' => 'rotate-icon',
                'prefix_class' => 'animation_',
                'default' => false
            ]
        );

        $this->add_responsive_control(
            'description_icon_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .description__icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'description_icon_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .description__icon > a,
                     {{WRAPPER}} .description__icon > i' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                    '{{WRAPPER}} .description__icon svg' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'description_icon_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .description__icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'description_icon_styles',
            ['separator' => 'before']
        );

        $this->start_controls_tab(
            'description_icon_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'description_icon_color_idle',
            [
                'label' => esc_html__('Icon Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .description__icon' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .description__icon a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .description__icon svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'description_icon_bg_idle',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .description__icon' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'description_icon_border_idle',
                'selector' => '{{WRAPPER}} .description__icon',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'description_icon_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'description_icon_color_hover',
            [
                'label' => esc_html__('Icon Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .description__icon:hover,
                     {{WRAPPER}} .description__icon:hover a' => 'color: {{VALUE}}',
                    '{{WRAPPER}} .description__icon:hover svg' => 'fill: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'description_icon_bg_hover',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .description__icon:hover' => 'background-color: {{VALUE}}',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'description_icon_border_hover',
                'selector' => '{{WRAPPER}} .description__icon:hover',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLE -> HEADINGS
         */

        $this->start_controls_section(
            'style_headings',
            [
                'label' => esc_html__('Headings', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [
                    'show_portfolio_title!' => '',
                    'gallery_mode_enabled' => ''
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'headings',
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->add_responsive_control(
            'headings_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .item__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'headings',
            ['separator' => 'before']
        );

        $this->start_controls_tab(
            'headings_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'headings_color_idle',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'headings_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'headings_color_hover',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .title:hover,
                     {{WRAPPER}} .title:hover a' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLE -> CATEGORIES
         */

        $this->start_controls_section(
            'style_categories',
            [
                'label' => esc_html__('Categories', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['show_meta_categories!' => ''],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'categories',
                'selector' => '{{WRAPPER}} .portfolio-category',
            ]
        );

        $this->add_responsive_control(
            'cat_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-category' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'cat_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-category' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'categories',
            ['separator' => 'before']
        );

        $this->start_controls_tab(
            'categories_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_responsive_control(
            'cat_padding_idle',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-category' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'cat_color_idle',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-category,
                     {{WRAPPER}} .portfolio-category:after' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'cat_bg_idle',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-category' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'categories_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_responsive_control(
            'cat_padding_hover',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-category:hover' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'cat_color_hover',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-category:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'cat_bg_hover',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .portfolio-category:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLE -> EXCERPT/CONTENT
         */

        $this->start_controls_section(
            'style_excerpt',
            [
                'label' => esc_html__('Excerpt|Content', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['show_content!' => ''],
            ]
        );

        $this->add_control(
            'custom_content_color',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .description_content' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         * STYLE -> LOAD MORE BUTTON
         */

        $this->start_controls_section(
            'style_load_more',
            [
                'label' => esc_html__('Load More Button', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['remainings_loading_type' => 'load_more'],
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'load_more',
                'selector' => '{{WRAPPER}} .load_more_item',
            ]
        );

        $this->add_control(
            'load_more_alignment',
            [
                'label' => esc_html__('Alignment', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'bili-core'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'bili-core'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'bili-core'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'load_more_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'load_more_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'after',
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'load_more_btn',
            ['separator' => 'before']
        );

        $this->start_controls_tab(
            'load_more_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'load_more_color_idle',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_bg_idle',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_animated_element_color_idle',
            [
                'label' => esc_html__('Animated Element Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item:after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'load_more_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'load_more_color_hover',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_bg_hover',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more_item:hover' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_animated_element_color_hover',
            [
                'label' => esc_html__('Animated Element Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item:hover:after' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'load_more_border',
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .load_more_item',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'load_more_shadow',
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .load_more_item',
            ]
        );

        $this->add_control(
            'load_more_media_heading',
            [
                'label' => esc_html__('Media', 'bili-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'load_more_media_type',
            [
                'label' => esc_html__('Media Type', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => false,
                'options' => [
                    '' => [
                        'title' => esc_html__('None', 'bili-core'),
                        'icon' => 'fa fa-ban',
                    ],
                    'icon' => [
                        'title' => esc_html__('Icon', 'bili-core'),
                        'icon' => 'far fa-smile',
                    ],
                ],
                'default' => '',
            ]
        );

        $this->add_control(
            'load_more_media_icon',
            [
                'label' => esc_html__('Icon', 'bili-core'),
                'type' => Controls_Manager::ICONS,
                'label_block' => true,
                'condition' => ['load_more_media_type' => 'icon'],
                'default' => [
                    'library' => 'flaticon',
                    'value' => 'flaticon-plus-1',
                ],
            ]
        );

        $this->add_responsive_control(
            'load_more_icon_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => ['load_more_media_type' => 'icon'],
                'allowed_dimensions' => 'horizontal',
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 0,
                    'left' => 10,
                ],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more__icon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'load_more_icon_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => ['load_more_media_type' => 'icon'],
                'allowed_dimensions' => 'horizontal',
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more__icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_icon_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'condition' => ['load_more_media_type' => 'icon'],
                'separator' => 'after',
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .load_more_wrapper .load_more_item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'load_more_icon',
            ['condition' => ['load_more_media_type' => 'icon']]
        );

        $this->start_controls_tab(
            'load_more_icon_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'load_more_icon_color_idle',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more__icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_icon_bg_idle',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more__icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'load_more_icon_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'load_more_icon_color_hover',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item:hover .load_more__icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'load_more_icon_bg_hover',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .load_more_item:hover .load_more__icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLE -> ADDITIONAL POST
         */

        $this->start_controls_section(
            'style_additional_item',
            [
                'label' => esc_html__('Additional Post', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['use_additional_post!' => ''],
            ]
        );

        $this->add_control(
            'additional_post_position',
            [
                'label' => esc_html__('Position', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'first' => esc_html__('First Item', 'bili-core'),
                    'last' => esc_html__('Last Item', 'bili-core'),
                ],
                'default' => 'last',
            ]
        );

        $this->add_control(
            'additional_post_link',
            [
                'label' => esc_html__('Link', 'bili-core'),
                'type' => Controls_Manager::URL,
                'label_block' => false,
                'placeholder' => esc_attr__('https://your-link.com', 'bili-core'),
            ]
        );

        $this->add_control(
            'additional_post_img_heading',
            [
                'label' => esc_html__('Image', 'bili-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'additional_post_img_media',
            [
                'type' => Controls_Manager::MEDIA,
                'default' => ['url' => Utils::get_placeholder_image_src()],
            ]
        );

        $this->add_control(
            'additional_post_btn_heading',
            [
                'label' => esc_html__('Button', 'bili-core'),
                'type' => Controls_Manager::HEADING,
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'additional_post_btn_text',
            [
                'label' => esc_html__('Button Text', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Coming Soon', 'bili-core'),
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'additional_post_btn',
                'selector' => '{{WRAPPER}} .additional-post .item__button',
            ]
        );

        $this->add_control(
            'additional_post_btn_align_h',
            [
                'label' => esc_html__('Horizontal Alignment', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => true,
                'toggle' => false,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Left', 'bili-core'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'bili-core'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Right', 'bili-core'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .additional-post .item__wrapper' => 'justify-content: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'additional_post_btn_align_v',
            [
                'label' => esc_html__('Vertical Alignment', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'label_block' => true,
                'toggle' => false,
                'options' => [
                    'flex-start' => [
                        'title' => esc_html__('Top', 'bili-core'),
                        'icon' => 'eicon-v-align-top',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'bili-core'),
                        'icon' => 'eicon-v-align-middle',
                    ],
                    'flex-end' => [
                        'title' => esc_html__('Bottom', 'bili-core'),
                        'icon' => 'eicon-v-align-bottom',
                    ],
                ],
                'default' => 'center',
                'selectors' => [
                    '{{WRAPPER}} .additional-post .item__wrapper' => 'align-items: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'additional_post_btn_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .additional-post .item__button' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'additional_post_btn_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .additional-post .item__button' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'additional_post_btn_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .additional-post .item__button' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'additional_post_button',
                'selector' => '{{WRAPPER}} .additional-post .item__button',
            ]
        );

        $this->start_controls_tabs('additional_post_btn');

        $this->start_controls_tab(
            'addtnl_btn_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'addtnl_btn_color_idle',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'addtnl_btn_bg_idle',
                'selector' => '{{WRAPPER}} .additional-post .item__button',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'addtnl_btn_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'addtnl_btn_color_hover',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'addtnl_btn_bg_hover',
                'selector' => '{{WRAPPER}} .additional-post .item__button',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLE -> CURSOR TOOLTIP
         */

        $this->start_controls_section(
            'style_tooltip',
            [
                'label' => esc_html__('Cursor Tooltip', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => ['description_position' => 'cursor_tooltip'],
            ]
        );

        $this->add_control(
            'tooltip_color',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'default' => '#ffffff'
            ]
        );

        $this->add_control(
            'tooltip_color_bg',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'default' => 'rgba(0,0,0,0)'
            ]
        );

        $this->add_control(
            'tooltip_color_bg_children',
            [
                'label' => esc_html__('Children Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        $atts = $this->get_settings_for_display();

        (new Portfolio_Template($atts, $this))->render();
    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
