<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/widgets/wgl-progress-bar.php`.
 */
namespace WGL_Extensions\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\{
    Widget_Base,
    Controls_Manager,
    Group_Control_Border,
    Group_Control_Typography,
    Group_Control_Box_Shadow
};
use WGL_Extensions\WGL_Framework_Global_Variables as WGL_Globals;

class WGL_Progress_Bar extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-progress-bar';
    }

    public function get_title()
    {
        return esc_html__( 'WGL Progress Bar', 'bili-core' );
    }

    public function get_icon()
    {
        return 'wgl-progress-bar';
    }

    public function get_keywords()
    {
        return [ 'progress', 'bar' ];
    }

    public function get_categories()
    {
        return [ 'wgl-modules' ];
    }

    public function get_script_depends()
    {
        return [
            'jquery-appear',
            'wgl-widgets'
        ];
    }

    protected function register_controls()
    {
        /** CONTENT -> GENERAL */

        $this->start_controls_section(
            'content_general',
            [ 'label' => esc_html__( 'General', 'bili-core' ) ]
        );

        $this->add_control(
            'title_text',
            [
                'label' => esc_html__( 'Title', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_attr__( 'ex: MARKETING', 'bili-core' ),
                'default' => esc_html__( 'MARKETING', 'bili-core' ),
            ]
        );

        $this->add_control(
            'value_progress',
            [
                'label' => esc_html__( 'Progress Value', 'bili-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'placeholder' => 50,
                'default' => 50,
            ]
        );

        $this->add_control(
            'value_maximum',
            [
                'label' => esc_html__( 'Maximum Value', 'bili-core' ),
                'type' => Controls_Manager::NUMBER,
                'min' => 1,
                'placeholder' => 100,
                'default' => 100,
            ]
        );

        $this->add_control(
            'units_text',
            [
                'label' => esc_html__( 'Units', 'bili-core' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_attr__( 'ex: %, px, points, etc.', 'bili-core' ),
                'default' => esc_html__( '%', 'bili-core' ),
            ]
        );

        $this->add_control(
            'value_position',
            [
                'label' => esc_html__( 'Value Position', 'bili-core' ),
                'type' => Controls_Manager::SELECT,
                'separator' => 'before',
                'options' => [
                    'fixed' => esc_html__( 'Top Fixed', 'bili-core' ),
                    'dynamic' => esc_html__( 'Top Dynamic', 'bili-core' ),
                    'aside' => esc_html__( 'Aside', 'bili-core' ),
                ],
                'default' => 'fixed',
            ]
        );

        $this->end_controls_section();

        /** STYLE -> CONTAINER */

        $this->start_controls_section(
            'style_container',
            [
                'label' => esc_html__( 'Container', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'container_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-progress-bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-progress-bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'container_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-progress-bar' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'container_bg',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-progress-bar' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /** STYLE -> TITLE */

        $this->start_controls_section(
            'style_title',
            [
                'label' => esc_html__( 'Title', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'title_text!' => '' ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .progress__content',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__( 'HTML Tag', 'bili-core' ),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => esc_html( '‹h1›' ),
                    'h2' => esc_html( '‹h2›' ),
                    'h3' => esc_html( '‹h3›' ),
                    'h4' => esc_html( '‹h4›' ),
                    'h5' => esc_html( '‹h5›' ),
                    'h6' => esc_html( '‹h6›' ),
                    'div' => esc_html( '‹div›' ),
                ],
                'default' => 'div',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .content__label' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .content__label' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .content__label' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_h_font_color(),
                'selectors' => [
                    '{{WRAPPER}} .content__label' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'title_bg',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .content__label' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /** STYLE -> VALUE */

        $this->start_controls_section(
            'style_value',
            [
                'label' => esc_html__( 'Value', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'value_typography',
                'selector' => '{{WRAPPER}} .content__value',
            ]
        );

        $this->add_responsive_control(
            'value_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .content__value' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'value_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'default' => [
                    'top' => 6,
                    'right' => 0,
                    'bottom' => 6,
                    'left' => 0,
                ],
                'selectors' => [
                    '{{WRAPPER}} .content__value,
                     {{WRAPPER}} .value__wrapper' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'value_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .content__value' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'value_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .content__value' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'value_bg',
            [
                'label' => esc_html__( 'Background Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .content__value' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'value_decoration',
            [
                'label' => esc_html__( 'Decoration Element Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .content__value::after' => 'border-right-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /** STYLE -> UNITS */

        $this->start_controls_section(
            'style_units',
            [
                'label' => esc_html__( 'Units', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
                'condition' => [ 'units_text!' => '' ]
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'units_typography',
                'selector' => '{{WRAPPER}} .value__unit',
            ]
        );

        $this->add_responsive_control(
            'units_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'allowed_dimensions' => 'horizontal',
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .value__unit' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'units_color',
            [
                'label' => esc_html__( 'Text Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'selectors' => [
                    '{{WRAPPER}} .value__unit' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /** STYLE -> PROGRESS BAR */

        $this->start_controls_section(
            'style_bar',
            [
                'label' => esc_html__( 'Bar', 'bili-core' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'bar_empty_height',
            [
                'label' => esc_html__( 'Empty Bar Height', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'label_block' => true,
                'range' => [
                    'px' => [ 'min' => 1, 'max' => 30 ],
                ],
                'default' => [ 'size' => 1 ],
                'selectors' => [
                    '{{WRAPPER}} .progress__bar' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bar_empty_bg',
            [
                'label' => esc_html__( 'Empty Bar Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => '#888888',
                'selectors' => [
                    '{{WRAPPER}} .progress__bar' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'bar_filled_height',
            [
                'label' => esc_html__( 'Filled Bar Height', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'separator' => 'before',
                'label_block' => true,
                'range' => [
                    'px' => [ 'min' => 1, 'max' => 30 ],
                ],
                'default' => [ 'size' => 5 ],
                'selectors' => [
                    '{{WRAPPER}} .bar__filled' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bar_filled_offset',
            [
                'label' => esc_html__( 'Filled Bar Vertical Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'label_block' => true,
                'range' => [
                    'px' => [ 'min' => -15, 'max' => 15 ],
                ],
                'default' => [ 'size' => 0 ],
                'selectors' => [
                    '{{WRAPPER}} .bar__filled' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'bar_filled_bg',
            [
                'label' => esc_html__( 'Filled Bar Color', 'bili-core' ),
                'type' => Controls_Manager::COLOR,
                'dynamic' => [ 'active' => true ],
                'default' => WGL_Globals::get_primary_color(),
                'selectors' => [
                    '{{WRAPPER}} .bar__filled' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'bar_margin',
            [
                'label' => esc_html__( 'Margin', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .progress__bar' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'bar_padding',
            [
                'label' => esc_html__( 'Padding', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .progress__bar' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'bar_border',
                'fields_options' => [
                    'width' => [
                        'label' => esc_html__( 'Border Width', 'bili-core' ),
                        'selectors' => [
                            '{{SELECTOR}}' => 'border-width: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};'
                                            . 'width: calc(100% - {{LEFT}}{{UNIT}} - {{RIGHT}}{{UNIT}});',
                        ],
                    ],
                    'color' => [ 'label' => esc_html__( 'Border Color', 'bili-core' ) ],
                ],
                'selector' => '{{WRAPPER}} .progress__bar',
            ]
        );

        $this->add_control(
            'bar_radius',
            [
                'label' => esc_html__( 'Border Radius', 'bili-core' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .progress__bar,
                     {{WRAPPER}} .bar__filled' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'bar_shadow',
                'selector' => '{{WRAPPER}} .progress__bar',
            ]
        );

        $this->add_control(
            'bar_transition_duration',
            [
                'label' => esc_html__( 'Animation Duratiom', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'separator' => 'before',
                'label_block' => true,
                'size_units' => [ 's', 'ms' ],
                'range' => [
                    's' => [ 'min' => 0.1, 'max' => 4, 'step' => 0.1 ],
                    'ms' => [ 'min' => 100, 'max' => 4000 ],
                ],
                'default' => [ 'unit' => 's' ],
                'selectors' => [
                    '{{WRAPPER}} .wgl-progress-bar' => 'transition: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    public function render()
    {
        $value_progress = $this->get_settings_for_display( 'value_progress' );
        $this->value_progress = 0 === $value_progress ? 0 : ( $value_progress ?: 50 );
        $this->value_maximum = $this->get_settings_for_display( 'value_maximum' ) ?: 100;

        $this->add_render_attribute( 'wrapper', 'class', [
            'wgl-progress-bar',
            'layout-' . $this->get_settings_for_display( 'value_position' )
        ] );

        echo '<div ', $this->get_render_attribute_string( 'wrapper' ), '>';

        if ( 'aside' === $this->get_settings_for_display( 'value_position' ) ) {
            $this->render_aside_layout();
        } else {
            $this->render_default_layout();
        }

        echo '</div>';
    }

    protected function render_default_layout()
    {
        echo '<div class="progress__content">';

            $this->render_title();
            $this->render_default_value();

        echo '</div>';

        $this->render_bar();
    }

    protected function render_aside_layout()
    {
        echo '<div class="aside__wrapper">';

            echo '<div class="progress__content">';
                $this->render_title();
            echo '</div>';

            $this->render_bar();

        echo '</div>';

        $this->render_aside_value();
    }

    protected function render_bar()
    {
        $this->add_render_attribute( 'bar-filled', [
            'class' => 'bar__filled',
            'data-value' => esc_attr( $this->value_progress ),
            'data-max-value' => esc_attr( $this->value_maximum ),
        ] );

        echo '<div class="progress__bar">',
            '<div ', $this->get_render_attribute_string( 'bar-filled' ), '></div>',
        '</div>';
    }

    protected function render_title()
    {
        $title_text = $this->get_settings_for_display( 'title_text' );

        if ( empty( $title_text ) ) {
            // Bailout.
            return;
        }

        $title_tag = $this->get_settings_for_display( 'title_tag' );

        echo '<', esc_attr( $title_tag ), ' class="content__label">',
            esc_html( $title_text ),
        '</', esc_attr( $title_tag ), '>';
    }

    protected function render_default_value()
    {
        $units = $this->get_settings_for_display( 'units_text' );

        echo '<div class="content__value">',
            '<span class="value__digit">0</span>',
            ( $units ? '<span class="value__unit">' . esc_html( $units ) . '</span>' : '' ),
        '</div>';
    }

    protected function render_aside_value()
    {
        $units = $this->get_settings_for_display( 'units_text' );

        echo '<div class="content__value">',

            '<span class="placeholder__digit">', esc_html( $this->value_progress ), '</span>',
            ( $units ? '<span class="placeholder__unit">' . esc_html( $units ) . '</span>' : '' ),

            '<div class="value__wrapper">',
                '<span class="value__digit">0</span>',
                ( $units ? '<span class="value__unit">' . esc_html( $units ) . '</span>' : '' ),
            '</div>',

        '</div>';
    }

    public function wpml_support_module()
    {
        add_filter( 'wpml_elementor_widgets_to_translate',  [ $this, 'wpml_widgets_to_translate_filter' ] );
    }

    public function wpml_widgets_to_translate_filter( $widgets )
    {
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
