<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/widgets/wgl-striped-services.php`.
 */

namespace WGL_Extensions\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\{
    Widget_Base,
    Controls_Manager,
    Control_Media,
    Group_Control_Background,
    Group_Control_Typography,
    Repeater
};

use WGL_Extensions\{
    WGL_Framework_Global_Variables as WGL_Globals
};

class Wgl_Striped_Services extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-striped-services';
    }

    public function get_title()
    {
        return esc_html__('WGL Striped Services', 'bili-core');
    }

    public function get_icon()
    {
        return 'wgl-striped-services';
    }

    public function get_categories()
    {
        return ['wgl-modules'];
    }

    public function get_script_depends()
    {
        return ['appear'];
    }

    protected function register_controls()
    {
        /** CONTENT -> GENERAL */

        $this->start_controls_section(
            'wgl_striped_services_section',
            ['label' => esc_html__('General', 'bili-core')]
        );

        $this->add_responsive_control(
            'interval',
            [
                'label' => esc_html__('Module Height', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 200, 'max' => 1000],
                ],
                'devices' => ['desktop', 'tablet', 'mobile'],
                'default' => ['size' => 700, 'unit' => 'px'],
                'tablet_default' => ['size' => 700, 'unit' => 'px'],
                'mobile_default' => ['size' => 1500, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .wgl-striped-services' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'reveal_right_items',
            [
                'label' => esc_html__('Reveal right edge items', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'bili-core'),
                'label_off' => esc_html__('Off', 'bili-core'),
                'default' => 'yes',
            ]
        );

        $this->end_controls_section();

        /** CONTENT -> CONTENT */

        $this->start_controls_section(
            'wgl_content_section',
            ['label' => esc_html__('Content', 'bili-core')]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'serv_title',
            [
                'label' => esc_html__('Title', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Service Title', 'bili-core'),
            ]
        );

        $repeater->add_control(
            'serv_subtitle',
            [
                'label' => esc_html__('Subtitle', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Service Subtitle', 'bili-core'),
            ]
        );
        $repeater->add_control(
            'serv_bg_text',
            [
                'label' => esc_html__('Background Text', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('01', 'bili-core'),
            ]
        );

        $repeater->add_control(
			'serv_def_active',
			[
                'label' => esc_html__('Active as Default', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
			]
        );

        $repeater->add_control(
            'bg_color',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'condition' => ['thumbnail[url]' => ''],
                'default' => '#323232',
            ]
        );

        $repeater->add_control(
            'thumbnail',
            [
                'label' => esc_html__('Thumbnail', 'bili-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => ['url' => ''],
            ]
        );

        $repeater->add_responsive_control(
            'bg_position',
            [
                'label' => esc_html__('Position', 'Background Control', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => ['thumbnail[url]!' => ''],
                'responsive' => true,
                'options' => [
                    'top left' => esc_html__('Top Left', 'Background Control', 'bili-core'),
                    'top center' => esc_html__('Top Center', 'Background Control', 'bili-core'),
                    'top right' => esc_html__('Top Right', 'Background Control', 'bili-core'),
                    'center left' => esc_html__('Center Left', 'Background Control', 'bili-core'),
                    'center center' => esc_html__('Center Center', 'Background Control', 'bili-core'),
                    'center right' => esc_html__('Center Right', 'Background Control', 'bili-core'),
                    'bottom left' => esc_html__('Bottom Left', 'Background Control', 'bili-core'),
                    'bottom center' => esc_html__('Bottom Center', 'Background Control', 'bili-core'),
                    'bottom right' => esc_html__('Bottom Right', 'Background Control', 'bili-core'),
                ],
                'default' => 'top left',
            ]
        );

        $repeater->add_control(
            'bg_size',
            [
                'label' => esc_html__('Size', 'Background Control', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'condition' => ['thumbnail[url]!' => ''],
                'responsive' => true,
                'options' => [
                    'auto' => esc_html__('Auto', 'Background Control', 'bili-core'),
                    'cover' => esc_html__('Cover', 'Background Control', 'bili-core'),
                    'contain' => esc_html__('Contain', 'Background Control', 'bili-core'),
                ],
                'default' => 'cover',
            ]
        );

        $repeater->add_control(
            'serv_link',
            [
                'label' => esc_html__('Add Link', 'bili-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'default' => [ 'url' => '#' ],
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Layers', 'bili-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '{{serv_title}}',
                'description' => esc_html__('Enter services height in pixels', 'bili-core'),
                'default' => [
                    ['serv_title' => esc_html__('Service Title', 'bili-core'), 'acc_tab_def_active' => 'yes'],
                    ['serv_title' => esc_html__('Service Title 2', 'bili-core')],
                ],
            ]
        );

        $this->add_control(
            'deprecated_notice',
            [
                'type' => Controls_Manager::HEADING,
                'label' => esc_html__('Two or more items are expected for correct rendering', 'bili-core'),
            ]
        );

        $this->end_controls_section();

         /**
         * STYLE -> MEDIA
         */

        $this->start_controls_section(
            'section_style_thumbnail',
            [
                'label' => esc_html__('Thumbnail', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs( 'thumbnail_colors' );

        $this->start_controls_tab(
            'thumbnail_normal',
            [ 'label' => esc_html__('Normal', 'bili-core') ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'media_overlay_idle',
                'label' => esc_html__('Background', 'bili-core'),
                'types' => ['classic', 'gradient'],
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .service-item .service-image:after',
            ]
        );
        $this->end_controls_tab();

        $this->start_controls_tab(
            'thumbnail_active',
            [ 'label' => esc_html__('Active', 'bili-core') ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'media_overlay_hover',
                'label' => esc_html__('Background', 'bili-core'),
                'types' => ['classic', 'gradient'],
                'exclude' => [ 'image' ],
                'selector' => '{{WRAPPER}} .service-item.active .service-image:after',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> TITLE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'section_style_title',
            [
                'label' => esc_html__('Title', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .service-item_title',
            ]
        );

        $this->start_controls_tabs( 'title_colors' );

        $this->start_controls_tab(
            'title_colors_normal',
            [ 'label' => esc_html__('Normal', 'bili-core') ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .service-item_title' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .onhover .service-item:not(.active) .service-item_title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_colors_hover',
            [ 'label' => esc_html__('Hover', 'bili-core') ]
        );

        $this->add_control(
            'title_color_hover',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .onhover .service-item .service-item_title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                ],
                'default' => 'h4',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 28,
                    'left' => 38,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-item_title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_max_width',
            [
                'label' => esc_html__( 'Max Width', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 0, 'max' => 850 ],
                ],
                'size_units' => [ 'px', 'vw' ],
                'default' => ['size' => 475, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .service-item_title' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> SUBTITLE
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'subtitle_style_section',
            [
                'label' => esc_html__('Subtitle', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'subtitle_typo',
                'selector' => '{{WRAPPER}} .service-item_subtitle',
            ]
        );

        $this->start_controls_tabs( 'subtitle_colors' );

        $this->start_controls_tab(
            'subtitle_colors_normal',
            [ 'label' => esc_html__('Normal', 'bili-core') ]
        );

       $this->add_control(
            'subtitle_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .service-item_subtitle' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .onhover .service-item:not(.active) .service-item_subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'subtitle_colors_hover',
            [ 'label' => esc_html__('Hover', 'bili-core') ]
        );

        $this->add_control(
            'subtitle_color_hover',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .onhover .service-item .service-item_subtitle' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_control(
            'subtitle_tag',
            [
                'label' => esc_html__('Subtitle HTML Tag', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => 'H1',
                    'h2' => 'H2',
                    'h3' => 'H3',
                    'h4' => 'H4',
                    'h5' => 'H5',
                    'h6' => 'H6',
                    'div' => 'div',
                ],
                'default' => 'div',
            ]
        );

        $this->add_responsive_control(
            'subtitle_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 10,
                    'left' => 38,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-item_subtitle' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'subtitle_max_width',
            [
                'label' => esc_html__( 'Max Width', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 0, 'max' => 850 ],
                ],
                'default' => ['size' => 475, 'unit' => 'px'],
                'selectors' => [
                    '{{WRAPPER}} .service-item_subtitle' => 'width: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> BACKGROUND TEXT
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'bg_text_style_section',
            [
                'label' => esc_html__('Background Text', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'bg_text_typo',
                'selector' => '{{WRAPPER}} .service-item_bg_text',
            ]
        );

        $this->start_controls_tabs( 'bg_text_colors' );

        $this->start_controls_tab(
            'bg_text_colors_normal',
            [ 'label' => esc_html__('Normal', 'bili-core') ]
        );

       $this->add_control(
            'bg_text_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .service-item_bg_text' => 'color: {{VALUE}};',
                    '{{WRAPPER}} .onhover .service-item:not(.active) .service-item_bg_text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'bg_text_colors_hover',
            [ 'label' => esc_html__('Hover', 'bili-core') ]
        );

        $this->add_control(
            'bg_text_color_hover',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .onhover .service-item .service-item_bg_text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_responsive_control(
            'bg_text_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .service-item_bg_text' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();


        /*-----------------------------------------------------------------------------------*/
        /*  STYLE -> LINK
        /*-----------------------------------------------------------------------------------*/

        $this->start_controls_section(
            'link_style_section',
            [
                'label' => esc_html__('Link', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'link_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 40,
                    'left' => 42,
                ],
                'selectors' => [
                    '{{WRAPPER}} .service-item_link' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('link_colors');

        $this->start_controls_tab(
            'link_colors_normal',
            ['label' => esc_html__('Normal', 'bili-core')]
        );

        $this->add_control(
            'link_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '#ffffff',
                'selectors' => [
                    '{{WRAPPER}} .service-item_link' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'link_bg_color',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .service-item_link' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'link_colors_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'hover_link_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => WGL_Globals::get_primary_color(),
                'selectors' => [
                    '{{WRAPPER}} .service-item_link:hover, {{WRAPPER}} .service-item_title:hover .service-item_link:after, {{WRAPPER}} .service-item_title:hover .service-item_link svg' => 'color: {{VALUE}}; fill:  {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'hover_link_bg_color',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => WGL_Globals::get_primary_color(),
                'selectors' => [
                    '{{WRAPPER}} .service-item_link:hover, {{WRAPPER}} .service-item_title:hover .service-item_link:after, {{WRAPPER}} .service-item_title:hover .service-item_link svg' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function render()
    {
        $_s = $this->get_settings_for_display();

        $this->add_render_attribute('striped-services', 'class', [
            'wgl-striped-services',
            !empty($_s['reveal_right_items']) ? 'reveal-right-items' : ''
        ]);

        echo '<div ', $this->get_render_attribute_string('striped-services'), '>';

        foreach ($_s['items'] as $index => $item) {

            $item_wrap = $this->get_repeater_setting_key('item_wrap', 'items', $index);
            $this->add_render_attribute(
                $item_wrap,
                [
                    'class' => [
                        'service-image',
                        !empty($item['thumbnail']['url']) ? '' : 'no-image',
                    ],
                    'style' => [
                        !empty($item['thumbnail']['url']) ? 'background-image: url(' . esc_url($item['thumbnail']['url']) . ');' : '',
                        $item['bg_position'] != '' ? 'background-position: ' . esc_attr($item['bg_position']) . ';' : '',
                        $item['bg_size'] != '' ? 'background-size: ' . esc_attr($item['bg_size']) . ';' : '',
                        $item['bg_color'] != '' ? 'background-color: ' . esc_attr($item['bg_color']) . ';' : '',
                    ]
                ]
            );

            $image = $this->get_repeater_setting_key('image', 'items', $index);
            $this->add_render_attribute(
                $image,
                [
                    'src' => isset($item['thumbnail']['url']) ? esc_url($item['thumbnail']['url']) : '',
                    'alt' => Control_Media::get_image_alt($item['thumbnail']),
                ]
            );

            if (!empty($item['serv_link']['url'])) {
                $serv_link = $this->get_repeater_setting_key('serv_link', 'items', $index);
                $this->add_link_attributes($serv_link, $item['serv_link']);
            }

            echo '<div class="service-item',!empty($item['serv_def_active']) ? ' active' : '','">';
            echo '<div ', $this->get_render_attribute_string($item_wrap), '></div>';
            echo '<div class="service-item_content">';
            if (!empty($item['serv_bg_text'])) {
                echo '<div class="service-item_bg_text">', esc_html($item['serv_bg_text']), '</div>';
            }

            if (!empty($item['serv_title'])) {
                echo '<', $_s['title_tag'], ' class="service-item_title">',
                    esc_html($item['serv_title']);
            }
            if (!empty($item['serv_title'])) {
                echo '</',
                    $_s['title_tag'],
                    '>';
            }
            if (!empty($item['serv_subtitle'])) {
                echo '<', $_s['subtitle_tag'], ' class="service-item_subtitle">',
                    esc_html($item['serv_subtitle']),
                    '</',
                    $_s['subtitle_tag'],
                    '>';
            }

            if (!empty($item['serv_link']['url'])) {
                echo '<a class="service-item_link" ', $this->get_render_attribute_string($serv_link), '>',WGL_Globals::arrow_right(),'</a>';
            }

            echo '</div>'; // service-item_content
            echo '</div>'; // service-item
        }

        echo '</div>';
    }
}
