<?php
/**
 * This template can be overridden by copying it to `bili[-child]/bili-core/elementor/widgets/wgl-testimonials.php`.
 */
namespace WGL_Extensions\Widgets;

defined('ABSPATH') || exit; // Abort, if called directly.

use Elementor\{
    Widget_Base,
    Controls_Manager,
    Utils,
    Repeater,
    Group_Control_Border,
    Group_Control_Box_Shadow,
    Group_Control_Typography,
    Group_Control_Background
};
use WGL_Extensions\{
    WGL_Framework_Global_Variables as WGL_Globals,
    Includes\WGL_Carousel_Settings,
    Templates\WGL_Testimonials as Testimonials_Template
};

class WGL_Testimonials extends Widget_Base
{
    public function get_name()
    {
        return 'wgl-testimonials';
    }

    public function get_title()
    {
        return esc_html__('WGL Testimonials', 'bili-core');
    }

    public function get_icon()
    {
        return 'wgl-testimonials';
    }

    public function get_script_depends()
    {
        return ['swiper'];
    }

    public function get_categories()
    {
        return ['wgl-modules'];
    }

    protected function register_controls()
    {
        /**
         * CONTENT -> GENERAL
         */

        $this->start_controls_section(
            'content_general',
            ['label' => esc_html__('General', 'bili-core')]
        );

        $this->add_control(
            'posts_per_row',
            [
                'label' => esc_html__('Grid Columns Amount', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    '1' => esc_html__('1 (one)', 'bili-core'),
                    '2' => esc_html__('2 (two)', 'bili-core'),
                    '3' => esc_html__('3 (three)', 'bili-core'),
                    '4' => esc_html__('4 (four)', 'bili-core'),
                    '5' => esc_html__('5 (five)', 'bili-core'),
                ],
                'default' => '1',
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'thumbnail',
            [
                'label' => esc_html__('Image', 'bili-core'),
                'type' => Controls_Manager::MEDIA,
                'label_block' => true,
                'default' => ['url' => Utils::get_placeholder_image_src()],
            ]
        );

        $repeater->add_control(
            'author_name',
            [
                'label' => esc_html__('Author Name', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
                'label_block' => true
            ]
        );

        $repeater->add_control(
            'link_author',
            [
                'label' => esc_html__('Link Author', 'bili-core'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'author_position',
            [
                'label' => esc_html__('Author Position', 'bili-core'),
                'type' => Controls_Manager::TEXT,
                'dynamic' => ['active' => true],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'bili-core'),
                'type' => Controls_Manager::TEXT,
	            'dynamic' => [ 'active' => true ],
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'quote',
            [
                'label' => esc_html__('Quote', 'bili-core'),
                'type' => Controls_Manager::WYSIWYG,
                'label_block' => true,
                'dynamic' => ['active' => true],
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Items', 'bili-core'),
                'type' => Controls_Manager::REPEATER,
                'default' => [
                    [
                        'author_name' => esc_html__('Dominicana Rodrigez', 'bili-core'),
                        'title' => esc_html__('Great Work!', 'bili-core'),
                        'author_position' => esc_html__('CLIENT OF AGENCY', 'bili-core'),
                        'quote' => esc_html__('“Our office is something we are pleased with. We consider it the little magnet; it is wanting to come here and afterward difficult to leave it. Our office is additionally a big name.”', 'bili-core'),
                        'thumbnail' => Utils::get_placeholder_image_src(),
                    ],
                ],
                'fields' => $repeater->get_controls(),
                'title_field' => '{{{ author_name }}}',
            ]
        );

        $this->add_control(
            'layout',
            [
                'label' => esc_html__('Layout', 'bili-core'),
                'type' => 'wgl-radio-image',
                'options' => [
                    'top_block' => [
                        'title' => esc_html__('Top', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/testimonials_1.png',
                    ],
                    'bottom_block' => [
                        'title' => esc_html__('Bottom', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/testimonials_4.png',
                    ],
                    'top_inline' => [
                        'title' => esc_html__('Top Inline', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/testimonials_2.png',
                    ],
                    'bottom_inline' => [
                        'title' => esc_html__('Bottom Inline', 'bili-core'),
                        'image' => WGL_EXTENSIONS_ELEMENTOR_URL . 'assets/img/wgl_elementor_addon/icons/testimonials_3.png',
                    ],
                ],
                'default' => 'bottom_inline',
            ]
        );

        $this->add_responsive_control(
            'image_position',
            [
                'label' => esc_html__('Image Position', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'toggle' => false,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'bili-core'),
                        'icon' => 'eicon-h-align-left',
                    ],
                    'default' => [
                        'title' => esc_html__('Default', 'bili-core'),
                        'icon' => 'eicon-h-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'bili-core'),
                        'icon' => 'eicon-h-align-right',
                    ],
                ],
	            'condition' => ['layout' => ['bottom_block', 'top_block']],
                'prefix_class' => 'image%s',
                'default' => 'left',
	            'mobile_default' => 'default',
            ]
        );

        $this->add_responsive_control(
            'alignment',
            [
                'label' => esc_html__('Alignment', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'toggle' => false,
	            'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'bili-core'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'bili-core'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'bili-core'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
	            'prefix_class' => 'a%s',
                'default' => 'left',
            ]
        );

        $this->add_control(
            'hover_animation',
            [
                'label' => esc_html__('Enable Hover Animation', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'description' => esc_html__('Lift up the item on hover.', 'bili-core'),
            ]
        );

        $this->end_controls_section();

        /**
         * CONTENT -> CAROUSEL OPTIONS
         */

        WGL_Carousel_Settings::add_controls($this, [
            '3d_animation_options' => 'enabled',
            'animation_style' => [
                'default' => 'default',
            ],
            'slide_per_single' => [
                'default' => 1,
            ],
            'pagination_margin' => [
                'default' => [
                    'size' => 0
                ],
            ],
        ]);

        /**
         * STYLE -> ITEM CONTAINER
         */

        $this->start_controls_section(
            'style_item_container',
            [
                'label' => esc_html__('Item Container', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'item_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px'],
                'allowed_dimensions' => 'vertical',
                'selectors' => [
                    '{{WRAPPER}} .testimonial__item' => 'margin-top: {{TOP}}{{UNIT}}; margin-bottom: {{BOTTOM}}{{UNIT}};',
                    '{{WRAPPER}} .wgl-carousel_wrapper .swiper-container' => 'margin: calc(-1 * {{TOP}}{{UNIT}}) -15px calc(-1 * {{BOTTOM}}{{UNIT}}) -15px;',
                ],
            ]
        );

        $this->add_responsive_control(
            'item_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial__item' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'item_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .testimonial__item' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_bg',
                'selector' => '{{WRAPPER}} .testimonial__item',
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'item_border',
                'selector' => '{{WRAPPER}} .testimonial__item',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_shadow',
                'selector' => '{{WRAPPER}} .testimonial__item',
            ]
        );

	    $this->end_controls_section();

        /**
         * STYLE -> TITLE
         */

        $this->start_controls_section(
            'style_title',
            [
                'label' => esc_html__('Title', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_title',
                'selector' => '{{WRAPPER}} .item__title',
            ]
        );

        $this->add_control(
            'title_tag',
            [
                'label' => esc_html__('Title tag', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => esc_html('‹h1›'),
                    'h2' => esc_html('‹h2›'),
                    'h3' => esc_html('‹h3›'),
                    'h4' => esc_html('‹h4›'),
                    'h5' => esc_html('‹h5›'),
                    'h6' => esc_html('‹h6›'),
                    'span' => esc_html('‹span›'),
                    'div' => esc_html('‹div›'),
                ],
                'default' => 'div',
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 2,
                    'right' => 20,
                    'bottom' => 10,
                    'left' => 74,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .item__title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );


        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Title Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .item__title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         * STYLE -> ICON
         */

        $this->start_controls_section(
            'style_title_icon',
            [
                'label' => esc_html__('Icon', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_icon_enabled',
            [
                'label' => esc_html__('Use Icon', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'selectors' => [
                    '{{WRAPPER}} .testimonial__item .item__content:before' => 'display: inline-block;'
                ],
                'default' => 'yes'
            ]
        );

	    $this->add_control(
		    'title_icon_size',
		    [
			    'label' => esc_html__('Icon Size', 'bili-core'),
			    'type' => Controls_Manager::SLIDER,
			    'condition' => ['title_icon_enabled!' => ''],
			    'range' => [
				    'px' => ['min' => 10, 'max' => 150],
			    ],
                'default' => ['size' => 48],
			    'selectors' => [
				    '{{WRAPPER}} .testimonial__item .item__content:before' => 'font-size: {{SIZE}}{{UNIT}};',
			    ],
		    ]
	    );

        $this->add_responsive_control(
		    'icon_padding',
		    [
			    'label' => esc_html__('Padding', 'bili-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'condition' => ['title_icon_enabled!' => ''],
			    'size_units' => ['px', 'em', '%'],
			    'selectors' => [
				    '{{WRAPPER}} .testimonial__item .item__content:before' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
		    'icon_margin',
		    [
			    'label' => esc_html__('Margin', 'bili-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'condition' => ['title_icon_enabled!' => ''],
			    'size_units' => ['px', 'em', '%'],
			    'selectors' => [
				    '{{WRAPPER}} .testimonial__item .item__content:before' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_responsive_control(
		    'icon_radius',
		    [
			    'label' => esc_html__('Border Radius', 'bili-core'),
			    'type' => Controls_Manager::DIMENSIONS,
			    'condition' => ['title_icon_enabled!' => ''],
			    'size_units' => ['px', 'em', '%'],
			    'selectors' => [
				    '{{WRAPPER}} .testimonial__item .item__content:before' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'title_icon_color',
		    [
			    'label' => esc_html__('Icon Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'condition' => ['title_icon_enabled!' => ''],
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .testimonial__item .item__content:before' => 'color: {{VALUE}};',
			    ],
		    ]
	    );

	    $this->add_control(
		    'title_icon_bg',
		    [
			    'label' => esc_html__('Background Color', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'condition' => ['title_icon_enabled!' => ''],
			    'dynamic' => ['active' => true],
			    'selectors' => [
				    '{{WRAPPER}} .testimonial__item .item__content:before' => 'background-color: {{VALUE}};',
			    ],
		    ]
	    );

        $this->end_controls_section();

        /**
         * STYLE -> QUOTE
         */

        $this->start_controls_section(
            'style_quote',
            [
                'label' => esc_html__('Quote', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_quote',
                'selector' => '{{WRAPPER}} .item__quote',
            ]
        );

        $this->add_control(
            'quote_tag',
            [
                'label' => esc_html__('Quote tag', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => esc_html('‹h1›'),
                    'h2' => esc_html('‹h2›'),
                    'h3' => esc_html('‹h3›'),
                    'h4' => esc_html('‹h4›'),
                    'h5' => esc_html('‹h5›'),
                    'h6' => esc_html('‹h6›'),
                    'span' => esc_html('‹span›'),
                    'div' => esc_html('‹div›'),
                ],
                'default' => 'div',
            ]
        );

        $this->add_responsive_control(
            'quote_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 0,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 0,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .item__quote' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'quote_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'default' => [
                    'top' => 0,
                    'right' => 0,
                    'bottom' => 39,
                    'left' => 2,
                    'unit' => 'px',
                ],
                'selectors' => [
                    '{{WRAPPER}} .item__quote' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'quote_border',
                'fields_options' => [
                    'border' => [
                        'default' => 'solid',
                    ],
                    'width' => [
                        'label' => esc_html__( 'Border Width', 'bili-core' ),
                        'default' => [
                            'top' => 0,
                            'right' => 0,
                            'bottom' => 1,
                            'left' => 0,
                        ],
                    ],
                    'color' => [ 'default' => WGL_Globals::get_h_font_color( 0.3 ), ],
                ],
                'selector' => '{{WRAPPER}} .item__quote',
            ]
        );

        $this->add_responsive_control(
            'show_triangle',
            [
                'label' => esc_html__( 'Show Triangle', 'bili-core' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'bili-core' ),
                'label_off' => esc_html__( 'Hide', 'bili-core' ),
                'selectors_dictionary' => [
                    'yes' => 'block;content: "";',
                    '' => 'none;',
                ],
                'toggle' => false,
	            'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'default' => 'yes',
                'selectors' => [
                    '{{WRAPPER}} .item__quote:before, {{WRAPPER}} .item__quote:after' => 'display: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'triangle_direction',
            [
                'label' => esc_html__('Triangle Direction', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'right' => esc_html__('Right', 'bili-core'),
                    'left' => esc_html__('Left', 'bili-core'),
                    'top' => esc_html__('Top', 'bili-core'),
                    'bottom' => esc_html__('Bottom', 'bili-core'),
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_triangle',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_tablet',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_mobile',
                            'operator' => '!=',
                            'value' => ''
                        ]
                    ]
                ],
                'default' => 'bottom',
            ]
        );

        $this->add_control(
            'triangle_width',
            [
                'label' => esc_html__('Triangle Width', 'bili-core'),
                'type' => Controls_Manager::NUMBER,
                'min' => 0,
                'default' => 15,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_triangle',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_tablet',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_mobile',
                            'operator' => '!=',
                            'value' => ''
                        ]
                    ]
                ],
                'selectors' => [
				    '{{WRAPPER}} .item__quote:before' => 'border-width: {{VALUE}}px;',
                    '{{WRAPPER}} .item__quote:after' => 'border-width: calc({{VALUE}}px - 1px);',
			    ],
            ]
        );

        $this->add_control(
		    'triangle_color_empty',
		    [
			    'label' => esc_html__('Triangle Fill', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'default' => WGL_Globals::get_h_font_color( 0.3 ),
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_triangle',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_tablet',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_mobile',
                            'operator' => '!=',
                            'value' => ''
                        ]
                    ]
                ],
			    'selectors' => [
                    '{{WRAPPER}} .triangle-direction-bottom .item__quote:before,
                    {{WRAPPER}} .triangle-direction-right .item__quote:before' => 'border-color: {{VALUE}} transparent transparent {{VALUE}};',
                    '{{WRAPPER}} .triangle-direction-left .item__quote:before,
                    {{WRAPPER}} .triangle-direction-top .item__quote:before' => 'border-color: transparent {{VALUE}} {{VALUE}} transparent;',
			    ],
		    ]
	    );

        $this->add_control(
		    'triangle_color_border',
		    [
			    'label' => esc_html__('Triangle Border', 'bili-core'),
			    'type' => Controls_Manager::COLOR,
			    'default' => WGL_Globals::get_tertiary_color(),
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_triangle',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_tablet',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_mobile',
                            'operator' => '!=',
                            'value' => ''
                        ]
                    ]
                ],
			    'selectors' => [
				    '{{WRAPPER}} .triangle-direction-bottom .item__quote:after,
                    {{WRAPPER}} .triangle-direction-right .item__quote:after' => 'border-color: {{VALUE}} transparent transparent {{VALUE}};',
                    '{{WRAPPER}} .triangle-direction-left .item__quote:after,
                    {{WRAPPER}} .triangle-direction-top .item__quote:after' => 'border-color: transparent {{VALUE}} {{VALUE}} transparent;',
			    ],
		    ]
	    );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'triangle_border',
                'fields_options' => [
                    'width' => [ 'type' => Controls_Manager::HIDDEN ],
                    'color' => [ 'type' => Controls_Manager::HIDDEN ],
                ],
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_triangle',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_tablet',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_mobile',
                            'operator' => '!=',
                            'value' => ''
                        ]
                    ]
                ],
                'selector' => '{{WRAPPER}} .item__quote:before, {{WRAPPER}} .item__quote:after',
            ]
        );


        $this->add_responsive_control(
            'triangle_top_offset',
            [
                'label' => esc_html__( 'Triangle Top Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_triangle',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_tablet',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_mobile',
                            'operator' => '!=',
                            'value' => ''
                        ]
                    ]
                ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => -2000, 'max' => 2000 ],
                    '%' => ['min' => -100,'max' => 200],
                ],
                'default' => [ 'size' => 100, 'unit' => '%' ],
                'selectors' => [
                    '{{WRAPPER}} .item__quote:before' => 'top:  {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .item__quote:after' => 'top:  calc({{SIZE}}{{UNIT}} - 1px);',
                    '{{WRAPPER}} .triangle-direction-left .item__quote:after,
                    {{WRAPPER}} .triangle-direction-right .item__quote:after' => 'top:  calc({{SIZE}}{{UNIT}} + 1px);',
                    '{{WRAPPER}} .triangle-direction-top .item__quote:after' => 'top:  calc({{SIZE}}{{UNIT}} + 2px);',
                ],
            ]
        );

        $this->add_responsive_control(
            'triangle_left_offset',
            [
                'label' => esc_html__( 'Triangle Left Offset', 'bili-core' ),
                'type' => Controls_Manager::SLIDER,
                'conditions' => [
                    'relation' => 'or',
                    'terms' => [
                        [
                            'name' => 'show_triangle',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_tablet',
                            'operator' => '!=',
                            'value' => ''
                        ],
                        [
                            'name' => 'show_triangle_mobile',
                            'operator' => '!=',
                            'value' => ''
                        ]
                    ]
                ],
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [ 'min' => -2000, 'max' => 2000 ],
                    '%' => ['min' => -100,'max' => 200],
                ],
                'default' => [ 'size' => 15, 'unit' => '%' ],
                'selectors' => [
                    '{{WRAPPER}} .item__quote:before' => 'left:  {{SIZE}}{{UNIT}};',
                    '{{WRAPPER}} .item__quote:after' => 'left:  calc({{SIZE}}{{UNIT}} + 1px);',
                    '{{WRAPPER}} .triangle-direction-left .item__quote:after' => 'left:  calc({{SIZE}}{{UNIT}} + 2px);',
                    '{{WRAPPER}} .triangle-direction-right .item__quote:after' => 'left:  calc({{SIZE}}{{UNIT}} + 1px);',
                    '{{WRAPPER}} .triangle-direction-top .item__quote:after' => 'left:  calc({{SIZE}}{{UNIT}} + 1px);',
                ],
            ]
        );

        $this->add_responsive_control(
            'quote_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .item__quote' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'quote_color',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .item__quote' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'quote_bg',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .item__quote' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         * STYLE -> AUTHOR THUMBNAIL
         */

        $this->start_controls_section(
            'style_thumnail',
            [
                'label' => esc_html__('Author Thumbnail', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'image_size',
            [
                'label' => esc_html__('Width', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 20, 'max' => 400],
                ],
                'default' => ['size' => 80],
	            'selectors' => [
		            '{{WRAPPER}} .testimonial__item' => '--image-width: {{SIZE}}{{UNIT}};',
	            ],
            ]
        );

        $this->add_responsive_control(
            'image_gap',
            [
                'label' => esc_html__('Image Gap', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 0, 'max' => 500],
                ],
                'default' => ['size' => 250],
	            'condition' => [
		            'layout' => ['bottom_block', 'top_block'],
	            	'image_position' => ['left', 'right']
	            ],
	            'selectors' => [
		            '{{WRAPPER}} .testimonial__item' => '--image-gap: {{SIZE}}{{UNIT}};',
	            ],
            ]
        );

        $this->add_responsive_control(
            'image_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'separator' => 'before',
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .author__thumbnail' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
	            'selectors' => [
                    '{{WRAPPER}} .author__thumbnail' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'image_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'default' => [
                    'top' => 50,
                    'right' => 50,
                    'bottom' => 50,
                    'left' => 50,
                    'unit' => '%',
                ],
                'selectors' => [
                    '{{WRAPPER}} .author__thumbnail img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'image_border',
                'separator' => 'before',
                'selector' => '{{WRAPPER}} .author__thumbnail img',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'testimonials_image_shadow',
                'selector' => '{{WRAPPER}} .author__thumbnail img',
            ]
        );

        $this->end_controls_section();

        /**
         * STYLE -> AUTHOR NAME
         */

        $this->start_controls_section(
            'style_name',
            [
                'label' => esc_html__('Author Name', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'name_tag',
            [
                'label' => esc_html__('HTML tag', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'h1' => esc_html('‹h1›'),
                    'h2' => esc_html('‹h2›'),
                    'h3' => esc_html('‹h3›'),
                    'h4' => esc_html('‹h4›'),
                    'h5' => esc_html('‹h5›'),
                    'h6' => esc_html('‹h6›'),
                    'div' => esc_html('‹div›'),
                    'span' => esc_html('‹span›'),
                ],
                'default' => 'h3',
            ]
        );

        $this->add_responsive_control(
            'name_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .author__name' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('name_colors');

        $this->start_controls_tab(
            'tab_name_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'name_color_idle',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .author__name' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_name_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'name_color_hover',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .author__name:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_name',
                'selector' => '{{WRAPPER}} .author__name',
            ]
        );

        $this->end_controls_section();

        /**
         * STYLE -> AUTHOR POSITION
         */

        $this->start_controls_section(
            'style_position',
            [
                'label' => esc_html__('Author Position', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'position_tag',
            [
                'label' => esc_html__('HTML tag', 'bili-core'),
                'type' => Controls_Manager::SELECT,
                'default' => 'span',
                'options' => [
                    'h1' => esc_html('‹h1›'),
                    'h2' => esc_html('‹h2›'),
                    'h3' => esc_html('‹h3›'),
                    'h4' => esc_html('‹h4›'),
                    'h5' => esc_html('‹h5›'),
                    'h6' => esc_html('‹h6›'),
                    'div' => esc_html('‹div›'),
                    'span' => esc_html('‹span›'),
                ],
            ]
        );

        $this->add_responsive_control(
            'position_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .author__position' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'position_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .author__position' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs('position_colors');

        $this->start_controls_tab(
            'position_color_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_control(
            'custom_position_color',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .author__position' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_position_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_control(
            'position_color_hover',
            [
                'label' => esc_html__('Text Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'dynamic' => ['active' => true],
                'selectors' => [
                    '{{WRAPPER}} .author__position:hover' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'custom_fonts_position',
                'selector' => '{{WRAPPER}} .author__position',
            ]
        );

        $this->end_controls_section();
    }

    protected function render()
    {
        (new Testimonials_Template())->render(
            $this,
            $this->get_settings_for_display()
        );
    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}
