<?php
/**
 * This template can be overridden by copying it to `yourtheme[-child]/bili-core/elementor/widgets/wgl-time-line-horizontal.php`.
 */
namespace WGL_Extensions\Widgets;

defined( 'ABSPATH' ) || exit; // Abort, if called directly.

use Elementor\{Group_Control_Background,
    Widget_Base,
    Controls_Manager,
    Control_Media,
    Frontend,
    Repeater,
    Group_Control_Border,
    Group_Control_Box_Shadow,
    Group_Control_Typography};

use WGL_Extensions\{
    Includes\WGL_Carousel_Settings,
    Includes\WGL_Elementor_Helper
};
use WGL_Extensions\WGL_Framework_Global_Variables as WGL_Globals;


class Wgl_Time_Line_Horizontal extends Widget_Base
{
    public function get_name() {
        return 'wgl-time-line-horizontal';
    }

    public function get_title() {
        return esc_html__('WGL Time Line Horizontal', 'bili-core');
    }

    public function get_icon() {
        return 'wgl-time-line-vertical';
    }

    public function get_categories()
    {
        return ['wgl-modules'];
    }

    public function get_script_depends() {
        return [ 'jquery-appear' ];
    }


    protected function register_controls()
    {
        /**
         * CONTENT -> GENERAL
         */

        $this->start_controls_section(
            'wgl_time_line_h_section',
            [
                'label' => esc_html__('General', 'bili-core'),
            ]
        );

        $this->add_responsive_control(
            'item_grid',
            [
                'label' => esc_html__('Grid Columns Amount', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 1, 'max' => 6 ],
                ],
                'size_units' => ['px'],
                'default' => ['size' => 3],
                'tablet_default' => ['size' => 2],
                'mobile_default' => ['size' => 1],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-items_wrap' => '--items-width: calc(100% / {{SIZE}});',
                ],
                'label_block' => true,
            ]
        );

        $this->add_control(
            'item_grid_refresh',
            [
                'type' => Controls_Manager::HIDDEN,
                'render_type' => 'template',
            ]
        );

        $this->add_control(
            'item_grid_alignment',
            [
                'label' => esc_html__('Alignment', 'bili-core'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__('Left', 'bili-core'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__('Center', 'bili-core'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__('Right', 'bili-core'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-items_wrap' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'add_appear',
            [
                'label' => esc_html__('Add Appear Animation', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('On', 'bili-core'),
                'label_off' => esc_html__('Off', 'bili-core'),
                'default' => 'yes',
            ]
        );

        $this->add_control(
            'disable_overflow',
            [
                'label' => esc_html__('Disable Overflow', 'bili-core'),
                'type' => Controls_Manager::SWITCHER,
                'default' => 'yes',
                'condition' => [ 'use_carousel!' => '' ],
                'selectors' => [
                    '{{WRAPPER}} .swiper-container' => 'overflow: visible;',
                ],
            ]
        );

        $this->end_controls_section();

        /**
         * CONTENT -> CONTENT
         */

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__('Content', 'bili-core'),
            ]
        );

        $repeater = new Repeater();

	    $repeater->add_control(
		    'date',
		    [
			    'label' => esc_html__('Date', 'bili-core'),
			    'type' => Controls_Manager::TEXT,
		    ]
	    );

	    $repeater->add_control(
		    'content_type',
		    [
			    'label' => esc_html__('Content Type', 'bili-core'),
			    'type' => Controls_Manager::SELECT,
			    'options' => [
				    'content' => esc_html__('Content', 'bili-core'),
				    'template' => esc_html__('Saved Templates', 'bili-core'),
			    ],
			    'default' => 'content',
		    ]
	    );
	    $repeater->add_control(
		    'content_templates',
		    [
			    'label' => esc_html__('Choose Template', 'bili-core'),
			    'type' => Controls_Manager::SELECT,
			    'condition' => [ 'content_type' => 'template' ],
			    'options' => Wgl_Elementor_Helper::get_instance()->get_elementor_templates(),
		    ]
	    );

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__('Title', 'bili-core'),
                'type' => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__('This is the heading', 'bili-core'),
                'dynamic' => [ 'active' => true],
                'condition' => [ 'content_type' => 'content' ],
            ]
        );

        $repeater->add_control(
            'content',
            [
                'label' => esc_html__('Content', 'bili-core'),
                'type' => Controls_Manager::WYSIWYG,
                'dynamic' => [ 'active' => true],
                'condition' => [ 'content_type' => 'content' ],
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__('Layers', 'bili-core'),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'date' => esc_html__('2015', 'bili-core'),
                        'content' => '<h5>Awwwards</h5><p>Website of the day</p><p>Mobile exelence</p><h5>CSS Design Awards</h5><p>Honorable mention</p>',
                    ],
                    [
                        'date' => esc_html__('2017', 'bili-core'),
                        'content' => '<h5>Awwwards</h5><p>Website of the day</p><h5>CSS Design Awards</h5><p>Honorable mention</p>',
                    ],
                    [
                        'date' => esc_html__('2018', 'bili-core'),
                        'content' => '<h5>Awwwards</h5><p>Website of the day</p><p>Mobile exelence</p><h5>CSS Design Awards</h5><p>Honorable mention</p>',
                    ],
                ],
                'title_field' => '{{title}}',
            ]
        );

        $this->end_controls_section();

        /**
         * CONTENT -> CAROUSEL OPTIONS
         */

        WGL_Carousel_Settings::add_controls($this, [
            'slide_per_single' => [ 'default' => 1 ],
            'use_navigation' => [ 'default' => 1 ],
            'use_responsive' => false,
        ]);

        /**
         * STYLES -> ITEMS
         */

        $this->start_controls_section(
            'section_style_items',
            [
                'label' => esc_html__('Items', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'items_gap',
            [
                'label' => esc_html__('Items Gap', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => ['min' => 0, 'max' => 60, 'step' => 2],
                ],
                'devices' => [ 'desktop', 'tablet', 'mobile' ],
                'default' => [ 'size' => '30' ],
                'tablet_default' => ['size' => '30'],
                'mobile_default' => ['size' => '20'],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-items_wrap' => '--items-gap: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->add_responsive_control(
            'items_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-content' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'items_border_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', '%'],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-content' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs(
            'tabs_items',
            ['separator' => 'before']
        );

        $this->start_controls_tab(
            'tab_item_idle',
            ['label' => esc_html__('Idle', 'bili-core')]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_idle',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .time_line_h-content',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_idle',
                'selector' => '{{WRAPPER}} .time_line_h-content',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'tab_item_hover',
            ['label' => esc_html__('Hover', 'bili-core')]
        );

        $this->add_group_control(
            Group_Control_Background::get_type(),
            [
                'name' => 'item_hover',
                'types' => ['classic', 'gradient'],
                'selector' => '{{WRAPPER}} .time_line_h-items:hover .time_line_h-content',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'item_hover',
                'selector' => '{{WRAPPER}} .time_line_h-items:hover .time_line_h-content',
            ]
        );

        $this->add_control(
            'item_transition',
            [
                'label' => esc_html__('Transition Duration', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'size_units' => ['s'],
                'range' => [
                    's' => ['min' => 0, 'max' => 2, 'step' => 0.1 ],
                ],
                'default' => ['size' => 0.4, 'unit' => 's'],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-content' => 'transition: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLE -> DATE
         */

        $this->start_controls_section(
            'date_style_section',
            [
                'label' => esc_html__('Date', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'date_typo',
                'selector' => '{{WRAPPER}} .wgl-time_line-date',
            ]
        );

        $this->add_responsive_control(
            'date_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .wgl-time_line-date' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'date_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .wgl-time_line-date' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'separator_color',
            [
                'label' => esc_html__('Separator Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-date' => '--separator-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'separator_corner_size',
            [
                'label' => esc_html__('Corner Size', 'bili-core'),
                'type' => Controls_Manager::SLIDER,
                'range' => [
                    'px' => [ 'min' => 5,'max' => 80 ],
                ],
                'size_units' => [ 'px' ],
                'default' => [ 'size' => 14, 'unit' => 'px' ],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-date .wgl-time_line-separator' => '--triangle-size: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'date_colors' );

        $this->start_controls_tab(
            'date_colors_idle',
            [
                'label' => esc_html__('Idle', 'bili-core'),
            ]
        );

        $this->add_control(
            'date_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .wgl-time_line-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'date_bg_color',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-date' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'date_colors_hover',
            [
                'label' => esc_html__('Hover', 'bili-core'),
            ]
        );

        $this->add_control(
            'date_color_hover',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-items:hover .wgl-time_line-date' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'date_bg_color_hover',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-items:hover .time_line_h-date' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * STYLE -> TITLE
         */

        $this->start_controls_section(
            'title_style_section',
            [
                'label' => esc_html__('Title', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'title_typo',
                'selector' => '{{WRAPPER}} .time_line_h-title',
            ]
        );

        $this->add_responsive_control(
            'title_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-title' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'title_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-title' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->start_controls_tabs( 'title_colors' );

        $this->start_controls_tab(
            'title_colors_idle',
            [
                'label' => esc_html__('Idle', 'bili-core'),
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'title_colors_hover',
            [
                'label' => esc_html__('Hover', 'bili-core'),
            ]
        );

        $this->add_control(
            'title_hover_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-items:hover .time_line_h-title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();

        /**
         * CONTENT -> CONTENT
         */

        $this->start_controls_section(
            'content_style_section',
            [
                'label' => esc_html__('Content', 'bili-core'),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'name' => 'content_typo',
                'selector' => '{{WRAPPER}} .time_line_h-text',
            ]
        );

        $this->add_responsive_control(
            'content_margin',
            [
                'label' => esc_html__('Margin', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-content_wrap' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_responsive_control(
            'content_padding',
            [
                'label' => esc_html__('Padding', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => ['px', 'em', '%'],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-content_wrap' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'content_border_radius',
            [
                'label' => esc_html__('Border Radius', 'bili-core'),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-content_wrap' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],

            ]
        );

        $this->start_controls_tabs( 'content_colors' );
        $this->start_controls_tab(
            'content_colors_idle',
            [
                'label' => esc_html__('Idle', 'bili-core'),
            ]
        );

        $this->add_control(
            'content_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_bg_color',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-content_wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_border',
                'selector' => '{{WRAPPER}} .time_line_h-content_wrap',
            ]
        );

        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_shadow',
                'selector' => '{{WRAPPER}} .time_line_h-content_wrap',
            ]
        );

        $this->end_controls_tab();

        $this->start_controls_tab(
            'content_colors_hover',
            [
                'label' => esc_html__('Hover', 'bili-core'),
            ]
        );

        $this->add_control(
            'content_hover_color',
            [
                'label' => esc_html__('Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-items:hover .time_line_h-text' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'content_hover_bg_color',
            [
                'label' => esc_html__('Background Color', 'bili-core'),
                'type' => Controls_Manager::COLOR,
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}} .time_line_h-items:hover .time_line_h-content_wrap' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'content_hover_border',
                'selector' => '{{WRAPPER}} .time_line_h-items:hover .time_line_h-content_wrap',
            ]
        );
        $this->add_group_control(
            Group_Control_Box_Shadow::get_type(),
            [
                'name' => 'content_hover_shadow',
                'selector' => '{{WRAPPER}} .time_line_h-items:hover .time_line_h-content_wrap',
            ]
        );

        $this->end_controls_tab();
        $this->end_controls_tabs();
        $this->end_controls_section();
    }

    protected function apply_carousel_settings($content)
    {
        $settings = $this->get_settings_for_display();

        $options = [
            'slides_per_row' => $settings['item_grid']['size'] ?? 4,
            'autoplay' => $settings['autoplay'],
            'autoplay_speed' => $settings['autoplay_speed'],
            'fade_animation' => $settings['fade_animation'],
            'slider_infinite' => $settings['slider_infinite'],
            'slide_per_single'  => $settings['slide_per_single'],
            'center_mode' => $settings['center_mode'],
            // Pagination
            'use_pagination' => $settings['use_pagination'],
            'pagination_type' => $settings['pagination_type'],
            // Navigation
            'use_navigation' => $settings['use_navigation'],
            'navigation_position' => $settings['navigation_position'],
            'navigation_view' => $settings['navigation_view'],
            // Responsive
            'responsive_gap' => [
                'desktop_gap' => !empty($settings['items_gap']['size']) ? $settings['items_gap'] : ['size' => 30],
                'tablet_gap' => !empty($settings['items_gap_tablet']['size']) ? $settings['items_gap_tablet'] : ['size' => 30],
                'mobile_gap' => !empty($settings['items_gap_mobile']['size']) ? $settings['items_gap_mobile'] : ['size' => 20],
            ],
        ];

        return WGL_Carousel_Settings::init($options, $content);
    }

    protected function render()
    {
        wp_enqueue_script('jquery-appear', get_template_directory_uri() . '/js/jquery.appear.js', [], false, false);

        $settings = $this->get_settings_for_display();
        $_content = '';

	    $this->add_render_attribute( 'timeline-horizontal', [
		    'class' => [
			    'wgl-timeline-horizontal',
			    ( $settings['add_appear'] ? 'appear_anim' : '' ),
		    ],
	    ] );

	    $this->add_render_attribute( 'timeline-horizontal-items-wrap', [
		    'class' => [
			    'time_line_h-items_wrap',
                $settings['use_carousel'] ? 'carousel_active' : '',
		    ],
	    ] );

	    ?><div <?php echo $this->get_render_attribute_string( 'timeline-horizontal' ); ?>>
            <div <?php echo $this->get_render_attribute_string( 'timeline-horizontal-items-wrap' ); ?>><?php

            foreach ( $settings[ 'items' ] as $index => $item ) {

                ob_start();
                $title = $this->get_repeater_setting_key( 'title', 'items' , $index );
                $this->add_render_attribute(
                    $title,
                    [ 'class' => 'time_line_h-title' ]
                );

                $_content .= '<div class="time_line_h-items '. ($settings['use_carousel'] ? ' swiper-slide' : '' ) . '">';
                $_content .= '<div class="time_line_h-content">';

                $_content .= '<div class="time_line_h-date">';
                    $_content .= '<span class="wgl-time_line-date">'.$item[ 'date' ].'</span>';
                    $_content .= '<span class="wgl-time_line-separator"></span>';
                $_content .= '</div>';

	            $_content .= '<div class="time_line_h-content_wrap">';
	            if ( $item['content_type'] == 'content' ) {
		            if ( ! empty( $item['content'] ) || ! empty( $item['title'] ) ) {
			            if ( ! empty( $item['title'] ) ) {
				            $_content .= '<h3 ' . $this->get_render_attribute_string( $title ) . '>' . $item['title'] . '</h3>';
			            }
			            if ( ! empty( $item['content'] ) ) {
				            $_content .= '<div class="time_line_h-text">' . $item['content'] . '</div>';
			            }
		            }
	            } else if ( $item['content_type'] == 'template' ) {
		            $wgl_frontend = new Frontend;
		            $_content .= $wgl_frontend->get_builder_content_for_display( $item['content_templates'], false );
	            }
	            $_content .= '</div>';

	            $_content .= '</div>';
	            $_content .= '</div>';

                $_content .= ob_get_clean();

            } // end foreach

            echo !$settings[ 'use_carousel'] ? $_content : $this->apply_carousel_settings($_content);

            ?></div>
        </div><?php

    }

    public function wpml_support_module() {
        add_filter( 'wpml_elementor_widgets_to_translate',  [$this, 'wpml_widgets_to_translate_filter']);
    }

    public function wpml_widgets_to_translate_filter( $widgets ){
        return \WGL_Extensions\Includes\WGL_WPML_Settings::get_translate(
            $this, $widgets
        );
    }
}