<?php

if (!function_exists('wgl_extended_example')) {
    /**
     * Add menu and rev slider to demo content.
     * Set defaults settings.
     *
     * @package     wgl_Importer - Extension for Importing demo content
     * @author      Webcreations907
     * @version     1.0
     */
    function wgl_extended_example($demo_active_import, $demo_directory_path)
    {
        
        reset($demo_active_import);
        $current_key = key($demo_active_import);

        
        /**
         * Menu(s)
         */

        // Set menu name
        $menu_array = [
            'full' => 'main'
        ];

        if (
            !empty($demo_active_import[$current_key]['directory'])
            && array_key_exists($demo_active_import[$current_key]['directory'], $menu_array)
        ) {
            $top_menu = get_term_by('name', $menu_array[$demo_active_import[$current_key]['directory']], 'nav_menu');
            if (isset($top_menu->term_id)) {
                set_theme_mod('nav_menu_locations', ['main_menu' => $top_menu->term_id]);
            }
        }


        /**
         * Home Page(s)
         */

        // Array of `demos => homepages` to select from
        $home_pages = [
            'full' => 'Homepage 2',
        ];

        if (
            !empty($demo_active_import[$current_key]['directory'])
            && array_key_exists($demo_active_import[$current_key]['directory'], $home_pages)
        ) {
            $page = get_page_by_title($home_pages[$demo_active_import[$current_key]['directory']]);
            if (isset($page->ID)) {
                update_option('page_on_front', $page->ID);
                update_option('show_on_front', 'page');
            }
        }


        /**
         * Elementor defaults
         */

        // Support all Custom Post Types
        $cpt_support = get_option('elementor_cpt_support');
        if (!$cpt_support) {
            $cpt_support = ['page', 'post', 'portfolio', 'team', 'footer', 'side_panel', 'header'];
            update_option('elementor_cpt_support', $cpt_support);
        } else {
            $include_cpt = ['portfolio', 'team', 'footer', 'side_panel', 'header'];
            foreach ($include_cpt as $cpt) {
                if (!in_array($cpt, $cpt_support)) {
                    $cpt_support[] = $cpt;
                }
            }
            update_option('elementor_cpt_support', $cpt_support);
        }

        update_option('elementor_experiment-e_optimized_css_loading', 'inactive');

        update_option('elementor_container_width', 1170);
        // Font Awesome Styles
        update_option('elementor_load_fa4_shim', 'yes');

        /**
         * WGL Defaults
         * */
        global $wgl_elementor_page_settings;
        global $wpdb;
        if(!empty($GLOBALS['wgl_elementor_page_settings'])){
            $like = '%'.$GLOBALS['wgl_elementor_page_settings'].'%';
            $result = $wpdb->get_row($wpdb->prepare("SELECT post_id FROM {$wpdb->prefix}postmeta WHERE meta_key='_elementor_page_settings' AND meta_value LIKE %s", $like), ARRAY_N);
            if (!empty($result)) {
                if (
                    defined('ELEMENTOR_VERSION')
                    && version_compare(ELEMENTOR_VERSION, '3.0', '>=')
                ) {
                    if(isset($result[0])){
                        update_option( 'elementor_active_full_import', 'yes' );
                        update_option( 'elementor_active_kit', $result[0] );
                        \Elementor\Plugin::$instance->files_manager->clear_cache();
                    }
                }
            }
            unset($GLOBALS['wgl_elementor_page_settings']);
        }

        // Permalink Structure
        update_option('permalink_structure', "/%postname%/");
    }

    add_action('wgl_importer_after_content_import', 'wgl_extended_example', 10, 2);

    function wgl_default_kits_init($atts)
    {
        if (!get_option('elementor_active_full_import')) {
            $kit_id = (new \Elementor\Core\Kits\Manager())->get_active_id();

            if(!$kit_id){
                return;
            }            
            
            $page_settings_manager = \Elementor\Core\Settings\Manager::get_settings_managers('page');
    
            $meta_key = \Elementor\Core\Settings\Page\Manager::META_KEY;
            $kit_settings = get_post_meta($kit_id, $meta_key, true);
    
            $wgl_settings = [];

            $settings = \Elementor\Plugin::$instance->kits_manager->get_active_kit_for_frontend();

            $system_items = $settings->get_settings_for_display('system_colors');            
            
            if (!$system_items) {
                $system_items = [];
            }

            $system_items[0]['color'] = '#FF7425';
            $system_items[1]['color'] = '';
            $system_items[2]['color'] = '';
            $system_items[3]['color'] = '#FF7425';
    
            $wgl_settings['system_colors'] = $system_items;
            
            if (!$kit_settings) {
                update_metadata('post', $kit_id, $meta_key, $wgl_settings);
            } else {
                $kit_settings = array_merge($kit_settings, $wgl_settings);
                $page_settings_manager->save_settings($kit_settings, $kit_id);
            }
            update_option( 'elementor_active_full_import', 'yes' );
    
            \Elementor\Plugin::$instance->files_manager->clear_cache();
        }
    }
    
    add_action('wgl_importer_elementor_default_kit', 'wgl_default_kits_init' ,10);
}

