<?php

defined('ABSPATH') || exit;

if (!class_exists('WGL_Admin_Icon')) {
    /**
     * Bili WGL_Admin_Icon
     *
     *
     * @package bili\core\class
     * @author WebGeniusLab <webgeniuslab@gmail.com>
     * @since 1.0.0
     */
    class WGL_Admin_Icon
    {
        private $icons = [];

        private static $instance = null;
        public static function get_instance()
        {
            if (is_null(self::$instance)) {
                self::$instance = new self();
            }

            return self::$instance;
        }

        private function __construct()
        {
            $this->load();
        }

        public function load()
        {
            $this->setup_stylesheet_data();
        }

        private function setup_stylesheet_data()
        {
            $this->icons = $this->setup_icon_array();
        }

        private function setup_icon_array()
        {
            $icons = array();

            $icons = $this->get_icon_list();
            $icons = apply_filters('bili_icon_list', $icons);

            return $icons;
        }

        /*----------------------------------------------------------------------------*
         * Public Helper Functions
         *----------------------------------------------------------------------------*/
        public function get_icons_name($get_icons_value = false)
        {
            $icons = [];

            if (!empty($this->icons)) {
                foreach ($this->icons as $key => $value) {
                    $icons[$key] = (bool) $get_icons_value ? esc_html($key) : esc_html($value);
                }

                return $icons;
            } else {
                return $icons;
            }
        }

        public function get_icon_list()
        {
            return [
                'fab fa-500px' => esc_html__( '500px', 'bili' ),
                'fab fa-accessible-icon' => esc_html__( 'accessible-icon', 'bili' ),
                'fab fa-accusoft' => esc_html__( 'accusoft', 'bili' ),
                'fas fa-address-book' => esc_html__( 'address-book', 'bili' ),
                'far fa-address-book' => esc_html__( 'address-book', 'bili' ),
                'fas fa-address-card' => esc_html__( 'address-card', 'bili' ),
                'far fa-address-card' => esc_html__( 'address-card', 'bili' ),
                'fas fa-adjust' => esc_html__( 'adjust', 'bili' ),
                'fab fa-adn' => esc_html__( 'adn', 'bili' ),
                'fab fa-adversal' => esc_html__( 'adversal', 'bili' ),
                'fab fa-affiliatetheme' => esc_html__( 'affiliatetheme', 'bili' ),
                'fab fa-algolia' => esc_html__( 'algolia', 'bili' ),
                'fas fa-align-center' => esc_html__( 'align-center', 'bili' ),
                'fas fa-align-justify' => esc_html__( 'align-justify', 'bili' ),
                'fas fa-align-left' => esc_html__( 'align-left', 'bili' ),
                'fas fa-align-right' => esc_html__( 'align-right', 'bili' ),
                'fas fa-allergies' => esc_html__( 'allergies', 'bili' ),
                'fab fa-amazon' => esc_html__( 'amazon', 'bili' ),
                'fab fa-amazon-pay' => esc_html__( 'amazon-pay', 'bili' ),
                'fas fa-ambulance' => esc_html__( 'ambulance', 'bili' ),
                'fas fa-american-sign-language-interpreting' => esc_html__( 'american-sign-language-interpreting', 'bili' ),
                'fab fa-amilia' => esc_html__( 'amilia', 'bili' ),
                'fas fa-anchor' => esc_html__( 'anchor', 'bili' ),
                'fab fa-android' => esc_html__( 'android', 'bili' ),
                'fab fa-angellist' => esc_html__( 'angellist', 'bili' ),
                'fas fa-angle-double-down' => esc_html__( 'angle-double-down', 'bili' ),
                'fas fa-angle-double-left' => esc_html__( 'angle-double-left', 'bili' ),
                'fas fa-angle-double-right' => esc_html__( 'angle-double-right', 'bili' ),
                'fas fa-angle-double-up' => esc_html__( 'angle-double-up', 'bili' ),
                'fas fa-angle-down' => esc_html__( 'angle-down', 'bili' ),
                'fas fa-angle-left' => esc_html__( 'angle-left', 'bili' ),
                'fas fa-angle-right' => esc_html__( 'angle-right', 'bili' ),
                'fas fa-angle-up' => esc_html__( 'angle-up', 'bili' ),
                'fab fa-angrycreative' => esc_html__( 'angrycreative', 'bili' ),
                'fab fa-angular' => esc_html__( 'angular', 'bili' ),
                'fab fa-app-store' => esc_html__( 'app-store', 'bili' ),
                'fab fa-app-store-ios' => esc_html__( 'app-store-ios', 'bili' ),
                'fab fa-apper' => esc_html__( 'apper', 'bili' ),
                'fab fa-apple' => esc_html__( 'apple', 'bili' ),
                'fab fa-apple-pay' => esc_html__( 'apple-pay', 'bili' ),
                'fas fa-archive' => esc_html__( 'archive', 'bili' ),
                'fas fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'bili' ),
                'far fa-arrow-alt-circle-down' => esc_html__( 'arrow-alt-circle-down', 'bili' ),
                'fas fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'bili' ),
                'far fa-arrow-alt-circle-left' => esc_html__( 'arrow-alt-circle-left', 'bili' ),
                'fas fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'bili' ),
                'far fa-arrow-alt-circle-right' => esc_html__( 'arrow-alt-circle-right', 'bili' ),
                'fas fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'bili' ),
                'far fa-arrow-alt-circle-up' => esc_html__( 'arrow-alt-circle-up', 'bili' ),
                'fas fa-arrow-circle-down' => esc_html__( 'arrow-circle-down', 'bili' ),
                'fas fa-arrow-circle-left' => esc_html__( 'arrow-circle-left', 'bili' ),
                'fas fa-arrow-circle-right' => esc_html__( 'arrow-circle-right', 'bili' ),
                'fas fa-arrow-circle-up' => esc_html__( 'arrow-circle-up', 'bili' ),
                'fas fa-arrow-down' => esc_html__( 'arrow-down', 'bili' ),
                'fas fa-arrow-left' => esc_html__( 'arrow-left', 'bili' ),
                'fas fa-arrow-right' => esc_html__( 'arrow-right', 'bili' ),
                'fas fa-arrow-up' => esc_html__( 'arrow-up', 'bili' ),
                'fas fa-arrows-alt' => esc_html__( 'arrows-alt', 'bili' ),
                'fas fa-arrows-alt-h' => esc_html__( 'arrows-alt-h', 'bili' ),
                'fas fa-arrows-alt-v' => esc_html__( 'arrows-alt-v', 'bili' ),
                'fas fa-assistive-listening-systems' => esc_html__( 'assistive-listening-systems', 'bili' ),
                'fas fa-asterisk' => esc_html__( 'asterisk', 'bili' ),
                'fab fa-asymmetrik' => esc_html__( 'asymmetrik', 'bili' ),
                'fas fa-at' => esc_html__( 'at', 'bili' ),
                'fab fa-audible' => esc_html__( 'audible', 'bili' ),
                'fas fa-audio-description' => esc_html__( 'audio-description', 'bili' ),
                'fab fa-autoprefixer' => esc_html__( 'autoprefixer', 'bili' ),
                'fab fa-avianex' => esc_html__( 'avianex', 'bili' ),
                'fab fa-aviato' => esc_html__( 'aviato', 'bili' ),
                'fab fa-aws' => esc_html__( 'aws', 'bili' ),
                'fas fa-backward' => esc_html__( 'backward', 'bili' ),
                'fas fa-balance-scale' => esc_html__( 'balance-scale', 'bili' ),
                'fas fa-ban' => esc_html__( 'ban', 'bili' ),
                'fas fa-band-aid' => esc_html__( 'band-aid', 'bili' ),
                'fab fa-bandcamp' => esc_html__( 'bandcamp', 'bili' ),
                'fas fa-barcode' => esc_html__( 'barcode', 'bili' ),
                'fas fa-bars' => esc_html__( 'bars', 'bili' ),
                'fas fa-baseball-ball' => esc_html__( 'baseball-ball', 'bili' ),
                'fas fa-basketball-ball' => esc_html__( 'basketball-ball', 'bili' ),
                'fas fa-bath' => esc_html__( 'bath', 'bili' ),
                'fas fa-battery-empty' => esc_html__( 'battery-empty', 'bili' ),
                'fas fa-battery-full' => esc_html__( 'battery-full', 'bili' ),
                'fas fa-battery-half' => esc_html__( 'battery-half', 'bili' ),
                'fas fa-battery-quarter' => esc_html__( 'battery-quarter', 'bili' ),
                'fas fa-battery-three-quarters' => esc_html__( 'battery-three-quarters', 'bili' ),
                'fas fa-bed' => esc_html__( 'bed', 'bili' ),
                'fas fa-beer' => esc_html__( 'beer', 'bili' ),
                'fab fa-behance' => esc_html__( 'behance', 'bili' ),
                'fab fa-behance-square' => esc_html__( 'behance-square', 'bili' ),
                'fas fa-bell' => esc_html__( 'bell', 'bili' ),
                'far fa-bell' => esc_html__( 'bell', 'bili' ),
                'fas fa-bell-slash' => esc_html__( 'bell-slash', 'bili' ),
                'far fa-bell-slash' => esc_html__( 'bell-slash', 'bili' ),
                'fas fa-bicycle' => esc_html__( 'bicycle', 'bili' ),
                'fab fa-bimobject' => esc_html__( 'bimobject', 'bili' ),
                'fas fa-binoculars' => esc_html__( 'binoculars', 'bili' ),
                'fas fa-birthday-cake' => esc_html__( 'birthday-cake', 'bili' ),
                'fab fa-bitbucket' => esc_html__( 'bitbucket', 'bili' ),
                'fab fa-bitcoin' => esc_html__( 'bitcoin', 'bili' ),
                'fab fa-bity' => esc_html__( 'bity', 'bili' ),
                'fab fa-black-tie' => esc_html__( 'black-tie', 'bili' ),
                'fab fa-blackberry' => esc_html__( 'blackberry', 'bili' ),
                'fas fa-blind' => esc_html__( 'blind', 'bili' ),
                'fab fa-blogger' => esc_html__( 'blogger', 'bili' ),
                'fab fa-blogger-b' => esc_html__( 'blogger-b', 'bili' ),
                'fab fa-bluetooth' => esc_html__( 'bluetooth', 'bili' ),
                'fab fa-bluetooth-b' => esc_html__( 'bluetooth-b', 'bili' ),
                'fas fa-bold' => esc_html__( 'bold', 'bili' ),
                'fas fa-bolt' => esc_html__( 'bolt', 'bili' ),
                'fas fa-bomb' => esc_html__( 'bomb', 'bili' ),
                'fas fa-book' => esc_html__( 'book', 'bili' ),
                'fas fa-bookmark' => esc_html__( 'bookmark', 'bili' ),
                'far fa-bookmark' => esc_html__( 'bookmark', 'bili' ),
                'fas fa-bowling-ball' => esc_html__( 'bowling-ball', 'bili' ),
                'fas fa-box' => esc_html__( 'box', 'bili' ),
                'fas fa-box-open' => esc_html__( 'box-open', 'bili' ),
                'fas fa-boxes' => esc_html__( 'boxes', 'bili' ),
                'fas fa-braille' => esc_html__( 'braille', 'bili' ),
                'fas fa-briefcase' => esc_html__( 'briefcase', 'bili' ),
                'fas fa-briefcase-medical' => esc_html__( 'briefcase-medical', 'bili' ),
                'fab fa-btc' => esc_html__( 'btc', 'bili' ),
                'fas fa-bug' => esc_html__( 'bug', 'bili' ),
                'fas fa-building' => esc_html__( 'building', 'bili' ),
                'far fa-building' => esc_html__( 'building', 'bili' ),
                'fas fa-bullhorn' => esc_html__( 'bullhorn', 'bili' ),
                'fas fa-bullseye' => esc_html__( 'bullseye', 'bili' ),
                'fas fa-burn' => esc_html__( 'burn', 'bili' ),
                'fab fa-buromobelexperte' => esc_html__( 'buromobelexperte', 'bili' ),
                'fas fa-bus' => esc_html__( 'bus', 'bili' ),
                'fab fa-buysellads' => esc_html__( 'buysellads', 'bili' ),
                'fas fa-calculator' => esc_html__( 'calculator', 'bili' ),
                'fas fa-calendar' => esc_html__( 'calendar', 'bili' ),
                'far fa-calendar' => esc_html__( 'calendar', 'bili' ),
                'fas fa-calendar-alt' => esc_html__( 'calendar-alt', 'bili' ),
                'far fa-calendar-alt' => esc_html__( 'calendar-alt', 'bili' ),
                'fas fa-calendar-check' => esc_html__( 'calendar-check', 'bili' ),
                'far fa-calendar-check' => esc_html__( 'calendar-check', 'bili' ),
                'fas fa-calendar-minus' => esc_html__( 'calendar-minus', 'bili' ),
                'far fa-calendar-minus' => esc_html__( 'calendar-minus', 'bili' ),
                'fas fa-calendar-plus' => esc_html__( 'calendar-plus', 'bili' ),
                'far fa-calendar-plus' => esc_html__( 'calendar-plus', 'bili' ),
                'fas fa-calendar-times' => esc_html__( 'calendar-times', 'bili' ),
                'far fa-calendar-times' => esc_html__( 'calendar-times', 'bili' ),
                'fas fa-camera' => esc_html__( 'camera', 'bili' ),
                'fas fa-camera-retro' => esc_html__( 'camera-retro', 'bili' ),
                'fas fa-capsules' => esc_html__( 'capsules', 'bili' ),
                'fas fa-car' => esc_html__( 'car', 'bili' ),
                'fas fa-caret-down' => esc_html__( 'caret-down', 'bili' ),
                'fas fa-caret-left' => esc_html__( 'caret-left', 'bili' ),
                'fas fa-caret-right' => esc_html__( 'caret-right', 'bili' ),
                'fas fa-caret-square-down' => esc_html__( 'caret-square-down', 'bili' ),
                'far fa-caret-square-down' => esc_html__( 'caret-square-down', 'bili' ),
                'fas fa-caret-square-left' => esc_html__( 'caret-square-left', 'bili' ),
                'far fa-caret-square-left' => esc_html__( 'caret-square-left', 'bili' ),
                'fas fa-caret-square-right' => esc_html__( 'caret-square-right', 'bili' ),
                'far fa-caret-square-right' => esc_html__( 'caret-square-right', 'bili' ),
                'fas fa-caret-square-up' => esc_html__( 'caret-square-up', 'bili' ),
                'far fa-caret-square-up' => esc_html__( 'caret-square-up', 'bili' ),
                'fas fa-caret-up' => esc_html__( 'caret-up', 'bili' ),
                'fas fa-cart-arrow-down' => esc_html__( 'cart-arrow-down', 'bili' ),
                'fas fa-cart-plus' => esc_html__( 'cart-plus', 'bili' ),
                'fab fa-cc-amazon-pay' => esc_html__( 'cc-amazon-pay', 'bili' ),
                'fab fa-cc-amex' => esc_html__( 'cc-amex', 'bili' ),
                'fab fa-cc-apple-pay' => esc_html__( 'cc-apple-pay', 'bili' ),
                'fab fa-cc-diners-club' => esc_html__( 'cc-diners-club', 'bili' ),
                'fab fa-cc-discover' => esc_html__( 'cc-discover', 'bili' ),
                'fab fa-cc-jcb' => esc_html__( 'cc-jcb', 'bili' ),
                'fab fa-cc-mastercard' => esc_html__( 'cc-mastercard', 'bili' ),
                'fab fa-cc-paypal' => esc_html__( 'cc-paypal', 'bili' ),
                'fab fa-cc-stripe' => esc_html__( 'cc-stripe', 'bili' ),
                'fab fa-cc-visa' => esc_html__( 'cc-visa', 'bili' ),
                'fab fa-centercode' => esc_html__( 'centercode', 'bili' ),
                'fas fa-certificate' => esc_html__( 'certificate', 'bili' ),
                'fas fa-chart-area' => esc_html__( 'chart-area', 'bili' ),
                'fas fa-chart-bar' => esc_html__( 'chart-bar', 'bili' ),
                'far fa-chart-bar' => esc_html__( 'chart-bar', 'bili' ),
                'fas fa-chart-line' => esc_html__( 'chart-line', 'bili' ),
                'fas fa-chart-pie' => esc_html__( 'chart-pie', 'bili' ),
                'fas fa-check' => esc_html__( 'check', 'bili' ),
                'fas fa-check-circle' => esc_html__( 'check-circle', 'bili' ),
                'far fa-check-circle' => esc_html__( 'check-circle', 'bili' ),
                'fas fa-check-square' => esc_html__( 'check-square', 'bili' ),
                'far fa-check-square' => esc_html__( 'check-square', 'bili' ),
                'fas fa-chess' => esc_html__( 'chess', 'bili' ),
                'fas fa-chess-bishop' => esc_html__( 'chess-bishop', 'bili' ),
                'fas fa-chess-board' => esc_html__( 'chess-board', 'bili' ),
                'fas fa-chess-king' => esc_html__( 'chess-king', 'bili' ),
                'fas fa-chess-knight' => esc_html__( 'chess-knight', 'bili' ),
                'fas fa-chess-pawn' => esc_html__( 'chess-pawn', 'bili' ),
                'fas fa-chess-queen' => esc_html__( 'chess-queen', 'bili' ),
                'fas fa-chess-rook' => esc_html__( 'chess-rook', 'bili' ),
                'fas fa-chevron-circle-down' => esc_html__( 'chevron-circle-down', 'bili' ),
                'fas fa-chevron-circle-left' => esc_html__( 'chevron-circle-left', 'bili' ),
                'fas fa-chevron-circle-right' => esc_html__( 'chevron-circle-right', 'bili' ),
                'fas fa-chevron-circle-up' => esc_html__( 'chevron-circle-up', 'bili' ),
                'fas fa-chevron-down' => esc_html__( 'chevron-down', 'bili' ),
                'fas fa-chevron-left' => esc_html__( 'chevron-left', 'bili' ),
                'fas fa-chevron-right' => esc_html__( 'chevron-right', 'bili' ),
                'fas fa-chevron-up' => esc_html__( 'chevron-up', 'bili' ),
                'fas fa-child' => esc_html__( 'child', 'bili' ),
                'fab fa-chrome' => esc_html__( 'chrome', 'bili' ),
                'fas fa-circle' => esc_html__( 'circle', 'bili' ),
                'far fa-circle' => esc_html__( 'circle', 'bili' ),
                'fas fa-circle-notch' => esc_html__( 'circle-notch', 'bili' ),
                'fas fa-clipboard' => esc_html__( 'clipboard', 'bili' ),
                'far fa-clipboard' => esc_html__( 'clipboard', 'bili' ),
                'fas fa-clipboard-check' => esc_html__( 'clipboard-check', 'bili' ),
                'fas fa-clipboard-list' => esc_html__( 'clipboard-list', 'bili' ),
                'fas fa-clock' => esc_html__( 'clock', 'bili' ),
                'far fa-clock' => esc_html__( 'clock', 'bili' ),
                'fas fa-clone' => esc_html__( 'clone', 'bili' ),
                'far fa-clone' => esc_html__( 'clone', 'bili' ),
                'fas fa-closed-captioning' => esc_html__( 'closed-captioning', 'bili' ),
                'far fa-closed-captioning' => esc_html__( 'closed-captioning', 'bili' ),
                'fas fa-cloud' => esc_html__( 'cloud', 'bili' ),
                'fas fa-cloud-download-alt' => esc_html__( 'cloud-download-alt', 'bili' ),
                'fas fa-cloud-upload-alt' => esc_html__( 'cloud-upload-alt', 'bili' ),
                'fab fa-cloudscale' => esc_html__( 'cloudscale', 'bili' ),
                'fab fa-cloudsmith' => esc_html__( 'cloudsmith', 'bili' ),
                'fab fa-cloudversify' => esc_html__( 'cloudversify', 'bili' ),
                'fas fa-code' => esc_html__( 'code', 'bili' ),
                'fas fa-code-branch' => esc_html__( 'code-branch', 'bili' ),
                'fab fa-codepen' => esc_html__( 'codepen', 'bili' ),
                'fab fa-codiepie' => esc_html__( 'codiepie', 'bili' ),
                'fas fa-coffee' => esc_html__( 'coffee', 'bili' ),
                'fas fa-cog' => esc_html__( 'cog', 'bili' ),
                'fas fa-cogs' => esc_html__( 'cogs', 'bili' ),
                'fas fa-columns' => esc_html__( 'columns', 'bili' ),
                'fas fa-comment' => esc_html__( 'comment', 'bili' ),
                'far fa-comment' => esc_html__( 'comment', 'bili' ),
                'fas fa-comment-alt' => esc_html__( 'comment-alt', 'bili' ),
                'far fa-comment-alt' => esc_html__( 'comment-alt', 'bili' ),
                'fas fa-comment-dots' => esc_html__( 'comment-dots', 'bili' ),
                'fas fa-comment-slash' => esc_html__( 'comment-slash', 'bili' ),
                'fas fa-comments' => esc_html__( 'comments', 'bili' ),
                'far fa-comments' => esc_html__( 'comments', 'bili' ),
                'fas fa-compass' => esc_html__( 'compass', 'bili' ),
                'far fa-compass' => esc_html__( 'compass', 'bili' ),
                'fas fa-compress' => esc_html__( 'compress', 'bili' ),
                'fab fa-connectdevelop' => esc_html__( 'connectdevelop', 'bili' ),
                'fab fa-contao' => esc_html__( 'contao', 'bili' ),
                'fas fa-copy' => esc_html__( 'copy', 'bili' ),
                'far fa-copy' => esc_html__( 'copy', 'bili' ),
                'fas fa-copyright' => esc_html__( 'copyright', 'bili' ),
                'far fa-copyright' => esc_html__( 'copyright', 'bili' ),
                'fas fa-couch' => esc_html__( 'couch', 'bili' ),
                'fab fa-cpanel' => esc_html__( 'cpanel', 'bili' ),
                'fab fa-creative-commons' => esc_html__( 'creative-commons', 'bili' ),
                'fas fa-credit-card' => esc_html__( 'credit-card', 'bili' ),
                'far fa-credit-card' => esc_html__( 'credit-card', 'bili' ),
                'fas fa-crop' => esc_html__( 'crop', 'bili' ),
                'fas fa-crosshairs' => esc_html__( 'crosshairs', 'bili' ),
                'fab fa-css3' => esc_html__( 'css3', 'bili' ),
                'fab fa-css3-alt' => esc_html__( 'css3-alt', 'bili' ),
                'fas fa-cube' => esc_html__( 'cube', 'bili' ),
                'fas fa-cubes' => esc_html__( 'cubes', 'bili' ),
                'fas fa-cut' => esc_html__( 'cut', 'bili' ),
                'fab fa-cuttlefish' => esc_html__( 'cuttlefish', 'bili' ),
                'fab fa-d-and-d' => esc_html__( 'd-and-d', 'bili' ),
                'fab fa-dashcube' => esc_html__( 'dashcube', 'bili' ),
                'fas fa-database' => esc_html__( 'database', 'bili' ),
                'fas fa-deaf' => esc_html__( 'deaf', 'bili' ),
                'fab fa-delicious' => esc_html__( 'delicious', 'bili' ),
                'fab fa-deploydog' => esc_html__( 'deploydog', 'bili' ),
                'fab fa-deskpro' => esc_html__( 'deskpro', 'bili' ),
                'fas fa-desktop' => esc_html__( 'desktop', 'bili' ),
                'fab fa-deviantart' => esc_html__( 'deviantart', 'bili' ),
                'fas fa-diagnoses' => esc_html__( 'diagnoses', 'bili' ),
                'fab fa-digg' => esc_html__( 'digg', 'bili' ),
                'fab fa-digital-ocean' => esc_html__( 'digital-ocean', 'bili' ),
                'fab fa-discord' => esc_html__( 'discord', 'bili' ),
                'fab fa-discourse' => esc_html__( 'discourse', 'bili' ),
                'fas fa-dna' => esc_html__( 'dna', 'bili' ),
                'fab fa-dochub' => esc_html__( 'dochub', 'bili' ),
                'fab fa-docker' => esc_html__( 'docker', 'bili' ),
                'fas fa-dollar-sign' => esc_html__( 'dollar-sign', 'bili' ),
                'fas fa-dolly' => esc_html__( 'dolly', 'bili' ),
                'fas fa-dolly-flatbed' => esc_html__( 'dolly-flatbed', 'bili' ),
                'fas fa-donate' => esc_html__( 'donate', 'bili' ),
                'fas fa-dot-circle' => esc_html__( 'dot-circle', 'bili' ),
                'far fa-dot-circle' => esc_html__( 'dot-circle', 'bili' ),
                'fas fa-dove' => esc_html__( 'dove', 'bili' ),
                'fas fa-download' => esc_html__( 'download', 'bili' ),
                'fab fa-draft2digital' => esc_html__( 'draft2digital', 'bili' ),
                'fab fa-dribbble' => esc_html__( 'dribbble', 'bili' ),
                'fab fa-dribbble-square' => esc_html__( 'dribbble-square', 'bili' ),
                'fab fa-dropbox' => esc_html__( 'dropbox', 'bili' ),
                'fab fa-drupal' => esc_html__( 'drupal', 'bili' ),
                'fab fa-dyalog' => esc_html__( 'dyalog', 'bili' ),
                'fab fa-earlybirds' => esc_html__( 'earlybirds', 'bili' ),
                'fab fa-edge' => esc_html__( 'edge', 'bili' ),
                'fas fa-edit' => esc_html__( 'edit', 'bili' ),
                'far fa-edit' => esc_html__( 'edit', 'bili' ),
                'fas fa-eject' => esc_html__( 'eject', 'bili' ),
                'fab fa-elementor' => esc_html__( 'elementor', 'bili' ),
                'fas fa-ellipsis-h' => esc_html__( 'ellipsis-h', 'bili' ),
                'fas fa-ellipsis-v' => esc_html__( 'ellipsis-v', 'bili' ),
                'fab fa-ember' => esc_html__( 'ember', 'bili' ),
                'fab fa-empire' => esc_html__( 'empire', 'bili' ),
                'fas fa-envelope' => esc_html__( 'envelope', 'bili' ),
                'far fa-envelope' => esc_html__( 'envelope', 'bili' ),
                'fas fa-envelope-open' => esc_html__( 'envelope-open', 'bili' ),
                'far fa-envelope-open' => esc_html__( 'envelope-open', 'bili' ),
                'fas fa-envelope-square' => esc_html__( 'envelope-square', 'bili' ),
                'fab fa-envira' => esc_html__( 'envira', 'bili' ),
                'fas fa-eraser' => esc_html__( 'eraser', 'bili' ),
                'fab fa-erlang' => esc_html__( 'erlang', 'bili' ),
                'fab fa-ethereum' => esc_html__( 'ethereum', 'bili' ),
                'fab fa-etsy' => esc_html__( 'etsy', 'bili' ),
                'fas fa-euro-sign' => esc_html__( 'euro-sign', 'bili' ),
                'fas fa-exchange-alt' => esc_html__( 'exchange-alt', 'bili' ),
                'fas fa-exclamation' => esc_html__( 'exclamation', 'bili' ),
                'fas fa-exclamation-circle' => esc_html__( 'exclamation-circle', 'bili' ),
                'fas fa-exclamation-triangle' => esc_html__( 'exclamation-triangle', 'bili' ),
                'fas fa-expand' => esc_html__( 'expand', 'bili' ),
                'fas fa-expand-arrows-alt' => esc_html__( 'expand-arrows-alt', 'bili' ),
                'fab fa-expeditedssl' => esc_html__( 'expeditedssl', 'bili' ),
                'fas fa-external-link-alt' => esc_html__( 'external-link-alt', 'bili' ),
                'fas fa-external-link-square-alt' => esc_html__( 'external-link-square-alt', 'bili' ),
                'fas fa-eye' => esc_html__( 'eye', 'bili' ),
                'fas fa-eye-dropper' => esc_html__( 'eye-dropper', 'bili' ),
                'fas fa-eye-slash' => esc_html__( 'eye-slash', 'bili' ),
                'far fa-eye-slash' => esc_html__( 'eye-slash', 'bili' ),
                'fab fa-facebook' => esc_html__( 'facebook', 'bili' ),
                'fab fa-facebook-f' => esc_html__( 'facebook-f', 'bili' ),
                'fab fa-facebook-messenger' => esc_html__( 'facebook-messenger', 'bili' ),
                'fab fa-facebook-square' => esc_html__( 'facebook-square', 'bili' ),
                'fas fa-fast-backward' => esc_html__( 'fast-backward', 'bili' ),
                'fas fa-fast-forward' => esc_html__( 'fast-forward', 'bili' ),
                'fas fa-fax' => esc_html__( 'fax', 'bili' ),
                'fas fa-female' => esc_html__( 'female', 'bili' ),
                'fas fa-fighter-jet' => esc_html__( 'fighter-jet', 'bili' ),
                'fas fa-file' => esc_html__( 'file', 'bili' ),
                'far fa-file' => esc_html__( 'file', 'bili' ),
                'fas fa-file-alt' => esc_html__( 'file-alt', 'bili' ),
                'far fa-file-alt' => esc_html__( 'file-alt', 'bili' ),
                'fas fa-file-archive' => esc_html__( 'file-archive', 'bili' ),
                'far fa-file-archive' => esc_html__( 'file-archive', 'bili' ),
                'fas fa-file-audio' => esc_html__( 'file-audio', 'bili' ),
                'far fa-file-audio' => esc_html__( 'file-audio', 'bili' ),
                'fas fa-file-code' => esc_html__( 'file-code', 'bili' ),
                'far fa-file-code' => esc_html__( 'file-code', 'bili' ),
                'fas fa-file-excel' => esc_html__( 'file-excel', 'bili' ),
                'far fa-file-excel' => esc_html__( 'file-excel', 'bili' ),
                'fas fa-file-image' => esc_html__( 'file-image', 'bili' ),
                'far fa-file-image' => esc_html__( 'file-image', 'bili' ),
                'fas fa-file-medical' => esc_html__( 'file-medical', 'bili' ),
                'fas fa-file-medical-alt' => esc_html__( 'file-medical-alt', 'bili' ),
                'fas fa-file-pdf' => esc_html__( 'file-pdf', 'bili' ),
                'far fa-file-pdf' => esc_html__( 'file-pdf', 'bili' ),
                'fas fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'bili' ),
                'far fa-file-powerpoint' => esc_html__( 'file-powerpoint', 'bili' ),
                'fas fa-file-video' => esc_html__( 'file-video', 'bili' ),
                'far fa-file-video' => esc_html__( 'file-video', 'bili' ),
                'fas fa-file-word' => esc_html__( 'file-word', 'bili' ),
                'far fa-file-word' => esc_html__( 'file-word', 'bili' ),
                'fas fa-film' => esc_html__( 'film', 'bili' ),
                'fas fa-filter' => esc_html__( 'filter', 'bili' ),
                'fas fa-fire' => esc_html__( 'fire', 'bili' ),
                'fas fa-fire-extinguisher' => esc_html__( 'fire-extinguisher', 'bili' ),
                'fab fa-firefox' => esc_html__( 'firefox', 'bili' ),
                'fas fa-first-aid' => esc_html__( 'first-aid', 'bili' ),
                'fab fa-first-order' => esc_html__( 'first-order', 'bili' ),
                'fab fa-firstdraft' => esc_html__( 'firstdraft', 'bili' ),
                'fas fa-flag' => esc_html__( 'flag', 'bili' ),
                'far fa-flag' => esc_html__( 'flag', 'bili' ),
                'fas fa-flag-checkered' => esc_html__( 'flag-checkered', 'bili' ),
                'fas fa-flask' => esc_html__( 'flask', 'bili' ),
                'fab fa-flickr' => esc_html__( 'flickr', 'bili' ),
                'fab fa-flipboard' => esc_html__( 'flipboard', 'bili' ),
                'fab fa-fly' => esc_html__( 'fly', 'bili' ),
                'fas fa-folder' => esc_html__( 'folder', 'bili' ),
                'far fa-folder' => esc_html__( 'folder', 'bili' ),
                'fas fa-folder-open' => esc_html__( 'folder-open', 'bili' ),
                'far fa-folder-open' => esc_html__( 'folder-open', 'bili' ),
                'fas fa-font' => esc_html__( 'font', 'bili' ),
                'fab fa-font-awesome' => esc_html__( 'font-awesome', 'bili' ),
                'fab fa-font-awesome-alt' => esc_html__( 'font-awesome-alt', 'bili' ),
                'fab fa-font-awesome-flag' => esc_html__( 'font-awesome-flag', 'bili' ),
                'fab fa-fonticons' => esc_html__( 'fonticons', 'bili' ),
                'fab fa-fonticons-fi' => esc_html__( 'fonticons-fi', 'bili' ),
                'fas fa-football-ball' => esc_html__( 'football-ball', 'bili' ),
                'fab fa-fort-awesome' => esc_html__( 'fort-awesome', 'bili' ),
                'fab fa-fort-awesome-alt' => esc_html__( 'fort-awesome-alt', 'bili' ),
                'fab fa-forumbee' => esc_html__( 'forumbee', 'bili' ),
                'fas fa-forward' => esc_html__( 'forward', 'bili' ),
                'fab fa-foursquare' => esc_html__( 'foursquare', 'bili' ),
                'fab fa-free-code-camp' => esc_html__( 'free-code-camp', 'bili' ),
                'fab fa-freebsd' => esc_html__( 'freebsd', 'bili' ),
                'fas fa-frown' => esc_html__( 'frown', 'bili' ),
                'far fa-frown' => esc_html__( 'frown', 'bili' ),
                'fas fa-futbol' => esc_html__( 'futbol', 'bili' ),
                'far fa-futbol' => esc_html__( 'futbol', 'bili' ),
                'fas fa-gamepad' => esc_html__( 'gamepad', 'bili' ),
                'fas fa-gavel' => esc_html__( 'gavel', 'bili' ),
                'fas fa-gem' => esc_html__( 'gem', 'bili' ),
                'far fa-gem' => esc_html__( 'gem', 'bili' ),
                'fas fa-genderless' => esc_html__( 'genderless', 'bili' ),
                'fab fa-get-pocket' => esc_html__( 'get-pocket', 'bili' ),
                'fab fa-gg' => esc_html__( 'gg', 'bili' ),
                'fab fa-gg-circle' => esc_html__( 'gg-circle', 'bili' ),
                'fas fa-gift' => esc_html__( 'gift', 'bili' ),
                'fab fa-git' => esc_html__( 'git', 'bili' ),
                'fab fa-git-square' => esc_html__( 'git-square', 'bili' ),
                'fab fa-github' => esc_html__( 'github', 'bili' ),
                'fab fa-github-alt' => esc_html__( 'github-alt', 'bili' ),
                'fab fa-github-square' => esc_html__( 'github-square', 'bili' ),
                'fab fa-gitkraken' => esc_html__( 'gitkraken', 'bili' ),
                'fab fa-gitlab' => esc_html__( 'gitlab', 'bili' ),
                'fab fa-gitter' => esc_html__( 'gitter', 'bili' ),
                'fas fa-glass-martini' => esc_html__( 'glass-martini', 'bili' ),
                'fab fa-glide' => esc_html__( 'glide', 'bili' ),
                'fab fa-glide-g' => esc_html__( 'glide-g', 'bili' ),
                'fas fa-globe' => esc_html__( 'globe', 'bili' ),
                'fab fa-gofore' => esc_html__( 'gofore', 'bili' ),
                'fas fa-golf-ball' => esc_html__( 'golf-ball', 'bili' ),
                'fab fa-goodreads' => esc_html__( 'goodreads', 'bili' ),
                'fab fa-goodreads-g' => esc_html__( 'goodreads-g', 'bili' ),
                'fab fa-google' => esc_html__( 'google', 'bili' ),
                'fab fa-google-drive' => esc_html__( 'google-drive', 'bili' ),
                'fab fa-google-play' => esc_html__( 'google-play', 'bili' ),
                'fab fa-google-plus' => esc_html__( 'google-plus', 'bili' ),
                'fab fa-google-plus-g' => esc_html__( 'google-plus-g', 'bili' ),
                'fab fa-google-plus-square' => esc_html__( 'google-plus-square', 'bili' ),
                'fab fa-google-wallet' => esc_html__( 'google-wallet', 'bili' ),
                'fas fa-graduation-cap' => esc_html__( 'graduation-cap', 'bili' ),
                'fab fa-gratipay' => esc_html__( 'gratipay', 'bili' ),
                'fab fa-grav' => esc_html__( 'grav', 'bili' ),
                'fab fa-gripfire' => esc_html__( 'gripfire', 'bili' ),
                'fab fa-grunt' => esc_html__( 'grunt', 'bili' ),
                'fab fa-gulp' => esc_html__( 'gulp', 'bili' ),
                'fas fa-h-square' => esc_html__( 'h-square', 'bili' ),
                'fab fa-hacker-news' => esc_html__( 'hacker-news', 'bili' ),
                'fab fa-hacker-news-square' => esc_html__( 'hacker-news-square', 'bili' ),
                'fas fa-hand-holding' => esc_html__( 'hand-holding', 'bili' ),
                'fas fa-hand-holding-heart' => esc_html__( 'hand-holding-heart', 'bili' ),
                'fas fa-hand-holding-usd' => esc_html__( 'hand-holding-usd', 'bili' ),
                'fas fa-hand-lizard' => esc_html__( 'hand-lizard', 'bili' ),
                'far fa-hand-lizard' => esc_html__( 'hand-lizard', 'bili' ),
                'fas fa-hand-paper' => esc_html__( 'hand-paper', 'bili' ),
                'far fa-hand-paper' => esc_html__( 'hand-paper', 'bili' ),
                'fas fa-hand-peace' => esc_html__( 'hand-peace', 'bili' ),
                'far fa-hand-peace' => esc_html__( 'hand-peace', 'bili' ),
                'fas fa-hand-point-down' => esc_html__( 'hand-point-down', 'bili' ),
                'far fa-hand-point-down' => esc_html__( 'hand-point-down', 'bili' ),
                'fas fa-hand-point-left' => esc_html__( 'hand-point-left', 'bili' ),
                'far fa-hand-point-left' => esc_html__( 'hand-point-left', 'bili' ),
                'fas fa-hand-point-right' => esc_html__( 'hand-point-right', 'bili' ),
                'far fa-hand-point-right' => esc_html__( 'hand-point-right', 'bili' ),
                'fas fa-hand-point-up' => esc_html__( 'hand-point-up', 'bili' ),
                'far fa-hand-point-up' => esc_html__( 'hand-point-up', 'bili' ),
                'fas fa-hand-pointer' => esc_html__( 'hand-pointer', 'bili' ),
                'far fa-hand-pointer' => esc_html__( 'hand-pointer', 'bili' ),
                'fas fa-hand-rock' => esc_html__( 'hand-rock', 'bili' ),
                'far fa-hand-rock' => esc_html__( 'hand-rock', 'bili' ),
                'fas fa-hand-scissors' => esc_html__( 'hand-scissors', 'bili' ),
                'far fa-hand-scissors' => esc_html__( 'hand-scissors', 'bili' ),
                'fas fa-hand-spock' => esc_html__( 'hand-spock', 'bili' ),
                'far fa-hand-spock' => esc_html__( 'hand-spock', 'bili' ),
                'fas fa-hands' => esc_html__( 'hands', 'bili' ),
                'fas fa-hands-helping' => esc_html__( 'hands-helping', 'bili' ),
                'fas fa-handshake' => esc_html__( 'handshake', 'bili' ),
                'far fa-handshake' => esc_html__( 'handshake', 'bili' ),
                'fas fa-hashtag' => esc_html__( 'hashtag', 'bili' ),
                'fas fa-hdd' => esc_html__( 'hdd', 'bili' ),
                'far fa-hdd' => esc_html__( 'hdd', 'bili' ),
                'fas fa-heading' => esc_html__( 'heading', 'bili' ),
                'fas fa-headphones' => esc_html__( 'headphones', 'bili' ),
                'fas fa-heart' => esc_html__( 'heart', 'bili' ),
                'far fa-heart' => esc_html__( 'heart', 'bili' ),
                'fas fa-heartbeat' => esc_html__( 'heartbeat', 'bili' ),
                'fab fa-hips' => esc_html__( 'hips', 'bili' ),
                'fab fa-hire-a-helper' => esc_html__( 'hire-a-helper', 'bili' ),
                'fas fa-history' => esc_html__( 'history', 'bili' ),
                'fas fa-hockey-puck' => esc_html__( 'hockey-puck', 'bili' ),
                'fas fa-home' => esc_html__( 'home', 'bili' ),
                'fab fa-hooli' => esc_html__( 'hooli', 'bili' ),
                'fas fa-hospital' => esc_html__( 'hospital', 'bili' ),
                'far fa-hospital' => esc_html__( 'hospital', 'bili' ),
                'fas fa-hospital-alt' => esc_html__( 'hospital-alt', 'bili' ),
                'fas fa-hospital-symbol' => esc_html__( 'hospital-symbol', 'bili' ),
                'fab fa-hotjar' => esc_html__( 'hotjar', 'bili' ),
                'fas fa-hourglass' => esc_html__( 'hourglass', 'bili' ),
                'far fa-hourglass' => esc_html__( 'hourglass', 'bili' ),
                'fas fa-hourglass-end' => esc_html__( 'hourglass-end', 'bili' ),
                'fas fa-hourglass-half' => esc_html__( 'hourglass-half', 'bili' ),
                'fas fa-hourglass-start' => esc_html__( 'hourglass-start', 'bili' ),
                'fab fa-houzz' => esc_html__( 'houzz', 'bili' ),
                'fab fa-html5' => esc_html__( 'html5', 'bili' ),
                'fab fa-hubspot' => esc_html__( 'hubspot', 'bili' ),
                'fas fa-i-cursor' => esc_html__( 'i-cursor', 'bili' ),
                'fas fa-id-badge' => esc_html__( 'id-badge', 'bili' ),
                'far fa-id-badge' => esc_html__( 'id-badge', 'bili' ),
                'fas fa-id-card' => esc_html__( 'id-card', 'bili' ),
                'far fa-id-card' => esc_html__( 'id-card', 'bili' ),
                'fas fa-id-card-alt' => esc_html__( 'id-card-alt', 'bili' ),
                'fas fa-image' => esc_html__( 'image', 'bili' ),
                'far fa-image' => esc_html__( 'image', 'bili' ),
                'fas fa-images' => esc_html__( 'images', 'bili' ),
                'far fa-images' => esc_html__( 'images', 'bili' ),
                'fab fa-imdb' => esc_html__( 'imdb', 'bili' ),
                'fas fa-inbox' => esc_html__( 'inbox', 'bili' ),
                'fas fa-indent' => esc_html__( 'indent', 'bili' ),
                'fas fa-industry' => esc_html__( 'industry', 'bili' ),
                'fas fa-info' => esc_html__( 'info', 'bili' ),
                'fas fa-info-circle' => esc_html__( 'info-circle', 'bili' ),
                'fab fa-instagram' => esc_html__( 'instagram', 'bili' ),
                'fab fa-internet-explorer' => esc_html__( 'internet-explorer', 'bili' ),
                'fab fa-ioxhost' => esc_html__( 'ioxhost', 'bili' ),
                'fas fa-italic' => esc_html__( 'italic', 'bili' ),
                'fab fa-itunes' => esc_html__( 'itunes', 'bili' ),
                'fab fa-itunes-note' => esc_html__( 'itunes-note', 'bili' ),
                'fab fa-java' => esc_html__( 'java', 'bili' ),
                'fab fa-jenkins' => esc_html__( 'jenkins', 'bili' ),
                'fab fa-joget' => esc_html__( 'joget', 'bili' ),
                'fab fa-joomla' => esc_html__( 'joomla', 'bili' ),
                'fab fa-js' => esc_html__( 'js', 'bili' ),
                'fab fa-js-square' => esc_html__( 'js-square', 'bili' ),
                'fab fa-jsfiddle' => esc_html__( 'jsfiddle', 'bili' ),
                'fas fa-key' => esc_html__( 'key', 'bili' ),
                'fas fa-keyboard' => esc_html__( 'keyboard', 'bili' ),
                'far fa-keyboard' => esc_html__( 'keyboard', 'bili' ),
                'fab fa-keycdn' => esc_html__( 'keycdn', 'bili' ),
                'fab fa-kickstarter' => esc_html__( 'kickstarter', 'bili' ),
                'fab fa-kickstarter-k' => esc_html__( 'kickstarter-k', 'bili' ),
                'fab fa-korvue' => esc_html__( 'korvue', 'bili' ),
                'fas fa-language' => esc_html__( 'language', 'bili' ),
                'fas fa-laptop' => esc_html__( 'laptop', 'bili' ),
                'fab fa-laravel' => esc_html__( 'laravel', 'bili' ),
                'fab fa-lastfm' => esc_html__( 'lastfm', 'bili' ),
                'fab fa-lastfm-square' => esc_html__( 'lastfm-square', 'bili' ),
                'fas fa-leaf' => esc_html__( 'leaf', 'bili' ),
                'fab fa-leanpub' => esc_html__( 'leanpub', 'bili' ),
                'fas fa-lemon' => esc_html__( 'lemon', 'bili' ),
                'far fa-lemon' => esc_html__( 'lemon', 'bili' ),
                'fab fa-less' => esc_html__( 'less', 'bili' ),
                'fas fa-level-down-alt' => esc_html__( 'level-down-alt', 'bili' ),
                'fas fa-level-up-alt' => esc_html__( 'level-up-alt', 'bili' ),
                'fas fa-life-ring' => esc_html__( 'life-ring', 'bili' ),
                'far fa-life-ring' => esc_html__( 'life-ring', 'bili' ),
                'fas fa-lightbulb' => esc_html__( 'lightbulb', 'bili' ),
                'far fa-lightbulb' => esc_html__( 'lightbulb', 'bili' ),
                'fab fa-line' => esc_html__( 'line', 'bili' ),
                'fas fa-link' => esc_html__( 'link', 'bili' ),
                'fab fa-linkedin' => esc_html__( 'linkedin', 'bili' ),
                'fab fa-linkedin-in' => esc_html__( 'linkedin-in', 'bili' ),
                'fab fa-linode' => esc_html__( 'linode', 'bili' ),
                'fab fa-linux' => esc_html__( 'linux', 'bili' ),
                'fas fa-lira-sign' => esc_html__( 'lira-sign', 'bili' ),
                'fas fa-list' => esc_html__( 'list', 'bili' ),
                'fas fa-list-alt' => esc_html__( 'list-alt', 'bili' ),
                'far fa-list-alt' => esc_html__( 'list-alt', 'bili' ),
                'fas fa-list-ol' => esc_html__( 'list-ol', 'bili' ),
                'fas fa-list-ul' => esc_html__( 'list-ul', 'bili' ),
                'fas fa-location-arrow' => esc_html__( 'location-arrow', 'bili' ),
                'fas fa-lock' => esc_html__( 'lock', 'bili' ),
                'fas fa-lock-open' => esc_html__( 'lock-open', 'bili' ),
                'fas fa-long-arrow-alt-down' => esc_html__( 'long-arrow-alt-down', 'bili' ),
                'fas fa-long-arrow-alt-left' => esc_html__( 'long-arrow-alt-left', 'bili' ),
                'fas fa-long-arrow-alt-right' => esc_html__( 'long-arrow-alt-right', 'bili' ),
                'fas fa-long-arrow-alt-up' => esc_html__( 'long-arrow-alt-up', 'bili' ),
                'fas fa-low-vision' => esc_html__( 'low-vision', 'bili' ),
                'fab fa-lyft' => esc_html__( 'lyft', 'bili' ),
                'fab fa-magento' => esc_html__( 'magento', 'bili' ),
                'fas fa-magic' => esc_html__( 'magic', 'bili' ),
                'fas fa-magnet' => esc_html__( 'magnet', 'bili' ),
                'fas fa-male' => esc_html__( 'male', 'bili' ),
                'fas fa-map' => esc_html__( 'map', 'bili' ),
                'far fa-map' => esc_html__( 'map', 'bili' ),
                'fas fa-map-marker' => esc_html__( 'map-marker', 'bili' ),
                'fas fa-map-marker-alt' => esc_html__( 'map-marker-alt', 'bili' ),
                'fas fa-map-pin' => esc_html__( 'map-pin', 'bili' ),
                'fas fa-map-signs' => esc_html__( 'map-signs', 'bili' ),
                'fas fa-mars' => esc_html__( 'mars', 'bili' ),
                'fas fa-mars-double' => esc_html__( 'mars-double', 'bili' ),
                'fas fa-mars-stroke' => esc_html__( 'mars-stroke', 'bili' ),
                'fas fa-mars-stroke-h' => esc_html__( 'mars-stroke-h', 'bili' ),
                'fas fa-mars-stroke-v' => esc_html__( 'mars-stroke-v', 'bili' ),
                'fab fa-maxcdn' => esc_html__( 'maxcdn', 'bili' ),
                'fab fa-medapps' => esc_html__( 'medapps', 'bili' ),
                'fab fa-medium' => esc_html__( 'medium', 'bili' ),
                'fab fa-medium-m' => esc_html__( 'medium-m', 'bili' ),
                'fas fa-medkit' => esc_html__( 'medkit', 'bili' ),
                'fab fa-medrt' => esc_html__( 'medrt', 'bili' ),
                'fab fa-meetup' => esc_html__( 'meetup', 'bili' ),
                'fas fa-meh' => esc_html__( 'meh', 'bili' ),
                'far fa-meh' => esc_html__( 'meh', 'bili' ),
                'fas fa-mercury' => esc_html__( 'mercury', 'bili' ),
                'fas fa-microchip' => esc_html__( 'microchip', 'bili' ),
                'fas fa-microphone' => esc_html__( 'microphone', 'bili' ),
                'fas fa-microphone-slash' => esc_html__( 'microphone-slash', 'bili' ),
                'fab fa-microsoft' => esc_html__( 'microsoft', 'bili' ),
                'fas fa-minus' => esc_html__( 'minus', 'bili' ),
                'fas fa-minus-circle' => esc_html__( 'minus-circle', 'bili' ),
                'fas fa-minus-square' => esc_html__( 'minus-square', 'bili' ),
                'far fa-minus-square' => esc_html__( 'minus-square', 'bili' ),
                'fab fa-mix' => esc_html__( 'mix', 'bili' ),
                'fab fa-mixcloud' => esc_html__( 'mixcloud', 'bili' ),
                'fab fa-mizuni' => esc_html__( 'mizuni', 'bili' ),
                'fas fa-mobile' => esc_html__( 'mobile', 'bili' ),
                'fas fa-mobile-alt' => esc_html__( 'mobile-alt', 'bili' ),
                'fab fa-modx' => esc_html__( 'modx', 'bili' ),
                'fab fa-monero' => esc_html__( 'monero', 'bili' ),
                'fas fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'bili' ),
                'far fa-money-bill-alt' => esc_html__( 'money-bill-alt', 'bili' ),
                'fas fa-moon' => esc_html__( 'moon', 'bili' ),
                'far fa-moon' => esc_html__( 'moon', 'bili' ),
                'fas fa-motorcycle' => esc_html__( 'motorcycle', 'bili' ),
                'fas fa-mouse-pointer' => esc_html__( 'mouse-pointer', 'bili' ),
                'fas fa-music' => esc_html__( 'music', 'bili' ),
                'fab fa-napster' => esc_html__( 'napster', 'bili' ),
                'fas fa-neuter' => esc_html__( 'neuter', 'bili' ),
                'fas fa-newspaper' => esc_html__( 'newspaper', 'bili' ),
                'far fa-newspaper' => esc_html__( 'newspaper', 'bili' ),
                'fab fa-nintendo-switch' => esc_html__( 'nintendo-switch', 'bili' ),
                'fab fa-node' => esc_html__( 'node', 'bili' ),
                'fab fa-node-js' => esc_html__( 'node-js', 'bili' ),
                'fas fa-notes-medical' => esc_html__( 'notes-medical', 'bili' ),
                'fab fa-npm' => esc_html__( 'npm', 'bili' ),
                'fab fa-ns8' => esc_html__( 'ns8', 'bili' ),
                'fab fa-nutritionix' => esc_html__( 'nutritionix', 'bili' ),
                'fas fa-object-group' => esc_html__( 'object-group', 'bili' ),
                'far fa-object-group' => esc_html__( 'object-group', 'bili' ),
                'fas fa-object-ungroup' => esc_html__( 'object-ungroup', 'bili' ),
                'far fa-object-ungroup' => esc_html__( 'object-ungroup', 'bili' ),
                'fab fa-odnoklassniki' => esc_html__( 'odnoklassniki', 'bili' ),
                'fab fa-odnoklassniki-square' => esc_html__( 'odnoklassniki-square', 'bili' ),
                'fab fa-opencart' => esc_html__( 'opencart', 'bili' ),
                'fab fa-openid' => esc_html__( 'openid', 'bili' ),
                'fab fa-opera' => esc_html__( 'opera', 'bili' ),
                'fab fa-optin-monster' => esc_html__( 'optin-monster', 'bili' ),
                'fab fa-osi' => esc_html__( 'osi', 'bili' ),
                'fas fa-outdent' => esc_html__( 'outdent', 'bili' ),
                'fab fa-page4' => esc_html__( 'page4', 'bili' ),
                'fab fa-pagelines' => esc_html__( 'pagelines', 'bili' ),
                'fas fa-paint-brush' => esc_html__( 'paint-brush', 'bili' ),
                'fab fa-palfed' => esc_html__( 'palfed', 'bili' ),
                'fas fa-pallet' => esc_html__( 'pallet', 'bili' ),
                'fas fa-paper-plane' => esc_html__( 'paper-plane', 'bili' ),
                'far fa-paper-plane' => esc_html__( 'paper-plane', 'bili' ),
                'fas fa-paperclip' => esc_html__( 'paperclip', 'bili' ),
                'fas fa-parachute-box' => esc_html__( 'parachute-box', 'bili' ),
                'fas fa-paragraph' => esc_html__( 'paragraph', 'bili' ),
                'fas fa-paste' => esc_html__( 'paste', 'bili' ),
                'fab fa-patreon' => esc_html__( 'patreon', 'bili' ),
                'fas fa-pause' => esc_html__( 'pause', 'bili' ),
                'fas fa-pause-circle' => esc_html__( 'pause-circle', 'bili' ),
                'far fa-pause-circle' => esc_html__( 'pause-circle', 'bili' ),
                'fas fa-paw' => esc_html__( 'paw', 'bili' ),
                'fab fa-paypal' => esc_html__( 'paypal', 'bili' ),
                'fas fa-pen-square' => esc_html__( 'pen-square', 'bili' ),
                'fas fa-pencil-alt' => esc_html__( 'pencil-alt', 'bili' ),
                'fas fa-people-carry' => esc_html__( 'people-carry', 'bili' ),
                'fas fa-percent' => esc_html__( 'percent', 'bili' ),
                'fab fa-periscope' => esc_html__( 'periscope', 'bili' ),
                'fab fa-phabricator' => esc_html__( 'phabricator', 'bili' ),
                'fab fa-phoenix-framework' => esc_html__( 'phoenix-framework', 'bili' ),
                'fas fa-phone' => esc_html__( 'phone', 'bili' ),
                'fas fa-phone-slash' => esc_html__( 'phone-slash', 'bili' ),
                'fas fa-phone-square' => esc_html__( 'phone-square', 'bili' ),
                'fas fa-phone-volume' => esc_html__( 'phone-volume', 'bili' ),
                'fab fa-php' => esc_html__( 'php', 'bili' ),
                'fab fa-pied-piper' => esc_html__( 'pied-piper', 'bili' ),
                'fab fa-pied-piper-alt' => esc_html__( 'pied-piper-alt', 'bili' ),
                'fab fa-pied-piper-hat' => esc_html__( 'pied-piper-hat', 'bili' ),
                'fab fa-pied-piper-pp' => esc_html__( 'pied-piper-pp', 'bili' ),
                'fas fa-piggy-bank' => esc_html__( 'piggy-bank', 'bili' ),
                'fas fa-pills' => esc_html__( 'pills', 'bili' ),
                'fab fa-pinterest' => esc_html__( 'pinterest', 'bili' ),
                'fab fa-pinterest-p' => esc_html__( 'pinterest-p', 'bili' ),
                'fab fa-pinterest-square' => esc_html__( 'pinterest-square', 'bili' ),
                'fas fa-plane' => esc_html__( 'plane', 'bili' ),
                'fas fa-play' => esc_html__( 'play', 'bili' ),
                'fas fa-play-circle' => esc_html__( 'play-circle', 'bili' ),
                'far fa-play-circle' => esc_html__( 'play-circle', 'bili' ),
                'fab fa-playstation' => esc_html__( 'playstation', 'bili' ),
                'fas fa-plug' => esc_html__( 'plug', 'bili' ),
                'fas fa-plus' => esc_html__( 'plus', 'bili' ),
                'fas fa-plus-circle' => esc_html__( 'plus-circle', 'bili' ),
                'fas fa-plus-square' => esc_html__( 'plus-square', 'bili' ),
                'far fa-plus-square' => esc_html__( 'plus-square', 'bili' ),
                'fas fa-podcast' => esc_html__( 'podcast', 'bili' ),
                'fas fa-poo' => esc_html__( 'poo', 'bili' ),
                'fas fa-pound-sign' => esc_html__( 'pound-sign', 'bili' ),
                'fas fa-power-off' => esc_html__( 'power-off', 'bili' ),
                'fas fa-prescription-bottle' => esc_html__( 'prescription-bottle', 'bili' ),
                'fas fa-prescription-bottle-alt' => esc_html__( 'prescription-bottle-alt', 'bili' ),
                'fas fa-print' => esc_html__( 'print', 'bili' ),
                'fas fa-procedures' => esc_html__( 'procedures', 'bili' ),
                'fab fa-product-hunt' => esc_html__( 'product-hunt', 'bili' ),
                'fab fa-pushed' => esc_html__( 'pushed', 'bili' ),
                'fas fa-puzzle-piece' => esc_html__( 'puzzle-piece', 'bili' ),
                'fab fa-python' => esc_html__( 'python', 'bili' ),
                'fab fa-qq' => esc_html__( 'qq', 'bili' ),
                'fas fa-qrcode' => esc_html__( 'qrcode', 'bili' ),
                'fas fa-question' => esc_html__( 'question', 'bili' ),
                'fas fa-question-circle' => esc_html__( 'question-circle', 'bili' ),
                'far fa-question-circle' => esc_html__( 'question-circle', 'bili' ),
                'fas fa-quidditch' => esc_html__( 'quidditch', 'bili' ),
                'fab fa-quinscape' => esc_html__( 'quinscape', 'bili' ),
                'fab fa-quora' => esc_html__( 'quora', 'bili' ),
                'fas fa-quote-left' => esc_html__( 'quote-left', 'bili' ),
                'fas fa-quote-right' => esc_html__( 'quote-right', 'bili' ),
                'fas fa-random' => esc_html__( 'random', 'bili' ),
                'fab fa-ravelry' => esc_html__( 'ravelry', 'bili' ),
                'fab fa-react' => esc_html__( 'react', 'bili' ),
                'fab fa-readme' => esc_html__( 'readme', 'bili' ),
                'fab fa-rebel' => esc_html__( 'rebel', 'bili' ),
                'fas fa-recycle' => esc_html__( 'recycle', 'bili' ),
                'fab fa-red-river' => esc_html__( 'red-river', 'bili' ),
                'fab fa-reddit' => esc_html__( 'reddit', 'bili' ),
                'fab fa-reddit-alien' => esc_html__( 'reddit-alien', 'bili' ),
                'fab fa-reddit-square' => esc_html__( 'reddit-square', 'bili' ),
                'fas fa-redo' => esc_html__( 'redo', 'bili' ),
                'fas fa-redo-alt' => esc_html__( 'redo-alt', 'bili' ),
                'fas fa-registered' => esc_html__( 'registered', 'bili' ),
                'far fa-registered' => esc_html__( 'registered', 'bili' ),
                'fab fa-rendact' => esc_html__( 'rendact', 'bili' ),
                'fab fa-renren' => esc_html__( 'renren', 'bili' ),
                'fas fa-reply' => esc_html__( 'reply', 'bili' ),
                'fas fa-reply-all' => esc_html__( 'reply-all', 'bili' ),
                'fab fa-replyd' => esc_html__( 'replyd', 'bili' ),
                'fab fa-resolving' => esc_html__( 'resolving', 'bili' ),
                'fas fa-retweet' => esc_html__( 'retweet', 'bili' ),
                'fas fa-ribbon' => esc_html__( 'ribbon', 'bili' ),
                'fas fa-road' => esc_html__( 'road', 'bili' ),
                'fas fa-rocket' => esc_html__( 'rocket', 'bili' ),
                'fab fa-rocketchat' => esc_html__( 'rocketchat', 'bili' ),
                'fab fa-rockrms' => esc_html__( 'rockrms', 'bili' ),
                'fas fa-rss' => esc_html__( 'rss', 'bili' ),
                'fas fa-rss-square' => esc_html__( 'rss-square', 'bili' ),
                'fas fa-ruble-sign' => esc_html__( 'ruble-sign', 'bili' ),
                'fas fa-rupee-sign' => esc_html__( 'rupee-sign', 'bili' ),
                'fab fa-safari' => esc_html__( 'safari', 'bili' ),
                'fab fa-sass' => esc_html__( 'sass', 'bili' ),
                'fas fa-save' => esc_html__( 'save', 'bili' ),
                'far fa-save' => esc_html__( 'save', 'bili' ),
                'fab fa-schlix' => esc_html__( 'schlix', 'bili' ),
                'fab fa-scribd' => esc_html__( 'scribd', 'bili' ),
                'fas fa-search' => esc_html__( 'search', 'bili' ),
                'fas fa-search-minus' => esc_html__( 'search-minus', 'bili' ),
                'fas fa-search-plus' => esc_html__( 'search-plus', 'bili' ),
                'fab fa-searchengin' => esc_html__( 'searchengin', 'bili' ),
                'fas fa-seedling' => esc_html__( 'seedling', 'bili' ),
                'fab fa-sellcast' => esc_html__( 'sellcast', 'bili' ),
                'fab fa-sellsy' => esc_html__( 'sellsy', 'bili' ),
                'fas fa-server' => esc_html__( 'server', 'bili' ),
                'fab fa-servicestack' => esc_html__( 'servicestack', 'bili' ),
                'fas fa-share' => esc_html__( 'share', 'bili' ),
                'fas fa-share-alt' => esc_html__( 'share-alt', 'bili' ),
                'fas fa-share-alt-square' => esc_html__( 'share-alt-square', 'bili' ),
                'fas fa-share-square' => esc_html__( 'share-square', 'bili' ),
                'far fa-share-square' => esc_html__( 'share-square', 'bili' ),
                'fas fa-shekel-sign' => esc_html__( 'shekel-sign', 'bili' ),
                'fas fa-shield-alt' => esc_html__( 'shield-alt', 'bili' ),
                'fas fa-ship' => esc_html__( 'ship', 'bili' ),
                'fas fa-shipping-fast' => esc_html__( 'shipping-fast', 'bili' ),
                'fab fa-shirtsinbulk' => esc_html__( 'shirtsinbulk', 'bili' ),
                'fas fa-shopping-bag' => esc_html__( 'shopping-bag', 'bili' ),
                'fas fa-shopping-basket' => esc_html__( 'shopping-basket', 'bili' ),
                'fas fa-shopping-cart' => esc_html__( 'shopping-cart', 'bili' ),
                'fas fa-shower' => esc_html__( 'shower', 'bili' ),
                'fas fa-sign' => esc_html__( 'sign', 'bili' ),
                'fas fa-sign-in-alt' => esc_html__( 'sign-in-alt', 'bili' ),
                'fas fa-sign-language' => esc_html__( 'sign-language', 'bili' ),
                'fas fa-sign-out-alt' => esc_html__( 'sign-out-alt', 'bili' ),
                'fas fa-signal' => esc_html__( 'signal', 'bili' ),
                'fab fa-simplybuilt' => esc_html__( 'simplybuilt', 'bili' ),
                'fab fa-sistrix' => esc_html__( 'sistrix', 'bili' ),
                'fas fa-sitemap' => esc_html__( 'sitemap', 'bili' ),
                'fab fa-skyatlas' => esc_html__( 'skyatlas', 'bili' ),
                'fab fa-skype' => esc_html__( 'skype', 'bili' ),
                'fab fa-slack' => esc_html__( 'slack', 'bili' ),
                'fab fa-slack-hash' => esc_html__( 'slack-hash', 'bili' ),
                'fas fa-sliders-h' => esc_html__( 'sliders-h', 'bili' ),
                'fab fa-slideshare' => esc_html__( 'slideshare', 'bili' ),
                'fas fa-smile' => esc_html__( 'smile', 'bili' ),
                'far fa-smile' => esc_html__( 'smile', 'bili' ),
                'fas fa-smoking' => esc_html__( 'smoking', 'bili' ),
                'fab fa-snapchat' => esc_html__( 'snapchat', 'bili' ),
                'fab fa-snapchat-ghost' => esc_html__( 'snapchat-ghost', 'bili' ),
                'fab fa-snapchat-square' => esc_html__( 'snapchat-square', 'bili' ),
                'fas fa-snowflake' => esc_html__( 'snowflake', 'bili' ),
                'far fa-snowflake' => esc_html__( 'snowflake', 'bili' ),
                'fas fa-sort' => esc_html__( 'sort', 'bili' ),
                'fas fa-sort-alpha-down' => esc_html__( 'sort-alpha-down', 'bili' ),
                'fas fa-sort-alpha-up' => esc_html__( 'sort-alpha-up', 'bili' ),
                'fas fa-sort-amount-down' => esc_html__( 'sort-amount-down', 'bili' ),
                'fas fa-sort-amount-up' => esc_html__( 'sort-amount-up', 'bili' ),
                'fas fa-sort-down' => esc_html__( 'sort-down', 'bili' ),
                'fas fa-sort-numeric-down' => esc_html__( 'sort-numeric-down', 'bili' ),
                'fas fa-sort-numeric-up' => esc_html__( 'sort-numeric-up', 'bili' ),
                'fas fa-sort-up' => esc_html__( 'sort-up', 'bili' ),
                'fab fa-soundcloud' => esc_html__( 'soundcloud', 'bili' ),
                'fas fa-space-shuttle' => esc_html__( 'space-shuttle', 'bili' ),
                'fab fa-speakap' => esc_html__( 'speakap', 'bili' ),
                'fas fa-spinner' => esc_html__( 'spinner', 'bili' ),
                'fab fa-spotify' => esc_html__( 'spotify', 'bili' ),
                'fas fa-square' => esc_html__( 'square', 'bili' ),
                'far fa-square' => esc_html__( 'square', 'bili' ),
                'fas fa-square-full' => esc_html__( 'square-full', 'bili' ),
                'fab fa-stack-exchange' => esc_html__( 'stack-exchange', 'bili' ),
                'fab fa-stack-overflow' => esc_html__( 'stack-overflow', 'bili' ),
                'fas fa-star' => esc_html__( 'star', 'bili' ),
                'far fa-star' => esc_html__( 'star', 'bili' ),
                'fas fa-star-half' => esc_html__( 'star-half', 'bili' ),
                'far fa-star-half' => esc_html__( 'star-half', 'bili' ),
                'fab fa-staylinked' => esc_html__( 'staylinked', 'bili' ),
                'fab fa-steam' => esc_html__( 'steam', 'bili' ),
                'fab fa-steam-square' => esc_html__( 'steam-square', 'bili' ),
                'fab fa-steam-symbol' => esc_html__( 'steam-symbol', 'bili' ),
                'fas fa-step-backward' => esc_html__( 'step-backward', 'bili' ),
                'fas fa-step-forward' => esc_html__( 'step-forward', 'bili' ),
                'fas fa-stethoscope' => esc_html__( 'stethoscope', 'bili' ),
                'fab fa-sticker-mule' => esc_html__( 'sticker-mule', 'bili' ),
                'fas fa-sticky-note' => esc_html__( 'sticky-note', 'bili' ),
                'far fa-sticky-note' => esc_html__( 'sticky-note', 'bili' ),
                'fas fa-stop' => esc_html__( 'stop', 'bili' ),
                'fas fa-stop-circle' => esc_html__( 'stop-circle', 'bili' ),
                'far fa-stop-circle' => esc_html__( 'stop-circle', 'bili' ),
                'fas fa-stopwatch' => esc_html__( 'stopwatch', 'bili' ),
                'fab fa-strava' => esc_html__( 'strava', 'bili' ),
                'fas fa-street-view' => esc_html__( 'street-view', 'bili' ),
                'fas fa-strikethrough' => esc_html__( 'strikethrough', 'bili' ),
                'fab fa-stripe' => esc_html__( 'stripe', 'bili' ),
                'fab fa-stripe-s' => esc_html__( 'stripe-s', 'bili' ),
                'fab fa-studiovinari' => esc_html__( 'studiovinari', 'bili' ),
                'fab fa-stumbleupon' => esc_html__( 'stumbleupon', 'bili' ),
                'fab fa-stumbleupon-circle' => esc_html__( 'stumbleupon-circle', 'bili' ),
                'fas fa-subscript' => esc_html__( 'subscript', 'bili' ),
                'fas fa-subway' => esc_html__( 'subway', 'bili' ),
                'fas fa-suitcase' => esc_html__( 'suitcase', 'bili' ),
                'fas fa-sun' => esc_html__( 'sun', 'bili' ),
                'far fa-sun' => esc_html__( 'sun', 'bili' ),
                'fab fa-superpowers' => esc_html__( 'superpowers', 'bili' ),
                'fas fa-superscript' => esc_html__( 'superscript', 'bili' ),
                'fab fa-supple' => esc_html__( 'supple', 'bili' ),
                'fas fa-sync' => esc_html__( 'sync', 'bili' ),
                'fas fa-sync-alt' => esc_html__( 'sync-alt', 'bili' ),
                'fas fa-syringe' => esc_html__( 'syringe', 'bili' ),
                'fas fa-table' => esc_html__( 'table', 'bili' ),
                'fas fa-table-tennis' => esc_html__( 'table-tennis', 'bili' ),
                'fas fa-tablet' => esc_html__( 'tablet', 'bili' ),
                'fas fa-tablet-alt' => esc_html__( 'tablet-alt', 'bili' ),
                'fas fa-tablets' => esc_html__( 'tablets', 'bili' ),
                'fas fa-tachometer-alt' => esc_html__( 'tachometer-alt', 'bili' ),
                'fas fa-tag' => esc_html__( 'tag', 'bili' ),
                'fas fa-tags' => esc_html__( 'tags', 'bili' ),
                'fas fa-tape' => esc_html__( 'tape', 'bili' ),
                'fas fa-tasks' => esc_html__( 'tasks', 'bili' ),
                'fas fa-taxi' => esc_html__( 'taxi', 'bili' ),
                'fab fa-telegram' => esc_html__( 'telegram', 'bili' ),
                'fab fa-telegram-plane' => esc_html__( 'telegram-plane', 'bili' ),
                'fab fa-tencent-weibo' => esc_html__( 'tencent-weibo', 'bili' ),
                'fas fa-terminal' => esc_html__( 'terminal', 'bili' ),
                'fas fa-text-height' => esc_html__( 'text-height', 'bili' ),
                'fas fa-text-width' => esc_html__( 'text-width', 'bili' ),
                'fas fa-th' => esc_html__( 'th', 'bili' ),
                'fas fa-th-large' => esc_html__( 'th-large', 'bili' ),
                'fas fa-th-list' => esc_html__( 'th-list', 'bili' ),
                'fab fa-themeisle' => esc_html__( 'themeisle', 'bili' ),
                'fas fa-thermometer' => esc_html__( 'thermometer', 'bili' ),
                'fas fa-thermometer-empty' => esc_html__( 'thermometer-empty', 'bili' ),
                'fas fa-thermometer-full' => esc_html__( 'thermometer-full', 'bili' ),
                'fas fa-thermometer-half' => esc_html__( 'thermometer-half', 'bili' ),
                'fas fa-thermometer-quarter' => esc_html__( 'thermometer-quarter', 'bili' ),
                'fas fa-thermometer-three-quarters' => esc_html__( 'thermometer-three-quarters', 'bili' ),
                'fas fa-thumbs-down' => esc_html__( 'thumbs-down', 'bili' ),
                'far fa-thumbs-down' => esc_html__( 'thumbs-down', 'bili' ),
                'fas fa-thumbs-up' => esc_html__( 'thumbs-up', 'bili' ),
                'far fa-thumbs-up' => esc_html__( 'thumbs-up', 'bili' ),
                'fas fa-thumbtack' => esc_html__( 'thumbtack', 'bili' ),
                'fas fa-ticket-alt' => esc_html__( 'ticket-alt', 'bili' ),
                'fas fa-times' => esc_html__( 'times', 'bili' ),
                'fas fa-times-circle' => esc_html__( 'times-circle', 'bili' ),
                'far fa-times-circle' => esc_html__( 'times-circle', 'bili' ),
                'fas fa-tint' => esc_html__( 'tint', 'bili' ),
                'fas fa-toggle-off' => esc_html__( 'toggle-off', 'bili' ),
                'fas fa-toggle-on' => esc_html__( 'toggle-on', 'bili' ),
                'fas fa-trademark' => esc_html__( 'trademark', 'bili' ),
                'fas fa-train' => esc_html__( 'train', 'bili' ),
                'fas fa-transgender' => esc_html__( 'transgender', 'bili' ),
                'fas fa-transgender-alt' => esc_html__( 'transgender-alt', 'bili' ),
                'fas fa-trash' => esc_html__( 'trash', 'bili' ),
                'fas fa-trash-alt' => esc_html__( 'trash-alt', 'bili' ),
                'far fa-trash-alt' => esc_html__( 'trash-alt', 'bili' ),
                'fas fa-tree' => esc_html__( 'tree', 'bili' ),
                'fab fa-trello' => esc_html__( 'trello', 'bili' ),
                'fab fa-tripadvisor' => esc_html__( 'tripadvisor', 'bili' ),
                'fas fa-trophy' => esc_html__( 'trophy', 'bili' ),
                'fas fa-truck' => esc_html__( 'truck', 'bili' ),
                'fas fa-truck-loading' => esc_html__( 'truck-loading', 'bili' ),
                'fas fa-truck-moving' => esc_html__( 'truck-moving', 'bili' ),
                'fas fa-tty' => esc_html__( 'tty', 'bili' ),
                'fab fa-tumblr' => esc_html__( 'tumblr', 'bili' ),
                'fab fa-tumblr-square' => esc_html__( 'tumblr-square', 'bili' ),
                'fas fa-tv' => esc_html__( 'tv', 'bili' ),
                'fab fa-twitch' => esc_html__( 'twitch', 'bili' ),
                'fab fa-twitter' => esc_html__( 'twitter', 'bili' ),
                'fab fa-twitter-square' => esc_html__( 'twitter-square', 'bili' ),
                'fab fa-typo3' => esc_html__( 'typo3', 'bili' ),
                'fab fa-uber' => esc_html__( 'uber', 'bili' ),
                'fab fa-uikit' => esc_html__( 'uikit', 'bili' ),
                'fas fa-umbrella' => esc_html__( 'umbrella', 'bili' ),
                'fas fa-underline' => esc_html__( 'underline', 'bili' ),
                'fas fa-undo' => esc_html__( 'undo', 'bili' ),
                'fas fa-undo-alt' => esc_html__( 'undo-alt', 'bili' ),
                'fab fa-uniregistry' => esc_html__( 'uniregistry', 'bili' ),
                'fas fa-universal-access' => esc_html__( 'universal-access', 'bili' ),
                'fas fa-university' => esc_html__( 'university', 'bili' ),
                'fas fa-unlink' => esc_html__( 'unlink', 'bili' ),
                'fas fa-unlock' => esc_html__( 'unlock', 'bili' ),
                'fas fa-unlock-alt' => esc_html__( 'unlock-alt', 'bili' ),
                'fab fa-untappd' => esc_html__( 'untappd', 'bili' ),
                'fas fa-upload' => esc_html__( 'upload', 'bili' ),
                'fab fa-usb' => esc_html__( 'usb', 'bili' ),
                'fas fa-user' => esc_html__( 'user', 'bili' ),
                'far fa-user' => esc_html__( 'user', 'bili' ),
                'fas fa-user-circle' => esc_html__( 'user-circle', 'bili' ),
                'far fa-user-circle' => esc_html__( 'user-circle', 'bili' ),
                'fas fa-user-md' => esc_html__( 'user-md', 'bili' ),
                'fas fa-user-plus' => esc_html__( 'user-plus', 'bili' ),
                'fas fa-user-secret' => esc_html__( 'user-secret', 'bili' ),
                'fas fa-user-times' => esc_html__( 'user-times', 'bili' ),
                'fas fa-users' => esc_html__( 'users', 'bili' ),
                'fab fa-ussunnah' => esc_html__( 'ussunnah', 'bili' ),
                'fas fa-utensil-spoon' => esc_html__( 'utensil-spoon', 'bili' ),
                'fas fa-utensils' => esc_html__( 'utensils', 'bili' ),
                'fab fa-vaadin' => esc_html__( 'vaadin', 'bili' ),
                'fas fa-venus' => esc_html__( 'venus', 'bili' ),
                'fas fa-venus-double' => esc_html__( 'venus-double', 'bili' ),
                'fas fa-venus-mars' => esc_html__( 'venus-mars', 'bili' ),
                'fab fa-viacoin' => esc_html__( 'viacoin', 'bili' ),
                'fab fa-viadeo' => esc_html__( 'viadeo', 'bili' ),
                'fab fa-viadeo-square' => esc_html__( 'viadeo-square', 'bili' ),
                'fas fa-vial' => esc_html__( 'vial', 'bili' ),
                'fas fa-vials' => esc_html__( 'vials', 'bili' ),
                'fab fa-viber' => esc_html__( 'viber', 'bili' ),
                'fas fa-video' => esc_html__( 'video', 'bili' ),
                'fas fa-video-slash' => esc_html__( 'video-slash', 'bili' ),
                'fab fa-vimeo' => esc_html__( 'vimeo', 'bili' ),
                'fab fa-vimeo-square' => esc_html__( 'vimeo-square', 'bili' ),
                'fab fa-vimeo-v' => esc_html__( 'vimeo-v', 'bili' ),
                'fab fa-vine' => esc_html__( 'vine', 'bili' ),
                'fab fa-vk' => esc_html__( 'vk', 'bili' ),
                'fab fa-vnv' => esc_html__( 'vnv', 'bili' ),
                'fas fa-volleyball-ball' => esc_html__( 'volleyball-ball', 'bili' ),
                'fas fa-volume-down' => esc_html__( 'volume-down', 'bili' ),
                'fas fa-volume-off' => esc_html__( 'volume-off', 'bili' ),
                'fas fa-volume-up' => esc_html__( 'volume-up', 'bili' ),
                'fab fa-vuejs' => esc_html__( 'vuejs', 'bili' ),
                'fas fa-warehouse' => esc_html__( 'warehouse', 'bili' ),
                'fab fa-weibo' => esc_html__( 'weibo', 'bili' ),
                'fas fa-weight' => esc_html__( 'weight', 'bili' ),
                'fab fa-weixin' => esc_html__( 'weixin', 'bili' ),
                'fab fa-whatsapp' => esc_html__( 'whatsapp', 'bili' ),
                'fab fa-whatsapp-square' => esc_html__( 'whatsapp-square', 'bili' ),
                'fas fa-wheelchair' => esc_html__( 'wheelchair', 'bili' ),
                'fab fa-whmcs' => esc_html__( 'whmcs', 'bili' ),
                'fas fa-wifi' => esc_html__( 'wifi', 'bili' ),
                'fab fa-wikipedia-w' => esc_html__( 'wikipedia-w', 'bili' ),
                'fas fa-window-close' => esc_html__( 'window-close', 'bili' ),
                'far fa-window-close' => esc_html__( 'window-close', 'bili' ),
                'fas fa-window-maximize' => esc_html__( 'window-maximize', 'bili' ),
                'far fa-window-maximize' => esc_html__( 'window-maximize', 'bili' ),
                'fas fa-window-minimize' => esc_html__( 'window-minimize', 'bili' ),
                'far fa-window-minimize' => esc_html__( 'window-minimize', 'bili' ),
                'fas fa-window-restore' => esc_html__( 'window-restore', 'bili' ),
                'far fa-window-restore' => esc_html__( 'window-restore', 'bili' ),
                'fab fa-windows' => esc_html__( 'windows', 'bili' ),
                'fas fa-wine-glass' => esc_html__( 'wine-glass', 'bili' ),
                'fas fa-won-sign' => esc_html__( 'won-sign', 'bili' ),
                'fab fa-wordpress' => esc_html__( 'wordpress', 'bili' ),
                'fab fa-wordpress-simple' => esc_html__( 'wordpress-simple', 'bili' ),
                'fab fa-wpbeginner' => esc_html__( 'wpbeginner', 'bili' ),
                'fab fa-wpexplorer' => esc_html__( 'wpexplorer', 'bili' ),
                'fab fa-wpforms' => esc_html__( 'wpforms', 'bili' ),
                'fas fa-wrench' => esc_html__( 'wrench', 'bili' ),
                'fas fa-x-ray' => esc_html__( 'x-ray', 'bili' ),
                'fab fa-xbox' => esc_html__( 'xbox', 'bili' ),
                'fab fa-xing' => esc_html__( 'xing', 'bili' ),
                'fab fa-xing-square' => esc_html__( 'xing-square', 'bili' ),
                'fab fa-y-combinator' => esc_html__( 'y-combinator', 'bili' ),
                'fab fa-yahoo' => esc_html__( 'yahoo', 'bili' ),
                'fab fa-yandex' => esc_html__( 'yandex', 'bili' ),
                'fab fa-yandex-international' => esc_html__( 'yandex-international', 'bili' ),
                'fab fa-yelp' => esc_html__( 'yelp', 'bili' ),
                'fas fa-yen-sign' => esc_html__( 'yen-sign', 'bili' ),
                'fab fa-yoast' => esc_html__( 'yoast', 'bili' ),
                'fab fa-youtube' => esc_html__( 'youtube', 'bili' ),
                'fab fa-youtube-square' => esc_html__( 'youtube-square', 'bili' ),
            ];
        }
    }

    function WGLAdminIcon()
    {
        return WGL_Admin_Icon::get_instance();
    }

    // Call Admin Function
    WGLAdminIcon();
}
