<?php
namespace WGL_Extensions;

defined( 'ABSPATH' ) || exit;

use WGL_Framework;

if ( ! class_exists( 'WGL_Framework_Global_Variables' ) ) {
    /**
     * Bili Global Variables
     *
     *
     * @package bili\core\class
     * @author WebGeniusLab <webgeniuslab@gmail.com>
     * @since 1.0.0
     */
    class WGL_Framework_Global_Variables
    {
        protected static $theme_slug;
        protected static $theme_version;
        protected static $primary_color;
        protected static $secondary_color;
        protected static $tertiary_color;
        protected static $main_font_color;
        protected static $h_font_color;
        protected static $btn_color_idle;
        protected static $btn_bg_idle;
        protected static $btn_color_hover;
        protected static $btn_bg_hover;
        protected static $cursor_point_color;

        function __construct()
        {
            if ( class_exists( '\WGL_Framework' ) ) {
                $this->set_variables();
            }
        }

        protected function set_variables()
        {
            // General
            self::$theme_slug = str_replace( '-child', '', wp_get_theme()->get( 'TextDomain' ) );
            self::$theme_version = wp_get_theme()->get( 'Version' ) ?? false;

            // Colors
            self::$primary_color = esc_attr( WGL_Framework::get_option( 'theme-primary-color' ) );
            self::$secondary_color = esc_attr( WGL_Framework::get_option( 'theme-secondary-color' ) );
            self::$tertiary_color = esc_attr( WGL_Framework::get_option( 'theme-tertiary-color' ) );
            self::$main_font_color = esc_attr( WGL_Framework::get_option( 'theme-content-color' ) );
            self::$h_font_color = esc_attr( WGL_Framework::get_option( 'theme-headings-color' ) );
            self::$btn_color_idle = esc_attr( WGL_Framework::get_option( 'button-color-idle' ) );
            self::$btn_bg_idle = esc_attr( WGL_Framework::get_option( 'button-bg-idle' ) );
            self::$btn_color_hover = esc_attr( WGL_Framework::get_option( 'button-color-hover' ) );
            self::$btn_bg_hover = esc_attr( WGL_Framework::get_option( 'button-bg-hover' ) );
            self::$cursor_point_color = isset(WGL_Framework::get_option('cursor_color')['rgba']) ? WGL_Framework::get_option('cursor_color')['rgba'] : '';
        }

        public static function get_theme_slug()
        {
            return self::$theme_slug;
        }

        public static function get_theme_version()
        {
            return self::$theme_version;
        }

        public static function get_primary_color( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$primary_color, $opacity );
            }

            return self::$primary_color;
        }

        public static function get_secondary_color( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$secondary_color, $opacity );
            }

            return self::$secondary_color;
        }

        public static function get_tertiary_color( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$tertiary_color, $opacity );
            }

            return self::$tertiary_color;
        }

        public static function get_main_font_color( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$h_font_color, $opacity );
            }

            return self::$main_font_color;
        }

        public static function get_h_font_color( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$h_font_color, $opacity );
            }

            return self::$h_font_color;
        }

        public static function get_btn_color_idle( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$btn_color_idle, $opacity );
            }

            return self::$btn_color_idle;
        }

        public static function get_btn_bg_idle( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$btn_bg_idle, $opacity );
            }

            return self::$btn_bg_idle;
        }

        public static function get_btn_color_hover( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$btn_color_hover, $opacity );
            }

            return self::$btn_color_hover;
        }

        public static function get_btn_bg_hover( $opacity = null )
        {
            if ( is_numeric( $opacity ) ) {
                return self::get_opaqued_rgba_color( self::$btn_bg_hover, $opacity );
            }

            return self::$btn_bg_hover;
        }

        public static function get_cursor_point_color()
        {
            return self::$cursor_point_color;
        }

        protected static function get_opaqued_rgba_color( String $color, $opacity )
        {
            if ( WGL_Framework::is_valid_hex( $color ) ) {
                return 'rgba( ' . WGL_Framework::hex_to_rgb( $color ) . ',' . $opacity . ' )';
            }

            if ( WGL_Framework::is_valid_rgb( $color ) ) {
                $rgb = WGL_Framework::get_bytes_array_from_rgb( $color );

                return 'rgba( ' . implode( ', ', $rgb ) . ', ' . $opacity . ' )';
            }

            if ( WGL_Framework::is_valid_rgba( $color ) ) {
                $rgba = WGL_Framework::get_bytes_array_from_rgba( $color );
                unset( $rgba[ 3 ] );

                return 'rgba( ' . implode( ', ', $rgba) . ', ' . $opacity . ' )';
            }
        }

        public static function arrow_right($fill = '#fff'){

            $output = '<svg width="14" height="16" viewBox="0 0 14 16" xmlns="http://www.w3.org/2000/svg" fill="'.esc_attr($fill).'"><path d="M13.435 8.70711C13.8256 8.31658 13.8256 7.68342 13.435 7.29289L7.07107 0.928932C6.68054 0.538408 6.04738 0.538408 5.65685 0.928932C5.26633 1.31946 5.26633 1.95262 5.65685 2.34315L11.3137 8L5.65685 13.6569C5.26633 14.0474 5.26633 14.6805 5.65685 15.0711C6.04738 15.4616 6.68054 15.4616 7.07107 15.0711L13.435 8.70711ZM0 9H12.7279V7L0 7L0 9Z"/></svg>';

            return $output;
        }

        public static function arrow_stroke($stroke = '#fff'){

            $output = '<svg width="31" height="31" viewBox="0 0 31 31" xmlns="http://www.w3.org/2000/svg" fill="transparent" stroke="'.esc_attr($stroke).'"><path d="M18.6742 30.3182L13.2701 30.2776L13.1406 13.0492L13.1316 11.8549L12.287 12.6994L5.30318 19.6833L1.44794 15.828L15.7504 1.52543L30.2803 16.0555L26.4931 19.8426L19.3983 12.7477L18.5355 11.8849L18.5447 13.105L18.6742 30.3182Z"/></svg>';

            return $output;
        }
    }

    new WGL_Framework_Global_Variables();
}
